/*
*  Rubrica
*  file: main.c
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "rubrica.h"
#include "autosave.h"
#include "log.h"
#include "ui.h"
#include "interface.h"
#include "main.h"
#include "druid.h"
#include "callbacks.h"
#include "prefer.h"
#include "file.h"
#include "view.h"
#include "card.h"
#include "dictionary.h"
#include "utils.h"

GtkWidget *app;               /* main application window */
GConfClient *client = NULL;   /* GConf client            */

gboolean first_run = FALSE;


GtkWidget *rubrica_get_app(void)
{
  return GTK_WIDGET(app);
}


GtkWidget *rubrica_get_toolbar()
{
  return (GtkWidget *) g_object_get_data(G_OBJECT(app), "toolbar");
}


GtkWidget *rubrica_get_popup_menu()
{
  return (GtkWidget *) g_object_get_data(G_OBJECT(app), "rubrica_popup_menu");
}

void rubrica_begin(void)
{
  gchar *fname = NULL;
  gint width, length;

  app = create_rubrica_app (client);

  width  = gconf_client_get_int(client, RUBRICA_KEY_WIDTH, NULL);
  length = gconf_client_get_int(client, RUBRICA_KEY_LENGTH, NULL);
  gtk_window_resize(GTK_WINDOW (app), width, length);
  rubrica_ui_set_default_icon(app);
   
  if (rubrica_start_with_user_addressbook(client) && !first_run)
    {  
      fname = rubrica_preferences_get_book();
      rubrica_file_start_with_file(fname);
      
      g_free(fname);
    }
  else
    rubrica_card_add_page_view(NULL);
  
  rubrica_set_just_start(FALSE);

  /* test if user enabled autosave */
  if (rubrica_preferences_get_autosave())
    rubrica_autosave_start(0);

  gtk_widget_show(app);
  rubrica_log_write_log("\nRubrica is running");
}


int
main (int argc, char *argv[])
{
  GError *error = NULL;

  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  printf("\nRubrica: Init Gnome libraries");
  gtk_set_locale ();
  gnome_program_init (RUBRICA_NAME, RUBRICA_VERSION, LIBGNOMEUI_MODULE,
		      argc, argv, GNOME_PARAM_APP_DATADIR, 
		      PACKAGE_DATA_DIR, NULL);

  printf("\nRubrica: Init Gnome libraries done...");

  g_print("\nRubrica: Init GConf libraries");

  if (!gconf_init(argc, argv, &error))
    {
      g_warning("GConf init failed:\n %s", error->message);

      g_error_free(error);
      error = NULL;
      return 1;
    }
    
  g_print("\nRubrica: Init GConf libraries done...");
  g_print("\nRubrica: get GConf client");
  
  client = gconf_client_get_default();
     
  g_print("\nRubrica: GConf client got...");

  rubrica_init();

  if ((first_run = rubrica_run_first_time()))
    {
       GtkWidget *druid;
              
       druid = rubrica_druid_create_druid();

       gtk_widget_show (druid);      
    }
  else
    {      
      gchar *home;

      home = g_strdup(g_get_home_dir());
      rubrica_utils_check_folders(home);
      rubrica_init_dictionary();
      rubrica_begin();
    }

  gtk_main ();

  g_object_unref(G_OBJECT(client));

  g_print("\n");
  rubrica_log_close_log_file();

  return 0;
}



