#
# based on Dag Wieers <dag@wieers.com> rubrica.spec file
#

%define rel   1

Name:      rubrica
Summary:   Rubrica, an address book for Gnome Environment.
Version:   1.0.15
Release:   %rel
License:   GPL
Group:     Applications/Productivity
Source:    http://digilander.libero.it/nfragale/download/rubrica/%{name}-%{version}.tar.bz2
URL:       http://digilander.iol.it/nfragale
Vendor:    Nicola Fragale <nicolafragale@libero.it>
Packager:  Nicola Fragale <nicolafragale@libero.it>

BuildRoot: %{_tmppath}/root-%{name}-%{version}
Prefix:    %{_prefix}
Requires:  libgnomeui >= 2.0 libxslt >= 1.0
BuildRequires: libgnomeui-devel >= 2.0,  libxslt-devel >= 1.0


%description
An address book for GNOME Environment. 

%prep
%setup

%build
#{__autoconf}
#{__automake}
%configure \
	--disable-install-schemas \
	--enable-nls
%{__make} %{?_smp_mflags}

#LC_ALL=""
#LANG=""
#export LC_ALL LANG
#CFLAGS="$RPM_OPT_FLAGS -Wall" ./configure --prefix=%{prefix} --sysconfdir=%{sysconfdir} --datadir=%{_datadir} --disable-install-schemas --enable-nls
#make 


%install
%{__rm} -rf %{buildroot}
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL="1"
#make DESTDIR=$RPM_BUILD_ROOT install
%makeinstall
%find_lang %{name}

%{__rm} -rf %{buildroot}%{_docdir}/rubrica

%post
export GCONF_CONFIG_SOURCE="$(gconftool-2 --get-default-source)"
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/%{name}.schemas &>/dev/null
scrollkeeper-update -q

%postun
scrollkeeper-update -q

%clean
%{__rm} -rf %{buildroot}


%files -f %{name}.lang
%defattr(-, root, root, 0755)
%doc README ChangeLog COPYING AUTHORS NEWS TODO CREDITS doc/examples.rub
%config %{_sysconfdir}/gconf/schemas/*.schemas
%{_bindir}/*
%{_datadir}/rubrica/
%{_datadir}/pixmaps/rubrica/
%{_datadir}/applications/*.desktop

