/*
*  Rubrica
*  file: form_card.c
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
  modulo rubrica, derivato da gnome-propertybox
*/
#include <config.h>
#include <gnome.h>
#include <time.h>

#include "rubrica.h"
#include "utils.h"
#include "view.h"
#include "form_card.h"
#include "form_int.h"
#include "ui.h"
#include "rubrica_type.h"

static void rubrica_form_card_class_init     (RubricaCardFormClass *klass);
static void rubrica_form_card_init           (RubricaCardForm *form);

void        rubrica_form_card_dialog_clicked_cb (GtkDialog *dialog, 
						 gint bottone, 
						 gpointer data);

/* classe genitore 
*/
static GtkDialogClass *parent_class = NULL;

static GtkWidget *card_form = NULL; 

time_t created, changed;              



/*    rubrica_form_get_type
      ritorna il GtkType del widget RubricaForm
*/
GtkType 
rubrica_form_card_get_type(void)
{
  static GtkType form_type = 0;
  
  if (!form_type)
    {
      static const GtkTypeInfo form_info =
      {
	"RubricaCardForm",
	sizeof(RubricaCardForm),
	sizeof(RubricaCardFormClass),
	(GtkClassInitFunc)  rubrica_form_card_class_init,
	(GtkObjectInitFunc) rubrica_form_card_init, 

	NULL, /* riservato per compatibilit */ 
	NULL, /* riservato per compatibilit */
        (GtkClassInitFunc) NULL, 
      };

      form_type = gtk_type_unique(gtk_dialog_get_type(), &form_info);
    }

  return form_type;
};


GtkWidget *
rubrica_form_card_new(void)
{
  GtkWidget *card_form;
  
  card_form = gtk_type_new(rubrica_form_card_get_type());

  return GTK_WIDGET(card_form);
}


/*  inizializzazione della classe RubricaForm
*/
static void
rubrica_form_card_class_init(RubricaCardFormClass *class)
{
  GObjectClass *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkBindingSet *binding_set;

  gobject_class = G_OBJECT_CLASS (class);
  object_class  = GTK_OBJECT_CLASS (class);
  widget_class  = GTK_WIDGET_CLASS(class);

  parent_class = g_type_class_peek_parent(class);

  /* la classe non gestisce segnali
   */
  binding_set = gtk_binding_set_by_class (class);  
  gtk_binding_entry_add_signal (binding_set, GDK_Escape, 0, "close", 0);
}



/*  inizializzazione della struttura dati RubricaForm
*/
static void
rubrica_form_card_init (RubricaCardForm *form)
{
  /* frame */
  GtkWidget *data;
  GtkWidget *net;
  GtkWidget *telephone;
  GtkWidget *work;
  GtkWidget *note;

  /* etichette notebook */
  GtkWidget *lbldata;
  GtkWidget *lblnet;
  GtkWidget *lbltel;
  GtkWidget *lblwork;
  GtkWidget *lblnote;
  

  gtk_dialog_set_has_separator (GTK_DIALOG(form), TRUE);
  gtk_dialog_add_buttons (GTK_DIALOG(form), 
			  GTK_STOCK_OK, GTK_RESPONSE_OK,
			  GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
			  NULL);
  gtk_window_set_position(GTK_WINDOW(form), GTK_WIN_POS_CENTER); 
  gtk_window_set_resizable (GTK_WINDOW(form), FALSE);

  form->notebook = gtk_notebook_new();
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(form)->vbox), form->notebook);
  gtk_widget_show (form->notebook);

  data = rubrica_form_create_card_data_page(form);
  if (!data)
    g_error("\nno data");

  net  = rubrica_form_create_card_net_page(form);
  if (!net)
    g_error("\nno frame data"); 
  
  telephone  = rubrica_form_create_card_telephone_page(form);
  if (!telephone)
    g_error("\nno frame data");

  work = rubrica_form_create_card_job_page(form);
  if (!work)
    g_error("\nno frame data");
  
  note = rubrica_form_create_card_notes_page(form);
  if (!note)
    g_error("\nno frame data");
  
  lbldata = gtk_label_new(_("Data"));
  lblnet  = gtk_label_new(_("Net"));
  lbltel  = gtk_label_new(_("Telephone"));
  lblwork = gtk_label_new(_("Work"));
  lblnote = gtk_label_new(_("Notes"));

  /*     inserisco le pagine nel notebook
  */
  gtk_notebook_append_page(GTK_NOTEBOOK(RUBRICA_CARD(form)->notebook), 
			   data, lbldata);
  gtk_notebook_append_page(GTK_NOTEBOOK(RUBRICA_CARD(form)->notebook), 
			   net, lblnet);
  gtk_notebook_append_page(GTK_NOTEBOOK(RUBRICA_CARD(form)->notebook), 
			   telephone, lbltel);
  gtk_notebook_append_page(GTK_NOTEBOOK(RUBRICA_CARD(form)->notebook), 
			   work, lblwork);
  gtk_notebook_append_page(GTK_NOTEBOOK(RUBRICA_CARD(form)->notebook),
			   note, lblnote);

  form->type = NEW_CARD;
  form->current_telephone = g_strdup("home");
  form->modificato = FALSE;

  /*
    La costruzione del card form pu essere piuttosto laboriosa su 
    vecchie macchine, per questo motivo l'oggetto card_form viene 
    costruito la prima volta che si chiama la funzione e non si 
    distrugge, ma si nascone, quando il form  chiuso. 
    Quando occorre di nuovo, viene semplicemente pulito e mostrato
  */
  rubrica_form_card_set_form(GTK_WIDGET(form));
}



/*   return saved form pointer 
*/
GtkWidget *rubrica_form_card_get_form(void) 
{
  return (GtkWidget *) card_form;; 
}


/*  store form widget
*/
void rubrica_form_card_set_form(GtkWidget *wid) 
{
  g_return_if_fail( wid != NULL); 

  card_form = (GtkWidget*) wid; 
}

gboolean 
rubrica_form_card_changed(RubricaCardForm *form)
{
  return (gboolean) form->modificato;
}

void rubrica_form_card_set_changed(RubricaCardForm *form, gboolean bool)
{
  form->modificato = bool;
}

void rubrica_form_card_set_form_type(GtkWidget *form, RubricaCardType type)
{
  g_return_if_fail(form != NULL);
  g_return_if_fail(RUBRICA_IS_CARD(form));

  RUBRICA_CARD(form)->type = type;
}

RubricaCardType rubrica_form_card_get_form_type(GtkWidget *form)
{
  return (RubricaCardType) RUBRICA_CARD(form)->type;
}

gchar 
*rubrica_form_card_get_telefono_attivo(RubricaCardForm *form)
{
  return (gchar *) g_strdup(form->current_telephone);
}


void 
rubrica_form_card_set_telefono_attivo(RubricaCardForm *form, gchar *str)
{  
  g_return_if_fail(RUBRICA_IS_CARD(form));
  
  if (form->current_telephone)
      g_free(form->current_telephone);

  strcpy(form->current_telephone, str);
}

/**
 * rubrica_form_card_get_entry_data
 * @entrywidget: the text widget pointer
 * 
 * extract text stored into the entry widget. 
 *
 * return:  
 */
gchar *rubrica_form_card_get_entry_data(GtkWidget *entrywidget)
{
  g_return_val_if_fail(GTK_IS_ENTRY(entrywidget), g_strdup(""));

  if (!gtk_entry_get_text(GTK_ENTRY(entrywidget)))
    return g_strdup("");

  return g_strdup(gtk_entry_get_text(GTK_ENTRY(entrywidget)));     
}

/**
 * rubrica_form_card_get_text_data
 * @textwidget: the text widget pointer
 * 
 * extract text stored into the text widget. 
 *
 * return: an allocated UTF-8 string 
 */
gchar *rubrica_form_card_get_text_data(GtkWidget *textwidget)
{
  GtkTextIter start, end;
  GtkTextBuffer *text_buffer;
  gchar *ret_val;  /* an allocated UTF-8 string */
  
  text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW (textwidget));
  
  gtk_text_buffer_get_bounds(text_buffer, &start, &end);
  ret_val = gtk_text_buffer_get_text(text_buffer, &start, &end, FALSE);

  return ret_val;
}

/*   funzioni per manipolare i dati contenuti nel widget

     estrae i dati contenuti nella finestra di dialogo e 
     li salva nella rubrica
*/
RubricaItem *rubrica_form_card_get_item(RubricaCardForm *form)
{
  RubricaItem *item;

  g_return_val_if_fail(form != NULL, NULL);
  g_return_val_if_fail(RUBRICA_IS_CARD(form), NULL);

  item = g_malloc (sizeof(RubricaItem));

  /*    Card data 
   */
  item->card   = rubrica_form_card_get_entry_data(form->card);
  item->delete = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(form->delete));
  item->group.type  = (RubricaCategoriesType) 
    gtk_option_menu_get_history(GTK_OPTION_MENU(form->option));
  item->group.label = rubrica_form_get_option_label(item->group.type);

  item->personal.first = rubrica_form_card_get_entry_data(form->personal.first);
  item->personal.middle = rubrica_form_card_get_entry_data(form->personal.middle);
  item->personal.last = rubrica_form_card_get_entry_data(form->personal.last);
  item->personal.profession = rubrica_form_card_get_entry_data(form->personal.profession);
  item->personal.prefix = rubrica_form_card_get_entry_data(form->personal.prefix);
  item->personal.title = rubrica_form_card_get_entry_data(form->personal.title);

  item->personal.birthknow  = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
							   (form->personal.birthknow));
  item->personal.birthdate = gnome_date_edit_get_time(GNOME_DATE_EDIT(form->personal.date));
  g_print("\ndata: %i", item->personal.birthdate);

  /*	Address data
  */
  item->address.street = rubrica_form_card_get_entry_data(form->address.street);
  item->address.number = rubrica_form_card_get_entry_data(form->address.number);
  item->address.zip    = rubrica_form_card_get_entry_data(form->address.zip);
  item->address.city   = rubrica_form_card_get_entry_data(form->address.city);
  item->address.province = rubrica_form_card_get_entry_data(form->address.province);
  item->address.state  = rubrica_form_card_get_entry_data(form->address.state);
  item->address.country = rubrica_form_card_get_entry_data(form->address.country);

  /*    Company data
  */
  item->company.name   = rubrica_form_card_get_entry_data(form->company.name);
  item->company.street = rubrica_form_card_get_entry_data(form->company.street); 
  item->company.number = rubrica_form_card_get_entry_data(form->company.number); 
  item->company.zip    = rubrica_form_card_get_entry_data(form->company.zip); 
  item->company.city   = rubrica_form_card_get_entry_data(form->company.city); 
  item->company.province = rubrica_form_card_get_entry_data(form->company.province); 
  item->company.country = rubrica_form_card_get_entry_data(form->company.country); 
  item->company.web     = rubrica_form_card_get_entry_data(form->company.web); 
  item->company.email  = rubrica_form_card_get_entry_data(form->company.email);
  item->company.operator = rubrica_form_card_get_entry_data(form->company.operator); 
  item->company.fax     = rubrica_form_card_get_entry_data(form->company.fax); 
  item->company.green  = rubrica_form_card_get_entry_data(form->company.green);
  item->company.customer_care = rubrica_form_card_get_entry_data(form->company.customer_care); 
  item->company.notes  = rubrica_form_card_get_text_data(form->company.notes);

  /*     Work data
  */
  item->work.assigment    = rubrica_form_card_get_entry_data(form->work.role);
  item->work.organization = rubrica_form_card_get_entry_data(form->work.org); 
  item->work.department   = rubrica_form_card_get_entry_data(form->work.dep);
  item->work.subdep       = rubrica_form_card_get_entry_data(form->work.sub);
  item->work.secretary = rubrica_form_card_get_entry_data(form->work.secretary);
  item->work.telephone    = rubrica_form_card_get_entry_data(form->work.phone);


  /*    Personal notes
  */
  item->notes.is_married   = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
							  (form->notes.is_married));
  item->notes.has_children = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
							  (form->notes.has_children));

  item->notes.birthknow = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
						       (form->notes.birthknow));
  item->notes.birthdate = gnome_date_edit_get_time(GNOME_DATE_EDIT(form->notes.birthdate));
  
  item->notes.anniverknow = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
							 (form->notes.anniverknow));
  item->notes.anniverdate = gnome_date_edit_get_time(GNOME_DATE_EDIT(form->notes.anniverdate));

  item->notes.spouse   = rubrica_form_card_get_entry_data(form->notes.spouse);
  item->notes.children = rubrica_form_card_get_text_data(form->notes.children);
  item->notes.hobbies  = rubrica_form_card_get_text_data(form->notes.hobbies);
  item->notes.notes    = rubrica_form_card_get_text_data(form->notes.notes);
  item->notes.pubkey   = rubrica_form_card_get_text_data(form->notes.pubkey);

  /* estrazione dei dati dalle liste, web, mail e telefonica 
   */
  /* web */
  item->net.web = rubrica_utils_get_all_data(form->net.web_tree, NET_TREE);

  /* mail */
  item->net.email = rubrica_utils_get_all_data(form->net.email_tree, NET_TREE);

  /* telephone */
  item->phone.telephone = rubrica_utils_get_all_data(form->tel.tree, 
						     PHONE_TREE);
  
  return (RubricaItem *) item;   
}


void 
rubrica_form_card_write_string(GtkWidget* entry, gchar* str)
{

  if (str && (strcmp(str, "") != 0))
    {
      g_print("\nDEBUG ***** rubrica_form_card_write_string - str: %s", str);
      gtk_entry_set_text(GTK_ENTRY(entry), str);
    }
}


/*
    visualizza i dati contenuti nell'elemento di 
    rubrica, nella finestra di dialogo
*/
RubricaErrorType rubrica_form_card_insert_item(RubricaCardForm *form, 
					       RubricaItem *item)
{
  GList *alias;
  GtkTreeModel *model;
  GtkTreeIter iter;

  g_return_val_if_fail(form != NULL, RE_MODULE_IS_NULL);
  g_return_val_if_fail(RUBRICA_IS_CARD(form), RE_BAD_MODULE);
  g_return_val_if_fail(item != NULL, RE_NO_ITEM_MODULE);

  created = item->created;
  changed = item->last_change;

  /*     Card data 
  */  
  g_print("\n\nDEBUG ***** rubrica_form_card_insert_item");

  rubrica_form_card_write_string(form->card, item->card);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->delete), item->delete);
  gtk_option_menu_set_history(GTK_OPTION_MENU(form->option), item->group.type);

  /*    Personal data
  */
  rubrica_form_card_write_string(form->personal.first, item->personal.first);
  rubrica_form_card_write_string(form->personal.middle, item->personal.middle);
  rubrica_form_card_write_string(form->personal.last, item->personal.last);
  rubrica_form_card_write_string(form->personal.profession, 
				 item->personal.profession);
  rubrica_form_card_write_string(form->personal.prefix, item->personal.prefix);
  
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->personal.birthknow), 
			       item->personal.birthknow);
  gnome_date_edit_set_time(GNOME_DATE_EDIT(form->personal.date),
			   item->personal.birthdate);

  if (!item->personal.birthknow)
    gtk_widget_set_sensitive(form->personal.date, FALSE);
  
  /* address */
  rubrica_form_card_write_string(form->address.street, item->address.street);
  rubrica_form_card_write_string(form->address.number, item->address.number);
  rubrica_form_card_write_string(form->address.zip, item->address.zip);
  rubrica_form_card_write_string(form->address.city, item->address.city);
  rubrica_form_card_write_string(form->address.province, 
				 item->address.province);
  rubrica_form_card_write_string(form->address.state, item->address.state);
  rubrica_form_card_write_string(form->address.country, item->address.country);

  /* company */
  rubrica_form_card_write_string(form->company.name, item->company.name);
  rubrica_form_card_write_string(form->company.street, item->company.street);
  rubrica_form_card_write_string(form->company.number, item->company.number);
  rubrica_form_card_write_string(form->company.zip, item->company.zip);
  rubrica_form_card_write_string(form->company.city, item->company.city);
  rubrica_form_card_write_string(form->company.province,
				 item->company.province);
  rubrica_form_card_write_string(form->company.country, item->company.country);
  rubrica_form_card_write_string(form->company.web, item->company.web);
  rubrica_form_card_write_string(form->company.email, item->company.email);
  rubrica_form_card_write_string(form->company.operator,
				 item->company.operator);
  rubrica_form_card_write_string(form->company.fax, item->company.fax);
  rubrica_form_card_write_string(form->company.green, item->company.green);
  rubrica_form_card_write_string(form->company.customer_care,
				 item->company.customer_care);
  rubrica_ui_set_text_in_view(form->company.notes, item->company.notes);

  /* work */
  rubrica_form_card_write_string(form->work.role, item->work.assigment);
  rubrica_form_card_write_string(form->work.org, item->work.organization);
  rubrica_form_card_write_string(form->work.dep, item->work.department);
  rubrica_form_card_write_string(form->work.sub, item->work.subdep);
  rubrica_form_card_write_string(form->work.secretary, item->work.secretary);
  rubrica_form_card_write_string(form->work.phone, item->work.telephone);

  /* notes */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.is_married), 
			       item->notes.is_married);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.has_children), 
			       item->notes.has_children);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.birthknow), 
			       item->notes.birthknow);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.anniverknow), 
			       item->notes.anniverknow);

  rubrica_form_card_write_string(form->notes.spouse,  item->notes.spouse);
  rubrica_ui_set_text_in_view(form->notes.children, item->notes.children);
  rubrica_ui_set_text_in_view(form->notes.hobbies,  item->notes.hobbies);
  rubrica_ui_set_text_in_view(form->notes.notes,    item->notes.notes);
  rubrica_ui_set_text_in_view(form->notes.pubkey,   item->notes.pubkey);
  
  gtk_widget_set_sensitive(form->notes.anniverdate, item->notes.anniverknow);
  gtk_widget_set_sensitive(form->notes.birthdate, item->notes.birthknow);
  gtk_widget_set_sensitive(form->notes.children, item->notes.has_children);
  gtk_widget_set_sensitive(form->notes.spouse, item->notes.is_married);
  gtk_widget_set_sensitive(form->notes.anniverknow, item->notes.is_married);
  gtk_widget_set_sensitive(form->notes.birthknow, item->notes.is_married);


  /* web 
   */
  alias = item->net.web;
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.web_tree));
  while (alias) 
    {     
      if (alias->data)
	{
	  gtk_list_store_append(GTK_LIST_STORE(model), &iter);
	  gtk_list_store_set(GTK_LIST_STORE(model), &iter, URI_COLUMN,
			     alias->data, -1); 
	}

      alias = g_list_next(alias);     
    } 
  

  /*    mail
   */
  alias = item->net.email;
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.email_tree));
  while (alias)  
    {      
      if (alias->data) 
	{
	  gtk_list_store_append(GTK_LIST_STORE(model), &iter); 
	  gtk_list_store_set(GTK_LIST_STORE(model), &iter, URI_COLUMN, 
			     alias->data, -1);
	}

      alias = g_list_next(alias);      
    }  
  

  /*    Telefono
   */
  alias = item->phone.telephone;
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->tel.tree));
  while (alias)  
    {      
      TelNum *tn; 

      if (alias->data) 
	{
	  tn = (TelNum *) alias->data; 
	  
	  if (tn->number)
	    {
	      gtk_list_store_append(GTK_LIST_STORE(model), &iter); 
	      gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
				 NUMBER_COLUMN, tn->number, -1);      
	      gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
				 TYPE_COLUMN, tn->type, -1);	  
	    }
	}
      
      alias = g_list_next(alias);      
    }  

  return RE_NO_ERROR;
}


void rubrica_form_card_clean_form(RubricaCardForm *form)
{
  GtkTreeModel *model;
  
  g_return_if_fail(form != NULL);
  
  gtk_entry_set_text(GTK_ENTRY(form->card), "");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->delete), FALSE);
  gtk_option_menu_set_history (GTK_OPTION_MENU(form->option), NO_GROUP);

  gtk_entry_set_text(GTK_ENTRY(form->personal.first), "");
  gtk_entry_set_text(GTK_ENTRY(form->personal.middle), "");
  gtk_entry_set_text(GTK_ENTRY(form->personal.last), "");
  gtk_entry_set_text(GTK_ENTRY(form->personal.profession), "");
  gtk_entry_set_text(GTK_ENTRY(form->personal.prefix), "");
  gtk_entry_set_text(GTK_ENTRY(form->personal.title), "");

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->personal.birthknow), 
			       FALSE);

  gnome_date_edit_set_time(GNOME_DATE_EDIT(form->personal.date), time(NULL));
  gtk_widget_set_sensitive(form->personal.date, FALSE);
  
  gtk_entry_set_text(GTK_ENTRY(form->address.street), "");
  gtk_entry_set_text(GTK_ENTRY(form->address.number), "");
  gtk_entry_set_text(GTK_ENTRY(form->address.zip), "");
  gtk_entry_set_text(GTK_ENTRY(form->address.city), "");
  gtk_entry_set_text(GTK_ENTRY(form->address.province), "");
  gtk_entry_set_text(GTK_ENTRY(form->address.state), "");
  gtk_entry_set_text(GTK_ENTRY(form->address.country), "");

  gtk_entry_set_text(GTK_ENTRY(form->net.web), "");
  gtk_entry_set_text(GTK_ENTRY(form->net.email), "");

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.web_tree));
  gtk_list_store_clear(GTK_LIST_STORE(model));

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->net.email_tree));
  gtk_list_store_clear(GTK_LIST_STORE(model));
  
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->tel.radiohome), TRUE);
  gtk_entry_set_text(GTK_ENTRY(form->tel.number), "");

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(form->tel.tree));
  gtk_list_store_clear(GTK_LIST_STORE(model));

  gtk_entry_set_text(GTK_ENTRY(form->company.name), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.street), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.number), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.zip), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.city), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.province), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.country), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.web), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.email), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.operator), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.fax), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.green), "");
  gtk_entry_set_text(GTK_ENTRY(form->company.customer_care), "");
  rubrica_ui_clean_text_view(form->company.notes);

  gtk_entry_set_text(GTK_ENTRY(form->work.role), "");
  gtk_entry_set_text(GTK_ENTRY(form->work.dep), "");
  gtk_entry_set_text(GTK_ENTRY(form->work.sub), "");
  gtk_entry_set_text(GTK_ENTRY(form->work.org), "");
  gtk_entry_set_text(GTK_ENTRY(form->work.secretary), "");
  gtk_entry_set_text(GTK_ENTRY(form->work.phone), "");

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.is_married), 
			       FALSE);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.has_children), 
			       FALSE);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.birthknow),  
			       FALSE);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.anniverknow),
			       FALSE);

  gnome_date_edit_set_time(GNOME_DATE_EDIT(form->notes.birthdate), time(NULL));
  gnome_date_edit_set_time(GNOME_DATE_EDIT(form->notes.anniverdate), 
			   time(NULL));

  gtk_widget_set_sensitive(form->notes.birthknow, FALSE);
  gtk_widget_set_sensitive(form->notes.anniverknow, FALSE);
  gtk_widget_set_sensitive(form->notes.birthdate, FALSE);
  gtk_widget_set_sensitive(form->notes.anniverdate, FALSE);

  gtk_entry_set_text(GTK_ENTRY(form->notes.spouse), "");
  rubrica_ui_clean_text_view(form->notes.children);
  rubrica_ui_clean_text_view(form->notes.hobbies);
  rubrica_ui_clean_text_view(form->notes.notes);
  rubrica_ui_clean_text_view(form->notes.pubkey);


  /* set default page to first page
   */
  gtk_notebook_set_page(GTK_NOTEBOOK(RUBRICA_CARD(form)->notebook), 0);
}


void 
rubrica_form_card_extract_insert_close(RubricaCardForm *form)
{
  Rubrica *rubrica;
  RubricaItem *item;

  g_return_if_fail(form != NULL);
  g_return_if_fail(RUBRICA_IS_CARD(form));

  rubrica = rubrica_get_current_rubrica();

  /* estrazione dei dati contenuti nel form 
   */
  item = rubrica_form_card_get_item(form);
  
  /* Imposta la data di creazione e ultima modifica 
   */
  item->created = item->last_change = time(NULL); 
  
  /* inserimento dei dati nella rubrica 
   */
  rubrica_append_item(rubrica, item); 
  
  /* setto il flag di lista vuota a falso 
   */
  rubrica_set_empty(rubrica, FALSE);
  
  /* chiudo il form 
   */
  rubrica_form_card_close(form);
}

void 
rubrica_form_card_extract_change_close(RubricaCardForm *form, gint index)
{
  Rubrica *rubrica;
  RubricaItem *item;

  g_return_if_fail(form != NULL);
  g_return_if_fail(RUBRICA_IS_CARD(form));

  rubrica = rubrica_get_current_rubrica();

  /* estrazione dei dati contenuti nel form */
  item = rubrica_form_card_get_item(form);

  /* Imposta la data di ultima modifica */
  item->created = created;
  item->last_change = time(NULL);

  /* inserimento dei dati nella rubrica */
  rubrica_modify_item(rubrica, item, index);
  
  /* setto il flag di lista vuota a falso */
  rubrica_set_empty(rubrica, FALSE);
  
  /* chiudo il form */
  rubrica_form_card_close(form);
}


RubricaErrorType
rubrica_form_card_modify_item(RubricaCardForm *form, RubricaItem *item)
{
  Rubrica *rubrica;
  RubricaErrorType err = RE_NO_ERROR;

  g_return_val_if_fail(item != NULL, RE_NO_ITEM_MODULE);
  g_return_val_if_fail(form != NULL, RE_NO_CARD_FORM);

  rubrica = rubrica_get_current_rubrica();
  err = rubrica_form_card_insert_item(RUBRICA_CARD(form), item);  

  gtk_widget_show(GTK_WIDGET(form));

  return err;
}


void rubrica_form_card_close (RubricaCardForm *form)
{
  gtk_widget_hide(GTK_WIDGET(form));
}


/*   funzione di callback che gestisce il 
     segnale "clicked" emesso dal form
*/  
void rubrica_form_card_clicked_ok(RubricaCardForm *form)
{
  Rubrica *rubrica;
  
  g_return_if_fail(RUBRICA_IS_CARD(form));

  rubrica = rubrica_get_current_rubrica();
    
  if (form->type == NEW_CARD) 
    {
      rubrica_form_card_extract_insert_close(form);
    }
/*
  if (form->type == OLD_CARD)  
    { 
      rubrica_form_card_extract_change_close(form);        
    } 
*/  
  rubrica_set_modified(rubrica, TRUE);
}


















