/*
*  Rubrica
*  file: menu.c
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <gnome.h>

#include "rubrica_type.h"
#include "callbacks.h"
#include "ui.h"
#include "menu.h"
#include "prefer.h"
#include "browse.h"


GtkWidget* rubrica_menu_create_toolbar(GtkWidget *app, 
				       GtkAccelGroup *accel_group)
{
  GtkWidget *toolbar;

  RubricaToolbarStyle style;
  GtkWidget *button_new;
  GtkWidget *button_open;
  GtkWidget *button_save;
  GtkWidget *button_close;
  GtkWidget *button_add;
  GtkWidget *button_remove;
  GtkWidget *button_modify;
  GtkWidget *button_first;
  GtkWidget *button_last;
  GtkWidget *button_find;
  GtkWidget *button_cards;
  GtkWidget *button_account;
  GtkWidget *button_quit;

  GtkWidget *main_notebook;
  
  GtkWidget *tmp_icon;
  
  toolbar = gtk_toolbar_new ();
  g_object_set_data(G_OBJECT(app), "toolbar", toolbar);
  main_notebook = g_object_get_data(G_OBJECT(app), "notebook");
  gnome_app_add_toolbar (GNOME_APP (app), GTK_TOOLBAR (toolbar), "toolbar",
                                BONOBO_DOCK_ITEM_BEH_EXCLUSIVE,
                                BONOBO_DOCK_TOP, 1, 0, 5);
  gtk_container_set_border_width (GTK_CONTAINER (toolbar), 1);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_BOTH);

  
  button_new = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
					 _(GTK_STOCK_NEW),
					 _("Make a new rubrica document"),
					 NULL, G_CALLBACK(on_button_new_clicked), NULL, -1);
  gtk_widget_show (button_new);
  
  button_open = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
					  _(GTK_STOCK_OPEN),
					  _("Open an existing file"),
					  NULL, G_CALLBACK(on_button_open_clicked), NULL, -1);
  gtk_widget_show (button_open);
  
  button_save = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
					  _(GTK_STOCK_SAVE),
					  _("Save current file"),
					  NULL, G_CALLBACK(on_button_save_clicked), NULL, -1);
  gtk_widget_show (button_save);
  
  button_close = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
					   _(GTK_STOCK_CLOSE),
					   _("Close current file"),
					   NULL, G_CALLBACK(on_button_close_clicked), NULL, -1);
  gtk_widget_show (button_close);
  
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  tmp_icon = rubrica_ui_image_new("add.png");
  button_add = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					   GTK_TOOLBAR_CHILD_BUTTON,
					   NULL,
					   _("_Add"),
					   _("Add an item"), NULL,
					   tmp_icon, G_CALLBACK(on_button_add_clicked), NULL);
  gtk_label_set_use_underline (GTK_LABEL(((GtkToolbarChild*) 
					  (g_list_last(GTK_TOOLBAR (toolbar)->children)->data))->label), TRUE);
  gtk_widget_show (button_add);
  
  tmp_icon = rubrica_ui_image_new("remove.png");  
  button_remove = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					      GTK_TOOLBAR_CHILD_BUTTON,
					      NULL,
					      _("R_emove"),
					      _("Remove an item"), NULL,
					      tmp_icon, 
					      G_CALLBACK(on_button_remove_clicked), NULL);
  gtk_label_set_use_underline (GTK_LABEL(((GtkToolbarChild*) 
					  (g_list_last(GTK_TOOLBAR (toolbar)->children)->data))->label), TRUE);
  gtk_widget_show (button_remove);
  
  tmp_icon = gtk_image_new_from_stock (GTK_STOCK_CONVERT, 
				       gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_modify = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					      GTK_TOOLBAR_CHILD_BUTTON,
					      NULL,
					      _("Modif_y"),
					      _("Modify the selected item"),
					      NULL, tmp_icon, 
					      G_CALLBACK(on_button_modify_clicked), NULL);
  gtk_label_set_use_underline (GTK_LABEL(((GtkToolbarChild*) 
					  (g_list_last(GTK_TOOLBAR (toolbar)->children)->data))->label), TRUE);
  gtk_widget_show (button_modify);
  
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  tmp_icon = gtk_image_new_from_stock (GTK_STOCK_GOTO_TOP, 
				       gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_first = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					     GTK_TOOLBAR_CHILD_BUTTON,
					     NULL,
					     _("Firs_t"),
					     _("Show the first item"), NULL,
					     tmp_icon, 
					     G_CALLBACK(on_button_browse_clicked), 
					     GINT_TO_POINTER(RB_FIRST_CARD));
  gtk_label_set_use_underline (GTK_LABEL(((GtkToolbarChild*) 
					  (g_list_last(GTK_TOOLBAR (toolbar)->children)->data))->label), TRUE);
  gtk_widget_show (button_first);
  
  tmp_icon = gtk_image_new_from_stock (GTK_STOCK_GOTO_BOTTOM, 
				       gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_last = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					    GTK_TOOLBAR_CHILD_BUTTON,
					    NULL,
					    _("_Last"),
					    _("Show the last item"), NULL,
					    tmp_icon, 
					    G_CALLBACK(on_button_browse_clicked),
					    GINT_TO_POINTER(RB_LAST_CARD));
  gtk_label_set_use_underline (GTK_LABEL(((GtkToolbarChild*)
					  (g_list_last(GTK_TOOLBAR (toolbar)->children)->data))->label), TRUE);
  gtk_widget_show (button_last);
  
  button_find = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
					  _(GTK_STOCK_FIND),
					  _("Search..."),
					  NULL,
					  G_CALLBACK(on_button_find_clicked), 
					  NULL, -1);
  gtk_widget_show (button_find);
  
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  tmp_icon = rubrica_ui_image_new("contacts.png");  
  button_cards = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					     GTK_TOOLBAR_CHILD_BUTTON,
					     NULL,
					     _("Ca_rds"),
					     _("Card view"), NULL,
					     tmp_icon, 
					     G_CALLBACK(on_button_cards_clicked), 
					     (gpointer)main_notebook);
  gtk_label_set_use_underline (GTK_LABEL(((GtkToolbarChild*)
					  (g_list_last(GTK_TOOLBAR (toolbar)->children)->data))->label), TRUE);
  gtk_widget_show (button_cards);
  
  tmp_icon = gtk_image_new_from_stock (GTK_STOCK_INDEX, 
				       gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar)));
  button_account = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
					       GTK_TOOLBAR_CHILD_BUTTON,
					       NULL,
					       _("Acco_unt"),
					       _("Account view"), NULL,
					       tmp_icon, 
					       G_CALLBACK(on_button_account_clicked), 
					       (gpointer) main_notebook);
  gtk_label_set_use_underline (GTK_LABEL(((GtkToolbarChild*)
					  (g_list_last(GTK_TOOLBAR (toolbar)->children)->data))->label), TRUE);
  gtk_widget_show (button_account);
  
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  button_quit = gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar), 
					  _(GTK_STOCK_QUIT), 
					  _("Quit program"), NULL, 
					  G_CALLBACK(on_button_exit_clicked), 
					  NULL, -1);
  gtk_widget_show (button_quit);

  style = rubrica_preferences_get_toolbarstyle();
  if (style != RTS_GNOME_DEFAULT)
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), style);
  else
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), 
			  rubrica_preferences_get_desktop_toolbarstyle());
  
  return (GtkWidget *) toolbar;
}


GtkWidget *rubrica_menu_popup_new(RubricaMenu *rm)
{
  g_return_val_if_fail(rm != NULL, NULL);

  return rubrica_ui_popup_menu_new(rm);
}

void rubrica_menu_attach_popup(GtkWidget *parent, GtkMenu *menu)
{
  gtk_menu_attach_to_widget(GTK_MENU(menu), GTK_WIDGET(parent), 
			    rubrica_menu_detach_menu);
  
  g_signal_connect_swapped (GTK_OBJECT (parent), "button_press_event",
			    G_CALLBACK (rubrica_menu_do_popup), 
			    GTK_OBJECT (menu));  
}


gint rubrica_menu_do_popup(GtkWidget *widget, GdkEvent *event)
{
  GtkMenu *menu;
  GdkEventButton *event_button;
  
  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_MENU (widget), FALSE);
  g_return_val_if_fail (event != NULL, FALSE);
  
  menu = GTK_MENU (widget);

  if (event->type == GDK_BUTTON_PRESS)
    {
      event_button = (GdkEventButton *) event;
      if (event_button->button == 3)
	{
	  gtk_widget_show_all(GTK_WIDGET(menu));
	  gtk_menu_popup (menu, NULL, NULL, NULL, NULL, 
			  event_button->button, event_button->time);
	  return TRUE;
	}
    }
  
  return FALSE;  
}

void rubrica_menu_detach_menu(GtkWidget *attach_widget, GtkMenu *menu)
{
  /* do nothing */ 
}
