/*
*  Rubrica
*  file: rubrica_type.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _RUBRICA_TYPE_H
#define _RUBRICA_TYPE_H

#include "error.h"

#define RUBRICA_FILE_FORMAT  FILE_FORMAT


typedef enum {
  URI_COLUMN = 0,
  LAST_NET_COLUMN
} RubricaNetColumnType;


typedef enum {
  NUMBER_COLUMN = 0,
  TYPE_COLUMN,
  LAST_TEL_COLUMN
} RubricaPhoneColumnType;


typedef enum {
  VBOX = 0,
  HBOX
} RubricaBoxType;

typedef enum {
  CARD_TREE = 0,
  ACCOUNT_TREE,
  NET_TREE,
  PHONE_TREE,
  PREF_TREE,
  PREF_CARD_LIST,
  PREF_PERSONAL_DATA_LIST,
  PREF_COMPANY_DATA_LIST,
  PREF_NOTE_DATA_LIST,
  PREF_ACCOUNT_LIST
} RubricaTreeType;

typedef enum {
  NET_MODEL,
  TELEPHONE_MODEL
} RubricaModelType;

typedef enum {
  WEB_COLUMNS = 0,  
  EMAIL_COLUMNS,
  TELEPHONE_COLUMNS
} RubricaColumnsType;

typedef enum {
  CARD_FORM_TYPE = 0,
  ACCOUNT_FORM_TYPE
} RubricaFormType;

typedef enum {
  NEW_CARD = 0,
  OLD_CARD
} RubricaCardType;


typedef enum {
  NO_GROUP = 0,
  FAVORITES_GROUP,
  HOT_GROUP,
  FRIENDS_GROUP,
  HEART_GROUP,
  RELATIVES_GROUP,
  HOLIDAYS_GROUP,
  HOBBIES_GROUP,
  SPORT_GROUP,
  BUSSINES_GROUP,
  COMPANY_GROUP,
  WORK_GROUP,
  CUSTOMER_GROUP,
  STRATEGIES_GROUP,
  PROGRAMMERS_GROUP,
  BSD_GROUP,
  UNIVERSITY_GROUP,
  PLUTO_GROUP
} RubricaCategoriesType;

/* RE ==> Rubrica Error  */
typedef enum {
  RE_FILE_NOT_EXIST = 0,
  RE_NO_XML_DOC,
  RE_NO_RUBRICA_HEADER,
  RE_PARSE_XML_DOC,
  RE_XML_DOC_NO_RUBRICA_HEADER,
  RE_XML_DOC_NO_RUBRICA_FIELD,
  RE_SELECT_FILE,
  RE_IMPORT_FILE,
  RE_BAD_MODULE,
  RE_MODULE_IS_NULL,
  RE_NO_ITEM_MODULE,
  RE_NO_CARD_FORM,
  RE_NO_ERROR
} RubricaErrorType;


typedef enum  {
  TELEPHONE_HOME = 0,
  TELEPHONE_WORK,
  TELEPHONE_FAX,
  TELEPHONE_CELLPHONE,
  TELEPHONE_OTHER,
  TELEPHONE_UNKNOWN
} RubricaTelephoneType;


typedef enum {
  CARD_VIEW = 0,
  ACCOUNT_VIEW
} RubricaViewType;


typedef enum {
  ACCOUNT_TYPE = 0,
  CARD_TYPE
} RubricaType;


typedef enum {
  ITALIAN = 0,
  ENGLISH,
  USER, 
  UNKNOWN
} RubricaLanguageType;


typedef enum {
  RT_DMY = 0,
  RT_MDY
} RubricaTimeFormatType;

/* RDC ==> Rubrica Dictionary Code */
typedef enum {
  RDC_CARD = 0,
  RDC_DATA, 
  RDC_ADDRESS, 
  RDC_COMPANY, 
  RDC_WORK,
  RDC_FIRST_NAME, 
  RDC_MIDDLE_NAME, 
  RDC_LAST_NAME, 
  RDC_PROFESSION, 
  RDC_NAME_PREFIX, 
  RDC_TITLE,
  RDC_STREET, 
  RDC_STREET_NUMBER, 
  RDC_ZIP_CODE, 
  RDC_CITY, 
  RDC_PROVINCE, 
  RDC_STATE, 
  RDC_COUNTRY, 
  RDC_WEB_ADDRESS, 
  RDC_WEB, 
  RDC_EMAIL_ADDRESS, 
  RDC_EMAIL, 
  RDC_TELEPHONE_NUMBERS, 
  RDC_TELEPHONE, 
  RDC_TYPE, 
  RDC_TELEPHONE_WORK, 
  RDC_TELEPHONE_HOME, 
  RDC_TELEPHONE_FAX, 
  RDC_TELEPHONE_CELL, 
  RDC_TELEPHONE_OTHER,
  RDC_COMPANY_NAME, 
  RDC_OPERATOR, 
  RDC_GREEN, 
  RDC_CUSTOMER_CARE,
  RDC_ASSIGMENT,
  RDC_ORGANIZATION,
  RDC_DEPARTMENT,
  RDC_SUB_DEPARTMENT, 
  RDC_SECRETARY,
  RDC_SECRETARY_PHONE, 
  RDC_SPOUSE,
  RDC_MARRIED,
  RDC_ANNIVERSARY,
  RDC_CHILDREN,
  RDC_CHILDREN_NOTES, 
  RDC_NOTE,
  RDC_HOBBIES,
  RDC_PUBLIC_KEY, 
  RDC_BIRTHDAY,
  RDC_SPOUSE_NAME,
  RDC_OTHER_NOTE,  
  RDC_CARD_GROUP,
  RDC_END
} RubricaDictionaryCode; 
 

/* RB ==> Rubrica Browse */
typedef enum {
  RB_FIRST_CARD = 0,
  RB_LAST_CARD,
  RB_NEXT_CARD,
  RB_PREV_CARD,
  RB_NTH_CARD
} RubricaBrowseType;


/* RTS ==> Rubrica Toolbar Style */
typedef enum {
  RTS_ICONS = 0,
  RTS_TEXT,
  RTS_BOTH,
  RTS_BOTH_HORIZ,
  RTS_GNOME_DEFAULT
} RubricaToolbarStyle;


typedef enum {
  SORT_ALPHA = 0,
  SORT_CREATION_DATE,
  SORT_MODIFICATION_DATE
} RubricaSortType;


typedef enum {
  SORT_ASCENDING = 0,
  SORT_DESCENDING
} RubricaSortDirectionType;


typedef enum {
  SEARCH_CARD,
  SEARCH_FIRST_NAME,
  SEARCH_LAST_NAME,
  SEARCH_PROFESSION,
  SEARCH_CITY,
  SEARCH_COUNTRY,
  SEARCH_WEB_ADDRESS,
  SEARCH_EMAIL_ADDRESS,
  SEARCH_TELEPHONE,
  SEARCH_COMPANY,
  SEARCH_CATEGORIES
} RubricaSearchType;


typedef gchar RubricaDictionary;
typedef struct _TelNum            TelNum;
typedef struct _RubricaInfoChild  RubricaInfoChild;
typedef struct _RubricaGroupType  RubricaGroupType;
typedef struct _RubricaOptionType RubricaOptionType;

struct _TelNum {
  gchar *number;
  gchar *type;
};


struct _RubricaInfoChild {
  RubricaType type;
  
  GtkWidget *child;
};


struct _RubricaGroupType {
  gchar *label;

  RubricaCategoriesType type;  
};


struct _RubricaOptionType {
  gchar *pixmap;
  gchar *label;

  gint type;
};


typedef enum {
  RM_ITEM,
  RM_CHECK_ITEM, 
  RM_SEPARATOR,
  RM_SUBTREE,
  RM_END
} RubricaMenuType;


typedef enum {
  RMP_NONE,
  RMP_STOCK,
  RMP_FILE
} RubricaMenuPixmapType;


typedef void (*RubricaMenuFunc) (GtkMenuItem *item, gpointer data);
typedef struct _RubricaMenu RubricaMenu;

struct _RubricaMenu {
  RubricaMenuType type;           /* menu type */
  gchar *label;                   /* displayed label */
  gchar *tip;                     /* tip */

  RubricaMenuPixmapType pixtype;  /* pixmap type */
  gchar *pixmap;                  /* pixmap file */

  gpointer more;                  /* more data (for subtree menu) */

  RubricaMenuFunc callback;       /* callback funcion */
  gpointer data;                  /* user data */
  // TODO: add hotkey
};


#define RUBRICA_MENU_CHECK(label, callback, data) {                     \
                                                    RM_CHECK_ITEM,      \
                                                    (label),            \
                                                    NULL, RMP_NONE,     \
                                                    NULL, NULL,         \
                                                    (callback), (data)  \
                                                  }
#define RUBRICA_MENU_SEPARATOR     {                                      \
                                     RM_SEPARATOR, NULL, NULL, RMP_NONE,  \
                                     NULL, NULL, NULL, NULL               \
                                   }

#define RUBRICA_MENU_SUBTREE(c, s) {                                     \
                                      RM_SUBTREE, (c), NULL,             \
                                      RMP_NONE, NULL, (s), NULL, NULL    \
                                   }

#define RUBRICA_MENU_END           {                                  \
                                      RM_END, NULL, NULL, RMP_NONE,   \
                                      NULL, NULL, NULL, NULL          \
                                   }


#endif
