# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Search
  #
  # Client that can be used to manage Azure Search services and API keys.
  #
  class AdminKeys
    include MsRestAzure

    #
    # Creates and initializes a new instance of the AdminKeys class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SearchManagementClient] reference to the SearchManagementClient
    attr_reader :client

    #
    # Gets the primary and secondary admin API keys for the specified Azure Search
    # service.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # current subscription. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param search_service_name [String] The name of the Azure Search service
    # associated with the specified resource group.
    # @param search_management_request_options [SearchManagementRequestOptions]
    # Additional parameters for the operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AdminKeyResult] operation results.
    #
    def get(resource_group_name, search_service_name, search_management_request_options = nil, custom_headers = nil)
      response = get_async(resource_group_name, search_service_name, search_management_request_options, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the primary and secondary admin API keys for the specified Azure Search
    # service.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # current subscription. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param search_service_name [String] The name of the Azure Search service
    # associated with the specified resource group.
    # @param search_management_request_options [SearchManagementRequestOptions]
    # Additional parameters for the operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, search_service_name, search_management_request_options = nil, custom_headers = nil)
      get_async(resource_group_name, search_service_name, search_management_request_options, custom_headers).value!
    end

    #
    # Gets the primary and secondary admin API keys for the specified Azure Search
    # service.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # current subscription. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param search_service_name [String] The name of the Azure Search service
    # associated with the specified resource group.
    # @param search_management_request_options [SearchManagementRequestOptions]
    # Additional parameters for the operation
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, search_service_name, search_management_request_options = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'search_service_name is nil' if search_service_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?

      client_request_id = nil
      unless search_management_request_options.nil?
        client_request_id = search_management_request_options.clientRequestId
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      request_headers['x-ms-client-request-id'] = client_request_id.to_s unless client_request_id.to_s.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/listAdminKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'searchServiceName' => search_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Search::Models::AdminKeyResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Regenerates either the primary or secondary admin API key. You can only
    # regenerate one key at a time.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # current subscription. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param search_service_name [String] The name of the Azure Search service
    # associated with the specified resource group.
    # @param key_kind [AdminKeyKind] Specifies which key to regenerate. Valid
    # values include 'primary' and 'secondary'. Possible values include: 'primary',
    # 'secondary'
    # @param search_management_request_options [SearchManagementRequestOptions]
    # Additional parameters for the operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AdminKeyResult] operation results.
    #
    def regenerate(resource_group_name, search_service_name, key_kind, search_management_request_options = nil, custom_headers = nil)
      response = regenerate_async(resource_group_name, search_service_name, key_kind, search_management_request_options, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Regenerates either the primary or secondary admin API key. You can only
    # regenerate one key at a time.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # current subscription. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param search_service_name [String] The name of the Azure Search service
    # associated with the specified resource group.
    # @param key_kind [AdminKeyKind] Specifies which key to regenerate. Valid
    # values include 'primary' and 'secondary'. Possible values include: 'primary',
    # 'secondary'
    # @param search_management_request_options [SearchManagementRequestOptions]
    # Additional parameters for the operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def regenerate_with_http_info(resource_group_name, search_service_name, key_kind, search_management_request_options = nil, custom_headers = nil)
      regenerate_async(resource_group_name, search_service_name, key_kind, search_management_request_options, custom_headers).value!
    end

    #
    # Regenerates either the primary or secondary admin API key. You can only
    # regenerate one key at a time.
    #
    # @param resource_group_name [String] The name of the resource group within the
    # current subscription. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param search_service_name [String] The name of the Azure Search service
    # associated with the specified resource group.
    # @param key_kind [AdminKeyKind] Specifies which key to regenerate. Valid
    # values include 'primary' and 'secondary'. Possible values include: 'primary',
    # 'secondary'
    # @param search_management_request_options [SearchManagementRequestOptions]
    # Additional parameters for the operation
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def regenerate_async(resource_group_name, search_service_name, key_kind, search_management_request_options = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'search_service_name is nil' if search_service_name.nil?
      fail ArgumentError, 'key_kind is nil' if key_kind.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?

      client_request_id = nil
      unless search_management_request_options.nil?
        client_request_id = search_management_request_options.clientRequestId
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      request_headers['x-ms-client-request-id'] = client_request_id.to_s unless client_request_id.to_s.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/regenerateAdminKey/{keyKind}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'searchServiceName' => search_service_name,'keyKind' => key_kind,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Search::Models::AdminKeyResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
