# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::CognitiveServices
  #
  # Cognitive Services Management Client
  #
  class CognitiveServicesAccounts
    include Azure::ARM::CognitiveServices::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the CognitiveServicesAccounts class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [CognitiveServicesManagementClient] reference to the CognitiveServicesManagementClient
    attr_reader :client

    #
    # Create Cognitive Services Account. Accounts is a resource group wide
    # resource type. It holds the keys for developer to access intelligent APIs.
    # It's also the resource type for billing.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param parameters [CognitiveServicesAccountCreateParameters] The parameters
    # to provide for the created account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CognitiveServicesAccount] operation results.
    #
    def create(resource_group_name, account_name, parameters, custom_headers = nil)
      response = create_async(resource_group_name, account_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create Cognitive Services Account. Accounts is a resource group wide
    # resource type. It holds the keys for developer to access intelligent APIs.
    # It's also the resource type for billing.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param parameters [CognitiveServicesAccountCreateParameters] The parameters
    # to provide for the created account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_with_http_info(resource_group_name, account_name, parameters, custom_headers = nil)
      create_async(resource_group_name, account_name, parameters, custom_headers).value!
    end

    #
    # Create Cognitive Services Account. Accounts is a resource group wide
    # resource type. It holds the keys for developer to access intelligent APIs.
    # It's also the resource type for billing.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param parameters [CognitiveServicesAccountCreateParameters] The parameters
    # to provide for the created account.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_async(resource_group_name, account_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CognitiveServicesAccountCreateParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates a Cognitive Services account
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param sku [Sku]
    # @param tags [Hash{String => String}] Gets or sets a list of key value pairs
    # that describe the resource. These tags can be used in viewing and grouping
    # this resource (across resource groups). A maximum of 15 tags can be
    # provided for a resource. Each tag must have a key no greater than 128
    # characters and value no greater than 256 characters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CognitiveServicesAccount] operation results.
    #
    def update(resource_group_name, account_name, sku = nil, tags = nil, custom_headers = nil)
      response = update_async(resource_group_name, account_name, sku, tags, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a Cognitive Services account
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param sku [Sku]
    # @param tags [Hash{String => String}] Gets or sets a list of key value pairs
    # that describe the resource. These tags can be used in viewing and grouping
    # this resource (across resource groups). A maximum of 15 tags can be
    # provided for a resource. Each tag must have a key no greater than 128
    # characters and value no greater than 256 characters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(resource_group_name, account_name, sku = nil, tags = nil, custom_headers = nil)
      update_async(resource_group_name, account_name, sku, tags, custom_headers).value!
    end

    #
    # Updates a Cognitive Services account
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param sku [Sku]
    # @param tags [Hash{String => String}] Gets or sets a list of key value pairs
    # that describe the resource. These tags can be used in viewing and grouping
    # this resource (across resource groups). A maximum of 15 tags can be
    # provided for a resource. Each tag must have a key no greater than 128
    # characters and value no greater than 256 characters.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(resource_group_name, account_name, sku = nil, tags = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?

      body = CognitiveServicesAccountUpdateParameters.new
      unless sku.nil? && tags.nil?
        body.sku = sku
        body.tags = tags
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CognitiveServicesAccountUpdateParameters.mapper()
      request_content = @client.serialize(request_mapper,  body, 'body')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :patch, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a Cognitive Services account from the resource group.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, account_name, custom_headers = nil)
      response = delete_async(resource_group_name, account_name, custom_headers).value!
      nil
    end

    #
    # Deletes a Cognitive Services account from the resource group.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, account_name, custom_headers = nil)
      delete_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Deletes a Cognitive Services account from the resource group.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Returns a Cognitive Services account specified by the parameters.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CognitiveServicesAccount] operation results.
    #
    def get_properties(resource_group_name, account_name, custom_headers = nil)
      response = get_properties_async(resource_group_name, account_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns a Cognitive Services account specified by the parameters.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_properties_with_http_info(resource_group_name, account_name, custom_headers = nil)
      get_properties_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Returns a Cognitive Services account specified by the parameters.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_properties_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns all the resources of a particular type belonging to a resource group
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CognitiveServicesAccountListResult] operation results.
    #
    def list_by_resource_group(resource_group_name, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns all the resources of a particular type belonging to a resource group
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, custom_headers).value!
    end

    #
    # Returns all the resources of a particular type belonging to a resource group
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns all the resources of a particular type belonging to a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CognitiveServicesAccountListResult] operation results.
    #
    def list(custom_headers = nil)
      response = list_async(custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns all the resources of a particular type belonging to a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(custom_headers = nil)
      list_async(custom_headers).value!
    end

    #
    # Returns all the resources of a particular type belonging to a subscription.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.CognitiveServices/accounts'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the account keys for the specified Cognitive Services account.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Congitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CognitiveServicesAccountKeys] operation results.
    #
    def list_keys(resource_group_name, account_name, custom_headers = nil)
      response = list_keys_async(resource_group_name, account_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the account keys for the specified Cognitive Services account.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Congitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_keys_with_http_info(resource_group_name, account_name, custom_headers = nil)
      list_keys_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Lists the account keys for the specified Cognitive Services account.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Congitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_keys_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/listKeys'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccountKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Regenerates the specified account key for the specified Cognitive Services
    # account.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param key_name [KeyName] key name to generate (Key1|Key2). Possible values
    # include: 'Key1', 'Key2'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CognitiveServicesAccountKeys] operation results.
    #
    def regenerate_key(resource_group_name, account_name, key_name = nil, custom_headers = nil)
      response = regenerate_key_async(resource_group_name, account_name, key_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Regenerates the specified account key for the specified Cognitive Services
    # account.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param key_name [KeyName] key name to generate (Key1|Key2). Possible values
    # include: 'Key1', 'Key2'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def regenerate_key_with_http_info(resource_group_name, account_name, key_name = nil, custom_headers = nil)
      regenerate_key_async(resource_group_name, account_name, key_name, custom_headers).value!
    end

    #
    # Regenerates the specified account key for the specified Cognitive Services
    # account.
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param key_name [KeyName] key name to generate (Key1|Key2). Possible values
    # include: 'Key1', 'Key2'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def regenerate_key_async(resource_group_name, account_name, key_name = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?

      body = RegenerateKeyParameters.new
      unless key_name.nil?
        body.key_name = key_name
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RegenerateKeyParameters.mapper()
      request_content = @client.serialize(request_mapper,  body, 'body')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/regenerateKey'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccountKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List available SKUs for the requested Cognitive Services account
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CognitiveServicesAccountEnumerateSkusResult] operation results.
    #
    def list_skus(resource_group_name, account_name, custom_headers = nil)
      response = list_skus_async(resource_group_name, account_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List available SKUs for the requested Cognitive Services account
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_skus_with_http_info(resource_group_name, account_name, custom_headers = nil)
      list_skus_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # List available SKUs for the requested Cognitive Services account
    #
    # @param resource_group_name [String] The name of the resource group within
    # the user's subscription.
    # @param account_name [String] The name of the cognitive services account
    # within the specified resource group. Cognitive Services account names must
    # be between 3 and 24 characters in length and use numbers and lower-case
    # letters only.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_skus_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/skus'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CognitiveServicesAccountEnumerateSkusResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
