# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::DataLakeAnalytics
  #
  # Creates an Azure Data Lake Analytics account management client.
  #
  class Account
    include Azure::ARM::DataLakeAnalytics::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Account class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [DataLakeAnalyticsAccountManagementClient] reference to the DataLakeAnalyticsAccountManagementClient
    attr_reader :client

    #
    # Gets the specified Azure Storage account linked to the given Data Lake
    # Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to retrieve Azure storage account details.
    # @param storage_account_name [String] The name of the Azure Storage account
    # for which to retrieve the details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StorageAccountInfo] operation results.
    #
    def get_storage_account(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      response = get_storage_account_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified Azure Storage account linked to the given Data Lake
    # Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to retrieve Azure storage account details.
    # @param storage_account_name [String] The name of the Azure Storage account
    # for which to retrieve the details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_storage_account_with_http_info(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      get_storage_account_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
    end

    #
    # Gets the specified Azure Storage account linked to the given Data Lake
    # Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to retrieve Azure storage account details.
    # @param storage_account_name [String] The name of the Azure Storage account
    # for which to retrieve the details.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_storage_account_async(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StorageAccountInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the specified Data Lake Analytics account to remove an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to remove the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account
    # to remove
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_storage_account(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      response = delete_storage_account_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
      nil
    end

    #
    # Updates the specified Data Lake Analytics account to remove an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to remove the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account
    # to remove
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_storage_account_with_http_info(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      delete_storage_account_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
    end

    #
    # Updates the specified Data Lake Analytics account to remove an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to remove the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account
    # to remove
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_storage_account_async(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the Data Lake Analytics account to replace Azure Storage blob
    # account details, such as the access key and/or suffix.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # modify storage accounts in
    # @param storage_account_name [String] The Azure Storage account to modify
    # @param parameters [AddStorageAccountParameters] The parameters containing
    # the access key and suffix to update the storage account with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def update_storage_account(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      response = update_storage_account_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers).value!
      nil
    end

    #
    # Updates the Data Lake Analytics account to replace Azure Storage blob
    # account details, such as the access key and/or suffix.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # modify storage accounts in
    # @param storage_account_name [String] The Azure Storage account to modify
    # @param parameters [AddStorageAccountParameters] The parameters containing
    # the access key and suffix to update the storage account with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_storage_account_with_http_info(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      update_storage_account_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers).value!
    end

    #
    # Updates the Data Lake Analytics account to replace Azure Storage blob
    # account details, such as the access key and/or suffix.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # modify storage accounts in
    # @param storage_account_name [String] The Azure Storage account to modify
    # @param parameters [AddStorageAccountParameters] The parameters containing
    # the access key and suffix to update the storage account with.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_storage_account_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = AddStorageAccountParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :patch, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the specified Data Lake Analytics account to add an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account
    # to add
    # @param parameters [AddStorageAccountParameters] The parameters containing
    # the access key and optional suffix for the Azure Storage Account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def add_storage_account(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      response = add_storage_account_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers).value!
      nil
    end

    #
    # Updates the specified Data Lake Analytics account to add an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account
    # to add
    # @param parameters [AddStorageAccountParameters] The parameters containing
    # the access key and optional suffix for the Azure Storage Account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_storage_account_with_http_info(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      add_storage_account_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers).value!
    end

    #
    # Updates the specified Data Lake Analytics account to add an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account
    # to add
    # @param parameters [AddStorageAccountParameters] The parameters containing
    # the access key and optional suffix for the Azure Storage Account.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_storage_account_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = AddStorageAccountParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the specified Azure Storage container associated with the given Data
    # Lake Analytics and Azure Storage accounts.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to retrieve blob container.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to retrieve the blob container.
    # @param container_name [String] The name of the Azure storage container to
    # retrieve
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BlobContainer] operation results.
    #
    def get_storage_container(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      response = get_storage_container_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified Azure Storage container associated with the given Data
    # Lake Analytics and Azure Storage accounts.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to retrieve blob container.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to retrieve the blob container.
    # @param container_name [String] The name of the Azure storage container to
    # retrieve
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_storage_container_with_http_info(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      get_storage_container_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers).value!
    end

    #
    # Gets the specified Azure Storage container associated with the given Data
    # Lake Analytics and Azure Storage accounts.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to retrieve blob container.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to retrieve the blob container.
    # @param container_name [String] The name of the Azure storage container to
    # retrieve
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_storage_container_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers/{containerName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BlobContainer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage blob containers.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to list blob containers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListBlobContainersResult] which provide lazy access to pages of the
    # response.
    #
    def list_storage_containers_as_lazy(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      response = list_storage_containers_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_storage_containers_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage blob containers.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to list blob containers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<BlobContainer>] operation results.
    #
    def list_storage_containers(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      first_page = list_storage_containers_as_lazy(resource_group_name, account_name, storage_account_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage blob containers.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to list blob containers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_storage_containers_with_http_info(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      list_storage_containers_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage blob containers.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to list blob containers.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_storage_containers_async(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ListBlobContainersResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which an Azure Storage account's SAS token is being requested.
    # @param storage_account_name [String] The name of the Azure storage account
    # for which the SAS token is being requested.
    # @param container_name [String] The name of the Azure storage container for
    # which the SAS token is being requested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListSasTokensResult] which provide lazy access to pages of the
    # response.
    #
    def list_sas_tokens_as_lazy(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      response = list_sas_tokens_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_sas_tokens_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which an Azure Storage account's SAS token is being requested.
    # @param storage_account_name [String] The name of the Azure storage account
    # for which the SAS token is being requested.
    # @param container_name [String] The name of the Azure storage container for
    # which the SAS token is being requested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SasTokenInfo>] operation results.
    #
    def list_sas_tokens(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      first_page = list_sas_tokens_as_lazy(resource_group_name, account_name, storage_account_name, container_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which an Azure Storage account's SAS token is being requested.
    # @param storage_account_name [String] The name of the Azure storage account
    # for which the SAS token is being requested.
    # @param container_name [String] The name of the Azure storage container for
    # which the SAS token is being requested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_sas_tokens_with_http_info(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      list_sas_tokens_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers).value!
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which an Azure Storage account's SAS token is being requested.
    # @param storage_account_name [String] The name of the Azure storage account
    # for which the SAS token is being requested.
    # @param container_name [String] The name of the Azure storage container for
    # which the SAS token is being requested.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_sas_tokens_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers/{containerName}/listSasTokens'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ListSasTokensResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the specified Data Lake Store account details in the specified Data
    # Lake Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to retrieve the Data Lake Store account details.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to retrieve
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccountInfo] operation results.
    #
    def get_data_lake_store_account(resource_group_name, account_name, data_lake_store_account_name, custom_headers = nil)
      response = get_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified Data Lake Store account details in the specified Data
    # Lake Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to retrieve the Data Lake Store account details.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to retrieve
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_data_lake_store_account_with_http_info(resource_group_name, account_name, data_lake_store_account_name, custom_headers = nil)
      get_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, custom_headers).value!
    end

    #
    # Gets the specified Data Lake Store account details in the specified Data
    # Lake Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to retrieve the Data Lake Store account details.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to retrieve
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'data_lake_store_account_name is nil' if data_lake_store_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/DataLakeStoreAccounts/{dataLakeStoreAccountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'dataLakeStoreAccountName' => data_lake_store_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccountInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Data Lake Analytics account specified to remove the specified
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to remove the Data Lake Store account.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to remove
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_data_lake_store_account(resource_group_name, account_name, data_lake_store_account_name, custom_headers = nil)
      response = delete_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, custom_headers).value!
      nil
    end

    #
    # Updates the Data Lake Analytics account specified to remove the specified
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to remove the Data Lake Store account.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to remove
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_data_lake_store_account_with_http_info(resource_group_name, account_name, data_lake_store_account_name, custom_headers = nil)
      delete_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, custom_headers).value!
    end

    #
    # Updates the Data Lake Analytics account specified to remove the specified
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account
    # from which to remove the Data Lake Store account.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to remove
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'data_lake_store_account_name is nil' if data_lake_store_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/DataLakeStoreAccounts/{dataLakeStoreAccountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'dataLakeStoreAccountName' => data_lake_store_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the specified Data Lake Analytics account to include the additional
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Data Lake Store account.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to add.
    # @param parameters [AddDataLakeStoreParameters] The details of the Data Lake
    # Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def add_data_lake_store_account(resource_group_name, account_name, data_lake_store_account_name, parameters, custom_headers = nil)
      response = add_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, parameters, custom_headers).value!
      nil
    end

    #
    # Updates the specified Data Lake Analytics account to include the additional
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Data Lake Store account.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to add.
    # @param parameters [AddDataLakeStoreParameters] The details of the Data Lake
    # Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_data_lake_store_account_with_http_info(resource_group_name, account_name, data_lake_store_account_name, parameters, custom_headers = nil)
      add_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, parameters, custom_headers).value!
    end

    #
    # Updates the specified Data Lake Analytics account to include the additional
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Data Lake Store account.
    # @param data_lake_store_account_name [String] The name of the Data Lake Store
    # account to add.
    # @param parameters [AddDataLakeStoreParameters] The details of the Data Lake
    # Store account.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_data_lake_store_account_async(resource_group_name, account_name, data_lake_store_account_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'data_lake_store_account_name is nil' if data_lake_store_account_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = AddDataLakeStoreParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/DataLakeStoreAccounts/{dataLakeStoreAccountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'dataLakeStoreAccountName' => data_lake_store_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage accounts.
    # @param filter [String] The OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListStorageAccountsResult] which provide
    # lazy access to pages of the response.
    #
    def list_storage_accounts_as_lazy(resource_group_name, account_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      response = list_storage_accounts_async(resource_group_name, account_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_storage_accounts_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage accounts.
    # @param filter [String] The OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<StorageAccountInfo>] operation results.
    #
    def list_storage_accounts(resource_group_name, account_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      first_page = list_storage_accounts_as_lazy(resource_group_name, account_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage accounts.
    # @param filter [String] The OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_storage_accounts_with_http_info(resource_group_name, account_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      list_storage_accounts_async(resource_group_name, account_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage accounts.
    # @param filter [String] The OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_storage_accounts_async(resource_group_name, account_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$top' => top,'$skip' => skip,'$expand' => expand,'$select' => select,'$orderby' => orderby,'$count' => count,'$search' => search,'$format' => format,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccountListStorageAccountsResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Data Lake Store accounts linked to the specified Data
    # Lake Analytics account. The response includes a link to the next page, if
    # any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Data Lake Store accounts.
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListDataLakeStoreResult] which provide lazy
    # access to pages of the response.
    #
    def list_data_lake_store_accounts_as_lazy(resource_group_name, account_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      response = list_data_lake_store_accounts_async(resource_group_name, account_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_data_lake_store_accounts_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the first page of Data Lake Store accounts linked to the specified Data
    # Lake Analytics account. The response includes a link to the next page, if
    # any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Data Lake Store accounts.
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DataLakeStoreAccountInfo>] operation results.
    #
    def list_data_lake_store_accounts(resource_group_name, account_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      first_page = list_data_lake_store_accounts_as_lazy(resource_group_name, account_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the first page of Data Lake Store accounts linked to the specified Data
    # Lake Analytics account. The response includes a link to the next page, if
    # any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Data Lake Store accounts.
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_data_lake_store_accounts_with_http_info(resource_group_name, account_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      list_data_lake_store_accounts_async(resource_group_name, account_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
    end

    #
    # Gets the first page of Data Lake Store accounts linked to the specified Data
    # Lake Analytics account. The response includes a link to the next page, if
    # any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Data Lake Store accounts.
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_data_lake_store_accounts_async(resource_group_name, account_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/DataLakeStoreAccounts/'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$top' => top,'$skip' => skip,'$expand' => expand,'$select' => select,'$orderby' => orderby,'$count' => count,'$search' => search,'$format' => format,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccountListDataLakeStoreResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within a
    # specific resource group. This includes a link to the next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The return format. Return the response in particular
    # formatxii without access to request headers for standard content-type
    # negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListResult] which provide lazy access to
    # pages of the response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_by_resource_group_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within a
    # specific resource group. This includes a link to the next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The return format. Return the response in particular
    # formatxii without access to request headers for standard content-type
    # negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DataLakeAnalyticsAccount>] operation results.
    #
    def list_by_resource_group(resource_group_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within a
    # specific resource group. This includes a link to the next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The return format. Return the response in particular
    # formatxii without access to request headers for standard content-type
    # negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within a
    # specific resource group. This includes a link to the next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The return format. Return the response in particular
    # formatxii without access to request headers for standard content-type
    # negotiation (e.g Orders?$format=json). Optional.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$top' => top,'$skip' => skip,'$expand' => expand,'$select' => select,'$orderby' => orderby,'$count' => count,'$search' => search,'$format' => format,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within the
    # current subscription. This includes a link to the next page, if any.
    #
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListResult] which provide lazy access to
    # pages of the response.
    #
    def list_as_lazy(filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      response = list_async(filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within the
    # current subscription. This includes a link to the next page, if any.
    #
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DataLakeAnalyticsAccount>] operation results.
    #
    def list(filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      first_page = list_as_lazy(filter, top, skip, expand, select, orderby, count, search, format, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within the
    # current subscription. This includes a link to the next page, if any.
    #
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      list_async(filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within the
    # current subscription. This includes a link to the next page, if any.
    #
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeAnalytics/accounts'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$top' => top,'$skip' => skip,'$expand' => expand,'$select' => select,'$orderby' => orderby,'$count' => count,'$search' => search,'$format' => format,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets details of the specified Data Lake Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # retrieve.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccount] operation results.
    #
    def get(resource_group_name, account_name, custom_headers = nil)
      response = get_async(resource_group_name, account_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets details of the specified Data Lake Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # retrieve.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, account_name, custom_headers = nil)
      get_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Gets details of the specified Data Lake Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # retrieve.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Begins the delete delete process for the Data Lake Analytics account object
    # specified by the account name.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # delete
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, account_name, custom_headers = nil)
      response = delete_async(resource_group_name, account_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # delete
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, account_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, account_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Begins the delete delete process for the Data Lake Analytics account object
    # specified by the account name.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # delete
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, account_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, account_name, custom_headers).value!
      nil
    end

    #
    # Begins the delete delete process for the Data Lake Analytics account object
    # specified by the account name.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # delete
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, account_name, custom_headers = nil)
      begin_delete_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Begins the delete delete process for the Data Lake Analytics account object
    # specified by the account name.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # delete
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 404 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates the specified Data Lake Analytics account. This supplies the user
    # with computation services for Data Lake Analytics workloads
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.the account will be
    # associated with.
    # @param name [String] The name of the Data Lake Analytics account to create.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # create Data Lake Analytics account operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccount] operation results.
    #
    def create(resource_group_name, name, parameters, custom_headers = nil)
      response = create_async(resource_group_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.the account will be
    # associated with.
    # @param name [String] The name of the Data Lake Analytics account to create.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # create Data Lake Analytics account operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_async(resource_group_name, name, parameters, custom_headers = nil)
      # Send request
      promise = begin_create_async(resource_group_name, name, parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = DataLakeAnalyticsAccount.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates the specified Data Lake Analytics account. This supplies the user
    # with computation services for Data Lake Analytics workloads
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.the account will be
    # associated with.
    # @param name [String] The name of the Data Lake Analytics account to create.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # create Data Lake Analytics account operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccount] operation results.
    #
    def begin_create(resource_group_name, name, parameters, custom_headers = nil)
      response = begin_create_async(resource_group_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates the specified Data Lake Analytics account. This supplies the user
    # with computation services for Data Lake Analytics workloads
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.the account will be
    # associated with.
    # @param name [String] The name of the Data Lake Analytics account to create.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # create Data Lake Analytics account operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_with_http_info(resource_group_name, name, parameters, custom_headers = nil)
      begin_create_async(resource_group_name, name, parameters, custom_headers).value!
    end

    #
    # Creates the specified Data Lake Analytics account. This supplies the user
    # with computation services for Data Lake Analytics workloads
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.the account will be
    # associated with.
    # @param name [String] The name of the Data Lake Analytics account to create.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # create Data Lake Analytics account operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_async(resource_group_name, name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = DataLakeAnalyticsAccount.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Data Lake Analytics account object specified by the accountName
    # with the contents of the account object.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param name [String] The name of the Data Lake Analytics account to update.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # update Data Lake Analytics account operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccount] operation results.
    #
    def update(resource_group_name, name, parameters, custom_headers = nil)
      response = update_async(resource_group_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param name [String] The name of the Data Lake Analytics account to update.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # update Data Lake Analytics account operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, name, parameters, custom_headers = nil)
      # Send request
      promise = begin_update_async(resource_group_name, name, parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = DataLakeAnalyticsAccount.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the Data Lake Analytics account object specified by the accountName
    # with the contents of the account object.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param name [String] The name of the Data Lake Analytics account to update.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # update Data Lake Analytics account operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccount] operation results.
    #
    def begin_update(resource_group_name, name, parameters, custom_headers = nil)
      response = begin_update_async(resource_group_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Data Lake Analytics account object specified by the accountName
    # with the contents of the account object.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param name [String] The name of the Data Lake Analytics account to update.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # update Data Lake Analytics account operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, name, parameters, custom_headers = nil)
      begin_update_async(resource_group_name, name, parameters, custom_headers).value!
    end

    #
    # Updates the Data Lake Analytics account object specified by the accountName
    # with the contents of the account object.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Analytics account.
    # @param name [String] The name of the Data Lake Analytics account to update.
    # @param parameters [DataLakeAnalyticsAccount] Parameters supplied to the
    # update Data Lake Analytics account operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = DataLakeAnalyticsAccount.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :patch, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListBlobContainersResult] operation results.
    #
    def list_storage_containers_next(next_page_link, custom_headers = nil)
      response = list_storage_containers_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_storage_containers_next_with_http_info(next_page_link, custom_headers = nil)
      list_storage_containers_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_storage_containers_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ListBlobContainersResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListSasTokensResult] operation results.
    #
    def list_sas_tokens_next(next_page_link, custom_headers = nil)
      response = list_sas_tokens_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_sas_tokens_next_with_http_info(next_page_link, custom_headers = nil)
      list_sas_tokens_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_sas_tokens_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ListSasTokensResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListStorageAccountsResult] operation
    # results.
    #
    def list_storage_accounts_next(next_page_link, custom_headers = nil)
      response = list_storage_accounts_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_storage_accounts_next_with_http_info(next_page_link, custom_headers = nil)
      list_storage_accounts_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_storage_accounts_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccountListStorageAccountsResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Data Lake Store accounts linked to the specified Data
    # Lake Analytics account. The response includes a link to the next page, if
    # any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListDataLakeStoreResult] operation results.
    #
    def list_data_lake_store_accounts_next(next_page_link, custom_headers = nil)
      response = list_data_lake_store_accounts_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the first page of Data Lake Store accounts linked to the specified Data
    # Lake Analytics account. The response includes a link to the next page, if
    # any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_data_lake_store_accounts_next_with_http_info(next_page_link, custom_headers = nil)
      list_data_lake_store_accounts_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the first page of Data Lake Store accounts linked to the specified Data
    # Lake Analytics account. The response includes a link to the next page, if
    # any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_data_lake_store_accounts_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccountListDataLakeStoreResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within a
    # specific resource group. This includes a link to the next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListResult] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within a
    # specific resource group. This includes a link to the next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within a
    # specific resource group. This includes a link to the next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within the
    # current subscription. This includes a link to the next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within the
    # current subscription. This includes a link to the next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the first page of Data Lake Analytics accounts, if any, within the
    # current subscription. This includes a link to the next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeAnalyticsAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
