# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::DataLakeStore
  #
  # Creates an Azure Data Lake Store account management client.
  #
  class Account
    include Azure::ARM::DataLakeStore::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Account class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [DataLakeStoreAccountManagementClient] reference to the DataLakeStoreAccountManagementClient
    attr_reader :client

    #
    # Deletes the specified firewall rule from the specified Data Lake Store
    # account
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to delete the firewall rule.
    # @param firewall_rule_name [String] The name of the firewall rule to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_firewall_rule(resource_group_name, account_name, firewall_rule_name, custom_headers = nil)
      response = delete_firewall_rule_async(resource_group_name, account_name, firewall_rule_name, custom_headers).value!
      nil
    end

    #
    # Deletes the specified firewall rule from the specified Data Lake Store
    # account
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to delete the firewall rule.
    # @param firewall_rule_name [String] The name of the firewall rule to delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_firewall_rule_with_http_info(resource_group_name, account_name, firewall_rule_name, custom_headers = nil)
      delete_firewall_rule_async(resource_group_name, account_name, firewall_rule_name, custom_headers).value!
    end

    #
    # Deletes the specified firewall rule from the specified Data Lake Store
    # account
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to delete the firewall rule.
    # @param firewall_rule_name [String] The name of the firewall rule to delete.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_firewall_rule_async(resource_group_name, account_name, firewall_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'firewall_rule_name is nil' if firewall_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'firewallRuleName' => firewall_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the specified Data Lake Store firewall rule.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to get the firewall rule.
    # @param firewall_rule_name [String] The name of the firewall rule to retrieve.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [FirewallRule] operation results.
    #
    def get_firewall_rule(resource_group_name, account_name, firewall_rule_name, custom_headers = nil)
      response = get_firewall_rule_async(resource_group_name, account_name, firewall_rule_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified Data Lake Store firewall rule.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to get the firewall rule.
    # @param firewall_rule_name [String] The name of the firewall rule to retrieve.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_firewall_rule_with_http_info(resource_group_name, account_name, firewall_rule_name, custom_headers = nil)
      get_firewall_rule_async(resource_group_name, account_name, firewall_rule_name, custom_headers).value!
    end

    #
    # Gets the specified Data Lake Store firewall rule.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to get the firewall rule.
    # @param firewall_rule_name [String] The name of the firewall rule to retrieve.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_firewall_rule_async(resource_group_name, account_name, firewall_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'firewall_rule_name is nil' if firewall_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{firewallRuleName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'firewallRuleName' => firewall_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = FirewallRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Data Lake Store firewall rules within the specified Data Lake
    # Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to get the firewall rules.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreFirewallRuleListResult] which provide lazy access to
    # pages of the response.
    #
    def list_firewall_rules_as_lazy(resource_group_name, account_name, custom_headers = nil)
      response = list_firewall_rules_async(resource_group_name, account_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_firewall_rules_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists the Data Lake Store firewall rules within the specified Data Lake
    # Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to get the firewall rules.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<FirewallRule>] operation results.
    #
    def list_firewall_rules(resource_group_name, account_name, custom_headers = nil)
      first_page = list_firewall_rules_as_lazy(resource_group_name, account_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the Data Lake Store firewall rules within the specified Data Lake
    # Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to get the firewall rules.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_firewall_rules_with_http_info(resource_group_name, account_name, custom_headers = nil)
      list_firewall_rules_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Lists the Data Lake Store firewall rules within the specified Data Lake
    # Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account from
    # which to get the firewall rules.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_firewall_rules_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreFirewallRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates the specified firewall rule.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # which to add the firewall rule.
    # @param name [String] The name of the firewall rule to create or update.
    # @param parameters [FirewallRule] Parameters supplied to create the create
    # firewall rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [FirewallRule] operation results.
    #
    def create_or_update_firewall_rule(resource_group_name, account_name, name, parameters, custom_headers = nil)
      response = create_or_update_firewall_rule_async(resource_group_name, account_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates the specified firewall rule.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # which to add the firewall rule.
    # @param name [String] The name of the firewall rule to create or update.
    # @param parameters [FirewallRule] Parameters supplied to create the create
    # firewall rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_firewall_rule_with_http_info(resource_group_name, account_name, name, parameters, custom_headers = nil)
      create_or_update_firewall_rule_async(resource_group_name, account_name, name, parameters, custom_headers).value!
    end

    #
    # Creates or updates the specified firewall rule.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # which to add the firewall rule.
    # @param name [String] The name of the firewall rule to create or update.
    # @param parameters [FirewallRule] Parameters supplied to create the create
    # firewall rule.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_firewall_rule_async(resource_group_name, account_name, name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = FirewallRule.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/firewallRules/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = FirewallRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to create.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to create the
    # Data Lake Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccount] operation results.
    #
    def create(resource_group_name, name, parameters, custom_headers = nil)
      response = create_async(resource_group_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to create.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to create the
    # Data Lake Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_async(resource_group_name, name, parameters, custom_headers = nil)
      # Send request
      promise = begin_create_async(resource_group_name, name, parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = DataLakeStoreAccount.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to create.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to create the
    # Data Lake Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccount] operation results.
    #
    def begin_create(resource_group_name, name, parameters, custom_headers = nil)
      response = begin_create_async(resource_group_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to create.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to create the
    # Data Lake Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_with_http_info(resource_group_name, name, parameters, custom_headers = nil)
      begin_create_async(resource_group_name, name, parameters, custom_headers).value!
    end

    #
    # Creates the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to create.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to create the
    # Data Lake Store account.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_async(resource_group_name, name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = DataLakeStoreAccount.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the specified Data Lake Store account information.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to update.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to update the
    # Data Lake Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccount] operation results.
    #
    def update(resource_group_name, name, parameters, custom_headers = nil)
      response = update_async(resource_group_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to update.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to update the
    # Data Lake Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, name, parameters, custom_headers = nil)
      # Send request
      promise = begin_update_async(resource_group_name, name, parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = DataLakeStoreAccount.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the specified Data Lake Store account information.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to update.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to update the
    # Data Lake Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccount] operation results.
    #
    def begin_update(resource_group_name, name, parameters, custom_headers = nil)
      response = begin_update_async(resource_group_name, name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the specified Data Lake Store account information.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to update.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to update the
    # Data Lake Store account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, name, parameters, custom_headers = nil)
      begin_update_async(resource_group_name, name, parameters, custom_headers).value!
    end

    #
    # Updates the specified Data Lake Store account information.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param name [String] The name of the Data Lake Store account to update.
    # @param parameters [DataLakeStoreAccount] Parameters supplied to update the
    # Data Lake Store account.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = DataLakeStoreAccount.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :patch, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, account_name, custom_headers = nil)
      response = delete_async(resource_group_name, account_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, account_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, account_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, account_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, account_name, custom_headers).value!
      nil
    end

    #
    # Deletes the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # delete.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, account_name, custom_headers = nil)
      begin_delete_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Deletes the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # delete.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404 || status_code == 204 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # retrieve.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccount] operation results.
    #
    def get(resource_group_name, account_name, custom_headers = nil)
      response = get_async(resource_group_name, account_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # retrieve.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, account_name, custom_headers = nil)
      get_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Gets the specified Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # retrieve.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccount.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Attempts to enable a user managed key vault for encryption of the specified
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # attempt to enable the Key Vault for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def enable_key_vault(resource_group_name, account_name, custom_headers = nil)
      response = enable_key_vault_async(resource_group_name, account_name, custom_headers).value!
      nil
    end

    #
    # Attempts to enable a user managed key vault for encryption of the specified
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # attempt to enable the Key Vault for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def enable_key_vault_with_http_info(resource_group_name, account_name, custom_headers = nil)
      enable_key_vault_async(resource_group_name, account_name, custom_headers).value!
    end

    #
    # Attempts to enable a user managed key vault for encryption of the specified
    # Data Lake Store account.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account.
    # @param account_name [String] The name of the Data Lake Store account to
    # attempt to enable the Key Vault for.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def enable_key_vault_async(resource_group_name, account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts/{accountName}/enableKeyVault'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Lists the Data Lake Store accounts within a specific resource group. The
    # response includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account(s).
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] A Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccountListResult] which provide lazy access to pages
    # of the response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_by_resource_group_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists the Data Lake Store accounts within a specific resource group. The
    # response includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account(s).
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] A Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DataLakeStoreAccount>] operation results.
    #
    def list_by_resource_group(resource_group_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the Data Lake Store accounts within a specific resource group. The
    # response includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account(s).
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] A Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
    end

    #
    # Lists the Data Lake Store accounts within a specific resource group. The
    # response includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group
    # that contains the Data Lake Store account(s).
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] A Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeStore/accounts'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$top' => top,'$skip' => skip,'$expand' => expand,'$select' => select,'$orderby' => orderby,'$count' => count,'$search' => search,'$format' => format,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Data Lake Store accounts within the subscription. The response
    # includes a link to the next page of results, if any.
    #
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccountListResult] which provide lazy access to pages
    # of the response.
    #
    def list_as_lazy(filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      response = list_async(filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists the Data Lake Store accounts within the subscription. The response
    # includes a link to the next page of results, if any.
    #
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DataLakeStoreAccount>] operation results.
    #
    def list(filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      first_page = list_as_lazy(filter, top, skip, expand, select, orderby, count, search, format, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the Data Lake Store accounts within the subscription. The response
    # includes a link to the next page of results, if any.
    #
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      list_async(filter, top, skip, expand, select, orderby, count, search, format, custom_headers).value!
    end

    #
    # Lists the Data Lake Store accounts within the subscription. The response
    # includes a link to the next page of results, if any.
    #
    # @param filter [String] OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param expand [String] OData expansion. Expand related resources in line
    # with the retrieved resources, e.g. Categories/$expand=Products would expand
    # Product data in line with each Category entry. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param search [String] A free form search. A free-text search expression to
    # match for whether a particular entry should be included in the feed, e.g.
    # Categories?$search=blue OR green. Optional.
    # @param format [String] The desired return format. Return the response in
    # particular formatxii without access to request headers for standard
    # content-type negotiation (e.g Orders?$format=json). Optional.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(filter = nil, top = nil, skip = nil, expand = nil, select = nil, orderby = nil, count = nil, search = nil, format = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.DataLakeStore/accounts'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$top' => top,'$skip' => skip,'$expand' => expand,'$select' => select,'$orderby' => orderby,'$count' => count,'$search' => search,'$format' => format,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Data Lake Store firewall rules within the specified Data Lake
    # Store account.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreFirewallRuleListResult] operation results.
    #
    def list_firewall_rules_next(next_page_link, custom_headers = nil)
      response = list_firewall_rules_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the Data Lake Store firewall rules within the specified Data Lake
    # Store account.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_firewall_rules_next_with_http_info(next_page_link, custom_headers = nil)
      list_firewall_rules_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the Data Lake Store firewall rules within the specified Data Lake
    # Store account.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_firewall_rules_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreFirewallRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Data Lake Store accounts within a specific resource group. The
    # response includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccountListResult] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the Data Lake Store accounts within a specific resource group. The
    # response includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the Data Lake Store accounts within a specific resource group. The
    # response includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Data Lake Store accounts within the subscription. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeStoreAccountListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the Data Lake Store accounts within the subscription. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the Data Lake Store accounts within the subscription. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DataLakeStoreAccountListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
