# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::MobileEngagement
  #
  # Microsoft Azure Mobile Engagement REST APIs.
  #
  class Campaigns
    include Azure::ARM::MobileEngagement::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Campaigns class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [EngagementManagementClient] reference to the EngagementManagementClient
    attr_reader :client

    #
    # Get the list of campaigns.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param skip [Integer] Control paging of campaigns, start results at the
    # given offset, defaults to 0 (1st page of data).
    # @param top [Integer] Control paging of campaigns, number of campaigns to
    # return with each call. It returns all campaigns by default. When specifying
    # $top parameter, the response contains a `nextLink` property describing the
    # path to get the next page if there are more results.
    # @param filter [String] Filter can be used to restrict the results to
    # campaigns matching a specific state. The syntax is `$filter=state eq
    # 'draft'`. Valid state values are: draft, scheduled, in-progress, and
    # finished. Only the eq operator and the state property are supported.
    # @param orderby [String] Sort results by an expression which looks like
    # `$orderby=id asc` (this example is actually the default behavior). The
    # syntax is orderby={property} {direction} or just orderby={property}. The
    # available sorting properties are id, name, state, activatedDate, and
    # finishedDate. The available directions are asc (for ascending order) and
    # desc (for descending order). When not specified the asc direction is used.
    # Only one property at a time can be used for sorting.
    # @param search [String] Restrict results to campaigns matching the optional
    # `search` expression. This currently performs the search based on the name
    # on the campaign only, case insensitive. If the campaign contains the value
    # of the `search` parameter anywhere in the name, it matches.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignsListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(kind, skip = nil, top = nil, filter = nil, orderby = nil, search = nil, custom_headers = nil)
      response = list_async(kind, skip, top, filter, orderby, search, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Get the list of campaigns.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param skip [Integer] Control paging of campaigns, start results at the
    # given offset, defaults to 0 (1st page of data).
    # @param top [Integer] Control paging of campaigns, number of campaigns to
    # return with each call. It returns all campaigns by default. When specifying
    # $top parameter, the response contains a `nextLink` property describing the
    # path to get the next page if there are more results.
    # @param filter [String] Filter can be used to restrict the results to
    # campaigns matching a specific state. The syntax is `$filter=state eq
    # 'draft'`. Valid state values are: draft, scheduled, in-progress, and
    # finished. Only the eq operator and the state property are supported.
    # @param orderby [String] Sort results by an expression which looks like
    # `$orderby=id asc` (this example is actually the default behavior). The
    # syntax is orderby={property} {direction} or just orderby={property}. The
    # available sorting properties are id, name, state, activatedDate, and
    # finishedDate. The available directions are asc (for ascending order) and
    # desc (for descending order). When not specified the asc direction is used.
    # Only one property at a time can be used for sorting.
    # @param search [String] Restrict results to campaigns matching the optional
    # `search` expression. This currently performs the search based on the name
    # on the campaign only, case insensitive. If the campaign contains the value
    # of the `search` parameter anywhere in the name, it matches.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CampaignListResult>] operation results.
    #
    def list(kind, skip = nil, top = nil, filter = nil, orderby = nil, search = nil, custom_headers = nil)
      first_page = list_as_lazy(kind, skip, top, filter, orderby, search, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the list of campaigns.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param skip [Integer] Control paging of campaigns, start results at the
    # given offset, defaults to 0 (1st page of data).
    # @param top [Integer] Control paging of campaigns, number of campaigns to
    # return with each call. It returns all campaigns by default. When specifying
    # $top parameter, the response contains a `nextLink` property describing the
    # path to get the next page if there are more results.
    # @param filter [String] Filter can be used to restrict the results to
    # campaigns matching a specific state. The syntax is `$filter=state eq
    # 'draft'`. Valid state values are: draft, scheduled, in-progress, and
    # finished. Only the eq operator and the state property are supported.
    # @param orderby [String] Sort results by an expression which looks like
    # `$orderby=id asc` (this example is actually the default behavior). The
    # syntax is orderby={property} {direction} or just orderby={property}. The
    # available sorting properties are id, name, state, activatedDate, and
    # finishedDate. The available directions are asc (for ascending order) and
    # desc (for descending order). When not specified the asc direction is used.
    # Only one property at a time can be used for sorting.
    # @param search [String] Restrict results to campaigns matching the optional
    # `search` expression. This currently performs the search based on the name
    # on the campaign only, case insensitive. If the campaign contains the value
    # of the `search` parameter anywhere in the name, it matches.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(kind, skip = nil, top = nil, filter = nil, orderby = nil, search = nil, custom_headers = nil)
      list_async(kind, skip, top, filter, orderby, search, custom_headers).value!
    end

    #
    # Get the list of campaigns.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param skip [Integer] Control paging of campaigns, start results at the
    # given offset, defaults to 0 (1st page of data).
    # @param top [Integer] Control paging of campaigns, number of campaigns to
    # return with each call. It returns all campaigns by default. When specifying
    # $top parameter, the response contains a `nextLink` property describing the
    # path to get the next page if there are more results.
    # @param filter [String] Filter can be used to restrict the results to
    # campaigns matching a specific state. The syntax is `$filter=state eq
    # 'draft'`. Valid state values are: draft, scheduled, in-progress, and
    # finished. Only the eq operator and the state property are supported.
    # @param orderby [String] Sort results by an expression which looks like
    # `$orderby=id asc` (this example is actually the default behavior). The
    # syntax is orderby={property} {direction} or just orderby={property}. The
    # available sorting properties are id, name, state, activatedDate, and
    # finishedDate. The available directions are asc (for ascending order) and
    # desc (for descending order). When not specified the asc direction is used.
    # Only one property at a time can be used for sorting.
    # @param search [String] Restrict results to campaigns matching the optional
    # `search` expression. This currently performs the search based on the name
    # on the campaign only, case insensitive. If the campaign contains the value
    # of the `search` parameter anywhere in the name, it matches.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(kind, skip = nil, top = nil, filter = nil, orderby = nil, search = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind},
          query_params: {'api-version' => @client.api_version,'$skip' => skip,'$top' => top,'$filter' => filter,'$orderby' => orderby,'$search' => search},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignsListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a push campaign (announcement, poll, data push or native push).
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param parameters [Campaign] Parameters supplied to the Update Campaign
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignStateResult] operation results.
    #
    def create(kind, parameters, custom_headers = nil)
      response = create_async(kind, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a push campaign (announcement, poll, data push or native push).
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param parameters [Campaign] Parameters supplied to the Update Campaign
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_with_http_info(kind, parameters, custom_headers = nil)
      create_async(kind, parameters, custom_headers).value!
    end

    #
    # Create a push campaign (announcement, poll, data push or native push).
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param parameters [Campaign] Parameters supplied to the Update Campaign
    # operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_async(kind, parameters, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Campaign.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignStateResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The Get campaign operation retrieves information about a previously created
    # campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignResult] operation results.
    #
    def get(kind, id, custom_headers = nil)
      response = get_async(kind, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The Get campaign operation retrieves information about a previously created
    # campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(kind, id, custom_headers = nil)
      get_async(kind, id, custom_headers).value!
    end

    #
    # The Get campaign operation retrieves information about a previously created
    # campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(kind, id, custom_headers = nil)
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'kind' => kind,'id' => id,'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update an existing push campaign (announcement, poll, data push or native
    # push).
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [Campaign] Parameters supplied to the Update Campaign
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignStateResult] operation results.
    #
    def update(kind, id, parameters, custom_headers = nil)
      response = update_async(kind, id, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update an existing push campaign (announcement, poll, data push or native
    # push).
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [Campaign] Parameters supplied to the Update Campaign
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(kind, id, parameters, custom_headers = nil)
      update_async(kind, id, parameters, custom_headers).value!
    end

    #
    # Update an existing push campaign (announcement, poll, data push or native
    # push).
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [Campaign] Parameters supplied to the Update Campaign
    # operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(kind, id, parameters, custom_headers = nil)
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Campaign.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'kind' => kind,'id' => id,'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignStateResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a campaign previously created by a call to Create campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(kind, id, custom_headers = nil)
      response = delete_async(kind, id, custom_headers).value!
      nil
    end

    #
    # Delete a campaign previously created by a call to Create campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(kind, id, custom_headers = nil)
      delete_async(kind, id, custom_headers).value!
    end

    #
    # Delete a campaign previously created by a call to Create campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(kind, id, custom_headers = nil)
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'kind' => kind,'id' => id,'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The Get campaign operation retrieves information about a previously created
    # campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param name [String] Campaign name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignResult] operation results.
    #
    def get_by_name(kind, name, custom_headers = nil)
      response = get_by_name_async(kind, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The Get campaign operation retrieves information about a previously created
    # campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param name [String] Campaign name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_by_name_with_http_info(kind, name, custom_headers = nil)
      get_by_name_async(kind, name, custom_headers).value!
    end

    #
    # The Get campaign operation retrieves information about a previously created
    # campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param name [String] Campaign name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_by_name_async(kind, name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaignsByName/{kind}/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind,'name' => name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Test an existing campaign (created with Create campaign) on a set of devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [CampaignTestSavedParameters] Parameters supplied to the
    # Test Campaign operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignStateResult] operation results.
    #
    def test_saved(kind, id, parameters, custom_headers = nil)
      response = test_saved_async(kind, id, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Test an existing campaign (created with Create campaign) on a set of devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [CampaignTestSavedParameters] Parameters supplied to the
    # Test Campaign operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def test_saved_with_http_info(kind, id, parameters, custom_headers = nil)
      test_saved_async(kind, id, parameters, custom_headers).value!
    end

    #
    # Test an existing campaign (created with Create campaign) on a set of devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [CampaignTestSavedParameters] Parameters supplied to the
    # Test Campaign operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def test_saved_async(kind, id, parameters, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CampaignTestSavedParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/test'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind,'id' => id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignStateResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Test a new campaign on a set of devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param parameters [CampaignTestNewParameters] Parameters supplied to the
    # Test Campaign operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignState] operation results.
    #
    def test_new(kind, parameters, custom_headers = nil)
      response = test_new_async(kind, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Test a new campaign on a set of devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param parameters [CampaignTestNewParameters] Parameters supplied to the
    # Test Campaign operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def test_new_with_http_info(kind, parameters, custom_headers = nil)
      test_new_async(kind, parameters, custom_headers).value!
    end

    #
    # Test a new campaign on a set of devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param parameters [CampaignTestNewParameters] Parameters supplied to the
    # Test Campaign operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def test_new_async(kind, parameters, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CampaignTestNewParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/test'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignState.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Activate a campaign previously created by a call to Create campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignStateResult] operation results.
    #
    def activate(kind, id, custom_headers = nil)
      response = activate_async(kind, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Activate a campaign previously created by a call to Create campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def activate_with_http_info(kind, id, custom_headers = nil)
      activate_async(kind, id, custom_headers).value!
    end

    #
    # Activate a campaign previously created by a call to Create campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def activate_async(kind, id, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/activate'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind,'id' => id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignStateResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Suspend a push campaign previously activated by a call to Activate campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignStateResult] operation results.
    #
    def suspend(kind, id, custom_headers = nil)
      response = suspend_async(kind, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Suspend a push campaign previously activated by a call to Activate campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def suspend_with_http_info(kind, id, custom_headers = nil)
      suspend_async(kind, id, custom_headers).value!
    end

    #
    # Suspend a push campaign previously activated by a call to Activate campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def suspend_async(kind, id, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/suspend'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind,'id' => id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignStateResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Push a previously saved campaign (created with Create campaign) to a set of
    # devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [CampaignPushParameters] Parameters supplied to the Push
    # Campaign operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignPushResult] operation results.
    #
    def push(kind, id, parameters, custom_headers = nil)
      response = push_async(kind, id, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Push a previously saved campaign (created with Create campaign) to a set of
    # devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [CampaignPushParameters] Parameters supplied to the Push
    # Campaign operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def push_with_http_info(kind, id, parameters, custom_headers = nil)
      push_async(kind, id, parameters, custom_headers).value!
    end

    #
    # Push a previously saved campaign (created with Create campaign) to a set of
    # devices.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param parameters [CampaignPushParameters] Parameters supplied to the Push
    # Campaign operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def push_async(kind, id, parameters, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CampaignPushParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/push'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind,'id' => id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignPushResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all the campaign statistics.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignStatisticsResult] operation results.
    #
    def get_statistics(kind, id, custom_headers = nil)
      response = get_statistics_async(kind, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all the campaign statistics.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_statistics_with_http_info(kind, id, custom_headers = nil)
      get_statistics_async(kind, id, custom_headers).value!
    end

    #
    # Get all the campaign statistics.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_statistics_async(kind, id, custom_headers = nil)
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/statistics'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'kind' => kind,'id' => id,'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignStatisticsResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Finish a push campaign previously activated by a call to Activate campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignStateResult] operation results.
    #
    def finish(kind, id, custom_headers = nil)
      response = finish_async(kind, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Finish a push campaign previously activated by a call to Activate campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def finish_with_http_info(kind, id, custom_headers = nil)
      finish_async(kind, id, custom_headers).value!
    end

    #
    # Finish a push campaign previously activated by a call to Activate campaign.
    #
    # @param kind [CampaignKinds] Campaign kind. Possible values include:
    # 'announcements', 'polls', 'dataPushes', 'nativePushes'
    # @param id [Integer] Campaign identifier.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def finish_async(kind, id, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.resource_group_name is nil' if @client.resource_group_name.nil?
      fail ArgumentError, '@client.app_collection is nil' if @client.app_collection.nil?
      fail ArgumentError, '@client.app_name is nil' if @client.app_name.nil?
      fail ArgumentError, 'kind is nil' if kind.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/finish'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => @client.resource_group_name,'appCollection' => @client.app_collection,'appName' => @client.app_name,'kind' => kind,'id' => id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignStateResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the list of campaigns.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CampaignsListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the list of campaigns.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get the list of campaigns.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CampaignsListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
