# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Network
  module Models
    #
    # ExpressRouteCircuit resource
    #
    class ExpressRouteCircuit < MsRestAzure::Resource

      include MsRestAzure

      # @return [ExpressRouteCircuitSku] Gets or sets sku
      attr_accessor :sku

      # @return [Boolean] allow classic operations
      attr_accessor :allow_classic_operations

      # @return [String] Gets or sets CircuitProvisioningState state of the
      # resource
      attr_accessor :circuit_provisioning_state

      # @return [ServiceProviderProvisioningState] Gets or sets
      # ServiceProviderProvisioningState state of the resource . Possible
      # values include: 'NotProvisioned', 'Provisioning', 'Provisioned',
      # 'Deprovisioning'
      attr_accessor :service_provider_provisioning_state

      # @return [Array<ExpressRouteCircuitAuthorization>] Gets or sets list of
      # authorizations
      attr_accessor :authorizations

      # @return [Array<ExpressRouteCircuitPeering>] Gets or sets list of
      # peerings
      attr_accessor :peerings

      # @return [String] Gets or sets ServiceKey
      attr_accessor :service_key

      # @return [String] Gets or sets ServiceProviderNotes
      attr_accessor :service_provider_notes

      # @return [ExpressRouteCircuitServiceProviderProperties] Gets or sets
      # ServiceProviderProperties
      attr_accessor :service_provider_properties

      # @return [String] Gets provisioning state of the PublicIP resource
      # Updating/Deleting/Failed
      attr_accessor :provisioning_state

      # @return [String] Gets or sets the GatewayManager Etag
      attr_accessor :gateway_manager_etag

      # @return [String] Gets a unique read-only string that changes whenever
      # the resource is updated
      attr_accessor :etag


      #
      # Mapper for ExpressRouteCircuit class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'ExpressRouteCircuit',
          type: {
            name: 'Composite',
            class_name: 'ExpressRouteCircuit',
            model_properties: {
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              sku: {
                required: false,
                serialized_name: 'sku',
                type: {
                  name: 'Composite',
                  class_name: 'ExpressRouteCircuitSku'
                }
              },
              allow_classic_operations: {
                required: false,
                serialized_name: 'properties.allowClassicOperations',
                type: {
                  name: 'Boolean'
                }
              },
              circuit_provisioning_state: {
                required: false,
                serialized_name: 'properties.circuitProvisioningState',
                type: {
                  name: 'String'
                }
              },
              service_provider_provisioning_state: {
                required: false,
                serialized_name: 'properties.serviceProviderProvisioningState',
                type: {
                  name: 'String'
                }
              },
              authorizations: {
                required: false,
                serialized_name: 'properties.authorizations',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'ExpressRouteCircuitAuthorizationElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'ExpressRouteCircuitAuthorization'
                      }
                  }
                }
              },
              peerings: {
                required: false,
                serialized_name: 'properties.peerings',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'ExpressRouteCircuitPeeringElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'ExpressRouteCircuitPeering'
                      }
                  }
                }
              },
              service_key: {
                required: false,
                serialized_name: 'properties.serviceKey',
                type: {
                  name: 'String'
                }
              },
              service_provider_notes: {
                required: false,
                serialized_name: 'properties.serviceProviderNotes',
                type: {
                  name: 'String'
                }
              },
              service_provider_properties: {
                required: false,
                serialized_name: 'properties.serviceProviderProperties',
                type: {
                  name: 'Composite',
                  class_name: 'ExpressRouteCircuitServiceProviderProperties'
                }
              },
              provisioning_state: {
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              gateway_manager_etag: {
                required: false,
                serialized_name: 'properties.gatewayManagerEtag',
                type: {
                  name: 'String'
                }
              },
              etag: {
                required: false,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
