# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Network
  module Models
    #
    # Inbound NAT rule of the loadbalancer
    #
    class InboundNatRule < MsRestAzure::SubResource

      include MsRestAzure

      # @return [SubResource] Gets or sets a reference to frontend IP Addresses
      attr_accessor :frontend_ipconfiguration

      # @return [NetworkInterfaceIPConfiguration] Gets or sets a reference to
      # a private ip address defined on a NetworkInterface of a VM. Traffic
      # sent to frontendPort of each of the frontendIPConfigurations is
      # forwarded to the backed IP
      attr_accessor :backend_ipconfiguration

      # @return [TransportProtocol] Gets or sets the transport protocol for
      # the endpoint. Possible values are Udp or Tcp. Possible values
      # include: 'Udp', 'Tcp'
      attr_accessor :protocol

      # @return [Integer] Gets or sets the port for the external endpoint. You
      # can specify any port number you choose, but the port numbers
      # specified for each role in the service must be unique. Possible
      # values range between 1 and 65535, inclusive
      attr_accessor :frontend_port

      # @return [Integer] Gets or sets a port used for internal connections on
      # the endpoint. The localPort attribute maps the eternal port of the
      # endpoint to an internal port on a role. This is useful in scenarios
      # where a role must communicate to an internal component on a port that
      # is different from the one that is exposed externally. If not
      # specified, the value of localPort is the same as the port attribute.
      # Set the value of localPort to '*' to automatically assign an
      # unallocated port that is discoverable using the runtime API
      attr_accessor :backend_port

      # @return [Integer] Gets or sets the timeout for the Tcp idle
      # connection. The value can be set between 4 and 30 minutes. The
      # default value is 4 minutes. This element is only used when the
      # protocol is set to Tcp
      attr_accessor :idle_timeout_in_minutes

      # @return [Boolean] Configures a virtual machine's endpoint for the
      # floating IP capability required to configure a SQL AlwaysOn
      # availability Group. This setting is required when using the SQL
      # Always ON availability Groups in SQL server. This setting can't be
      # changed after you create the endpoint
      attr_accessor :enable_floating_ip

      # @return [String] Gets provisioning state of the PublicIP resource
      # Updating/Deleting/Failed
      attr_accessor :provisioning_state

      # @return [String] Gets name of the resource that is unique within a
      # resource group. This name can be used to access the resource
      attr_accessor :name

      # @return [String] A unique read-only string that changes whenever the
      # resource is updated
      attr_accessor :etag


      #
      # Mapper for InboundNatRule class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'InboundNatRule',
          type: {
            name: 'Composite',
            class_name: 'InboundNatRule',
            model_properties: {
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              frontend_ipconfiguration: {
                required: false,
                serialized_name: 'properties.frontendIPConfiguration',
                type: {
                  name: 'Composite',
                  class_name: 'SubResource'
                }
              },
              backend_ipconfiguration: {
                required: false,
                read_only: true,
                serialized_name: 'properties.backendIPConfiguration',
                type: {
                  name: 'Composite',
                  class_name: 'NetworkInterfaceIPConfiguration'
                }
              },
              protocol: {
                required: false,
                serialized_name: 'properties.protocol',
                type: {
                  name: 'String'
                }
              },
              frontend_port: {
                required: false,
                serialized_name: 'properties.frontendPort',
                type: {
                  name: 'Number'
                }
              },
              backend_port: {
                required: false,
                serialized_name: 'properties.backendPort',
                type: {
                  name: 'Number'
                }
              },
              idle_timeout_in_minutes: {
                required: false,
                serialized_name: 'properties.idleTimeoutInMinutes',
                type: {
                  name: 'Number'
                }
              },
              enable_floating_ip: {
                required: false,
                serialized_name: 'properties.enableFloatingIP',
                type: {
                  name: 'Boolean'
                }
              },
              provisioning_state: {
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              etag: {
                required: false,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
