# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # Certificate purchase order
    #
    class CertificateOrder < MsRestAzure::Resource

      include MsRestAzure

      # @return [Hash{String => CertificateOrderCertificate}] State of the Key
      # Vault secret
      attr_accessor :certificates

      # @return [String] Certificate distinguished name
      attr_accessor :distinguished_name

      # @return [String] Domain Verification Token
      attr_accessor :domain_verification_token

      # @return [Integer] Duration in years (must be between 1 and 3)
      attr_accessor :validity_in_years

      # @return [Integer] Certificate Key Size
      attr_accessor :key_size

      # @return [CertificateProductType] Certificate product type. Possible
      # values include: 'StandardDomainValidatedSsl',
      # 'StandardDomainValidatedWildCardSsl'
      attr_accessor :product_type

      # @return [Boolean] Auto renew
      attr_accessor :auto_renew

      # @return [ProvisioningState] Status of certificate order. Possible
      # values include: 'Succeeded', 'Failed', 'Canceled', 'InProgress',
      # 'Deleting'
      attr_accessor :provisioning_state

      # @return [CertificateOrderStatus] Current order status. Possible values
      # include: 'Pendingissuance', 'Issued', 'Revoked', 'Canceled',
      # 'Denied', 'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired',
      # 'NotSubmitted'
      attr_accessor :status

      # @return [CertificateDetails] Signed certificate
      attr_accessor :signed_certificate

      # @return [String] Last CSR that was created for this order
      attr_accessor :csr

      # @return [CertificateDetails] Intermediate certificate
      attr_accessor :intermediate

      # @return [CertificateDetails] Root certificate
      attr_accessor :root

      # @return [String] Current serial number of the certificate
      attr_accessor :serial_number

      # @return [DateTime] Certificate last issuance time
      attr_accessor :last_certificate_issuance_time

      # @return [DateTime] Certificate expiration time
      attr_accessor :expiration_time


      #
      # Mapper for CertificateOrder class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'CertificateOrder',
          type: {
            name: 'Composite',
            class_name: 'CertificateOrder',
            model_properties: {
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              kind: {
                required: false,
                serialized_name: 'kind',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              certificates: {
                required: false,
                serialized_name: 'properties.certificates',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'CertificateOrderCertificateElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'CertificateOrderCertificate'
                      }
                  }
                }
              },
              distinguished_name: {
                required: false,
                serialized_name: 'properties.distinguishedName',
                type: {
                  name: 'String'
                }
              },
              domain_verification_token: {
                required: false,
                serialized_name: 'properties.domainVerificationToken',
                type: {
                  name: 'String'
                }
              },
              validity_in_years: {
                required: false,
                serialized_name: 'properties.validityInYears',
                type: {
                  name: 'Number'
                }
              },
              key_size: {
                required: false,
                serialized_name: 'properties.keySize',
                type: {
                  name: 'Number'
                }
              },
              product_type: {
                required: false,
                serialized_name: 'properties.productType',
                type: {
                  name: 'Enum',
                  module: 'CertificateProductType'
                }
              },
              auto_renew: {
                required: false,
                serialized_name: 'properties.autoRenew',
                type: {
                  name: 'Boolean'
                }
              },
              provisioning_state: {
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'Enum',
                  module: 'ProvisioningState'
                }
              },
              status: {
                required: false,
                serialized_name: 'properties.status',
                type: {
                  name: 'Enum',
                  module: 'CertificateOrderStatus'
                }
              },
              signed_certificate: {
                required: false,
                serialized_name: 'properties.signedCertificate',
                type: {
                  name: 'Composite',
                  class_name: 'CertificateDetails'
                }
              },
              csr: {
                required: false,
                serialized_name: 'properties.csr',
                type: {
                  name: 'String'
                }
              },
              intermediate: {
                required: false,
                serialized_name: 'properties.intermediate',
                type: {
                  name: 'Composite',
                  class_name: 'CertificateDetails'
                }
              },
              root: {
                required: false,
                serialized_name: 'properties.root',
                type: {
                  name: 'Composite',
                  class_name: 'CertificateDetails'
                }
              },
              serial_number: {
                required: false,
                serialized_name: 'properties.serialNumber',
                type: {
                  name: 'String'
                }
              },
              last_certificate_issuance_time: {
                required: false,
                serialized_name: 'properties.lastCertificateIssuanceTime',
                type: {
                  name: 'DateTime'
                }
              },
              expiration_time: {
                required: false,
                serialized_name: 'properties.expirationTime',
                type: {
                  name: 'DateTime'
                }
              }
            }
          }
        }
      end
    end
  end
end
