# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # Represents a domain
    #
    class Domain < MsRestAzure::Resource

      include MsRestAzure

      # @return [Contact] Admin contact information
      attr_accessor :contact_admin

      # @return [Contact] Billing contact information
      attr_accessor :contact_billing

      # @return [Contact] Registrant contact information
      attr_accessor :contact_registrant

      # @return [Contact] Technical contact information
      attr_accessor :contact_tech

      # @return [DomainStatus] Domain registration status. Possible values
      # include: 'Active', 'Awaiting', 'Cancelled', 'Confiscated',
      # 'Disabled', 'Excluded', 'Expired', 'Failed', 'Held', 'Locked',
      # 'Parked', 'Pending', 'Reserved', 'Reverted', 'Suspended',
      # 'Transferred', 'Unknown', 'Unlocked', 'Unparked', 'Updated',
      # 'JsonConverterFailed'
      attr_accessor :registration_status

      # @return [ProvisioningState] Domain provisioning state. Possible values
      # include: 'Succeeded', 'Failed', 'Canceled', 'InProgress', 'Deleting'
      attr_accessor :provisioning_state

      # @return [Array<String>] Name servers
      attr_accessor :name_servers

      # @return [Boolean] If true then domain privacy is enabled for this
      # domain
      attr_accessor :privacy

      # @return [DateTime] Domain creation timestamp
      attr_accessor :created_time

      # @return [DateTime] Domain expiration timestamp
      attr_accessor :expiration_time

      # @return [DateTime] Timestamp when the domain was renewed last time
      attr_accessor :last_renewed_time

      # @return [Boolean] If true then domain will renewed automatically
      attr_accessor :auto_renew

      # @return [Boolean] If true then Azure can assign this domain to Web
      # Apps. This value will be true if domain registration status is active
      # and it is hosted on name servers Azure has programmatic access to
      attr_accessor :ready_for_dns_record_management

      # @return [Array<HostName>] All hostnames derived from the domain and
      # assigned to Azure resources
      attr_accessor :managed_host_names

      # @return [DomainPurchaseConsent] Legal agreement consent
      attr_accessor :consent

      # @return Reasons why domain is not renewable
      attr_accessor :domain_not_renewable_reasons


      #
      # Mapper for Domain class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'Domain',
          type: {
            name: 'Composite',
            class_name: 'Domain',
            model_properties: {
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              kind: {
                required: false,
                serialized_name: 'kind',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              contact_admin: {
                required: false,
                serialized_name: 'properties.contactAdmin',
                type: {
                  name: 'Composite',
                  class_name: 'Contact'
                }
              },
              contact_billing: {
                required: false,
                serialized_name: 'properties.contactBilling',
                type: {
                  name: 'Composite',
                  class_name: 'Contact'
                }
              },
              contact_registrant: {
                required: false,
                serialized_name: 'properties.contactRegistrant',
                type: {
                  name: 'Composite',
                  class_name: 'Contact'
                }
              },
              contact_tech: {
                required: false,
                serialized_name: 'properties.contactTech',
                type: {
                  name: 'Composite',
                  class_name: 'Contact'
                }
              },
              registration_status: {
                required: false,
                serialized_name: 'properties.registrationStatus',
                type: {
                  name: 'Enum',
                  module: 'DomainStatus'
                }
              },
              provisioning_state: {
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'Enum',
                  module: 'ProvisioningState'
                }
              },
              name_servers: {
                required: false,
                serialized_name: 'properties.nameServers',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              privacy: {
                required: false,
                serialized_name: 'properties.privacy',
                type: {
                  name: 'Boolean'
                }
              },
              created_time: {
                required: false,
                serialized_name: 'properties.createdTime',
                type: {
                  name: 'DateTime'
                }
              },
              expiration_time: {
                required: false,
                serialized_name: 'properties.expirationTime',
                type: {
                  name: 'DateTime'
                }
              },
              last_renewed_time: {
                required: false,
                serialized_name: 'properties.lastRenewedTime',
                type: {
                  name: 'DateTime'
                }
              },
              auto_renew: {
                required: false,
                serialized_name: 'properties.autoRenew',
                type: {
                  name: 'Boolean'
                }
              },
              ready_for_dns_record_management: {
                required: false,
                serialized_name: 'properties.readyForDnsRecordManagement',
                type: {
                  name: 'Boolean'
                }
              },
              managed_host_names: {
                required: false,
                serialized_name: 'properties.managedHostNames',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'HostNameElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'HostName'
                      }
                  }
                }
              },
              consent: {
                required: false,
                serialized_name: 'properties.consent',
                type: {
                  name: 'Composite',
                  class_name: 'DomainPurchaseConsent'
                }
              },
              domain_not_renewable_reasons: {
                required: false,
                serialized_name: 'properties.domainNotRenewableReasons',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'ElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
