# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # Use these APIs to manage Azure Websites resources through the Azure
  # Resource Manager. All task operations conform to the HTTP/1.1 protocol
  # specification and each operation returns an x-ms-request-id header that
  # can be used to obtain information about the request. You must make sure
  # that requests made to these resources are secure. For more information,
  # see <a
  # href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
  # Azure Resource Manager requests.</a>
  #
  class ServerFarms
    include Azure::ARM::Web::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the ServerFarms class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Gets collection of App Service Plans in a resource group for a given
    # subscription.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] which provide lazy access to pages of the
    # response.
    #
    def get_server_farms_as_lazy(resource_group_name, custom_headers = nil)
      response = get_server_farms_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          get_server_farms_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets collection of App Service Plans in a resource group for a given
    # subscription.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ServerFarmWithRichSku>] operation results.
    #
    def get_server_farms(resource_group_name, custom_headers = nil)
      first_page = get_server_farms_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets collection of App Service Plans in a resource group for a given
    # subscription.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farms_with_http_info(resource_group_name, custom_headers = nil)
      get_server_farms_async(resource_group_name, custom_headers).value!
    end

    #
    # Gets collection of App Service Plans in a resource group for a given
    # subscription.
    #
    # @param resource_group_name [String] Name of resource group
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farms_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets specified App Service Plan in a resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmWithRichSku] operation results.
    #
    def get_server_farm(resource_group_name, name, custom_headers = nil)
      response = get_server_farm_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets specified App Service Plan in a resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_with_http_info(resource_group_name, name, custom_headers = nil)
      get_server_farm_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets specified App Service Plan in a resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmWithRichSku.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param server_farm_envelope [ServerFarmWithRichSku] Details of App Service
    # Plan
    # @param allow_pending_state [Boolean] OBSOLETE: If true, allow pending state
    # for App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmWithRichSku] operation results.
    #
    def create_or_update_server_farm(resource_group_name, name, server_farm_envelope, allow_pending_state = nil, custom_headers = nil)
      response = create_or_update_server_farm_async(resource_group_name, name, server_farm_envelope, allow_pending_state, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param server_farm_envelope [ServerFarmWithRichSku] Details of App Service
    # Plan
    # @param allow_pending_state [Boolean] OBSOLETE: If true, allow pending state
    # for App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_server_farm_async(resource_group_name, name, server_farm_envelope, allow_pending_state = nil, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_server_farm_async(resource_group_name, name, server_farm_envelope, allow_pending_state, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = ServerFarmWithRichSku.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates or updates an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param server_farm_envelope [ServerFarmWithRichSku] Details of App Service
    # Plan
    # @param allow_pending_state [Boolean] OBSOLETE: If true, allow pending state
    # for App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmWithRichSku] operation results.
    #
    def begin_create_or_update_server_farm(resource_group_name, name, server_farm_envelope, allow_pending_state = nil, custom_headers = nil)
      response = begin_create_or_update_server_farm_async(resource_group_name, name, server_farm_envelope, allow_pending_state, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param server_farm_envelope [ServerFarmWithRichSku] Details of App Service
    # Plan
    # @param allow_pending_state [Boolean] OBSOLETE: If true, allow pending state
    # for App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_server_farm_with_http_info(resource_group_name, name, server_farm_envelope, allow_pending_state = nil, custom_headers = nil)
      begin_create_or_update_server_farm_async(resource_group_name, name, server_farm_envelope, allow_pending_state, custom_headers).value!
    end

    #
    # Creates or updates an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param server_farm_envelope [ServerFarmWithRichSku] Details of App Service
    # Plan
    # @param allow_pending_state [Boolean] OBSOLETE: If true, allow pending state
    # for App Service Plan
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_server_farm_async(resource_group_name, name, server_farm_envelope, allow_pending_state = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'server_farm_envelope is nil' if server_farm_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = ServerFarmWithRichSku.mapper()
      request_content = @client.serialize(request_mapper,  server_farm_envelope, 'server_farm_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'allowPendingState' => allow_pending_state,'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmWithRichSku.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmWithRichSku.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_server_farm(resource_group_name, name, custom_headers = nil)
      response = delete_server_farm_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_server_farm_with_http_info(resource_group_name, name, custom_headers = nil)
      delete_server_farm_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Deletes a App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_server_farm_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Queries for App Serice Plan metrics
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param details [Boolean] If true, metrics are broken down per App Service
    # Plan instance
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def get_server_farm_metrics_as_lazy(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      response = get_server_farm_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          get_server_farm_metrics_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Queries for App Serice Plan metrics
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param details [Boolean] If true, metrics are broken down per App Service
    # Plan instance
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def get_server_farm_metrics(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      first_page = get_server_farm_metrics_as_lazy(resource_group_name, name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Queries for App Serice Plan metrics
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param details [Boolean] If true, metrics are broken down per App Service
    # Plan instance
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_metrics_with_http_info(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      get_server_farm_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
    end

    #
    # Queries for App Serice Plan metrics
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param details [Boolean] If true, metrics are broken down per App Service
    # Plan instance
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_metrics_async(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metrics'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List of metrics that can be queried for an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] which provide lazy access to pages of
    # the response.
    #
    def get_server_farm_metric_defintions_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_server_farm_metric_defintions_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          get_server_farm_metric_defintions_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # List of metrics that can be queried for an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<MetricDefinition>] operation results.
    #
    def get_server_farm_metric_defintions(resource_group_name, name, custom_headers = nil)
      first_page = get_server_farm_metric_defintions_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # List of metrics that can be queried for an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_metric_defintions_with_http_info(resource_group_name, name, custom_headers = nil)
      get_server_farm_metric_defintions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List of metrics that can be queried for an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_metric_defintions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metricdefinitions'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets list of vnets associated with App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_vnets_for_server_farm(resource_group_name, name, custom_headers = nil)
      response = get_vnets_for_server_farm_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets list of vnets associated with App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnets_for_server_farm_with_http_info(resource_group_name, name, custom_headers = nil)
      get_vnets_for_server_farm_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets list of vnets associated with App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnets_for_server_farm_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a vnet associated with an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def get_vnet_from_server_farm(resource_group_name, name, vnet_name, custom_headers = nil)
      response = get_vnet_from_server_farm_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a vnet associated with an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_from_server_farm_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      get_vnet_from_server_farm_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Gets a vnet associated with an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_from_server_farm_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all routes associated with a vnet, in an app service plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_routes_for_vnet(resource_group_name, name, vnet_name, custom_headers = nil)
      response = get_routes_for_vnet_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of all routes associated with a vnet, in an app service plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_routes_for_vnet_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      get_routes_for_vnet_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Gets a list of all routes associated with a vnet, in an app service plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_routes_for_vnet_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetRouteElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetRoute'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a specific route associated with a vnet, in an app service plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_route_for_vnet(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      response = get_route_for_vnet_async(resource_group_name, name, vnet_name, route_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a specific route associated with a vnet, in an app service plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_route_for_vnet_with_http_info(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      get_route_for_vnet_async(resource_group_name, name, vnet_name, route_name, custom_headers).value!
    end

    #
    # Gets a specific route associated with a vnet, in an app service plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_route_for_vnet_async(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'route_name is nil' if route_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'routeName' => route_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetRouteElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetRoute'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new route or updates an existing route for a vnet in an app
    # service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param route [VnetRoute] The route object
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetRoute] operation results.
    #
    def create_or_update_vnet_route(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      response = create_or_update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new route or updates an existing route for a vnet in an app
    # service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param route [VnetRoute] The route object
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_route_with_http_info(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      create_or_update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers).value!
    end

    #
    # Creates a new route or updates an existing route for a vnet in an app
    # service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param route [VnetRoute] The route object
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'route_name is nil' if route_name.nil?
      fail ArgumentError, 'route is nil' if route.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetRoute.mapper()
      request_content = @client.serialize(request_mapper,  route, 'route')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'routeName' => route_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 400 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetRoute.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes an existing route for a vnet in an app service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_vnet_route(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      response = delete_vnet_route_async(resource_group_name, name, vnet_name, route_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes an existing route for a vnet in an app service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_vnet_route_with_http_info(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      delete_vnet_route_async(resource_group_name, name, vnet_name, route_name, custom_headers).value!
    end

    #
    # Deletes an existing route for a vnet in an app service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_vnet_route_async(resource_group_name, name, vnet_name, route_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'route_name is nil' if route_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'routeName' => route_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new route or updates an existing route for a vnet in an app
    # service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param route [VnetRoute] The route object
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetRoute] operation results.
    #
    def update_vnet_route(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      response = update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new route or updates an existing route for a vnet in an app
    # service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param route [VnetRoute] The route object
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_route_with_http_info(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers).value!
    end

    #
    # Creates a new route or updates an existing route for a vnet in an app
    # service plan.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param vnet_name [String] Name of virtual network
    # @param route_name [String] Name of the virtual network route
    # @param route [VnetRoute] The route object
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_route_async(resource_group_name, name, vnet_name, route_name, route, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'route_name is nil' if route_name.nil?
      fail ArgumentError, 'route is nil' if route.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetRoute.mapper()
      request_content = @client.serialize(request_mapper,  route, 'route')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'routeName' => route_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :patch, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 400 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetRoute.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the vnet gateway.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of the App Service Plan
    # @param vnet_name [String] Name of the virtual network
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def get_server_farm_vnet_gateway(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      response = get_server_farm_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the vnet gateway.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of the App Service Plan
    # @param vnet_name [String] Name of the virtual network
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_vnet_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      get_server_farm_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
    end

    #
    # Gets the vnet gateway.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of the App Service Plan
    # @param vnet_name [String] Name of the virtual network
    # @param gateway_name [String] Name of the gateway. Only the 'primary' gateway
    # is supported.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the vnet gateway
    #
    # @param resource_group_name [String] The resource group
    # @param name [String] The name of the App Service Plan
    # @param vnet_name [String] The name of the virtual network
    # @param gateway_name [String] The name of the gateway. Only 'primary' is
    # supported.
    # @param connection_envelope [VnetGateway] The gateway entity.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def update_server_farm_vnet_gateway(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      response = update_server_farm_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the vnet gateway
    #
    # @param resource_group_name [String] The resource group
    # @param name [String] The name of the App Service Plan
    # @param vnet_name [String] The name of the virtual network
    # @param gateway_name [String] The name of the gateway. Only 'primary' is
    # supported.
    # @param connection_envelope [VnetGateway] The gateway entity.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_server_farm_vnet_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      update_server_farm_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
    end

    #
    # Updates the vnet gateway
    #
    # @param resource_group_name [String] The resource group
    # @param name [String] The name of the App Service Plan
    # @param vnet_name [String] The name of the virtual network
    # @param gateway_name [String] The name of the gateway. Only 'primary' is
    # supported.
    # @param connection_envelope [VnetGateway] The gateway entity.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_server_farm_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets list of Apps associated with an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param skip_token [String] Skip to of web apps in a list. If specified, the
    # resulting list will contain web apps starting from (including) the
    # skipToken. Else, the resulting list contains web apps from the start of the
    # list
    # @param filter [String] Supported filter: $filter=state eq running. Returns
    # only web apps that are currently running
    # @param top [String] List page size. If specified, results are paged.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def get_server_farm_sites_as_lazy(resource_group_name, name, skip_token = nil, filter = nil, top = nil, custom_headers = nil)
      response = get_server_farm_sites_async(resource_group_name, name, skip_token, filter, top, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          get_server_farm_sites_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets list of Apps associated with an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param skip_token [String] Skip to of web apps in a list. If specified, the
    # resulting list will contain web apps starting from (including) the
    # skipToken. Else, the resulting list contains web apps from the start of the
    # list
    # @param filter [String] Supported filter: $filter=state eq running. Returns
    # only web apps that are currently running
    # @param top [String] List page size. If specified, results are paged.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def get_server_farm_sites(resource_group_name, name, skip_token = nil, filter = nil, top = nil, custom_headers = nil)
      first_page = get_server_farm_sites_as_lazy(resource_group_name, name, skip_token, filter, top, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets list of Apps associated with an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param skip_token [String] Skip to of web apps in a list. If specified, the
    # resulting list will contain web apps starting from (including) the
    # skipToken. Else, the resulting list contains web apps from the start of the
    # list
    # @param filter [String] Supported filter: $filter=state eq running. Returns
    # only web apps that are currently running
    # @param top [String] List page size. If specified, results are paged.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_sites_with_http_info(resource_group_name, name, skip_token = nil, filter = nil, top = nil, custom_headers = nil)
      get_server_farm_sites_async(resource_group_name, name, skip_token, filter, top, custom_headers).value!
    end

    #
    # Gets list of Apps associated with an App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param skip_token [String] Skip to of web apps in a list. If specified, the
    # resulting list will contain web apps starting from (including) the
    # skipToken. Else, the resulting list contains web apps from the start of the
    # list
    # @param filter [String] Supported filter: $filter=state eq running. Returns
    # only web apps that are currently running
    # @param top [String] List page size. If specified, results are paged.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_sites_async(resource_group_name, name, skip_token = nil, filter = nil, top = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'$skipToken' => skip_token,'$filter' => filter,'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Submit a reboot request for a worker machine in the specified server farm
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of server farm
    # @param worker_name [String] Name of worker machine, typically starts with RD
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def reboot_worker_for_server_farm(resource_group_name, name, worker_name, custom_headers = nil)
      response = reboot_worker_for_server_farm_async(resource_group_name, name, worker_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Submit a reboot request for a worker machine in the specified server farm
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of server farm
    # @param worker_name [String] Name of worker machine, typically starts with RD
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reboot_worker_for_server_farm_with_http_info(resource_group_name, name, worker_name, custom_headers = nil)
      reboot_worker_for_server_farm_async(resource_group_name, name, worker_name, custom_headers).value!
    end

    #
    # Submit a reboot request for a worker machine in the specified server farm
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of server farm
    # @param worker_name [String] Name of worker machine, typically starts with RD
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reboot_worker_for_server_farm_async(resource_group_name, name, worker_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_name is nil' if worker_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/reboot'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerName' => worker_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Restarts web apps in a specified App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the apps if necessary. Hard restart always restarts
    # and reprovisions the apps
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def restart_sites_for_server_farm(resource_group_name, name, soft_restart = nil, custom_headers = nil)
      response = restart_sites_for_server_farm_async(resource_group_name, name, soft_restart, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restarts web apps in a specified App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the apps if necessary. Hard restart always restarts
    # and reprovisions the apps
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def restart_sites_for_server_farm_with_http_info(resource_group_name, name, soft_restart = nil, custom_headers = nil)
      restart_sites_for_server_farm_async(resource_group_name, name, soft_restart, custom_headers).value!
    end

    #
    # Restarts web apps in a specified App Service Plan
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of App Service Plan
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the apps if necessary. Hard restart always restarts
    # and reprovisions the apps
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def restart_sites_for_server_farm_async(resource_group_name, name, soft_restart = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'softRestart' => soft_restart,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a server farm operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of server farm
    # @param operation_id [String] Id of Server farm operation"&gt;
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmWithRichSku] operation results.
    #
    def get_server_farm_operation(resource_group_name, name, operation_id, custom_headers = nil)
      response = get_server_farm_operation_async(resource_group_name, name, operation_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a server farm operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of server farm
    # @param operation_id [String] Id of Server farm operation"&gt;
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_operation_with_http_info(resource_group_name, name, operation_id, custom_headers = nil)
      get_server_farm_operation_async(resource_group_name, name, operation_id, custom_headers).value!
    end

    #
    # Gets a server farm operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of server farm
    # @param operation_id [String] Id of Server farm operation"&gt;
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_operation_async(resource_group_name, name, operation_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'operation_id is nil' if operation_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/operationresults/{operationId}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'operationId' => operation_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmWithRichSku.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets collection of App Service Plans in a resource group for a given
    # subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] operation results.
    #
    def get_server_farms_next(next_page_link, custom_headers = nil)
      response = get_server_farms_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets collection of App Service Plans in a resource group for a given
    # subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farms_next_with_http_info(next_page_link, custom_headers = nil)
      get_server_farms_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets collection of App Service Plans in a resource group for a given
    # subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farms_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Queries for App Serice Plan metrics
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def get_server_farm_metrics_next(next_page_link, custom_headers = nil)
      response = get_server_farm_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Queries for App Serice Plan metrics
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      get_server_farm_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Queries for App Serice Plan metrics
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List of metrics that can be queried for an App Service Plan
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] operation results.
    #
    def get_server_farm_metric_defintions_next(next_page_link, custom_headers = nil)
      response = get_server_farm_metric_defintions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List of metrics that can be queried for an App Service Plan
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_metric_defintions_next_with_http_info(next_page_link, custom_headers = nil)
      get_server_farm_metric_defintions_next_async(next_page_link, custom_headers).value!
    end

    #
    # List of metrics that can be queried for an App Service Plan
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_metric_defintions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets list of Apps associated with an App Service Plan
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def get_server_farm_sites_next(next_page_link, custom_headers = nil)
      response = get_server_farm_sites_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets list of Apps associated with an App Service Plan
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_server_farm_sites_next_with_http_info(next_page_link, custom_headers = nil)
      get_server_farm_sites_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets list of Apps associated with an App Service Plan
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_server_farm_sites_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
