# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # A service client - single point of access to the REST API.
  #
  class WebSiteManagementClient < MsRestAzure::AzureServiceClient
    include MsRestAzure
    include MsRestAzure::Serialization

    # @return [String] the base URI of the service.
    attr_accessor :base_url

    # @return Credentials needed for the client to connect to Azure.
    attr_reader :credentials

    # @return [String] Subscription Id
    attr_accessor :subscription_id

    # @return [String] API Version
    attr_reader :api_version

    # @return [String] Gets or sets the preferred language for the response.
    attr_accessor :accept_language

    # @return [Integer] Gets or sets the retry timeout in seconds for Long
    # Running Operations. Default value is 30.
    attr_accessor :long_running_operation_retry_timeout

    # @return [Boolean] When set to true a unique x-ms-client-request-id value
    # is generated and included in each request. Default is true.
    attr_accessor :generate_client_request_id

    # @return Subscription credentials which uniquely identify client
    # subscription.
    attr_accessor :credentials

    # @return [CertificateOrders] certificate_orders
    attr_reader :certificate_orders

    # @return [Certificates] certificates
    attr_reader :certificates

    # @return [ClassicMobileServices] classic_mobile_services
    attr_reader :classic_mobile_services

    # @return [Domains] domains
    attr_reader :domains

    # @return [Global] global
    attr_reader :global

    # @return [GlobalCertificateOrder] global_certificate_order
    attr_reader :global_certificate_order

    # @return [GlobalDomainRegistration] global_domain_registration
    attr_reader :global_domain_registration

    # @return [GlobalResourceGroups] global_resource_groups
    attr_reader :global_resource_groups

    # @return [HostingEnvironments] hosting_environments
    attr_reader :hosting_environments

    # @return [ManagedHostingEnvironments] managed_hosting_environments
    attr_reader :managed_hosting_environments

    # @return [Provider] provider
    attr_reader :provider

    # @return [Recommendations] recommendations
    attr_reader :recommendations

    # @return [ServerFarms] server_farms
    attr_reader :server_farms

    # @return [Sites] sites
    attr_reader :sites

    # @return [TopLevelDomains] top_level_domains
    attr_reader :top_level_domains

    # @return [UsageOperations] usage_operations
    attr_reader :usage_operations

    #
    # Creates initializes a new instance of the WebSiteManagementClient class.
    # @param credentials [MsRest::ServiceClientCredentials] credentials to authorize HTTP requests made by the service client.
    # @param base_url [String] the base URI of the service.
    # @param options [Array] filters to be applied to the HTTP requests.
    #
    def initialize(credentials, base_url = nil, options = nil)
      super(credentials, options)
      @base_url = base_url || 'https://management.azure.com'

      fail ArgumentError, 'credentials is nil' if credentials.nil?
      fail ArgumentError, 'invalid type of credentials input parameter' unless credentials.is_a?(MsRest::ServiceClientCredentials)
      @credentials = credentials

      @certificate_orders = CertificateOrders.new(self)
      @certificates = Certificates.new(self)
      @classic_mobile_services = ClassicMobileServices.new(self)
      @domains = Domains.new(self)
      @global = Global.new(self)
      @global_certificate_order = GlobalCertificateOrder.new(self)
      @global_domain_registration = GlobalDomainRegistration.new(self)
      @global_resource_groups = GlobalResourceGroups.new(self)
      @hosting_environments = HostingEnvironments.new(self)
      @managed_hosting_environments = ManagedHostingEnvironments.new(self)
      @provider = Provider.new(self)
      @recommendations = Recommendations.new(self)
      @server_farms = ServerFarms.new(self)
      @sites = Sites.new(self)
      @top_level_domains = TopLevelDomains.new(self)
      @usage_operations = UsageOperations.new(self)
      @api_version = '2015-08-01'
      @accept_language = 'en-US'
      @long_running_operation_retry_timeout = 30
      @generate_client_request_id = true
    end

  end
end
