# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::CDN
  module Models
    #
    # CDN profile represents the top level resource and the entry point into
    # the CDN API. This allows users to set up a logical grouping of endpoints
    # in addition to creating shared configuration settings and selecting
    # pricing tiers and providers.
    #
    class Profile < MsRestAzure::Resource

      include MsRestAzure

      # @return [Sku] The SKU (pricing tier) of the CDN profile.
      attr_accessor :sku

      # @return [ProfileResourceState] Resource status of the profile. Possible
      # values include: 'Creating', 'Active', 'Deleting', 'Disabled'
      attr_accessor :resource_state

      # @return [String] Provisioning status of the profile.
      attr_accessor :provisioning_state


      #
      # Mapper for Profile class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'Profile',
          type: {
            name: 'Composite',
            class_name: 'Profile',
            model_properties: {
              id: {
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              sku: {
                required: true,
                serialized_name: 'sku',
                type: {
                  name: 'Composite',
                  class_name: 'Sku'
                }
              },
              resource_state: {
                required: false,
                read_only: true,
                serialized_name: 'properties.resourceState',
                type: {
                  name: 'String'
                }
              },
              provisioning_state: {
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
