# Copyright 2012 Mail Bypass, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

dir = File.dirname(__FILE__)

require 'rubygems'
require 'fakeweb'
require 'rr'
require 'json'
require 'action_mailer'
require "#{dir}/spec_core_extensions"
require "#{dir}/../lib/messagebus_ruby_api"


def json_valid_send
  json = <<JAVASCRIPT
{"statusCode":202,"statusMessage":"OK","statusTime":"2011-10-10T21:32:14.195Z","successCount":1,"failureCount":0,"results":[{"toEmail":"apitest1@messagebus.com","messageId":"51efcf00f38711e0a93640405cc99fee","messageStatus":0}]}
JAVASCRIPT
  json
end

def json_incomplete_results
  json = <<JAVASCRIPT
{"statusCode":202}
JAVASCRIPT
  json
end

def json_invalid_results
  json = <<JAVASCRIPT
GARBAGE_JSON
JAVASCRIPT
  json
end

def json_mailing_lists
  json = <<JAVASCRIPT
{"statusCode":200,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z","results":[{"name":"list_1","mailingListKey":"51efcf00f38711e0a93640405cc99fee"}]}
JAVASCRIPT
  json
end

def json_mailing_list_upload
  json = <<JAVASCRIPT
{"invalidCount":1,"invalidLines":[3],"mailngListKey":"392d08c0694811e1a7dd4040f34d0a26","statusCode":201,"statusMessage":"","statusTime":"2012-03-08T17:57:51.596Z","validCount":2}
JAVASCRIPT
  json
end

def json_mailing_list_overwrite
  json = <<JAVASCRIPT
{"invalidCount":0,"invalidLines":[0],"mailingListKey":"392d08c0694811e1a7dd4040f34d0a26","statusCode":201,"statusMessage":"","statusTime":"2012-03-08T17:57:51.596Z","validCount":3}
JAVASCRIPT
  json
end

def json_mailing_list_create
  json = <<JAVASCRIPT
{"statusCode":201,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z","key":"51efcf00f38711e0a93640405cc99fee"}
JAVASCRIPT
  json
end

def json_campaign_send
  json = <<JAVASCRIPT
{"statusCode":202,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z","campaignKey":"51efcf00f38711e0a93640405cc99fee"}
JAVASCRIPT
  json
end

def json_unsubscribes
  json = <<JAVASCRIPT
{"statusCode":200,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z","results":[{"toEmail":"joe@example.com","time":"2011-10-10T21:32:14.195Z"}]}
JAVASCRIPT
  json
end

def json_feedbackloops
  json = <<JAVASCRIPT
{"statusCode":200,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z","results":[{"toEmail":"joe@example.com","time":"2011-10-10T21:32:14.195Z","messageId":"62cf5460b7b0012e8cb440406818e8c7"}]}
JAVASCRIPT
  json
end

def json_delivery_errors
  json = <<JAVASCRIPT
{"statusCode":200,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z","results":[{"toEmail":"joe@example.com", "messageId":"62cf5460b7b0012e8cb440406818e8c7","time":"2011-10-10T21:32:14.195Z","DSNCode":"5.1.1"}]}
JAVASCRIPT
  json
end

def json_stats
  json = <<JAVASCRIPT
{"statusCode":200,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z","results":[{"date":"2011-09-01", "sent":10,"errors":2,"opens":3,"uniqueOpens":2,"clicks":0}]}
JAVASCRIPT
  json
end

def json_response_201
  json = <<JAVASCRIPT
{"statusCode":201,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z"}
JAVASCRIPT
  json
end

def json_response_200
  json = <<JAVASCRIPT
{"statusCode":200,"statusMessage":"","statusTime":"2011-10-10T21:32:14.195Z"}
JAVASCRIPT
  json
end

def json_response_404
  json = <<JAVASCRIPT
{"statusCode":404,"statusMessage":"Invalid URL - Mailing list key not found.","statusTime":"2011-10-10T21:32:14.195Z"}
JAVASCRIPT
  json
end



ActionMailer::Base.add_delivery_method :messagebus, MessagebusApi::Messagebus, @api_key
ActionMailer::Base.delivery_method = :messagebus

class MessageBusActionMailerTest < ActionMailer::Base
  default :to => "someone@example.com",
          :from => "no-reply@messagebus.com",
          :body => "This is a test",
          :subject => "Unit Test",
          :return_path => "bounce@bounce.example.com"

  def new_message(from_email, bcc = "", x_headers = {})
    x_headers.each do |key, value|
      headers[key] = value
    end

    mail(:bcc => bcc) if bcc != ""
    mail(:from => from_email)
  end
end
