require 'raven/interface'

module Raven
  class MessageInterface < Interface
    attr_accessor :message, :params

    def initialize(*arguments)
      self.params = []
      super(*arguments)
    end

    def unformatted_message
      params.nil? ? message : message % params
    end

    def self.sentry_alias
      :logentry
    end
  end
end
