//! This module contains some standard interfaces and an easy way to call them.
//!
//! See the [D-Bus specification](https://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces) for more information about these standard interfaces.
//!
//! The code here was originally created by dbus-codegen.


// cargo run -- -d org.freedesktop.Notifications -p /org/freedesktop/Notifications -m none -c blocking -g -i "org.freedesktop.DBus"
// This code was autogenerated with dbus-codegen-rust, see https://github.com/diwic/dbus-rs

pub mod org_freedesktop_dbus {

#![allow(missing_docs)]

#[derive(Debug, PartialEq, Eq, Copy, Clone)]
pub enum RequestNameReply {
    PrimaryOwner = 1,
    InQueue = 2,
    Exists = 3,
    AlreadyOwner = 4,
}

#[derive(Debug, PartialEq, Eq, Copy, Clone)]
pub enum ReleaseNameReply {
    Released = 1,
    NonExistent = 2,
    NotOwner = 3,
}

use crate as dbus;
use crate::arg;
use crate::blocking;

pub trait Properties {
    fn get<R0: for<'b> arg::Get<'b>>(&self, interface_name: &str, property_name: &str) -> Result<R0, dbus::Error>;
    fn get_all(&self, interface_name: &str) -> Result<::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>, dbus::Error>;
    fn set<I2: arg::Arg + arg::Append>(&self, interface_name: &str, property_name: &str, value: I2) -> Result<(), dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> Properties for blocking::Proxy<'a, C> {

    fn get<R0: for<'b> arg::Get<'b>>(&self, interface_name: &str, property_name: &str) -> Result<R0, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Properties", "Get", (interface_name, property_name, ))
            .map(|r: (arg::Variant<R0>,)| (r.0).0)
    }

    fn get_all(&self, interface_name: &str) -> Result<::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Properties", "GetAll", (interface_name, ))
            .map(|r: (::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>,)| r.0)
    }

    fn set<I2: arg::Arg + arg::Append>(&self, interface_name: &str, property_name: &str, value: I2) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus.Properties", "Set", (interface_name, property_name, arg::Variant(value), ))
    }
}

#[derive(Debug)]
pub struct PropertiesPropertiesChanged {
    pub interface_name: String,
    pub changed_properties: ::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>,
    pub invalidated_properties: Vec<String>,
}

impl arg::AppendAll for PropertiesPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.interface_name, i);
        arg::RefArg::append(&self.changed_properties, i);
        arg::RefArg::append(&self.invalidated_properties, i);
    }
}

impl arg::ReadAll for PropertiesPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(PropertiesPropertiesChanged {
            interface_name: i.read()?,
            changed_properties: i.read()?,
            invalidated_properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for PropertiesPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.DBus.Properties";
}

pub trait Introspectable {
    fn introspect(&self) -> Result<String, dbus::Error>;
}

impl<'a, C: ::std::ops::Deref<Target=blocking::Connection>> Introspectable for blocking::Proxy<'a, C> {

    fn introspect(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Introspectable", "Introspect", ())
            .map(|r: (String,)| r.0)
    }
}

pub trait Peer {
    fn ping(&self) -> Result<(), dbus::Error>;
    fn get_machine_id(&self) -> Result<String, dbus::Error>;
}

impl<'a, C: ::std::ops::Deref<Target=blocking::Connection>> Peer for blocking::Proxy<'a, C> {

    fn ping(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus.Peer", "Ping", ())
    }

    fn get_machine_id(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Peer", "GetMachineId", ())
            .map(|r: (String,)| r.0)
    }
}

pub trait ObjectManager {
    fn get_managed_objects(&self) -> Result<::std::collections::HashMap<dbus::Path<'static>, ::std::collections::HashMap<String, ::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>>>, dbus::Error>;
}

impl<'a, C: ::std::ops::Deref<Target=blocking::Connection>> ObjectManager for blocking::Proxy<'a, C> {

    fn get_managed_objects(&self) -> Result<::std::collections::HashMap<dbus::Path<'static>, ::std::collections::HashMap<String, ::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>>>, dbus::Error> {
        self.method_call("org.freedesktop.DBus.ObjectManager", "GetManagedObjects", ())
            .and_then(|r: (::std::collections::HashMap<dbus::Path<'static>, ::std::collections::HashMap<String, ::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>>>, )| Ok(r.0, ))
    }
}

#[derive(Debug)]
pub struct ObjectManagerInterfacesAdded {
    pub object: dbus::Path<'static>,
    pub interfaces: ::std::collections::HashMap<String, ::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>>,
}

impl arg::AppendAll for ObjectManagerInterfacesAdded {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.object, i);
        arg::RefArg::append(&self.interfaces, i);
    }
}

impl arg::ReadAll for ObjectManagerInterfacesAdded {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ObjectManagerInterfacesAdded {
            object: i.read()?,
            interfaces: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ObjectManagerInterfacesAdded {
    const NAME: &'static str = "InterfacesAdded";
    const INTERFACE: &'static str = "org.freedesktop.DBus.ObjectManager";
}

#[derive(Debug)]
pub struct ObjectManagerInterfacesRemoved {
    pub object: dbus::Path<'static>,
    pub interfaces: Vec<String>,
}

impl arg::AppendAll for ObjectManagerInterfacesRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.object, i);
        arg::RefArg::append(&self.interfaces, i);
    }
}

impl arg::ReadAll for ObjectManagerInterfacesRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ObjectManagerInterfacesRemoved {
            object: i.read()?,
            interfaces: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ObjectManagerInterfacesRemoved {
    const NAME: &'static str = "InterfacesRemoved";
    const INTERFACE: &'static str = "org.freedesktop.DBus.ObjectManager";
}

// Autogenerated code end


pub (crate) fn request_name<S: blocking::BlockingSender>(s: &S, name: &str, allow_replacement: bool, replace_existing: bool, do_not_queue: bool)
    -> Result<RequestNameReply, dbus::Error> {
    let flags: u32 =
        if allow_replacement { 1 } else { 0 } +
        if replace_existing { 2 } else { 0 } +
        if do_not_queue { 4 } else { 0 };
    let proxy = super::proxy(s);
    use super::org_freedesktop::DBus;
    let r = proxy.request_name(name, flags)?;
    use RequestNameReply::*;
    let all = [PrimaryOwner, InQueue, Exists, AlreadyOwner];
    all.iter().find(|x| **x as u32 == r).copied().ok_or_else(||
        dbus::Error::new_failed("Invalid reply from DBus server")
    )
}

pub (crate) fn release_name<S: blocking::BlockingSender>(s: &S, name: &str)
    -> Result<ReleaseNameReply, dbus::Error> {

    let proxy = super::proxy(s);
    use super::org_freedesktop::DBus;
    let r = proxy.release_name(name)?;
    use ReleaseNameReply::*;
    let all = [Released, NonExistent, NotOwner];
    all.iter().find(|x| **x as u32 == r).copied().ok_or_else(||
        dbus::Error::new_failed("Invalid reply from DBus server")
    )
}

}

pub (crate) fn proxy<C>(c: C) -> crate::blocking::Proxy<'static, C> {
    crate::blocking::Proxy::new("org.freedesktop.DBus", "/org/freedesktop/DBus", std::time::Duration::from_millis(5000), c)
}

/// Not public yet, because of lack of named arguments
pub (super) mod org_freedesktop {


use crate as dbus;
use crate::arg;
use crate::blocking;

// autogenerated from
// cargo run -- -d org.freedesktop.DBus -p /org/freedesktop/DBus -m none -c blocking -g -i "org.freedesktop."

pub trait DBus {
    fn hello(&self) -> Result<String, dbus::Error>;
    fn request_name(&self, arg0: &str, arg1: u32) -> Result<u32, dbus::Error>;
    fn release_name(&self, arg0: &str) -> Result<u32, dbus::Error>;
    fn start_service_by_name(&self, arg0: &str, arg1: u32) -> Result<u32, dbus::Error>;
    fn update_activation_environment(&self, arg0: ::std::collections::HashMap<&str, &str>) -> Result<(), dbus::Error>;
    fn name_has_owner(&self, arg0: &str) -> Result<bool, dbus::Error>;
    fn list_names(&self) -> Result<Vec<String>, dbus::Error>;
    fn list_activatable_names(&self) -> Result<Vec<String>, dbus::Error>;
    fn add_match(&self, arg0: &str) -> Result<(), dbus::Error>;
    fn remove_match(&self, arg0: &str) -> Result<(), dbus::Error>;
    fn get_name_owner(&self, arg0: &str) -> Result<String, dbus::Error>;
    fn list_queued_owners(&self, arg0: &str) -> Result<Vec<String>, dbus::Error>;
    fn get_connection_unix_user(&self, arg0: &str) -> Result<u32, dbus::Error>;
    fn get_connection_unix_process_id(&self, arg0: &str) -> Result<u32, dbus::Error>;
    fn get_adt_audit_session_data(&self, arg0: &str) -> Result<Vec<u8>, dbus::Error>;
    fn get_connection_selinux_security_context(&self, arg0: &str) -> Result<Vec<u8>, dbus::Error>;
    fn get_connection_app_armor_security_context(&self, arg0: &str) -> Result<String, dbus::Error>;
    fn reload_config(&self) -> Result<(), dbus::Error>;
    fn get_id(&self) -> Result<String, dbus::Error>;
    fn get_connection_credentials(&self, arg0: &str) -> Result<::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>, dbus::Error>;
    fn get_features(&self) -> Result<Vec<String>, dbus::Error>;
    fn get_interfaces(&self) -> Result<Vec<String>, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> DBus for blocking::Proxy<'a, C> {

    fn hello(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "Hello", ())
            .and_then(|r: (String,)| Ok(r.0))
    }

    fn request_name(&self, arg0: &str, arg1: u32) -> Result<u32, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "RequestName", (arg0, arg1, ))
            .and_then(|r: (u32,)| Ok(r.0))
    }

    fn release_name(&self, arg0: &str) -> Result<u32, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "ReleaseName", (arg0, ))
            .and_then(|r: (u32,)| Ok(r.0))
    }

    fn start_service_by_name(&self, arg0: &str, arg1: u32) -> Result<u32, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "StartServiceByName", (arg0, arg1, ))
            .and_then(|r: (u32,)| Ok(r.0))
    }

    fn update_activation_environment(&self, arg0: ::std::collections::HashMap<&str, &str>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus", "UpdateActivationEnvironment", (arg0, ))
    }

    fn name_has_owner(&self, arg0: &str) -> Result<bool, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "NameHasOwner", (arg0, ))
            .and_then(|r: (bool,)| Ok(r.0))
    }

    fn list_names(&self) -> Result<Vec<String>, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "ListNames", ())
            .and_then(|r: (Vec<String>,)| Ok(r.0))
    }

    fn list_activatable_names(&self) -> Result<Vec<String>, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "ListActivatableNames", ())
            .and_then(|r: (Vec<String>,)| Ok(r.0))
    }

    fn add_match(&self, arg0: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus", "AddMatch", (arg0, ))
    }

    fn remove_match(&self, arg0: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus", "RemoveMatch", (arg0, ))
    }

    fn get_name_owner(&self, arg0: &str) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "GetNameOwner", (arg0, ))
            .and_then(|r: (String,)| Ok(r.0))
    }

    fn list_queued_owners(&self, arg0: &str) -> Result<Vec<String>, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "ListQueuedOwners", (arg0, ))
            .and_then(|r: (Vec<String>,)| Ok(r.0))
    }

    fn get_connection_unix_user(&self, arg0: &str) -> Result<u32, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "GetConnectionUnixUser", (arg0, ))
            .and_then(|r: (u32,)| Ok(r.0))
    }

    fn get_connection_unix_process_id(&self, arg0: &str) -> Result<u32, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "GetConnectionUnixProcessID", (arg0, ))
            .and_then(|r: (u32,)| Ok(r.0))
    }

    fn get_adt_audit_session_data(&self, arg0: &str) -> Result<Vec<u8>, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "GetAdtAuditSessionData", (arg0, ))
            .and_then(|r: (Vec<u8>,)| Ok(r.0))
    }

    fn get_connection_selinux_security_context(&self, arg0: &str) -> Result<Vec<u8>, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "GetConnectionSELinuxSecurityContext", (arg0, ))
            .and_then(|r: (Vec<u8>,)| Ok(r.0))
    }

    fn get_connection_app_armor_security_context(&self, arg0: &str) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "GetConnectionAppArmorSecurityContext", (arg0, ))
            .and_then(|r: (String,)| Ok(r.0))
    }

    fn reload_config(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus", "ReloadConfig", ())
    }

    fn get_id(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "GetId", ())
            .and_then(|r: (String,)| Ok(r.0))
    }

    fn get_connection_credentials(&self, arg0: &str) -> Result<::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>, dbus::Error> {
        self.method_call("org.freedesktop.DBus", "GetConnectionCredentials", (arg0, ))
            .and_then(|r: (::std::collections::HashMap<String, arg::Variant<Box<dyn arg::RefArg + 'static>>>,)| Ok(r.0))
    }

    fn get_features(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.DBus", "Features")
    }

    fn get_interfaces(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.DBus", "Interfaces")
    }
}

#[derive(Debug)]
pub struct DBusNameOwnerChanged {
    pub arg0: String,
    pub arg1: String,
    pub arg2: String,
}

impl arg::AppendAll for DBusNameOwnerChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
        arg::RefArg::append(&self.arg2, i);
    }
}

impl arg::ReadAll for DBusNameOwnerChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DBusNameOwnerChanged {
            arg0: i.read()?,
            arg1: i.read()?,
            arg2: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DBusNameOwnerChanged {
    const NAME: &'static str = "NameOwnerChanged";
    const INTERFACE: &'static str = "org.freedesktop.DBus";
}

#[derive(Debug)]
pub struct DBusNameLost {
    pub arg0: String,
}

impl arg::AppendAll for DBusNameLost {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
    }
}

impl arg::ReadAll for DBusNameLost {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DBusNameLost {
            arg0: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DBusNameLost {
    const NAME: &'static str = "NameLost";
    const INTERFACE: &'static str = "org.freedesktop.DBus";
}

#[derive(Debug)]
pub struct DBusNameAcquired {
    pub arg0: String,
}

impl arg::AppendAll for DBusNameAcquired {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
    }
}

impl arg::ReadAll for DBusNameAcquired {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(DBusNameAcquired {
            arg0: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for DBusNameAcquired {
    const NAME: &'static str = "NameAcquired";
    const INTERFACE: &'static str = "org.freedesktop.DBus";
}


}
