// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, ToastPriority};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwToast")]
    pub struct Toast(Object<ffi::AdwToast, ffi::AdwToastClass>);

    match fn {
        type_ => || ffi::adw_toast_get_type(),
    }
}

impl Toast {
    #[doc(alias = "adw_toast_new")]
    pub fn new(title: &str) -> Toast {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::adw_toast_new(title.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Toast`] objects.
    ///
    /// This method returns an instance of [`ToastBuilder`](crate::builders::ToastBuilder) which can be used to create [`Toast`] objects.
    pub fn builder() -> ToastBuilder {
        ToastBuilder::new()
    }

    #[doc(alias = "adw_toast_dismiss")]
    pub fn dismiss(&self) {
        unsafe {
            ffi::adw_toast_dismiss(self.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_toast_get_action_name")]
    #[doc(alias = "get_action_name")]
    #[doc(alias = "action-name")]
    pub fn action_name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::adw_toast_get_action_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_toast_get_action_target_value")]
    #[doc(alias = "get_action_target_value")]
    #[doc(alias = "action-target")]
    pub fn action_target_value(&self) -> Option<glib::Variant> {
        unsafe {
            from_glib_none(ffi::adw_toast_get_action_target_value(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_toast_get_button_label")]
    #[doc(alias = "get_button_label")]
    #[doc(alias = "button-label")]
    pub fn button_label(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::adw_toast_get_button_label(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "adw_toast_get_custom_title")]
    #[doc(alias = "get_custom_title")]
    #[doc(alias = "custom-title")]
    pub fn custom_title(&self) -> Option<gtk::Widget> {
        unsafe { from_glib_none(ffi::adw_toast_get_custom_title(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_toast_get_priority")]
    #[doc(alias = "get_priority")]
    pub fn priority(&self) -> ToastPriority {
        unsafe { from_glib(ffi::adw_toast_get_priority(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_toast_get_timeout")]
    #[doc(alias = "get_timeout")]
    pub fn timeout(&self) -> u32 {
        unsafe { ffi::adw_toast_get_timeout(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_toast_get_title")]
    #[doc(alias = "get_title")]
    pub fn title(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::adw_toast_get_title(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adw_toast_get_use_markup")]
    #[doc(alias = "get_use_markup")]
    #[doc(alias = "use-markup")]
    pub fn uses_markup(&self) -> bool {
        unsafe { from_glib(ffi::adw_toast_get_use_markup(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_toast_set_action_name")]
    #[doc(alias = "action-name")]
    pub fn set_action_name(&self, action_name: Option<&str>) {
        unsafe {
            ffi::adw_toast_set_action_name(self.to_glib_none().0, action_name.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_toast_set_action_target_value")]
    #[doc(alias = "action-target")]
    pub fn set_action_target_value(&self, action_target: Option<&glib::Variant>) {
        unsafe {
            ffi::adw_toast_set_action_target_value(
                self.to_glib_none().0,
                action_target.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_toast_set_button_label")]
    #[doc(alias = "button-label")]
    pub fn set_button_label(&self, button_label: Option<&str>) {
        unsafe {
            ffi::adw_toast_set_button_label(self.to_glib_none().0, button_label.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "adw_toast_set_custom_title")]
    #[doc(alias = "custom-title")]
    pub fn set_custom_title(&self, widget: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::adw_toast_set_custom_title(
                self.to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_toast_set_detailed_action_name")]
    pub fn set_detailed_action_name(&self, detailed_action_name: Option<&str>) {
        unsafe {
            ffi::adw_toast_set_detailed_action_name(
                self.to_glib_none().0,
                detailed_action_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_toast_set_priority")]
    #[doc(alias = "priority")]
    pub fn set_priority(&self, priority: ToastPriority) {
        unsafe {
            ffi::adw_toast_set_priority(self.to_glib_none().0, priority.into_glib());
        }
    }

    #[doc(alias = "adw_toast_set_timeout")]
    #[doc(alias = "timeout")]
    pub fn set_timeout(&self, timeout: u32) {
        unsafe {
            ffi::adw_toast_set_timeout(self.to_glib_none().0, timeout);
        }
    }

    #[doc(alias = "adw_toast_set_title")]
    #[doc(alias = "title")]
    pub fn set_title(&self, title: &str) {
        unsafe {
            ffi::adw_toast_set_title(self.to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adw_toast_set_use_markup")]
    #[doc(alias = "use-markup")]
    pub fn set_use_markup(&self, use_markup: bool) {
        unsafe {
            ffi::adw_toast_set_use_markup(self.to_glib_none().0, use_markup.into_glib());
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "button-clicked")]
    pub fn connect_button_clicked<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn button_clicked_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"button-clicked\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    button_clicked_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "dismissed")]
    pub fn connect_dismissed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn dismissed_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"dismissed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    dismissed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "action-name")]
    pub fn connect_action_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_action_name_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::action-name\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_action_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "action-target")]
    pub fn connect_action_target_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_action_target_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::action-target\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_action_target_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "button-label")]
    pub fn connect_button_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_button_label_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::button-label\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_button_label_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "custom-title")]
    pub fn connect_custom_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_custom_title_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::custom-title\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_custom_title_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "priority")]
    pub fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_priority_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::priority\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_priority_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "timeout")]
    pub fn connect_timeout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_timeout_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::timeout\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_timeout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "title")]
    pub fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_title_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "use-markup")]
    pub fn connect_use_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_markup_trampoline<F: Fn(&Toast) + 'static>(
            this: *mut ffi::AdwToast,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-markup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_use_markup_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Toast {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Toast`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ToastBuilder {
    builder: glib::object::ObjectBuilder<'static, Toast>,
}

impl ToastBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn action_name(self, action_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("action-name", action_name.into()),
        }
    }

    pub fn action_target(self, action_target: &glib::Variant) -> Self {
        Self {
            builder: self
                .builder
                .property("action-target", action_target.clone()),
        }
    }

    pub fn button_label(self, button_label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("button-label", button_label.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn custom_title(self, custom_title: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("custom-title", custom_title.clone().upcast()),
        }
    }

    pub fn priority(self, priority: ToastPriority) -> Self {
        Self {
            builder: self.builder.property("priority", priority),
        }
    }

    pub fn timeout(self, timeout: u32) -> Self {
        Self {
            builder: self.builder.property("timeout", timeout),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    pub fn use_markup(self, use_markup: bool) -> Self {
        Self {
            builder: self.builder.property("use-markup", use_markup),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Toast`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Toast {
        self.builder.build()
    }
}
