/* rygel-http-byte-seek-test.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-http-byte-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_BYTE_SEEK_TEST (rygel_http_byte_seek_test_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTest))
#define RYGEL_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))

typedef struct _RygelHTTPByteSeekTest RygelHTTPByteSeekTest;
typedef struct _RygelHTTPByteSeekTestClass RygelHTTPByteSeekTestClass;
typedef struct _RygelHTTPByteSeekTestPrivate RygelHTTPByteSeekTestPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPIdentityHandler {
	GObject parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gint64 size;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
	gint64 size;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gint64 size;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaItem* item;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPIdentityHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTest {
	GObject parent_instance;
	RygelHTTPByteSeekTestPrivate * priv;
};

struct _RygelHTTPByteSeekTestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTestPrivate {
	GRegex* range_regex;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_byte_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (GObject* obj);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (GObject* obj);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_inverted_range (void);
RygelHTTPGet* rygel_http_get_construct_inverted_range (GType object_type);
RygelHTTPGet* rygel_http_get_new_invalid_range (void);
RygelHTTPGet* rygel_http_get_construct_invalid_range (GType object_type);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_byte_seek_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestPrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_TEST_DUMMY_PROPERTY
};
gint rygel_http_byte_seek_test_main (gchar** args, int args_length1);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error);
static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void rygel_http_byte_seek_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type) {
	RygelHTTPIdentityHandler * self = NULL;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPIdentityHandler*) g_object_new (object_type, NULL);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 296 "rygel-http-byte-seek-test.c"
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER);
#line 303 "rygel-http-byte-seek-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
#line 310 "rygel-http-byte-seek-test.c"
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelMediaItem*) g_object_new (object_type, NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 336 "rygel-http-byte-seek-test.c"
}


RygelMediaItem* rygel_media_item_new (void) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 343 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 352 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 2048;
#line 359 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 369 "rygel-http-byte-seek-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail * self = NULL;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 391 "rygel-http-byte-seek-test.c"
}


RygelThumbnail* rygel_thumbnail_new (void) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 398 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnail_finalize;
#line 407 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
#line 35 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 1024;
#line 414 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_finalize (GObject* obj) {
	RygelThumbnail * self;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_THUMBNAIL (obj);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_thumbnail_parent_class)->finalize (obj);
#line 424 "rygel-http-byte-seek-test.c"
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 446 "rygel-http-byte-seek-test.c"
}


RygelSubtitle* rygel_subtitle_new (void) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 453 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_finalize;
#line 462 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
#line 39 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->size = (gint64) 512;
#line 469 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_finalize (GObject* obj) {
	RygelSubtitle * self;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_SUBTITLE (obj);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_subtitle_parent_class)->finalize (obj);
#line 479 "rygel-http-byte-seek-test.c"
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 498 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelHTTPIdentityHandler* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelSubtitle* _tmp5_;
	RygelSubtitle* _tmp6_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->msg = _tmp0_;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = rygel_media_item_new ();
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->item);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->item = _tmp1_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_identity_handler_new ();
#line 55 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 55 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->handler = _tmp2_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = thumbnail;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->thumbnail = _tmp4_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp5_ = subtitle;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->subtitle = _tmp6_;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 549 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, thumbnail, subtitle);
#line 556 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, (gint64) (-1));
#line 60 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 577 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 60 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start, thumbnail, subtitle);
#line 584 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = stop;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, (gint64) 0, _tmp2_);
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 605 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 68 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop, thumbnail, subtitle);
#line 612 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = stop;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, _tmp2_, _tmp3_);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 636 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
#line 76 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
#line 643 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_inverted_range (GType object_type) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, NULL, NULL);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = self->msg;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	soup_message_headers_append (_tmp1_, "Range", "bytes=34-0");
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 661 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_inverted_range (void) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_inverted_range (RYGEL_TYPE_HTTP_GET);
#line 668 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_construct_invalid_range (GType object_type) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, NULL, NULL);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = self->msg;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	soup_message_headers_append (_tmp1_, "Range", "bytes=a-b");
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 686 "rygel-http-byte-seek-test.c"
}


RygelHTTPGet* rygel_http_get_new_invalid_range (void) {
#line 90 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_invalid_range (RYGEL_TYPE_HTTP_GET);
#line 693 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = self->msg;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = start;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = stop;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	soup_message_headers_set_range (_tmp1_, _tmp2_, _tmp3_);
#line 714 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 723 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_HTTP_GET (obj);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->msg);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->item);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->thumbnail);
#line 48 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->subtitle);
#line 50 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (self->handler);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 747 "rygel-http-byte-seek-test.c"
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


gint rygel_http_byte_seek_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPByteSeekTest* _tmp0_;
		RygelHTTPByteSeekTest* test;
		RygelHTTPByteSeekTest* _tmp1_;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp0_ = rygel_http_byte_seek_test_new ();
#line 105 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		test = _tmp0_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp1_ = test;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		rygel_http_byte_seek_test_run (_tmp1_, &_inner_error_);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 107 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (test);
#line 107 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
#line 784 "rygel-http-byte-seek-test.c"
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (test);
#line 791 "rygel-http-byte-seek-test.c"
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		result = 77;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return result;
#line 807 "rygel-http-byte-seek-test.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp2_ = _error_;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp3_ = _tmp2_->message;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("rygel-http-byte-seek-test.vala:111: %s", _tmp3_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		result = -1;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return result;
#line 831 "rygel-http-byte-seek-test.c"
	}
	__finally0:
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return 0;
#line 842 "rygel-http-byte-seek-test.c"
	}
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	result = 0;
#line 116 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return result;
#line 848 "rygel-http-byte-seek-test.c"
}


int main (int argc, char ** argv) {
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_thread_init (NULL);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_type_init ();
#line 103 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_byte_seek_test_main (argv, argc);
#line 859 "rygel-http-byte-seek-test.c"
}


void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelThumbnail** _tmp1_ = NULL;
	RygelThumbnail** thumbnails;
	gint thumbnails_length1;
	gint _thumbnails_size_;
	RygelSubtitle* _tmp2_;
	RygelSubtitle** _tmp3_ = NULL;
	RygelSubtitle** subtitles;
	gint subtitles_length1;
	gint _subtitles_size_;
	RygelThumbnail** _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = rygel_thumbnail_new ();
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = g_new0 (RygelThumbnail*, 2 + 1);
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_[0] = NULL;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_[1] = _tmp0_;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails = _tmp1_;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails_length1 = 2;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_thumbnails_size_ = thumbnails_length1;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_subtitle_new ();
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = g_new0 (RygelSubtitle*, 2 + 1);
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_[0] = NULL;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_[1] = _tmp2_;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles = _tmp3_;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles_length1 = 2;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_subtitles_size_ = subtitles_length1;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = thumbnails;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4__length1 = thumbnails_length1;
#line 911 "rygel-http-byte-seek-test.c"
	{
		RygelThumbnail** thumbnail_collection = NULL;
		gint thumbnail_collection_length1 = 0;
		gint _thumbnail_collection_size_ = 0;
		gint thumbnail_it = 0;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		thumbnail_collection = _tmp4_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		thumbnail_collection_length1 = _tmp4__length1;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		for (thumbnail_it = 0; thumbnail_it < _tmp4__length1; thumbnail_it = thumbnail_it + 1) {
#line 923 "rygel-http-byte-seek-test.c"
			RygelThumbnail* _tmp5_;
			RygelThumbnail* thumbnail = NULL;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp5_ = _g_object_ref0 (thumbnail_collection[thumbnail_it]);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnail = _tmp5_;
#line 930 "rygel-http-byte-seek-test.c"
			{
				RygelSubtitle** _tmp6_;
				gint _tmp6__length1;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_tmp6_ = subtitles;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_tmp6__length1 = subtitles_length1;
#line 938 "rygel-http-byte-seek-test.c"
				{
					RygelSubtitle** subtitle_collection = NULL;
					gint subtitle_collection_length1 = 0;
					gint _subtitle_collection_size_ = 0;
					gint subtitle_it = 0;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					subtitle_collection = _tmp6_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					subtitle_collection_length1 = _tmp6__length1;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
					for (subtitle_it = 0; subtitle_it < _tmp6__length1; subtitle_it = subtitle_it + 1) {
#line 950 "rygel-http-byte-seek-test.c"
						RygelSubtitle* _tmp7_;
						RygelSubtitle* subtitle = NULL;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
						_tmp7_ = _g_object_ref0 (subtitle_collection[subtitle_it]);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
						subtitle = _tmp7_;
#line 957 "rygel-http-byte-seek-test.c"
						{
							RygelThumbnail* _tmp8_;
							RygelSubtitle* _tmp9_;
							RygelThumbnail* _tmp10_;
							RygelSubtitle* _tmp11_;
							RygelThumbnail* _tmp12_;
							RygelSubtitle* _tmp13_;
							RygelThumbnail* _tmp14_;
							RygelSubtitle* _tmp15_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp8_ = thumbnail;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp9_ = subtitle;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_no_seek (self, _tmp8_, _tmp9_, &_inner_error_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 989 "rygel-http-byte-seek-test.c"
								} else {
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1005 "rygel-http-byte-seek-test.c"
								}
							}
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp10_ = thumbnail;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp11_ = subtitle;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_start_only_seek (self, _tmp10_, _tmp11_, &_inner_error_);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1030 "rygel-http-byte-seek-test.c"
								} else {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1046 "rygel-http-byte-seek-test.c"
								}
							}
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp12_ = thumbnail;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp13_ = subtitle;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_stop_only_seek (self, _tmp12_, _tmp13_, &_inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1071 "rygel-http-byte-seek-test.c"
								} else {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1087 "rygel-http-byte-seek-test.c"
								}
							}
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp14_ = thumbnail;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_tmp15_ = subtitle;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							rygel_http_byte_seek_test_test_start_stop_seek (self, _tmp14_, _tmp15_, &_inner_error_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							if (_inner_error_ != NULL) {
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_propagate_error (error, _inner_error_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1112 "rygel-http-byte-seek-test.c"
								} else {
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (subtitle);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									_g_object_unref0 (thumbnail);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									g_clear_error (&_inner_error_);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
									return;
#line 1128 "rygel-http-byte-seek-test.c"
								}
							}
#line 124 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
							_g_object_unref0 (subtitle);
#line 1133 "rygel-http-byte-seek-test.c"
						}
					}
				}
#line 123 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
				_g_object_unref0 (thumbnail);
#line 1139 "rygel-http-byte-seek-test.c"
			}
		}
	}
	{
		RygelHTTPGet* _tmp16_;
		RygelHTTPGet* _tmp17_;
		RygelHTTPByteSeek* _tmp18_;
		RygelHTTPByteSeek* _tmp19_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp16_ = rygel_http_get_new_inverted_range ();
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp17_ = _tmp16_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp18_ = rygel_http_byte_seek_new (_tmp17_, &_inner_error_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp19_ = _tmp18_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (_tmp19_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (_tmp17_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 1164 "rygel-http-byte-seek-test.c"
				goto __catch1_rygel_http_seek_error;
			}
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1177 "rygel-http-byte-seek-test.c"
		}
#line 134 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert_not_reached ();
#line 1181 "rygel-http-byte-seek-test.c"
	}
	goto __finally1;
	__catch1_rygel_http_seek_error:
	{
		GError* _error_ = NULL;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 1193 "rygel-http-byte-seek-test.c"
	}
	__finally1:
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1208 "rygel-http-byte-seek-test.c"
		} else {
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1220 "rygel-http-byte-seek-test.c"
		}
	}
	{
		RygelHTTPGet* _tmp20_;
		RygelHTTPGet* _tmp21_;
		RygelHTTPByteSeek* _tmp22_;
		RygelHTTPByteSeek* _tmp23_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp20_ = rygel_http_get_new_invalid_range ();
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp21_ = _tmp20_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp22_ = rygel_http_byte_seek_new (_tmp21_, &_inner_error_);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp23_ = _tmp22_;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (_tmp23_);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_object_unref0 (_tmp21_);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_ != NULL) {
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 1244 "rygel-http-byte-seek-test.c"
				goto __catch2_rygel_http_seek_error;
			}
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1257 "rygel-http-byte-seek-test.c"
		}
#line 139 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert_not_reached ();
#line 1261 "rygel-http-byte-seek-test.c"
	}
	goto __finally2;
	__catch2_rygel_http_seek_error:
	{
		GError* _error_ = NULL;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_error_ = _inner_error_;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_inner_error_ = NULL;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_error_free0 (_error_);
#line 1273 "rygel-http-byte-seek-test.c"
	}
	__finally2:
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1288 "rygel-http-byte-seek-test.c"
		} else {
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1300 "rygel-http-byte-seek-test.c"
		}
	}
#line 119 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1307 "rygel-http-byte-seek-test.c"
}


static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type) {
	RygelHTTPByteSeekTest * self = NULL;
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	GError * _inner_error_ = NULL;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = (RygelHTTPByteSeekTest*) g_object_new (object_type, NULL);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = g_regex_new ("bytes +[0-9]+-[0-9]+/[0-9]+", G_REGEX_CASELESS, 0, &_inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = _tmp0_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_clear_error (&_inner_error_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		return NULL;
#line 1330 "rygel-http-byte-seek-test.c"
	}
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_regex_unref0 (self->priv->range_regex);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->priv->range_regex = _tmp1_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return self;
#line 1338 "rygel-http-byte-seek-test.c"
}


static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void) {
#line 143 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	return rygel_http_byte_seek_test_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_TEST);
#line 1345 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelHTTPGet* _tmp16_;
	gint64 _tmp17_;
	GError * _inner_error_ = NULL;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new (_tmp0_, _tmp1_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = request;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _tmp3_->thumbnail;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp4_ != NULL) {
#line 1376 "rygel-http-byte-seek-test.c"
		RygelHTTPGet* _tmp5_;
		RygelThumbnail* _tmp6_;
		gint64 _tmp7_;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp5_ = request;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp6_ = _tmp5_->thumbnail;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp7_ = _tmp6_->size;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		size = _tmp7_;
#line 1388 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp8_;
		RygelSubtitle* _tmp9_;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp8_ = request;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp9_ = _tmp8_->subtitle;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp9_ != NULL) {
#line 1398 "rygel-http-byte-seek-test.c"
			RygelHTTPGet* _tmp10_;
			RygelSubtitle* _tmp11_;
			gint64 _tmp12_;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp10_ = request;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp11_ = _tmp10_->subtitle;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp12_ = _tmp11_->size;
#line 156 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp12_;
#line 1410 "rygel-http-byte-seek-test.c"
		} else {
			RygelHTTPGet* _tmp13_;
			RygelMediaItem* _tmp14_;
			gint64 _tmp15_;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp13_ = request;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp14_ = _tmp13_->item;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp15_ = _tmp14_->size;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp15_;
#line 1423 "rygel-http-byte-seek-test.c"
		}
	}
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp16_ = request;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp17_ = size;
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, _tmp16_, (gint64) 0, _tmp17_ - 1, &_inner_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1442 "rygel-http-byte-seek-test.c"
		} else {
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 161 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1452 "rygel-http-byte-seek-test.c"
		}
	}
#line 148 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1457 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelHTTPGet* _tmp16_;
	gint64 _tmp17_;
	GError * _inner_error_ = NULL;
#line 164 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 167 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_start ((gint64) 128, _tmp0_, _tmp1_);
#line 167 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = request;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = _tmp3_->thumbnail;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp4_ != NULL) {
#line 1488 "rygel-http-byte-seek-test.c"
		RygelHTTPGet* _tmp5_;
		RygelThumbnail* _tmp6_;
		gint64 _tmp7_;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp5_ = request;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp6_ = _tmp5_->thumbnail;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp7_ = _tmp6_->size;
#line 171 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		size = _tmp7_;
#line 1500 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp8_;
		RygelSubtitle* _tmp9_;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp8_ = request;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp9_ = _tmp8_->subtitle;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp9_ != NULL) {
#line 1510 "rygel-http-byte-seek-test.c"
			RygelHTTPGet* _tmp10_;
			RygelSubtitle* _tmp11_;
			gint64 _tmp12_;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp10_ = request;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp11_ = _tmp10_->subtitle;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp12_ = _tmp11_->size;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp12_;
#line 1522 "rygel-http-byte-seek-test.c"
		} else {
			RygelHTTPGet* _tmp13_;
			RygelMediaItem* _tmp14_;
			gint64 _tmp15_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp13_ = request;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp14_ = _tmp13_->item;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp15_ = _tmp14_->size;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			size = _tmp15_;
#line 1535 "rygel-http-byte-seek-test.c"
		}
	}
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp16_ = request;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp17_ = size;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, _tmp16_, (gint64) 128, _tmp17_ - 1, &_inner_error_);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1554 "rygel-http-byte-seek-test.c"
		} else {
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1564 "rygel-http-byte-seek-test.c"
		}
	}
#line 164 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1569 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	GError * _inner_error_ = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_stop ((gint64) 128, _tmp0_, _tmp1_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 0, (gint64) 128, &_inner_error_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1601 "rygel-http-byte-seek-test.c"
		} else {
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1611 "rygel-http-byte-seek-test.c"
		}
	}
#line 181 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1616 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	GError * _inner_error_ = NULL;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = thumbnail;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = subtitle;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256, _tmp0_, _tmp1_);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	request = _tmp2_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 128, (gint64) 256, &_inner_error_);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1648 "rygel-http-byte-seek-test.c"
		} else {
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_g_object_unref0 (request);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1658 "rygel-http-byte-seek-test.c"
		}
	}
#line 189 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (request);
#line 1663 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
	RygelHTTPGet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelHTTPGet* _tmp2_;
	RygelHTTPByteSeek* _tmp3_;
	RygelHTTPByteSeek* seek;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	RygelHTTPGet* _tmp10_;
	RygelThumbnail* _tmp11_;
	RygelHTTPGet* _tmp29_;
	SoupMessage* _tmp30_;
	SoupMessageHeaders* _tmp31_;
	const gchar* _tmp32_ = NULL;
	RygelHTTPGet* _tmp48_;
	SoupMessage* _tmp49_;
	SoupMessageHeaders* _tmp50_;
	gint64 _tmp51_ = 0LL;
	gint64 _tmp52_;
	gint64 _tmp53_;
	GError * _inner_error_ = NULL;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_return_if_fail (request != NULL);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp0_ = request;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp1_ = rygel_http_byte_seek_needed (_tmp0_);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (_tmp1_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp2_ = request;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp3_ = rygel_http_byte_seek_new (_tmp2_, &_inner_error_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	seek = _tmp3_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_inner_error_ != NULL) {
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_propagate_error (error, _inner_error_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1716 "rygel-http-byte-seek-test.c"
		} else {
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_clear_error (&_inner_error_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			return;
#line 1724 "rygel-http-byte-seek-test.c"
		}
	}
#line 206 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
#line 208 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (seek != NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp4_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp5_ = _tmp4_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp6_ = start;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (_tmp5_ == _tmp6_);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp7_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp8_ = _tmp7_;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp9_ = stop;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (_tmp8_ == _tmp9_);
#line 212 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp10_ = request;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp11_ = _tmp10_->thumbnail;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp11_ != NULL) {
#line 1753 "rygel-http-byte-seek-test.c"
		gint64 _tmp12_;
		gint64 _tmp13_;
		RygelHTTPGet* _tmp14_;
		RygelThumbnail* _tmp15_;
		gint64 _tmp16_;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp12_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 213 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp13_ = _tmp12_;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp14_ = request;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp15_ = _tmp14_->thumbnail;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp16_ = _tmp15_->size;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert (_tmp13_ == _tmp16_);
#line 1771 "rygel-http-byte-seek-test.c"
	} else {
		RygelHTTPGet* _tmp17_;
		RygelSubtitle* _tmp18_;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp17_ = request;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp18_ = _tmp17_->subtitle;
#line 214 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		if (_tmp18_ != NULL) {
#line 1781 "rygel-http-byte-seek-test.c"
			gint64 _tmp19_;
			gint64 _tmp20_;
			RygelHTTPGet* _tmp21_;
			RygelSubtitle* _tmp22_;
			gint64 _tmp23_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp19_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp20_ = _tmp19_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp21_ = request;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp22_ = _tmp21_->subtitle;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp23_ = _tmp22_->size;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_assert (_tmp20_ == _tmp23_);
#line 1799 "rygel-http-byte-seek-test.c"
		} else {
			gint64 _tmp24_;
			gint64 _tmp25_;
			RygelHTTPGet* _tmp26_;
			RygelMediaItem* _tmp27_;
			gint64 _tmp28_;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp24_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
#line 217 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp25_ = _tmp24_;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp26_ = request;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp27_ = _tmp26_->item;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			_tmp28_ = _tmp27_->size;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
			g_assert (_tmp25_ == _tmp28_);
#line 1818 "rygel-http-byte-seek-test.c"
		}
	}
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp29_ = request;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp30_ = _tmp29_->msg;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp31_ = _tmp30_->request_headers;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp32_ = soup_message_headers_get_one (_tmp31_, "Range");
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	if (_tmp32_ != NULL) {
#line 1831 "rygel-http-byte-seek-test.c"
		RygelHTTPGet* _tmp33_;
		SoupMessage* _tmp34_;
		SoupMessageHeaders* _tmp35_;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* header;
		const gchar* _tmp38_;
		RygelHTTPGet* _tmp39_;
		SoupMessage* _tmp40_;
		SoupMessageHeaders* _tmp41_;
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		GRegex* _tmp45_;
		const gchar* _tmp46_;
		gboolean _tmp47_ = FALSE;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp33_ = request;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp34_ = _tmp33_->msg;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp35_ = _tmp34_->response_headers;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp36_ = soup_message_headers_get_one (_tmp35_, "Accept-Ranges");
#line 221 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 221 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		header = _tmp37_;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp38_ = header;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert (g_strcmp0 (_tmp38_, "bytes") == 0);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp39_ = request;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp40_ = _tmp39_->msg;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp41_ = _tmp40_->response_headers;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp42_ = soup_message_headers_get_one (_tmp41_, "Content-Range");
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp43_ = g_strdup (_tmp42_);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_free0 (header);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		header = _tmp43_;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp44_ = header;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert (_tmp44_ != NULL);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp45_ = self->priv->range_regex;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp46_ = header;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_tmp47_ = g_regex_match (_tmp45_, _tmp46_, 0, NULL);
#line 225 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		g_assert (_tmp47_);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
		_g_free0 (header);
#line 1892 "rygel-http-byte-seek-test.c"
	}
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp48_ = request;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp49_ = _tmp48_->msg;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp50_ = _tmp49_->response_headers;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp51_ = soup_message_headers_get_content_length (_tmp50_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp52_ = rygel_http_seek_get_length ((RygelHTTPSeek*) seek);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_tmp53_ = _tmp52_;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_assert (_tmp51_ == _tmp53_);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_object_unref0 (seek);
#line 1910 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_class_init (RygelHTTPByteSeekTestClass * klass) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_parent_class = g_type_class_peek_parent (klass);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekTestPrivate));
#line 100 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_test_finalize;
#line 1921 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_instance_init (RygelHTTPByteSeekTest * self) {
#line 100 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self->priv = RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE (self);
#line 1928 "rygel-http-byte-seek-test.c"
}


static void rygel_http_byte_seek_test_finalize (GObject* obj) {
	RygelHTTPByteSeekTest * self;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	self = RYGEL_HTTP_BYTE_SEEK_TEST (obj);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	_g_regex_unref0 (self->priv->range_regex);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-byte-seek-test.vala"
	G_OBJECT_CLASS (rygel_http_byte_seek_test_parent_class)->finalize (obj);
#line 1940 "rygel-http-byte-seek-test.c"
}


GType rygel_http_byte_seek_test_get_type (void) {
	static volatile gsize rygel_http_byte_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekTest), 0, (GInstanceInitFunc) rygel_http_byte_seek_test_instance_init, NULL };
		GType rygel_http_byte_seek_test_type_id;
		rygel_http_byte_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPByteSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_test_type_id__volatile, rygel_http_byte_seek_test_type_id);
	}
	return rygel_http_byte_seek_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



