/* rygel-item-creator-test.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-item-creator-test.vala, do not modify */

/*
 * Copyright (C) 2012 Nokia Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <libxml/tree.h>
#include <libxml/parser.h>


#define RYGEL_TYPE_SERVICE_ACTION (rygel_service_action_get_type ())
#define RYGEL_SERVICE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERVICE_ACTION, RygelServiceAction))
#define RYGEL_SERVICE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERVICE_ACTION, RygelServiceActionClass))
#define RYGEL_IS_SERVICE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERVICE_ACTION))
#define RYGEL_IS_SERVICE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERVICE_ACTION))
#define RYGEL_SERVICE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERVICE_ACTION, RygelServiceActionClass))

typedef struct _RygelServiceAction RygelServiceAction;
typedef struct _RygelServiceActionClass RygelServiceActionClass;
typedef struct _RygelServiceActionPrivate RygelServiceActionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemRemovalQueuePrivate RygelItemRemovalQueuePrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;
typedef struct _RygelImageItemPrivate RygelImageItemPrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;
typedef struct _RygelPhotoItemPrivate RygelPhotoItemPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
typedef struct _RygelMediaObjectsPrivate RygelMediaObjectsPrivate;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_IS_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerClass RygelWritableContainerClass;
typedef struct _RygelWritableContainerPrivate RygelWritableContainerPrivate;
typedef struct _RygelWritableContainerGetWritableData RygelWritableContainerGetWritableData;
typedef struct _RygelWritableContainerAddItemData RygelWritableContainerAddItemData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_SEARCHABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerClass))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_IS_SEARCHABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerClass))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerClass RygelSearchableContainerClass;
typedef struct _RygelSearchableContainerPrivate RygelSearchableContainerPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _Block2Data Block2Data;
typedef struct _RygelSearchableContainerSearchData RygelSearchableContainerSearchData;

#define RYGEL_TYPE_HTTP_ITEM_CREATOR_TEST (rygel_http_item_creator_test_get_type ())
#define RYGEL_HTTP_ITEM_CREATOR_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_CREATOR_TEST, RygelHTTPItemCreatorTest))
#define RYGEL_HTTP_ITEM_CREATOR_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_CREATOR_TEST, RygelHTTPItemCreatorTestClass))
#define RYGEL_IS_HTTP_ITEM_CREATOR_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_CREATOR_TEST))
#define RYGEL_IS_HTTP_ITEM_CREATOR_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_CREATOR_TEST))
#define RYGEL_HTTP_ITEM_CREATOR_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_CREATOR_TEST, RygelHTTPItemCreatorTestClass))

typedef struct _RygelHTTPItemCreatorTest RygelHTTPItemCreatorTest;
typedef struct _RygelHTTPItemCreatorTestClass RygelHTTPItemCreatorTestClass;
typedef struct _RygelHTTPItemCreatorTestPrivate RygelHTTPItemCreatorTestPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _Block3Data Block3Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _RygelServiceAction {
	GObject parent_instance;
	RygelServiceActionPrivate * priv;
	gint error_code;
	gchar* error_message;
	gchar* id;
	gchar* elements;
};

struct _RygelServiceActionClass {
	GObjectClass parent_class;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelItemRemovalQueue {
	GObject parent_instance;
	RygelItemRemovalQueuePrivate * priv;
};

struct _RygelItemRemovalQueueClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	RygelMediaContainer* parent;
	gchar* upnp_class;
	gchar* title;
	GUPnPOCMFlags ocm_flags;
	GeeArrayList* uris;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* dlna_profile;
	gchar* mime_type;
	glong size;
	gboolean place_holder;
	gchar* date;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gchar* artist;
	gchar* album;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelImageItem {
	RygelMediaItem parent_instance;
	RygelImageItemPrivate * priv;
};

struct _RygelImageItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVideoItem {
	RygelMediaItem parent_instance;
	RygelVideoItemPrivate * priv;
};

struct _RygelVideoItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelPhotoItem {
	RygelMediaItem parent_instance;
	RygelPhotoItemPrivate * priv;
	gchar* creator;
};

struct _RygelPhotoItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelContentDirectory {
	GObject parent_instance;
	RygelContentDirectoryPrivate * priv;
	GCancellable* cancellable;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
};

struct _RygelContentDirectoryClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	GeeArrayList* create_classes;
	gint child_count;
	gchar* sort_criteria;
	RygelMediaObject* found_object;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	RygelMediaContainer * self;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block1Data* _data1_;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
};

struct _RygelMediaObjects {
	GeeArrayList parent_instance;
	RygelMediaObjectsPrivate * priv;
};

struct _RygelMediaObjectsClass {
	GeeArrayListClass parent_class;
};

struct _RygelWritableContainer {
	RygelMediaContainer parent_instance;
	RygelWritableContainerPrivate * priv;
};

struct _RygelWritableContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelWritableContainerGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelWritableContainer* self;
	GCancellable* cancellable;
	GFile* result;
	GFile* _tmp0_;
};

struct _RygelWritableContainerAddItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelWritableContainer* self;
	RygelMediaItem* item;
	GCancellable* cancellable;
};

struct _RygelSearchableContainer {
	RygelMediaContainer parent_instance;
	RygelSearchableContainerPrivate * priv;
	RygelMediaObjects* result;
};

struct _RygelSearchableContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelSearchableContainer * self;
	gpointer _async_data_;
};

struct _RygelSearchableContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	gint offset;
	gint count;
	gint total_matches;
	gchar* soer_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	Block2Data* _data2_;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _tmp1_;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT,
	RYGEL_CONTENT_DIRECTORY_ERROR_ERROR
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelHTTPItemCreatorTest {
	GObject parent_instance;
	RygelHTTPItemCreatorTestPrivate * priv;
};

struct _RygelHTTPItemCreatorTestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemCreatorTestPrivate {
	GError* no_such_object;
	GError* restricted_parent;
	GError* bad_metadata;
	GError* invalid_args;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPItemCreatorTest * self;
	GMainLoop* main_loop;
};


static gpointer rygel_service_action_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_item_removal_queue_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_image_item_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static gpointer rygel_photo_item_parent_class = NULL;
static gpointer rygel_content_directory_parent_class = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_media_objects_parent_class = NULL;
static gpointer rygel_writable_container_parent_class = NULL;
static gpointer rygel_searchable_container_parent_class = NULL;
static gpointer rygel_http_item_creator_test_parent_class = NULL;

void uuid_generate (guchar* uuid);
void uuid_unparse (guchar* uuid, guchar* output);
#define DIDL_ITEM "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" \
"<DIDL-Lite\n" \
"    xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n" \
"    xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\"\n" \
"    xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\"\n" \
"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" \
"    xsi:schemaLocation=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\n" \
"        http://www.upnp.org/schemas/av/didl-lite-v2-20060531.xsd\n" \
"      urn:schemas-upnp-org:metadata-1-0/upnp/\n" \
"        http://www.upnp.org/schemas/av/upnp-v2-20060531.xsd\">\n" \
"    <item id=\"\" parentID=\"0\" restricted=\"0\">\n" \
"        <dc:title>New Song</dc:title>\n" \
"        <upnp:class>object.item.audioItem</upnp:class>\n" \
"        <res protocolInfo=\"*:*:*:*\" />\n" \
"    </item>\n" \
"</DIDL-Lite>"
GType rygel_service_action_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SERVICE_ACTION_DUMMY_PROPERTY
};
RygelServiceAction* rygel_service_action_new (const gchar* container_id, const gchar* elements);
RygelServiceAction* rygel_service_action_construct (GType object_type, const gchar* container_id, const gchar* elements);
void rygel_service_action_return (RygelServiceAction* self);
void rygel_service_action_return_error (RygelServiceAction* self, gint code, const gchar* message);
void rygel_service_action_get (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, gchar** arg1_val, const gchar* arg2_name, GType arg2_type, gchar** arg2_val);
void rygel_service_action_set (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, const gchar* arg1_val, const gchar* arg2_name, GType arg2_type, const gchar* arg2_val);
static void rygel_service_action_finalize (GObject* obj);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY
};
RygelHTTPServer* rygel_http_server_new (void);
RygelHTTPServer* rygel_http_server_construct (GType object_type);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_ITEM_REMOVAL_QUEUE_DUMMY_PROPERTY
};
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
RygelItemRemovalQueue* rygel_item_removal_queue_new (void);
RygelItemRemovalQueue* rygel_item_removal_queue_construct (GType object_type);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
static void rygel_media_object_finalize (GObject* obj);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
void rygel_media_item_serialize (RygelMediaItem* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* server);
static void rygel_media_item_finalize (GObject* obj);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
static void rygel_audio_item_finalize (GObject* obj);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_IMAGE_ITEM_DUMMY_PROPERTY
};
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_PHOTO_ITEM_DUMMY_PROPERTY
};
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
static void rygel_photo_item_finalize (GObject* obj);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CONTENT_DIRECTORY_DUMMY_PROPERTY
};
RygelContentDirectory* rygel_content_directory_new (void);
RygelContentDirectory* rygel_content_directory_construct (GType object_type);
static void rygel_content_directory_finalize (GObject* obj);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda2_ (Block1Data* _data1_);
static gboolean ___lambda2__gsource_func (gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
static void rygel_media_container_finalize (GObject* obj);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECTS_DUMMY_PROPERTY
};
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_WRITABLE_CONTAINER_DUMMY_PROPERTY
};
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
static void rygel_writable_container_get_writable_data_free (gpointer _data);
void rygel_writable_container_get_writable (RygelWritableContainer* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_writable_container_get_writable_finish (RygelWritableContainer* self, GAsyncResult* _res_);
static gboolean rygel_writable_container_get_writable_co (RygelWritableContainerGetWritableData* _data_);
static void rygel_writable_container_add_item_data_free (gpointer _data);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_);
static gboolean rygel_writable_container_add_item_co (RygelWritableContainerAddItemData* _data_);
RygelWritableContainer* rygel_writable_container_new (void);
RygelWritableContainer* rygel_writable_container_construct (GType object_type);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SEARCHABLE_CONTAINER_DUMMY_PROPERTY
};
static void rygel_searchable_container_search_data_free (gpointer _data);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, gint offset, gint count, const gchar* soer_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, gint* total_matches);
static gboolean rygel_searchable_container_search_co (RygelSearchableContainerSearchData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda3_ (Block2Data* _data2_);
static gboolean ___lambda3__gsource_func (gpointer self);
RygelSearchableContainer* rygel_searchable_container_new (void);
RygelSearchableContainer* rygel_searchable_container_construct (GType object_type);
static void rygel_searchable_container_finalize (GObject* obj);
GQuark rygel_content_directory_error_quark (void);
GType rygel_http_item_creator_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_CREATOR_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_CREATOR_TEST, RygelHTTPItemCreatorTestPrivate))
enum  {
	RYGEL_HTTP_ITEM_CREATOR_TEST_DUMMY_PROPERTY
};
gint rygel_http_item_creator_test_main (gchar** args, int args_length1);
RygelHTTPItemCreatorTest* rygel_http_item_creator_test_new (void);
RygelHTTPItemCreatorTest* rygel_http_item_creator_test_construct (GType object_type);
static void rygel_http_item_creator_test_test_parse_args (RygelHTTPItemCreatorTest* self);
static void rygel_http_item_creator_test_test_didl_parsing (RygelHTTPItemCreatorTest* self);
static void rygel_http_item_creator_test_test_fetch_container (RygelHTTPItemCreatorTest* self);
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, RygelServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, RygelServiceAction* action);
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_item_creator_test_test_didl_parsing_step (RygelHTTPItemCreatorTest* self, xmlDoc* doc, gint expected_code);
static void rygel_http_item_creator_test_test_fetch_container_run (RygelHTTPItemCreatorTest* self, RygelItemCreator* creator);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rygel_http_item_creator_test_finalize (GObject* obj);


RygelServiceAction* rygel_service_action_construct (GType object_type, const gchar* container_id, const gchar* elements) {
	RygelServiceAction * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 55 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelServiceAction*) g_object_new (object_type, NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = container_id;
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->id);
#line 57 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->id = _tmp1_;
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = elements;
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->elements);
#line 58 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->elements = _tmp3_;
#line 55 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 736 "rygel-item-creator-test.c"
}


RygelServiceAction* rygel_service_action_new (const gchar* container_id, const gchar* elements) {
#line 55 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_service_action_construct (RYGEL_TYPE_SERVICE_ACTION, container_id, elements);
#line 743 "rygel-item-creator-test.c"
}


void rygel_service_action_return (RygelServiceAction* self) {
#line 61 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 750 "rygel-item-creator-test.c"
}


void rygel_service_action_return_error (RygelServiceAction* self, gint code, const gchar* message) {
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 62 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (message != NULL);
#line 63 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = code;
#line 63 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->error_code = _tmp0_;
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = message;
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->error_message);
#line 64 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->error_message = _tmp2_;
#line 774 "rygel-item-creator-test.c"
}


void rygel_service_action_get (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, gchar** arg1_val, const gchar* arg2_name, GType arg2_type, gchar** arg2_val) {
	gchar* _vala_arg1_val = NULL;
	gchar* _vala_arg2_val = NULL;
	const gchar* _tmp0_;
	GType _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GType _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (arg1_name != NULL);
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (arg2_name != NULL);
#line 73 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = arg1_name;
#line 73 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (g_strcmp0 (_tmp0_, "ContainerID") == 0);
#line 74 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = arg1_type;
#line 74 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp1_ == G_TYPE_STRING);
#line 75 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = self->id;
#line 75 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 75 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (_vala_arg1_val);
#line 75 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_vala_arg1_val = _tmp3_;
#line 77 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = arg2_name;
#line 77 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (g_strcmp0 (_tmp4_, "Elements") == 0);
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp5_ = arg2_type;
#line 78 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp5_ == G_TYPE_STRING);
#line 79 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp6_ = self->elements;
#line 79 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 79 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (_vala_arg2_val);
#line 79 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_vala_arg2_val = _tmp7_;
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (arg1_val) {
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		*arg1_val = _vala_arg1_val;
#line 831 "rygel-item-creator-test.c"
	} else {
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		_g_free0 (_vala_arg1_val);
#line 835 "rygel-item-creator-test.c"
	}
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (arg2_val) {
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		*arg2_val = _vala_arg2_val;
#line 841 "rygel-item-creator-test.c"
	} else {
#line 67 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		_g_free0 (_vala_arg2_val);
#line 845 "rygel-item-creator-test.c"
	}
}


void rygel_service_action_set (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, const gchar* arg1_val, const gchar* arg2_name, GType arg2_type, const gchar* arg2_val) {
	const gchar* _tmp0_;
	GType _tmp1_;
	const gchar* _tmp2_;
	GType _tmp3_;
#line 82 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (arg1_name != NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (arg1_val != NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (arg2_name != NULL);
#line 82 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (arg2_val != NULL);
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = arg1_name;
#line 88 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (g_strcmp0 (_tmp0_, "ObjectID") == 0);
#line 89 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = arg1_type;
#line 89 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp1_ == G_TYPE_STRING);
#line 91 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = arg2_name;
#line 91 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (g_strcmp0 (_tmp2_, "Result") == 0);
#line 92 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = arg2_type;
#line 92 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp3_ == G_TYPE_STRING);
#line 881 "rygel-item-creator-test.c"
}


static void rygel_service_action_class_init (RygelServiceActionClass * klass) {
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_service_action_parent_class = g_type_class_peek_parent (klass);
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_service_action_finalize;
#line 890 "rygel-item-creator-test.c"
}


static void rygel_service_action_instance_init (RygelServiceAction * self) {
}


static void rygel_service_action_finalize (GObject* obj) {
	RygelServiceAction * self;
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_SERVICE_ACTION (obj);
#line 51 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->error_message);
#line 52 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->id);
#line 53 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->elements);
#line 49 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_service_action_parent_class)->finalize (obj);
#line 910 "rygel-item-creator-test.c"
}


GType rygel_service_action_get_type (void) {
	static volatile gsize rygel_service_action_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_service_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelServiceActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_service_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelServiceAction), 0, (GInstanceInitFunc) rygel_service_action_instance_init, NULL };
		GType rygel_service_action_type_id;
		rygel_service_action_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelServiceAction", &g_define_type_info, 0);
		g_once_init_leave (&rygel_service_action_type_id__volatile, rygel_service_action_type_id);
	}
	return rygel_service_action_type_id__volatile;
}


RygelHTTPServer* rygel_http_server_construct (GType object_type) {
	RygelHTTPServer * self = NULL;
#line 96 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
#line 96 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 932 "rygel-item-creator-test.c"
}


RygelHTTPServer* rygel_http_server_new (void) {
#line 96 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER);
#line 939 "rygel-item-creator-test.c"
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
#line 96 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
#line 946 "rygel-item-creator-test.c"
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void) {
	RygelItemRemovalQueue* result = NULL;
	RygelItemRemovalQueue* _tmp0_;
#line 101 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = rygel_item_removal_queue_new ();
#line 101 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	result = _tmp0_;
#line 101 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 975 "rygel-item-creator-test.c"
}


void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable) {
#line 104 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (item != NULL);
#line 984 "rygel-item-creator-test.c"
}


RygelItemRemovalQueue* rygel_item_removal_queue_construct (GType object_type) {
	RygelItemRemovalQueue * self = NULL;
#line 99 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelItemRemovalQueue*) g_object_new (object_type, NULL);
#line 99 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 994 "rygel-item-creator-test.c"
}


RygelItemRemovalQueue* rygel_item_removal_queue_new (void) {
#line 99 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_item_removal_queue_construct (RYGEL_TYPE_ITEM_REMOVAL_QUEUE);
#line 1001 "rygel-item-creator-test.c"
}


static void rygel_item_removal_queue_class_init (RygelItemRemovalQueueClass * klass) {
#line 99 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_item_removal_queue_parent_class = g_type_class_peek_parent (klass);
#line 1008 "rygel-item-creator-test.c"
}


static void rygel_item_removal_queue_instance_init (RygelItemRemovalQueue * self) {
}


GType rygel_item_removal_queue_get_type (void) {
	static volatile gsize rygel_item_removal_queue_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_removal_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemRemovalQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_removal_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemRemovalQueue), 0, (GInstanceInitFunc) rygel_item_removal_queue_instance_init, NULL };
		GType rygel_item_removal_queue_type_id;
		rygel_item_removal_queue_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemRemovalQueue", &g_define_type_info, 0);
		g_once_init_leave (&rygel_item_removal_queue_type_id__volatile, rygel_item_removal_queue_type_id);
	}
	return rygel_item_removal_queue_type_id__volatile;
}


void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri) {
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
#line 117 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (uri != NULL);
#line 118 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = self->uris;
#line 118 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = uri;
#line 118 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 1041 "rygel-item-creator-test.c"
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
#line 108 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1051 "rygel-item-creator-test.c"
}


RygelMediaObject* rygel_media_object_new (void) {
#line 108 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
#line 1058 "rygel-item-creator-test.c"
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
#line 108 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
#line 108 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
#line 1067 "rygel-item-creator-test.c"
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
#line 108 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_MEDIA_OBJECT (obj);
#line 109 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->id);
#line 110 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->ref_id);
#line 112 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->upnp_class);
#line 113 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->title);
#line 115 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (self->uris);
#line 108 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
#line 1091 "rygel-item-creator-test.c"
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelMediaItem * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelMediaContainer* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 129 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 129 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 129 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 129 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 130 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = id;
#line 130 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 130 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (((RygelMediaObject*) self)->id);
#line 130 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	((RygelMediaObject*) self)->id = _tmp1_;
#line 131 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = parent;
#line 131 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	((RygelMediaObject*) self)->parent = _tmp2_;
#line 132 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = title;
#line 132 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 132 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (((RygelMediaObject*) self)->title);
#line 132 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	((RygelMediaObject*) self)->title = _tmp4_;
#line 129 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1144 "rygel-item-creator-test.c"
}


RygelMediaItem* rygel_media_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 129 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM, id, parent, title);
#line 1151 "rygel-item-creator-test.c"
}


void rygel_media_item_serialize (RygelMediaItem* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* server) {
#line 135 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (writer != NULL);
#line 135 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (server != NULL);
#line 1162 "rygel-item-creator-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
#line 122 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
#line 122 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
#line 1171 "rygel-item-creator-test.c"
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
#line 122 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_MEDIA_ITEM (obj);
#line 123 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->dlna_profile);
#line 124 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->mime_type);
#line 127 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->date);
#line 122 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
#line 1191 "rygel-item-creator-test.c"
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelMusicItem * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 143 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = id;
#line 143 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = parent;
#line 143 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = title;
#line 143 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1228 "rygel-item-creator-test.c"
}


RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 142 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM, id, parent, title);
#line 1235 "rygel-item-creator-test.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 139 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 1242 "rygel-item-creator-test.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelAudioItem * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
#line 152 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 152 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 152 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 153 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = id;
#line 153 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = parent;
#line 153 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = title;
#line 153 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelAudioItem*) rygel_media_item_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 152 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1283 "rygel-item-creator-test.c"
}


RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 152 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM, id, parent, title);
#line 1290 "rygel-item-creator-test.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
#line 147 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
#line 147 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
#line 1299 "rygel-item-creator-test.c"
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
}


static void rygel_audio_item_finalize (GObject* obj) {
	RygelAudioItem * self;
#line 147 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_AUDIO_ITEM (obj);
#line 149 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->artist);
#line 150 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->album);
#line 147 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
#line 1317 "rygel-item-creator-test.c"
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelImageItem * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
#line 158 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 158 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 158 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 159 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = id;
#line 159 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = parent;
#line 159 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = title;
#line 159 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelImageItem*) rygel_media_item_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 158 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1354 "rygel-item-creator-test.c"
}


RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 158 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_image_item_construct (RYGEL_TYPE_IMAGE_ITEM, id, parent, title);
#line 1361 "rygel-item-creator-test.c"
}


static void rygel_image_item_class_init (RygelImageItemClass * klass) {
#line 156 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_image_item_parent_class = g_type_class_peek_parent (klass);
#line 1368 "rygel-item-creator-test.c"
}


static void rygel_image_item_instance_init (RygelImageItem * self) {
}


GType rygel_image_item_get_type (void) {
	static volatile gsize rygel_image_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_image_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelImageItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_image_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelImageItem), 0, (GInstanceInitFunc) rygel_image_item_instance_init, NULL };
		GType rygel_image_item_type_id;
		rygel_image_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelImageItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_image_item_type_id__volatile, rygel_image_item_type_id);
	}
	return rygel_image_item_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelVideoItem * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
#line 165 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 165 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 165 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = id;
#line 166 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = parent;
#line 166 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = title;
#line 166 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelVideoItem*) rygel_media_item_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 165 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1409 "rygel-item-creator-test.c"
}


RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 165 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM, id, parent, title);
#line 1416 "rygel-item-creator-test.c"
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
#line 163 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
#line 1423 "rygel-item-creator-test.c"
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title) {
	RygelPhotoItem * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
#line 174 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 174 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 174 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 175 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = id;
#line 175 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = parent;
#line 175 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = title;
#line 175 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelPhotoItem*) rygel_media_item_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 174 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1464 "rygel-item-creator-test.c"
}


RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title) {
#line 174 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_photo_item_construct (RYGEL_TYPE_PHOTO_ITEM, id, parent, title);
#line 1471 "rygel-item-creator-test.c"
}


static void rygel_photo_item_class_init (RygelPhotoItemClass * klass) {
#line 170 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_photo_item_parent_class = g_type_class_peek_parent (klass);
#line 170 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_photo_item_finalize;
#line 1480 "rygel-item-creator-test.c"
}


static void rygel_photo_item_instance_init (RygelPhotoItem * self) {
}


static void rygel_photo_item_finalize (GObject* obj) {
	RygelPhotoItem * self;
#line 170 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_PHOTO_ITEM (obj);
#line 172 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->creator);
#line 170 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_photo_item_parent_class)->finalize (obj);
#line 1496 "rygel-item-creator-test.c"
}


GType rygel_photo_item_get_type (void) {
	static volatile gsize rygel_photo_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_photo_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPhotoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_photo_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPhotoItem), 0, (GInstanceInitFunc) rygel_photo_item_instance_init, NULL };
		GType rygel_photo_item_type_id;
		rygel_photo_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelPhotoItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_photo_item_type_id__volatile, rygel_photo_item_type_id);
	}
	return rygel_photo_item_type_id__volatile;
}


RygelContentDirectory* rygel_content_directory_construct (GType object_type) {
	RygelContentDirectory * self = NULL;
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelContentDirectory*) g_object_new (object_type, NULL);
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1518 "rygel-item-creator-test.c"
}


RygelContentDirectory* rygel_content_directory_new (void) {
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_content_directory_construct (RYGEL_TYPE_CONTENT_DIRECTORY);
#line 1525 "rygel-item-creator-test.c"
}


static void rygel_content_directory_class_init (RygelContentDirectoryClass * klass) {
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_content_directory_parent_class = g_type_class_peek_parent (klass);
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_content_directory_finalize;
#line 1534 "rygel-item-creator-test.c"
}


static void rygel_content_directory_instance_init (RygelContentDirectory * self) {
}


static void rygel_content_directory_finalize (GObject* obj) {
	RygelContentDirectory * self;
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_CONTENT_DIRECTORY (obj);
#line 179 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (self->cancellable);
#line 180 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (self->root_container);
#line 181 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (self->http_server);
#line 178 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->finalize (obj);
#line 1554 "rygel-item-creator-test.c"
}


GType rygel_content_directory_get_type (void) {
	static volatile gsize rygel_content_directory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_content_directory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelContentDirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_content_directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelContentDirectory), 0, (GInstanceInitFunc) rygel_content_directory_instance_init, NULL };
		GType rygel_content_directory_type_id;
		rygel_content_directory_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelContentDirectory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_content_directory_type_id__volatile, rygel_content_directory_type_id);
	}
	return rygel_content_directory_type_id__volatile;
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = _data;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (_data_->id);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->result);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->self);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_slice_free (RygelMediaContainerFindObjectData, _data_);
#line 1583 "rygel-item-creator-test.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 1590 "rygel-item-creator-test.c"
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_container_find_object);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->self = _tmp0_;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = id;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->id = _tmp2_;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = cancellable;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->cancellable = _tmp4_;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_media_container_find_object_co (_data_);
#line 1625 "rygel-item-creator-test.c"
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	result = _data_->result;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->result = NULL;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 1640 "rygel-item-creator-test.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return _data1_;
#line 1649 "rygel-item-creator-test.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1658 "rygel-item-creator-test.c"
		RygelMediaContainer * self;
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		self = _data1_->self;
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		_g_object_unref0 (self);
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_slice_free (Block1Data, _data1_);
#line 1666 "rygel-item-creator-test.c"
	}
}


static gboolean __lambda2_ (Block1Data* _data1_) {
	RygelMediaContainer * self;
	gboolean result = FALSE;
#line 194 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = _data1_->self;
#line 194 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_media_container_find_object_co (_data1_->_async_data_);
#line 194 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	result = FALSE;
#line 194 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 1682 "rygel-item-creator-test.c"
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
#line 194 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 1691 "rygel-item-creator-test.c"
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_) {
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	switch (_data_->_state_) {
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		case 0:
#line 1700 "rygel-item-creator-test.c"
		goto _state_0;
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		case 1:
#line 1704 "rygel-item-creator-test.c"
		goto _state_1;
		default:
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_assert_not_reached ();
#line 1709 "rygel-item-creator-test.c"
	}
	_state_0:
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 194 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda2__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
#line 195 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_state_ = 1;
#line 195 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 1726 "rygel-item-creator-test.c"
	_state_1:
	;
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_tmp0_ = _data_->self->found_object;
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->result = _data_->_tmp1_;
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	block1_data_unref (_data_->_data1_);
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data1_ = NULL;
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (_data_->_state_ == 0) {
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1743 "rygel-item-creator-test.c"
	} else {
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1747 "rygel-item-creator-test.c"
	}
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_object_unref (_data_->_async_result);
#line 197 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	block1_data_unref (_data_->_data1_);
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data1_ = NULL;
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (_data_->_state_ == 0) {
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1761 "rygel-item-creator-test.c"
	} else {
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1765 "rygel-item-creator-test.c"
	}
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_object_unref (_data_->_async_result);
#line 192 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 1771 "rygel-item-creator-test.c"
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer * self = NULL;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1781 "rygel-item-creator-test.c"
}


RygelMediaContainer* rygel_media_container_new (void) {
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
#line 1788 "rygel-item-creator-test.c"
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_CONTAINER);
#line 1799 "rygel-item-creator-test.c"
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
#line 185 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->create_classes = _tmp0_;
#line 187 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = g_strdup ("+dc:title");
#line 187 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->sort_criteria = _tmp1_;
#line 190 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->found_object = NULL;
#line 1816 "rygel-item-creator-test.c"
}


static void rygel_media_container_finalize (GObject* obj) {
	RygelMediaContainer * self;
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_MEDIA_CONTAINER (obj);
#line 185 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (self->create_classes);
#line 187 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (self->sort_criteria);
#line 190 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (self->found_object);
#line 184 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
#line 1832 "rygel-item-creator-test.c"
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelMediaObjects* rygel_media_objects_construct (GType object_type) {
	RygelMediaObjects * self = NULL;
#line 203 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelMediaObjects*) gee_array_list_construct (object_type, RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 203 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 1854 "rygel-item-creator-test.c"
}


RygelMediaObjects* rygel_media_objects_new (void) {
#line 203 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_media_objects_construct (RYGEL_TYPE_MEDIA_OBJECTS);
#line 1861 "rygel-item-creator-test.c"
}


static void rygel_media_objects_class_init (RygelMediaObjectsClass * klass) {
#line 203 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_media_objects_parent_class = g_type_class_peek_parent (klass);
#line 1868 "rygel-item-creator-test.c"
}


static void rygel_media_objects_instance_init (RygelMediaObjects * self) {
}


GType rygel_media_objects_get_type (void) {
	static volatile gsize rygel_media_objects_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_objects_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_objects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObjects), 0, (GInstanceInitFunc) rygel_media_objects_instance_init, NULL };
		GType rygel_media_objects_type_id;
		rygel_media_objects_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "RygelMediaObjects", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_objects_type_id__volatile, rygel_media_objects_type_id);
	}
	return rygel_media_objects_type_id__volatile;
}


gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 207 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 207 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_val_if_fail (upnp_class != NULL, FALSE);
#line 208 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = ((RygelMediaContainer*) self)->create_classes;
#line 208 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = upnp_class;
#line 208 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 208 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	result = _tmp2_;
#line 208 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 1907 "rygel-item-creator-test.c"
}


static void rygel_writable_container_get_writable_data_free (gpointer _data) {
	RygelWritableContainerGetWritableData* _data_;
	_data_ = _data;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->result);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->self);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_slice_free (RygelWritableContainerGetWritableData, _data_);
#line 1922 "rygel-item-creator-test.c"
}


void rygel_writable_container_get_writable (RygelWritableContainer* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelWritableContainerGetWritableData* _data_;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_ = g_slice_new0 (RygelWritableContainerGetWritableData);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_writable_container_get_writable);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_writable_container_get_writable_data_free);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->self = _tmp0_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = cancellable;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->cancellable = _tmp2_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_writable_container_get_writable_co (_data_);
#line 1949 "rygel-item-creator-test.c"
}


GFile* rygel_writable_container_get_writable_finish (RygelWritableContainer* self, GAsyncResult* _res_) {
	GFile* result;
	RygelWritableContainerGetWritableData* _data_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	result = _data_->result;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->result = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 1964 "rygel-item-creator-test.c"
}


static gboolean rygel_writable_container_get_writable_co (RygelWritableContainerGetWritableData* _data_) {
#line 211 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	switch (_data_->_state_) {
#line 211 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		case 0:
#line 1973 "rygel-item-creator-test.c"
		goto _state_0;
		default:
#line 211 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_assert_not_reached ();
#line 1978 "rygel-item-creator-test.c"
	}
	_state_0:
#line 212 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_tmp0_ = NULL;
#line 212 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_tmp0_ = g_file_new_for_commandline_arg ("/tmp");
#line 212 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->result = _data_->_tmp0_;
#line 212 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (_data_->_state_ == 0) {
#line 212 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1991 "rygel-item-creator-test.c"
	} else {
#line 212 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1995 "rygel-item-creator-test.c"
	}
#line 212 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_object_unref (_data_->_async_result);
#line 212 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 211 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (_data_->_state_ == 0) {
#line 211 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2005 "rygel-item-creator-test.c"
	} else {
#line 211 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2009 "rygel-item-creator-test.c"
	}
#line 211 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_object_unref (_data_->_async_result);
#line 211 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 2015 "rygel-item-creator-test.c"
}


static void rygel_writable_container_add_item_data_free (gpointer _data) {
	RygelWritableContainerAddItemData* _data_;
	_data_ = _data;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->item);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->self);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_slice_free (RygelWritableContainerAddItemData, _data_);
#line 2030 "rygel-item-creator-test.c"
}


void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelWritableContainerAddItemData* _data_;
	RygelWritableContainer* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelMediaItem* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_ = g_slice_new0 (RygelWritableContainerAddItemData);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_writable_container_add_item);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_writable_container_add_item_data_free);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->self = _tmp0_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = item;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->item = _tmp2_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = cancellable;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->cancellable = _tmp4_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_writable_container_add_item_co (_data_);
#line 2065 "rygel-item-creator-test.c"
}


void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_) {
	RygelWritableContainerAddItemData* _data_;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2073 "rygel-item-creator-test.c"
}


static gboolean rygel_writable_container_add_item_co (RygelWritableContainerAddItemData* _data_) {
#line 215 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	switch (_data_->_state_) {
#line 215 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		case 0:
#line 2082 "rygel-item-creator-test.c"
		goto _state_0;
		default:
#line 215 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_assert_not_reached ();
#line 2087 "rygel-item-creator-test.c"
	}
	_state_0:
#line 215 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (_data_->_state_ == 0) {
#line 215 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2094 "rygel-item-creator-test.c"
	} else {
#line 215 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2098 "rygel-item-creator-test.c"
	}
#line 215 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_object_unref (_data_->_async_result);
#line 215 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 2104 "rygel-item-creator-test.c"
}


RygelWritableContainer* rygel_writable_container_construct (GType object_type) {
	RygelWritableContainer * self = NULL;
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelWritableContainer*) rygel_media_container_construct (object_type);
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 2114 "rygel-item-creator-test.c"
}


RygelWritableContainer* rygel_writable_container_new (void) {
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_writable_container_construct (RYGEL_TYPE_WRITABLE_CONTAINER);
#line 2121 "rygel-item-creator-test.c"
}


static void rygel_writable_container_class_init (RygelWritableContainerClass * klass) {
#line 206 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_writable_container_parent_class = g_type_class_peek_parent (klass);
#line 2128 "rygel-item-creator-test.c"
}


static void rygel_writable_container_instance_init (RygelWritableContainer * self) {
}


GType rygel_writable_container_get_type (void) {
	static volatile gsize rygel_writable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_writable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWritableContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_writable_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWritableContainer), 0, (GInstanceInitFunc) rygel_writable_container_instance_init, NULL };
		GType rygel_writable_container_type_id;
		rygel_writable_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelWritableContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_writable_container_type_id__volatile, rygel_writable_container_type_id);
	}
	return rygel_writable_container_type_id__volatile;
}


static void rygel_searchable_container_search_data_free (gpointer _data) {
	RygelSearchableContainerSearchData* _data_;
	_data_ = _data;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (_data_->soer_criteria);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->cancellable);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->result);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (_data_->self);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_slice_free (RygelSearchableContainerSearchData, _data_);
#line 2163 "rygel-item-creator-test.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 2170 "rygel-item-creator-test.c"
}


void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, gint offset, gint count, const gchar* soer_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSearchData);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_search);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_data_free);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->self = _tmp0_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = expression;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->expression = _tmp2_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = offset;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->offset = _tmp3_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = count;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->count = _tmp4_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp5_ = soer_criteria;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->soer_criteria = _tmp6_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp7_ = cancellable;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->cancellable = _tmp8_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_searchable_container_search_co (_data_);
#line 2223 "rygel-item-creator-test.c"
}


RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, gint* total_matches) {
	RygelMediaObjects* result;
	RygelSearchableContainerSearchData* _data_;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (total_matches) {
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		*total_matches = _data_->total_matches;
#line 2236 "rygel-item-creator-test.c"
	}
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	result = _data_->result;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->result = NULL;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 2244 "rygel-item-creator-test.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return _data2_;
#line 2253 "rygel-item-creator-test.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2262 "rygel-item-creator-test.c"
		RygelSearchableContainer * self;
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		self = _data2_->self;
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		_g_object_unref0 (self);
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_slice_free (Block2Data, _data2_);
#line 2270 "rygel-item-creator-test.c"
	}
}


static gboolean __lambda3_ (Block2Data* _data2_) {
	RygelSearchableContainer * self;
	gboolean result = FALSE;
#line 229 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = _data2_->self;
#line 229 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_searchable_container_search_co (_data2_->_async_data_);
#line 229 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	result = FALSE;
#line 229 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 2286 "rygel-item-creator-test.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 229 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 2295 "rygel-item-creator-test.c"
}


static gboolean rygel_searchable_container_search_co (RygelSearchableContainerSearchData* _data_) {
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	switch (_data_->_state_) {
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		case 0:
#line 2304 "rygel-item-creator-test.c"
		goto _state_0;
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		case 1:
#line 2308 "rygel-item-creator-test.c"
		goto _state_1;
		default:
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_assert_not_reached ();
#line 2313 "rygel-item-creator-test.c"
	}
	_state_0:
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 229 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda3__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
#line 230 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_state_ = 1;
#line 230 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 2330 "rygel-item-creator-test.c"
	_state_1:
	;
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_tmp0_ = _data_->self->result;
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->result = _data_->_tmp1_;
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	block2_data_unref (_data_->_data2_);
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data2_ = NULL;
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (_data_->_state_ == 0) {
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2347 "rygel-item-creator-test.c"
	} else {
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2351 "rygel-item-creator-test.c"
	}
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_object_unref (_data_->_async_result);
#line 232 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	block2_data_unref (_data_->_data2_);
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data_->_data2_ = NULL;
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (_data_->_state_ == 0) {
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2365 "rygel-item-creator-test.c"
	} else {
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2369 "rygel-item-creator-test.c"
	}
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_object_unref (_data_->_async_result);
#line 223 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return FALSE;
#line 2375 "rygel-item-creator-test.c"
}


RygelSearchableContainer* rygel_searchable_container_construct (GType object_type) {
	RygelSearchableContainer * self = NULL;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelSearchableContainer*) rygel_media_container_construct (object_type);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 2385 "rygel-item-creator-test.c"
}


RygelSearchableContainer* rygel_searchable_container_new (void) {
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_searchable_container_construct (RYGEL_TYPE_SEARCHABLE_CONTAINER);
#line 2392 "rygel-item-creator-test.c"
}


static void rygel_searchable_container_class_init (RygelSearchableContainerClass * klass) {
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_searchable_container_parent_class = g_type_class_peek_parent (klass);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_searchable_container_finalize;
#line 2401 "rygel-item-creator-test.c"
}


static void rygel_searchable_container_instance_init (RygelSearchableContainer * self) {
	RygelMediaObjects* _tmp0_;
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->result = _tmp0_;
#line 2411 "rygel-item-creator-test.c"
}


static void rygel_searchable_container_finalize (GObject* obj) {
	RygelSearchableContainer * self;
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_SEARCHABLE_CONTAINER (obj);
#line 221 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (self->result);
#line 220 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_searchable_container_parent_class)->finalize (obj);
#line 2423 "rygel-item-creator-test.c"
}


GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_searchable_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearchableContainer), 0, (GInstanceInitFunc) rygel_searchable_container_instance_init, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelSearchableContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}


GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}


gint rygel_http_item_creator_test_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelHTTPItemCreatorTest* _tmp0_;
	RygelHTTPItemCreatorTest* test;
#line 247 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = rygel_http_item_creator_test_new ();
#line 247 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	test = _tmp0_;
#line 248 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_parse_args (test);
#line 249 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing (test);
#line 250 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_fetch_container (test);
#line 252 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	result = 0;
#line 252 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (test);
#line 252 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return result;
#line 2464 "rygel-item-creator-test.c"
}


int main (int argc, char ** argv) {
#line 246 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_thread_init (NULL);
#line 246 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_type_init ();
#line 246 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_http_item_creator_test_main (argv, argc);
#line 2475 "rygel-item-creator-test.c"
}


RygelHTTPItemCreatorTest* rygel_http_item_creator_test_construct (GType object_type) {
	RygelHTTPItemCreatorTest * self = NULL;
	GError* _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
#line 261 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = (RygelHTTPItemCreatorTest*) g_object_new (object_type, NULL);
#line 262 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "");
#line 262 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_error_free0 (self->priv->no_such_object);
#line 262 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->priv->no_such_object = _tmp0_;
#line 263 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, "");
#line 263 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_error_free0 (self->priv->restricted_parent);
#line 263 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->priv->restricted_parent = _tmp1_;
#line 264 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "");
#line 264 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_error_free0 (self->priv->bad_metadata);
#line 264 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->priv->bad_metadata = _tmp2_;
#line 265 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "");
#line 265 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_error_free0 (self->priv->invalid_args);
#line 265 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->priv->invalid_args = _tmp3_;
#line 261 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return self;
#line 2513 "rygel-item-creator-test.c"
}


RygelHTTPItemCreatorTest* rygel_http_item_creator_test_new (void) {
#line 261 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return rygel_http_item_creator_test_construct (RYGEL_TYPE_HTTP_ITEM_CREATOR_TEST);
#line 2520 "rygel-item-creator-test.c"
}


static void rygel_http_item_creator_test_test_parse_args (RygelHTTPItemCreatorTest* self) {
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* content_directory;
	RygelServiceAction* _tmp1_;
	RygelServiceAction* action;
	RygelServiceAction* _tmp2_;
	RygelServiceAction* _tmp3_;
	RygelItemCreator* _tmp4_;
	RygelItemCreator* creator;
	RygelItemCreator* _tmp5_;
	RygelServiceAction* _tmp6_;
	gint _tmp7_;
	GError* _tmp8_;
	gint _tmp9_;
	RygelServiceAction* _tmp10_;
	RygelServiceAction* _tmp11_;
	RygelServiceAction* _tmp12_;
	RygelItemCreator* _tmp13_;
	RygelItemCreator* _tmp14_;
	RygelServiceAction* _tmp15_;
	gint _tmp16_;
	GError* _tmp17_;
	gint _tmp18_;
	RygelServiceAction* _tmp19_;
	RygelServiceAction* _tmp20_;
	RygelServiceAction* _tmp21_;
	RygelItemCreator* _tmp22_;
	RygelItemCreator* _tmp23_;
	RygelServiceAction* _tmp24_;
	gint _tmp25_;
	GError* _tmp26_;
	gint _tmp27_;
#line 268 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 270 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = rygel_content_directory_new ();
#line 270 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	content_directory = _tmp0_;
#line 272 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = rygel_service_action_new (NULL, "");
#line 272 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	action = _tmp1_;
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = action;
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = rygel_item_creator_new (content_directory, _tmp3_);
#line 273 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	creator = _tmp4_;
#line 274 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp5_ = creator;
#line 274 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp5_, NULL, NULL);
#line 275 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp6_ = action;
#line 275 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp7_ = _tmp6_->error_code;
#line 275 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp8_ = self->priv->no_such_object;
#line 275 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp9_ = _tmp8_->code;
#line 275 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp7_ == _tmp9_);
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp10_ = rygel_service_action_new ("0", "<!-- This is an XML comment -->");
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (action);
#line 278 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	action = _tmp10_;
#line 279 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp11_ = action;
#line 279 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 279 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp13_ = rygel_item_creator_new (content_directory, _tmp12_);
#line 279 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (creator);
#line 279 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	creator = _tmp13_;
#line 280 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp14_ = creator;
#line 280 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp14_, NULL, NULL);
#line 281 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp15_ = action;
#line 281 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp16_ = _tmp15_->error_code;
#line 281 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp17_ = self->priv->bad_metadata;
#line 281 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp18_ = _tmp17_->code;
#line 281 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp16_ == _tmp18_);
#line 284 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp19_ = rygel_service_action_new ("0", NULL);
#line 284 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (action);
#line 284 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	action = _tmp19_;
#line 285 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp20_ = action;
#line 285 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp21_ = _g_object_ref0 (_tmp20_);
#line 285 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp22_ = rygel_item_creator_new (content_directory, _tmp21_);
#line 285 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (creator);
#line 285 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	creator = _tmp22_;
#line 286 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp23_ = creator;
#line 286 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp23_, NULL, NULL);
#line 287 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp24_ = action;
#line 287 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp25_ = _tmp24_->error_code;
#line 287 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp26_ = self->priv->bad_metadata;
#line 287 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp27_ = _tmp26_->code;
#line 287 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp25_ == _tmp27_);
#line 268 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (creator);
#line 268 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (action);
#line 268 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (content_directory);
#line 2654 "rygel-item-creator-test.c"
}


static void rygel_http_item_creator_test_test_didl_parsing_step (RygelHTTPItemCreatorTest* self, xmlDoc* doc, gint expected_code) {
	gchar* xml = NULL;
	xmlDoc* _tmp0_;
	gchar* _tmp1_ = NULL;
	RygelServiceAction* _tmp2_;
	RygelServiceAction* action;
	RygelContentDirectory* _tmp3_;
	RygelContentDirectory* content_directory;
	RygelServiceAction* _tmp4_;
	RygelItemCreator* _tmp5_;
	RygelItemCreator* creator;
	gint _tmp6_;
	gint _tmp7_;
#line 290 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 293 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = doc;
#line 293 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlDocDumpMemoryEnc (_tmp0_, &_tmp1_, NULL, "UTF-8");
#line 293 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (xml);
#line 293 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xml = _tmp1_;
#line 294 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = rygel_service_action_new ("0", xml);
#line 294 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	action = _tmp2_;
#line 295 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = rygel_content_directory_new ();
#line 295 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	content_directory = _tmp3_;
#line 296 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = _g_object_ref0 (action);
#line 296 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp5_ = rygel_item_creator_new (content_directory, _tmp4_);
#line 296 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	creator = _tmp5_;
#line 297 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
#line 298 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp6_ = action->error_code;
#line 298 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp7_ = expected_code;
#line 298 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp6_ == _tmp7_);
#line 290 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (creator);
#line 290 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (content_directory);
#line 290 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (action);
#line 290 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (xml);
#line 2711 "rygel-item-creator-test.c"
}


static void rygel_http_item_creator_test_test_didl_parsing (RygelHTTPItemCreatorTest* self) {
	gint _tmp0_;
	gint _tmp1_;
	xmlDoc* _tmp2_ = NULL;
	xmlDoc* xml;
	xmlNode* _tmp3_;
	xmlNode* didl_node;
	xmlNode* _tmp4_;
	xmlNode* item_node;
	RygelContentDirectory* _tmp5_;
	RygelContentDirectory* content_directory;
	RygelServiceAction* _tmp6_;
	RygelServiceAction* action;
	RygelServiceAction* _tmp7_;
	RygelItemCreator* _tmp8_;
	RygelItemCreator* creator;
	gint _tmp9_;
	GError* _tmp10_;
	gint _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	gint _tmp14_;
	xmlNode* _tmp15_ = NULL;
	xmlNode* tmp;
	xmlNode* _tmp16_;
	xmlNode* _tmp17_;
	GError* _tmp18_;
	gint _tmp19_;
	xmlNode* _tmp20_;
	GError* _tmp21_;
	gint _tmp22_;
	xmlNode* _tmp23_;
	xmlNode* _tmp24_ = NULL;
	xmlNode* _tmp25_;
	xmlNode* _tmp26_;
	GError* _tmp27_;
	gint _tmp28_;
	xmlNode* _tmp29_;
	GError* _tmp30_;
	gint _tmp31_;
	xmlNode* _tmp32_;
	xmlNode* _tmp33_ = NULL;
	xmlNode* _tmp34_;
	xmlNode* _tmp35_;
	xmlNode* title_node;
	xmlNode* _tmp36_;
	GError* _tmp37_;
	gint _tmp38_;
	xmlNode* _tmp39_;
	xmlNode* _tmp40_ = NULL;
	xmlNode* _tmp41_;
	xmlNode* _tmp42_;
	xmlNode* _tmp43_;
	xmlNode* class_node;
	xmlNode* _tmp44_;
	GError* _tmp45_;
	gint _tmp46_;
	GError* _tmp47_;
	gint _tmp48_;
	GError* _tmp49_;
	gint _tmp50_;
#line 301 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 302 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = strlen (DIDL_ITEM);
#line 302 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = _tmp0_;
#line 302 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = xmlReadMemory (DIDL_ITEM, _tmp1_, NULL, NULL, (gint) (XML_PARSE_RECOVER | XML_PARSE_NOBLANKS));
#line 302 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xml = _tmp2_;
#line 308 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = xml->children;
#line 308 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	didl_node = _tmp3_;
#line 309 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = didl_node->children;
#line 309 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	item_node = _tmp4_;
#line 310 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp5_ = rygel_content_directory_new ();
#line 310 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	content_directory = _tmp5_;
#line 313 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp6_ = rygel_service_action_new ("0", "");
#line 313 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	action = _tmp6_;
#line 314 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp7_ = _g_object_ref0 (action);
#line 314 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp8_ = rygel_item_creator_new (content_directory, _tmp7_);
#line 314 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	creator = _tmp8_;
#line 315 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
#line 316 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp9_ = action->error_code;
#line 316 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp10_ = self->priv->bad_metadata;
#line 316 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp11_ = _tmp10_->code;
#line 316 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp9_ == _tmp11_);
#line 317 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp12_ = action->error_message;
#line 317 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (g_strcmp0 (_tmp12_, "Bad metadata") == 0);
#line 320 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlUnlinkNode (item_node);
#line 321 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlNodeSetContent (didl_node, "  ");
#line 322 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp13_ = self->priv->bad_metadata;
#line 322 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp14_ = _tmp13_->code;
#line 322 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp14_);
#line 325 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp15_ = xmlCopyNode (item_node, 1);
#line 325 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	tmp = _tmp15_;
#line 326 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp16_ = tmp;
#line 326 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlUnsetProp (_tmp16_, "restricted");
#line 327 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp17_ = tmp;
#line 327 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlAddChild (didl_node, _tmp17_);
#line 328 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp18_ = self->priv->bad_metadata;
#line 328 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp19_ = _tmp18_->code;
#line 328 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp19_);
#line 331 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp20_ = tmp;
#line 331 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlSetProp (_tmp20_, "restricted", "1");
#line 332 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp21_ = self->priv->invalid_args;
#line 332 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp22_ = _tmp21_->code;
#line 332 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp22_);
#line 335 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp23_ = tmp;
#line 335 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlUnlinkNode (_tmp23_);
#line 336 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp24_ = xmlCopyNode (item_node, 1);
#line 336 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	tmp = _tmp24_;
#line 337 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp25_ = tmp;
#line 337 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlSetProp (_tmp25_, "id", "InvalidItemId");
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp26_ = tmp;
#line 338 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlAddChild (didl_node, _tmp26_);
#line 339 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp27_ = self->priv->bad_metadata;
#line 339 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp28_ = _tmp27_->code;
#line 339 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp28_);
#line 342 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp29_ = tmp;
#line 342 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlUnsetProp (_tmp29_, "id");
#line 343 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp30_ = self->priv->bad_metadata;
#line 343 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp31_ = _tmp30_->code;
#line 343 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp31_);
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp32_ = tmp;
#line 346 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlUnlinkNode (_tmp32_);
#line 347 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp33_ = xmlCopyNode (item_node, 1);
#line 347 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	tmp = _tmp33_;
#line 348 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp34_ = tmp;
#line 348 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp35_ = _tmp34_->children;
#line 348 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	title_node = _tmp35_;
#line 349 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlUnlinkNode (title_node);
#line 350 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp36_ = tmp;
#line 350 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlAddChild (didl_node, _tmp36_);
#line 351 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp37_ = self->priv->bad_metadata;
#line 351 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp38_ = _tmp37_->code;
#line 351 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp38_);
#line 354 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp39_ = tmp;
#line 354 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlUnlinkNode (_tmp39_);
#line 355 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp40_ = xmlCopyNode (item_node, 1);
#line 355 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	tmp = _tmp40_;
#line 356 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp41_ = tmp;
#line 356 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp42_ = _tmp41_->children;
#line 356 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp43_ = _tmp42_->next;
#line 356 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	class_node = _tmp43_;
#line 357 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlNodeSetContent (class_node, "object.container");
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp44_ = tmp;
#line 358 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlAddChild (didl_node, _tmp44_);
#line 359 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp45_ = self->priv->bad_metadata;
#line 359 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp46_ = _tmp45_->code;
#line 359 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp46_);
#line 361 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlNodeSetContent (class_node, "");
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp47_ = self->priv->bad_metadata;
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp48_ = _tmp47_->code;
#line 362 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp48_);
#line 364 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	xmlUnlinkNode (class_node);
#line 365 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp49_ = self->priv->bad_metadata;
#line 365 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp50_ = _tmp49_->code;
#line 365 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_didl_parsing_step (self, xml, _tmp50_);
#line 301 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (creator);
#line 301 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (action);
#line 301 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (content_directory);
#line 2968 "rygel-item-creator-test.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	return _data3_;
#line 2977 "rygel-item-creator-test.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2986 "rygel-item-creator-test.c"
		RygelHTTPItemCreatorTest * self;
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		self = _data3_->self;
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		_g_main_loop_unref0 (_data3_->main_loop);
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		_g_object_unref0 (self);
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
		g_slice_free (Block3Data, _data3_);
#line 2996 "rygel-item-creator-test.c"
	}
}


static void __lambda7_ (Block3Data* _data3_) {
	RygelHTTPItemCreatorTest * self;
#line 370 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = _data3_->self;
#line 370 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_main_loop_quit (_data3_->main_loop);
#line 3007 "rygel-item-creator-test.c"
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 370 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	__lambda7_ (self);
#line 370 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	block3_data_unref (self);
#line 3016 "rygel-item-creator-test.c"
}


static void rygel_http_item_creator_test_test_fetch_container_run (RygelHTTPItemCreatorTest* self, RygelItemCreator* creator) {
	Block3Data* _data3_;
	GMainLoop* _tmp0_;
	RygelItemCreator* _tmp1_;
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (creator != NULL);
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data3_->_ref_count_ = 1;
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data3_->self = g_object_ref (self);
#line 369 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 369 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data3_->main_loop = _tmp0_;
#line 370 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = creator;
#line 370 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp1_, ___lambda7__gasync_ready_callback, block3_data_ref (_data3_));
#line 371 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_main_loop_run (_data3_->main_loop);
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	block3_data_unref (_data3_);
#line 368 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_data3_ = NULL;
#line 3048 "rygel-item-creator-test.c"
}


static void rygel_http_item_creator_test_test_fetch_container (RygelHTTPItemCreatorTest* self) {
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* content_directory;
	RygelSearchableContainer* _tmp1_;
	RygelSearchableContainer* root_container;
	RygelMediaContainer* _tmp2_;
	RygelServiceAction* _tmp3_;
	RygelServiceAction* action;
	RygelServiceAction* _tmp4_;
	RygelItemCreator* _tmp5_;
	RygelItemCreator* creator;
	gint _tmp6_;
	GError* _tmp7_;
	gint _tmp8_;
	RygelMediaObject* _tmp9_;
	gint _tmp10_;
	GError* _tmp11_;
	gint _tmp12_;
	RygelMediaContainer* _tmp13_;
	gint _tmp14_;
	GError* _tmp15_;
	gint _tmp16_;
	RygelMediaObject* _tmp17_;
	RygelMediaObject* _tmp18_;
	GUPnPOCMFlags _tmp19_;
	gint _tmp20_;
	GError* _tmp21_;
	gint _tmp22_;
	RygelWritableContainer* _tmp23_;
	RygelWritableContainer* container;
	GeeArrayList* _tmp24_;
	GUPnPOCMFlags _tmp25_;
	RygelMediaObject* _tmp26_;
	gint _tmp27_;
	GError* _tmp28_;
	gint _tmp29_;
	RygelMediaContainer* _tmp30_;
	gchar* _tmp31_;
	gint _tmp32_;
	GError* _tmp33_;
	gint _tmp34_;
	RygelSearchableContainer* _tmp35_;
	gint _tmp36_;
	GError* _tmp37_;
	gint _tmp38_;
#line 374 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_return_if_fail (self != NULL);
#line 376 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp0_ = rygel_content_directory_new ();
#line 376 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	content_directory = _tmp0_;
#line 377 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp1_ = rygel_searchable_container_new ();
#line 377 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	root_container = _tmp1_;
#line 378 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp2_ = _g_object_ref0 ((RygelMediaContainer*) root_container);
#line 378 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (content_directory->root_container);
#line 378 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	content_directory->root_container = _tmp2_;
#line 379 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp3_ = rygel_service_action_new ("0", DIDL_ITEM);
#line 379 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	action = _tmp3_;
#line 380 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp4_ = _g_object_ref0 (action);
#line 380 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp5_ = rygel_item_creator_new (content_directory, _tmp4_);
#line 380 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	creator = _tmp5_;
#line 381 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_fetch_container_run (self, creator);
#line 382 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp6_ = action->error_code;
#line 382 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp7_ = self->priv->no_such_object;
#line 382 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp8_ = _tmp7_->code;
#line 382 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp6_ == _tmp8_);
#line 386 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp9_ = rygel_media_object_new ();
#line 386 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (((RygelMediaContainer*) root_container)->found_object);
#line 386 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	((RygelMediaContainer*) root_container)->found_object = _tmp9_;
#line 387 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_fetch_container_run (self, creator);
#line 388 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp10_ = action->error_code;
#line 388 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp11_ = self->priv->no_such_object;
#line 388 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp12_ = _tmp11_->code;
#line 388 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp10_ == _tmp12_);
#line 391 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp13_ = rygel_media_container_new ();
#line 391 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (((RygelMediaContainer*) root_container)->found_object);
#line 391 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	((RygelMediaContainer*) root_container)->found_object = (RygelMediaObject*) _tmp13_;
#line 392 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_fetch_container_run (self, creator);
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp14_ = action->error_code;
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp15_ = self->priv->restricted_parent;
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp16_ = _tmp15_->code;
#line 393 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp14_ == _tmp16_);
#line 396 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp17_ = ((RygelMediaContainer*) root_container)->found_object;
#line 396 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp18_ = ((RygelMediaContainer*) root_container)->found_object;
#line 396 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp19_ = _tmp18_->ocm_flags;
#line 396 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp18_->ocm_flags = _tmp19_ | GUPNP_OCM_FLAGS_UPLOAD;
#line 397 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_fetch_container_run (self, creator);
#line 398 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp20_ = action->error_code;
#line 398 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp21_ = self->priv->restricted_parent;
#line 398 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp22_ = _tmp21_->code;
#line 398 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp20_ == _tmp22_);
#line 401 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp23_ = rygel_writable_container_new ();
#line 401 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	container = _tmp23_;
#line 402 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp24_ = ((RygelMediaContainer*) container)->create_classes;
#line 402 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, "object.item.imageItem.musicTrack");
#line 403 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp25_ = ((RygelMediaObject*) container)->ocm_flags;
#line 403 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	((RygelMediaObject*) container)->ocm_flags = _tmp25_ | GUPNP_OCM_FLAGS_UPLOAD;
#line 404 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp26_ = _g_object_ref0 ((RygelMediaObject*) container);
#line 404 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (((RygelMediaContainer*) root_container)->found_object);
#line 404 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	((RygelMediaContainer*) root_container)->found_object = _tmp26_;
#line 405 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_fetch_container_run (self, creator);
#line 406 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp27_ = action->error_code;
#line 406 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp28_ = self->priv->bad_metadata;
#line 406 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp29_ = _tmp28_->code;
#line 406 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp27_ == _tmp29_);
#line 409 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp30_ = rygel_media_container_new ();
#line 409 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (content_directory->root_container);
#line 409 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	content_directory->root_container = _tmp30_;
#line 410 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp31_ = g_strdup ("DLNA.ORG_AnyContainer");
#line 410 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_free0 (action->id);
#line 410 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	action->id = _tmp31_;
#line 411 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_fetch_container_run (self, creator);
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp32_ = action->error_code;
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp33_ = self->priv->no_such_object;
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp34_ = _tmp33_->code;
#line 412 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp32_ == _tmp34_);
#line 415 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp35_ = rygel_searchable_container_new ();
#line 415 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (content_directory->root_container);
#line 415 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	content_directory->root_container = (RygelMediaContainer*) _tmp35_;
#line 416 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_test_fetch_container_run (self, creator);
#line 419 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp36_ = action->error_code;
#line 419 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp37_ = self->priv->bad_metadata;
#line 419 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_tmp38_ = _tmp37_->code;
#line 419 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_assert (_tmp36_ == _tmp38_);
#line 374 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (container);
#line 374 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (creator);
#line 374 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (action);
#line 374 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (root_container);
#line 374 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_object_unref0 (content_directory);
#line 3259 "rygel-item-creator-test.c"
}


static void rygel_http_item_creator_test_class_init (RygelHTTPItemCreatorTestClass * klass) {
#line 244 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	rygel_http_item_creator_test_parent_class = g_type_class_peek_parent (klass);
#line 244 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemCreatorTestPrivate));
#line 244 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_creator_test_finalize;
#line 3270 "rygel-item-creator-test.c"
}


static void rygel_http_item_creator_test_instance_init (RygelHTTPItemCreatorTest * self) {
#line 244 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self->priv = RYGEL_HTTP_ITEM_CREATOR_TEST_GET_PRIVATE (self);
#line 3277 "rygel-item-creator-test.c"
}


static void rygel_http_item_creator_test_finalize (GObject* obj) {
	RygelHTTPItemCreatorTest * self;
#line 244 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	self = RYGEL_HTTP_ITEM_CREATOR_TEST (obj);
#line 256 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_error_free0 (self->priv->no_such_object);
#line 257 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_error_free0 (self->priv->restricted_parent);
#line 258 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_error_free0 (self->priv->bad_metadata);
#line 259 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	_g_error_free0 (self->priv->invalid_args);
#line 244 "/home/jens/Source/rygel/tests/rygel-item-creator-test.vala"
	G_OBJECT_CLASS (rygel_http_item_creator_test_parent_class)->finalize (obj);
#line 3295 "rygel-item-creator-test.c"
}


GType rygel_http_item_creator_test_get_type (void) {
	static volatile gsize rygel_http_item_creator_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_creator_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemCreatorTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_creator_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemCreatorTest), 0, (GInstanceInitFunc) rygel_http_item_creator_test_instance_init, NULL };
		GType rygel_http_item_creator_test_type_id;
		rygel_http_item_creator_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemCreatorTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_creator_test_type_id__volatile, rygel_http_item_creator_test_type_id);
	}
	return rygel_http_item_creator_test_type_id__volatile;
}



