/* rygel-object-creator.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-object-creator.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <stdio.h>
#include <uuid/uuid.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_BASE_MEDIA_CONTAINER (rygel_base_media_container_get_type ())
#define RYGEL_BASE_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainer))
#define RYGEL_BASE_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainerClass))
#define RYGEL_IS_BASE_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER))
#define RYGEL_IS_BASE_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASE_MEDIA_CONTAINER))
#define RYGEL_BASE_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainerClass))

typedef struct _RygelBaseMediaContainer RygelBaseMediaContainer;
typedef struct _RygelBaseMediaContainerClass RygelBaseMediaContainerClass;
typedef struct _RygelBaseMediaContainerPrivate RygelBaseMediaContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelBaseMediaContainerGetChildrenData RygelBaseMediaContainerGetChildrenData;
typedef struct _RygelBaseMediaContainerFindObjectData RygelBaseMediaContainerFindObjectData;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_OBJECT_CREATOR (rygel_object_creator_get_type ())
#define RYGEL_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator))
#define RYGEL_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))
#define RYGEL_IS_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_IS_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_OBJECT_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))

typedef struct _RygelObjectCreator RygelObjectCreator;
typedef struct _RygelObjectCreatorClass RygelObjectCreatorClass;
typedef struct _RygelObjectCreatorPrivate RygelObjectCreatorPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;

#define RYGEL_TYPE_SERVICE_ACTION (rygel_service_action_get_type ())
#define RYGEL_SERVICE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERVICE_ACTION, RygelServiceAction))
#define RYGEL_SERVICE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERVICE_ACTION, RygelServiceActionClass))
#define RYGEL_IS_SERVICE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERVICE_ACTION))
#define RYGEL_IS_SERVICE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERVICE_ACTION))
#define RYGEL_SERVICE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERVICE_ACTION, RygelServiceActionClass))

typedef struct _RygelServiceAction RygelServiceAction;
typedef struct _RygelServiceActionClass RygelServiceActionClass;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define TYPE_SERIALIZER_TYPE (serializer_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_IS_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerClass RygelWritableContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
typedef struct _RygelObjectCreatorRunData RygelObjectCreatorRunData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_SEARCHABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerClass))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_IS_SEARCHABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerClass))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerClass RygelSearchableContainerClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelObjectCreatorFindAnyContainerData RygelObjectCreatorFindAnyContainerData;
typedef struct _RygelObjectCreatorFetchContainerData RygelObjectCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelObjectCreatorCreateObjectFromDidlData RygelObjectCreatorCreateObjectFromDidlData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_PLAYLIST_ITEM (rygel_playlist_item_get_type ())
#define RYGEL_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItem))
#define RYGEL_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItemClass))
#define RYGEL_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYLIST_ITEM))
#define RYGEL_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYLIST_ITEM))
#define RYGEL_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItemClass))

typedef struct _RygelPlaylistItem RygelPlaylistItem;
typedef struct _RygelPlaylistItemClass RygelPlaylistItemClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _RygelObjectCreatorCreateUriData RygelObjectCreatorCreateUriData;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _RygelObjectCreatorWaitForObjectData RygelObjectCreatorWaitForObjectData;

#define RYGEL_TYPE_DLNA_PROFILE (rygel_dlna_profile_get_type ())
#define RYGEL_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfile))
#define RYGEL_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))
#define RYGEL_IS_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_IS_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_DLNA_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))

typedef struct _RygelDLNAProfile RygelDLNAProfile;
typedef struct _RygelDLNAProfileClass RygelDLNAProfileClass;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* ref_id;
	gchar* upnp_class;
	GUPnPOCMFlags ocm_flags;
	GeeArrayList* uris;
	guint object_update_id;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*get_children) (RygelMediaObject* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaObject* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	GeeArrayList* create_classes;
	gchar* sort_criteria;
	guint update_id;
	RygelMediaObject* found_object;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelBaseMediaContainer {
	RygelMediaContainer parent_instance;
	RygelBaseMediaContainerPrivate * priv;
};

struct _RygelBaseMediaContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelBaseMediaContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelBaseMediaContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
};

struct _RygelBaseMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelBaseMediaContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelObjectCreator {
	GObject parent_instance;
	RygelObjectCreatorPrivate * priv;
};

struct _RygelObjectCreatorClass {
	GObjectClass parent_class;
};

struct _RygelObjectCreatorPrivate {
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteObject* didl_object;
	RygelMediaObject* object;
	RygelContentDirectory* content_dir;
	RygelServiceAction* action;
	RygelSerializer* serializer;
	GUPnPDIDLLiteParser* didl_parser;
	GRegex* title_regex;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GObject parent_instance;
	RygelContentDirectoryPrivate * priv;
	GCancellable* cancellable;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
};

struct _RygelContentDirectoryClass {
	GObjectClass parent_class;
};

typedef enum  {
	SERIALIZER_TYPE_GENERIC_DIDL,
	SERIALIZER_TYPE_DIDL_S
} SerializerType;

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT,
	RYGEL_CONTENT_DIRECTORY_ERROR_ERROR
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* dlna_profile;
	gchar* mime_type;
	glong size;
	gboolean place_holder;
	gchar* date;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelObjectCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* container;
	gboolean _tmp1_;
	RygelWritableContainer* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GUPnPDIDLLiteObject* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	RygelWritableContainer* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	RygelWritableContainer* _tmp16_;
	RygelMediaObject* _tmp17_;
	RygelWritableContainer* _tmp18_;
	RygelMediaObject* _tmp19_;
	GCancellable* _tmp20_;
	GCancellable* _tmp21_;
	RygelWritableContainer* _tmp22_;
	RygelMediaObject* _tmp23_;
	GCancellable* _tmp24_;
	GCancellable* _tmp25_;
	RygelWritableContainer* _tmp26_;
	RygelMediaObject* _tmp27_;
	RygelSerializer* _tmp28_;
	RygelContentDirectory* _tmp29_;
	RygelHTTPServer* _tmp30_;
	gboolean _tmp31_;
	const gchar* _tmp32_;
	gboolean _tmp33_;
	RygelMediaObject* _tmp34_;
	gboolean _tmp35_;
	RygelMediaObject* _tmp36_;
	RygelMediaObject* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	RygelObjectRemovalQueue* _tmp42_;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp43_;
	RygelMediaObject* _tmp44_;
	GCancellable* _tmp45_;
	GCancellable* _tmp46_;
	GError* err;
	GError* _tmp47_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelObjectCreatorFindAnyContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelMediaObject* result;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchableContainer* root_container;
	RygelSearchableContainer* _tmp3_;
	GUPnPDIDLLiteObject* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* upnp_class;
	RygelRelationalExpression* _tmp8_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelRelationalExpression* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	guint total_matches;
	RygelSearchableContainer* _tmp16_;
	RygelRelationalExpression* _tmp17_;
	RygelSearchableContainer* _tmp18_;
	const gchar* _tmp19_;
	GCancellable* _tmp20_;
	GCancellable* _tmp21_;
	gint _tmp22_;
	RygelMediaObjects* _tmp23_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GUPnPDIDLLiteObject* _tmp27_;
	const gchar* _tmp28_;
	RygelMediaObjects* _tmp29_;
	gpointer _tmp30_;
	const gchar* _tmp31_;
	GUPnPDIDLLiteObject* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GError* _tmp35_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelContentDirectory* _tmp3_;
	RygelMediaContainer* _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	RygelMediaObject* _tmp8_;
	RygelMediaObject* _tmp9_;
	gboolean _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	gboolean _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	gboolean _tmp16_;
	RygelMediaObject* _tmp17_;
	GUPnPOCMFlags _tmp18_;
	RygelMediaObject* _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	RygelMediaObject* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	RygelMediaObject* _tmp26_;
	RygelWritableContainer* _tmp27_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorCreateObjectFromDidlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	GUPnPDIDLLiteObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelWritableContainer* _tmp3_;
	GUPnPDIDLLiteObject* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GUPnPDIDLLiteObject* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	RygelWritableContainer* _tmp17_;
	RygelMediaObject* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* uri;
	RygelMediaObject* _tmp22_;
	GeeArrayList* _tmp23_;
	const gchar* _tmp24_;
	RygelMediaObject* _tmp25_;
	RygelMediaObject* _tmp26_;
	RygelMediaObject* _tmp27_;
	RygelMediaObject* _tmp28_;
	GeeArrayList* _tmp29_;
	gpointer _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	GFile* file;
	RygelMediaObject* _tmp34_;
	GFile* _tmp35_;
	gboolean _tmp36_;
	RygelMediaObject* _tmp37_;
	RygelMediaObject* _tmp38_;
	GeeArrayList* _tmp39_;
	gpointer _tmp40_;
	gchar* _tmp41_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	GFile* dir;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	RygelWritableContainer* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* file;
	GFile* _tmp17_;
	gchar* _tmp18_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	RygelObjectCreator * self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	guint timeout;
};

struct _RygelObjectCreatorWaitForObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	Block4Data* _data4_;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaObject* object;
	RygelMediaObject* _tmp4_;
	RygelWritableContainer* _tmp5_;
	RygelMediaObject* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	GError* _error_;
	RygelWritableContainer* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	RygelMediaObject* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	RygelMediaObject* _tmp19_;
	Block5Data* _data5_;
	RygelWritableContainer* _tmp20_;
	gulong _tmp21_;
	gulong id;
	guint _tmp22_;
	RygelWritableContainer* _tmp23_;
	gulong _tmp24_;
	guint _tmp25_;
	guint _tmp26_;
	RygelWritableContainer* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GError * _inner_error_;
};


static gpointer rygel_base_media_container_parent_class = NULL;
static gpointer rygel_object_creator_parent_class = NULL;
static GPatternSpec* rygel_object_creator_comment_pattern;
static GPatternSpec* rygel_object_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_object_creator_rygel_state_machine_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_base_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_BASE_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelBaseMediaContainer* rygel_base_media_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelBaseMediaContainer* rygel_base_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
static void rygel_base_media_container_real_get_children_data_free (gpointer _data);
static void rygel_base_media_container_real_get_children (RygelMediaObject* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_base_media_container_real_get_children_co (RygelBaseMediaContainerGetChildrenData* _data_);
static void rygel_base_media_container_real_find_object_data_free (gpointer _data);
static void rygel_base_media_container_real_find_object (RygelMediaObject* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_base_media_container_real_find_object_co (RygelBaseMediaContainerFindObjectData* _data_);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_object_creator_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_service_action_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
#define RYGEL_OBJECT_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorPrivate))
enum  {
	RYGEL_OBJECT_CREATOR_DUMMY_PROPERTY,
	RYGEL_OBJECT_CREATOR_CANCELLABLE
};
#define RYGEL_OBJECT_CREATOR_INVALID_CHARS "/?<>\\:*|\""
RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, RygelServiceAction* action);
RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, RygelServiceAction* action);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
GType serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (SerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, SerializerType type);
static void rygel_object_creator_real_run_data_free (gpointer _data);
static void rygel_object_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_object_creator_real_run_co (RygelObjectCreatorRunData* _data_);
static void rygel_object_creator_parse_args (RygelObjectCreator* self, GError** error);
static void rygel_object_creator_parse_didl (RygelObjectCreator* self, GError** error);
static void rygel_object_creator_fetch_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static RygelWritableContainer* rygel_object_creator_fetch_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_object_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
#define RYGEL_MEDIA_CONTAINER_ANY "DLNA.ORG_AnyContainer"
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GQuark rygel_content_directory_error_quark (void);
static void rygel_object_creator_create_object_from_didl (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_object_creator_create_object_from_didl_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
void rygel_writable_container_add_container (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_container_finish (RygelWritableContainer* self, GAsyncResult* _res_);
static void rygel_object_creator_wait_for_object (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_object_creator_wait_for_object_finish (RygelObjectCreator* self, GAsyncResult* _res_);
void rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* server);
static void rygel_object_creator_conclude (RygelObjectCreator* self);
GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST;
RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
void rygel_object_removal_queue_queue (RygelObjectRemovalQueue* self, RygelMediaObject* object, GCancellable* cancellable);
static void rygel_object_creator_handle_error (RygelObjectCreator* self, GError* _error_);
void rygel_service_action_get (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, gchar** arg1_val, const gchar* arg2_name, GType arg2_type, gchar** arg2_val);
static void __lambda4_ (RygelObjectCreator* self, GUPnPDIDLLiteObject* didl_object);
static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self);
static void rygel_object_creator_generalize_upnp_class (RygelObjectCreator* self, gchar** upnp_class);
static void rygel_object_creator_find_any_container_data_free (gpointer _data);
static void rygel_object_creator_find_any_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_object_creator_find_any_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_object_creator_find_any_container_co (RygelObjectCreatorFindAnyContainerData* _data_);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, gint offset, gint count, const gchar* soer_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, gint* total_matches);
static void rygel_object_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_object_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_object_creator_fetch_container_co (RygelObjectCreatorFetchContainerData* _data_);
static void rygel_object_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_find_object (RygelMediaObject* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_object_find_object_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
gchar* rygel_serializer_get_string (RygelSerializer* self);
void rygel_service_action_set (RygelServiceAction* self, const gchar* arg1_name, GType arg1_type, const gchar* arg1_val, const gchar* arg2_name, GType arg2_type, const gchar* arg2_val);
void rygel_service_action_return (RygelServiceAction* self);
void rygel_service_action_return_error (RygelServiceAction* self, gint code, const gchar* message);
static gchar* rygel_object_creator_get_generic_mime_type (RygelObjectCreator* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_create_object_from_didl_data_free (gpointer _data);
static gboolean rygel_object_creator_create_object_from_didl_co (RygelObjectCreatorCreateObjectFromDidlData* _data_);
static RygelMediaObject* rygel_object_creator_create_object (RygelObjectCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
static void rygel_object_creator_extract_item_parameters (RygelObjectCreator* self, GError** error);
static void rygel_object_creator_create_uri (RygelObjectCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_object_creator_create_uri_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_object_creator_create_object_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
static void rygel_object_creator_parse_and_verify_didl_date (RygelObjectCreator* self, GError** error);
static gboolean rygel_object_creator_is_profile_valid (RygelObjectCreator* self, const gchar* profile);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean rygel_object_creator_is_valid_uri (RygelObjectCreator* self, const gchar* uri, gchar** sanitized_uri);
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
static void _vala_SoupDate_free (SoupDate* self);
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
#define RYGEL_PLAYLIST_ITEM_UPNP_CLASS "object.item.playlistItem"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER "object.container.storageFolder"
#define RYGEL_MEDIA_CONTAINER_PLAYLIST "object.container.playlistContainer"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelPlaylistItem* rygel_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelPlaylistItem* rygel_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
GType rygel_playlist_item_get_type (void) G_GNUC_CONST;
static void _vala_SoupURI_free (SoupURI* self);
static gchar* rygel_object_creator_mangle_title (RygelObjectCreator* self, const gchar* title, GError** error);
static void rygel_object_creator_create_uri_data_free (gpointer _data);
static gboolean rygel_object_creator_create_uri_co (RygelObjectCreatorCreateUriData* _data_);
void rygel_writable_container_get_writable (RygelWritableContainer* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_writable_container_get_writable_finish (RygelWritableContainer* self, GAsyncResult* _res_);
static void rygel_object_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_object_creator_wait_for_object_data_free (gpointer _data);
static gboolean rygel_object_creator_wait_for_object_co (RygelObjectCreatorWaitForObjectData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void rygel_object_creator_wait_for_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ____lambda5_ (Block5Data* _data5_, RygelMediaContainer* container);
static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean ____lambda6_ (Block5Data* _data5_);
static gboolean _____lambda6__gsource_func (gpointer self);
gpointer rygel_dlna_profile_ref (gpointer instance);
void rygel_dlna_profile_unref (gpointer instance);
GParamSpec* rygel_param_spec_dlna_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_dlna_profile (GValue* value, gpointer v_object);
void rygel_value_take_dlna_profile (GValue* value, gpointer v_object);
gpointer rygel_value_get_dlna_profile (const GValue* value);
GType rygel_dlna_profile_get_type (void) G_GNUC_CONST;
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
GList* rygel_media_engine_get_dlna_profiles (RygelMediaEngine* self);
RygelDLNAProfile* rygel_dlna_profile_new (const gchar* name, const gchar* mime);
RygelDLNAProfile* rygel_dlna_profile_construct (GType object_type, const gchar* name, const gchar* mime);
gint rygel_dlna_profile_compare_by_name (RygelDLNAProfile* a, RygelDLNAProfile* b);
static gint _rygel_dlna_profile_compare_by_name_gcompare_func (gconstpointer a, gconstpointer b);
static void rygel_object_creator_finalize (GObject* obj);
static void _vala_rygel_object_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_object_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a media container with the specified details.
     *
     * @param id See the id property of the #RygelMediaObject class.
     * @param parent The parent container, if any.
     * @param title See the title property of the #RygelMediaObject class.
     * @param child_count The initially-known number of child items.
     */
RygelBaseMediaContainer* rygel_base_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelBaseMediaContainer * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = child_count;
	self = (RygelBaseMediaContainer*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "child-count", _tmp3_, NULL);
	return self;
}


RygelBaseMediaContainer* rygel_base_media_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	return rygel_base_media_container_construct (RYGEL_TYPE_BASE_MEDIA_CONTAINER, id, parent, title, child_count);
}


static void rygel_base_media_container_real_get_children_data_free (gpointer _data) {
	RygelBaseMediaContainerGetChildrenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBaseMediaContainerGetChildrenData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_base_media_container_real_get_children (RygelMediaObject* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelBaseMediaContainer * self;
	RygelBaseMediaContainerGetChildrenData* _data_;
	RygelBaseMediaContainer* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	self = (RygelBaseMediaContainer*) base;
	_data_ = g_slice_new0 (RygelBaseMediaContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_base_media_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_base_media_container_real_get_children_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = offset;
	_data_->offset = _tmp1_;
	_tmp2_ = max_count;
	_data_->max_count = _tmp2_;
	_tmp3_ = sort_criteria;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	rygel_base_media_container_real_get_children_co (_data_);
}


static RygelMediaObjects* rygel_base_media_container_real_get_children_finish (RygelMediaObject* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelBaseMediaContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches the list of media objects directly under this container.
     *
     * @param offset zero-based index of the first item to return
     * @param max_count maximum number of objects to return
     * @param sort_criteria sorting order of objects to return
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static gboolean rygel_base_media_container_real_get_children_co (RygelBaseMediaContainerGetChildrenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_base_media_container_real_find_object_data_free (gpointer _data) {
	RygelBaseMediaContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelBaseMediaContainerFindObjectData, _data_);
}


static void rygel_base_media_container_real_find_object (RygelMediaObject* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelBaseMediaContainer * self;
	RygelBaseMediaContainerFindObjectData* _data_;
	RygelBaseMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelBaseMediaContainer*) base;
	_data_ = g_slice_new0 (RygelBaseMediaContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_base_media_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_base_media_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_base_media_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_base_media_container_real_find_object_finish (RygelMediaObject* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelBaseMediaContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Recursively searches this container for a media object with the given ID.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     *
     * @return the found media object.
     */
static gboolean rygel_base_media_container_real_find_object_co (RygelBaseMediaContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_base_media_container_class_init (RygelBaseMediaContainerClass * klass) {
	rygel_base_media_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_children = rygel_base_media_container_real_get_children;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_children_finish = rygel_base_media_container_real_get_children_finish;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->find_object = rygel_base_media_container_real_find_object;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->find_object_finish = rygel_base_media_container_real_find_object_finish;
}


static void rygel_base_media_container_instance_init (RygelBaseMediaContainer * self) {
}


/**
 * Dummy implementation of Rygel.MediaContainer to pass on to
 * Rygel.WritableContianer for creation.
 */
GType rygel_base_media_container_get_type (void) {
	static volatile gsize rygel_base_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_base_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBaseMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_base_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBaseMediaContainer), 0, (GInstanceInitFunc) rygel_base_media_container_instance_init, NULL };
		GType rygel_base_media_container_type_id;
		rygel_base_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelBaseMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_base_media_container_type_id__volatile, rygel_base_media_container_type_id);
	}
	return rygel_base_media_container_type_id__volatile;
}


RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, RygelServiceAction* action) {
	RygelObjectCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	RygelContentDirectory* _tmp2_;
	GCancellable* _tmp3_;
	RygelServiceAction* _tmp4_;
	RygelSerializer* _tmp5_;
	GUPnPDIDLLiteParser* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelObjectCreator*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp1_;
	_tmp2_ = content_dir;
	_tmp3_ = _tmp2_->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
	_tmp4_ = action;
	action = NULL;
	_g_object_unref0 (self->priv->action);
	self->priv->action = _tmp4_;
	_tmp5_ = rygel_serializer_new (SERIALIZER_TYPE_GENERIC_DIDL);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp5_;
	_tmp6_ = gupnp_didl_lite_parser_new ();
	_g_object_unref0 (self->priv->didl_parser);
	self->priv->didl_parser = _tmp6_;
	{
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* pattern;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		_tmp7_ = g_regex_escape_string (RYGEL_OBJECT_CREATOR_INVALID_CHARS, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("[", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "]", NULL);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		pattern = _tmp12_;
		_tmp13_ = g_regex_new (pattern, G_REGEX_OPTIMIZE, G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_free0 (pattern);
			goto __catch0_g_error;
		}
		_g_regex_unref0 (self->priv->title_regex);
		self->priv->title_regex = _tmp14_;
		_g_free0 (pattern);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (action);
	return self;
}


RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, RygelServiceAction* action) {
	return rygel_object_creator_construct (RYGEL_TYPE_OBJECT_CREATOR, content_dir, action);
}


static void rygel_object_creator_real_run_data_free (gpointer _data) {
	RygelObjectCreatorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorRunData, _data_);
}


static void rygel_object_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreator * self;
	RygelObjectCreatorRunData* _data_;
	RygelObjectCreator* _tmp0_;
	self = (RygelObjectCreator*) base;
	_data_ = g_slice_new0 (RygelObjectCreatorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_object_creator_real_run_co (_data_);
}


static void rygel_object_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelObjectCreatorRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_object_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_object_creator_real_run_co (_data_);
}


static gboolean rygel_object_creator_real_run_co (RygelObjectCreatorRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		rygel_object_creator_parse_args (_data_->self, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		rygel_object_creator_parse_didl (_data_->self, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_data_->_state_ = 1;
		rygel_object_creator_fetch_container (_data_->self, rygel_object_creator_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = rygel_object_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->container = _data_->_tmp0_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_data_->_tmp2_ = _data_->container;
		_data_->_tmp3_ = _data_->self->priv->didl_object;
		_data_->_tmp4_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = FALSE;
		_data_->_tmp6_ = rygel_writable_container_can_create (_data_->_tmp2_, _data_->_tmp5_);
		if (!_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->self->priv->container_id;
			_data_->_tmp1_ = g_strcmp0 (_data_->_tmp7_, RYGEL_MEDIA_CONTAINER_ANY) != 0;
		} else {
			_data_->_tmp1_ = FALSE;
		}
		_data_->_tmp8_ = _data_->_tmp1_;
		if (_data_->_tmp8_) {
			_data_->_tmp9_ = _data_->self->priv->didl_object;
			_data_->_tmp10_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->container;
			_data_->_tmp13_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			_data_->_tmp15_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", _data_->_tmp11_, _data_->_tmp14_);
			_data_->_inner_error_ = _data_->_tmp15_;
			_g_object_unref0 (_data_->container);
			goto __catch1_g_error;
		}
		_data_->_tmp16_ = _data_->container;
		_data_->_state_ = 2;
		rygel_object_creator_create_object_from_didl (_data_->self, _data_->_tmp16_, rygel_object_creator_run_ready, _data_);
		return FALSE;
		_state_2:
		rygel_object_creator_create_object_from_didl_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->container);
			goto __catch1_g_error;
		}
		_data_->_tmp17_ = _data_->self->priv->object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp17_, RYGEL_TYPE_MEDIA_ITEM)) {
			_data_->_tmp18_ = _data_->container;
			_data_->_tmp19_ = _data_->self->priv->object;
			_data_->_tmp20_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_state_ = 3;
			rygel_writable_container_add_item (_data_->_tmp18_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp19_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp19_) : NULL, _data_->_tmp21_, rygel_object_creator_run_ready, _data_);
			return FALSE;
			_state_3:
			rygel_writable_container_add_item_finish (_data_->_tmp18_, _data_->_res_);
		} else {
			_data_->_tmp22_ = _data_->container;
			_data_->_tmp23_ = _data_->self->priv->object;
			_data_->_tmp24_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_state_ = 4;
			rygel_writable_container_add_container (_data_->_tmp22_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp23_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp23_) : NULL, _data_->_tmp25_, rygel_object_creator_run_ready, _data_);
			return FALSE;
			_state_4:
			rygel_writable_container_add_container_finish (_data_->_tmp22_, _data_->_res_);
		}
		_data_->_tmp26_ = _data_->container;
		_data_->_state_ = 5;
		rygel_object_creator_wait_for_object (_data_->self, _data_->_tmp26_, rygel_object_creator_run_ready, _data_);
		return FALSE;
		_state_5:
		rygel_object_creator_wait_for_object_finish (_data_->self, _data_->_res_);
		_data_->_tmp27_ = _data_->self->priv->object;
		_data_->_tmp28_ = _data_->self->priv->serializer;
		_data_->_tmp29_ = _data_->self->priv->content_dir;
		_data_->_tmp30_ = _data_->_tmp29_->http_server;
		rygel_media_object_serialize (_data_->_tmp27_, _data_->_tmp28_, _data_->_tmp30_);
		rygel_object_creator_conclude (_data_->self);
		_data_->_tmp32_ = _data_->self->priv->container_id;
		if (g_strcmp0 (_data_->_tmp32_, RYGEL_MEDIA_CONTAINER_ANY) == 0) {
			_data_->_tmp34_ = _data_->self->priv->object;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp34_, RYGEL_TYPE_MEDIA_CONTAINER)) {
				_data_->_tmp33_ = TRUE;
			} else {
				_data_->_tmp36_ = _data_->self->priv->object;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp36_, RYGEL_TYPE_MEDIA_ITEM)) {
					_data_->_tmp37_ = _data_->self->priv->object;
					_data_->_tmp38_ = (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp37_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp37_) : NULL)->place_holder;
					_data_->_tmp35_ = _data_->_tmp38_;
				} else {
					_data_->_tmp35_ = FALSE;
				}
				_data_->_tmp39_ = _data_->_tmp35_;
				_data_->_tmp33_ = _data_->_tmp39_;
			}
			_data_->_tmp40_ = _data_->_tmp33_;
			_data_->_tmp31_ = _data_->_tmp40_;
		} else {
			_data_->_tmp31_ = FALSE;
		}
		_data_->_tmp41_ = _data_->_tmp31_;
		if (_data_->_tmp41_) {
			_data_->_tmp42_ = NULL;
			_data_->_tmp42_ = rygel_object_removal_queue_get_default ();
			_data_->queue = _data_->_tmp42_;
			_data_->_tmp43_ = _data_->queue;
			_data_->_tmp44_ = _data_->self->priv->object;
			_data_->_tmp45_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp46_ = _data_->_tmp45_;
			rygel_object_removal_queue_queue (_data_->_tmp43_, _data_->_tmp44_, _data_->_tmp46_);
			_g_object_unref0 (_data_->queue);
		}
		_g_object_unref0 (_data_->container);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp47_ = _data_->err;
		rygel_object_creator_handle_error (_data_->self, _data_->_tmp47_);
		_g_error_free0 (_data_->err);
	}
	__finally1:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Check the supplied input parameters.
     */
static void rygel_object_creator_parse_args (RygelObjectCreator* self, GError** error) {
	RygelServiceAction* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action;
	rygel_service_action_get (_tmp0_, "ContainerID", G_TYPE_STRING, &_tmp1_, "Elements", G_TYPE_STRING, &_tmp2_);
	_g_free0 (self->priv->container_id);
	self->priv->container_id = _tmp1_;
	_g_free0 (self->priv->elements);
	self->priv->elements = _tmp2_;
	_tmp3_ = self->priv->elements;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_;
		_tmp4_ = _ ("'Elements' argument missing.");
		_tmp5_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		return;
	} else {
		GPatternSpec* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = rygel_object_creator_comment_pattern;
		_tmp7_ = self->priv->elements;
		_tmp8_ = g_pattern_match_string (_tmp6_, _tmp7_);
		if (_tmp8_) {
			const gchar* _tmp9_ = NULL;
			GError* _tmp10_;
			_tmp9_ = _ ("Comments not allowed in XML");
			_tmp10_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp9_);
			_inner_error_ = _tmp10_;
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp11_ = self->priv->container_id;
	if (_tmp11_ == NULL) {
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_;
		_tmp12_ = _ ("No such object");
		_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _tmp12_);
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Parse the given DIDL-Lite snippet.
     *
     * Parses the DIDL-Lite and performs checking of the passed meta-data
     * according to UPnP and DLNA guidelines.
     */
static void __lambda4_ (RygelObjectCreator* self, GUPnPDIDLLiteObject* didl_object) {
	GUPnPDIDLLiteObject* _tmp0_;
	GUPnPDIDLLiteObject* _tmp1_;
	g_return_if_fail (didl_object != NULL);
	_tmp0_ = didl_object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->didl_object);
	self->priv->didl_object = _tmp1_;
}


static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self) {
	__lambda4_ (self, object);
}


static void rygel_object_creator_parse_didl (RygelObjectCreator* self, GError** error) {
	GUPnPDIDLLiteParser* _tmp0_;
	GUPnPDIDLLiteObject* _tmp4_;
	gboolean _tmp10_ = FALSE;
	GUPnPDIDLLiteObject* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp17_;
	GUPnPDIDLLiteObject* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GUPnPDIDLLiteObject* _tmp23_;
	GUPnPOCMFlags _tmp24_;
	GUPnPOCMFlags _tmp25_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	GUPnPDIDLLiteObject* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gboolean _tmp35_;
	gboolean _tmp40_;
	GUPnPDIDLLiteObject* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->didl_parser;
	g_signal_connect_object (_tmp0_, "object-available", (GCallback) ___lambda4__gupnp_didl_lite_parser_object_available, self, 0);
	{
		GUPnPDIDLLiteParser* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->didl_parser;
		_tmp2_ = self->priv->elements;
		gupnp_didl_lite_parser_parse_didl (_tmp1_, _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* parse_err = NULL;
		GError* _tmp3_;
		parse_err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
		_inner_error_ = _tmp3_;
		_g_error_free0 (parse_err);
		goto __finally2;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp4_ = self->priv->didl_object;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* message;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		_tmp5_ = _ ("No items in DIDL-Lite from client: '%s'");
		_tmp6_ = g_strdup (_tmp5_);
		message = _tmp6_;
		_tmp7_ = message;
		_tmp8_ = self->priv->elements;
		_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp7_, _tmp8_);
		_inner_error_ = _tmp9_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		return;
	}
	_tmp11_ = self->priv->didl_object;
	_tmp12_ = gupnp_didl_lite_object_get_id (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		GUPnPDIDLLiteObject* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = self->priv->didl_object;
		_tmp15_ = gupnp_didl_lite_object_get_id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp10_ = g_strcmp0 (_tmp16_, "") != 0;
	}
	_tmp17_ = _tmp10_;
	if (_tmp17_) {
		GError* _tmp18_;
		_tmp18_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "@id must be set to \"\" in " "CreateItem");
		_inner_error_ = _tmp18_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp19_ = self->priv->didl_object;
	_tmp20_ = gupnp_didl_lite_object_get_title (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ == NULL) {
		GError* _tmp22_;
		_tmp22_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "dc:title must be set in " "CreateItem");
		_inner_error_ = _tmp22_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp23_ = self->priv->didl_object;
	_tmp24_ = gupnp_didl_lite_object_get_dlna_managed (_tmp23_);
	_tmp25_ = _tmp24_;
	if ((_tmp25_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0) {
		GError* _tmp26_;
		_tmp26_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Flags that must not be set " "were found in 'dlnaManaged'");
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp29_ = self->priv->didl_object;
	_tmp30_ = gupnp_didl_lite_object_get_upnp_class (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == NULL) {
		_tmp28_ = TRUE;
	} else {
		GUPnPDIDLLiteObject* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp32_ = self->priv->didl_object;
		_tmp33_ = gupnp_didl_lite_object_get_upnp_class (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp28_ = g_strcmp0 (_tmp34_, "") == 0;
	}
	_tmp35_ = _tmp28_;
	if (_tmp35_) {
		_tmp27_ = TRUE;
	} else {
		GUPnPDIDLLiteObject* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gboolean _tmp39_ = FALSE;
		_tmp36_ = self->priv->didl_object;
		_tmp37_ = gupnp_didl_lite_object_get_upnp_class (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_str_has_prefix (_tmp38_, "object");
		_tmp27_ = !_tmp39_;
	}
	_tmp40_ = _tmp27_;
	if (_tmp40_) {
		GError* _tmp41_;
		_tmp41_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid upnp:class given ");
		_inner_error_ = _tmp41_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp42_ = self->priv->didl_object;
	_tmp43_ = gupnp_didl_lite_object_get_restricted (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_) {
		GError* _tmp45_;
		_tmp45_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Cannot create restricted item");
		_inner_error_ = _tmp45_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Modify the give UPnP class to be a more general one.
     *
     * Used to simplify the search for a valid container in the
     * DLNA.ORG_AnyContainer use-case.
     * Example: object.item.videoItem.videoBroadcast → object.item.videoItem
     *
     * @param upnp_class the current UPnP class which will be modified in-place.
     */
static void rygel_object_creator_generalize_upnp_class (RygelObjectCreator* self, gchar** upnp_class) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* needle;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*upnp_class != NULL);
	_tmp0_ = *upnp_class;
	_tmp1_ = g_strrstr_len (_tmp0_, (gssize) (-1), ".");
	needle = _tmp1_;
	_tmp2_ = needle;
	if (_tmp2_ != NULL) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = needle;
		*_tmp3_ = '\0';
		_tmp4_ = *_tmp3_;
	}
}


static void rygel_object_creator_find_any_container_data_free (gpointer _data) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorFindAnyContainerData, _data_);
}


static void rygel_object_creator_find_any_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	RygelObjectCreator* _tmp0_;
	_data_ = g_slice_new0 (RygelObjectCreatorFindAnyContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_find_any_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_find_any_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_object_creator_find_any_container_co (_data_);
}


static RygelMediaObject* rygel_object_creator_find_any_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelObjectCreatorFindAnyContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Find a container that can create items matching the UPnP class of the
     * requested item.
     *
     * If the item's UPnP class cannot be found, generalize the UPnP class until
     * we reach object.item according to DLNA guideline 7.3.120.4.
     *
     * @returns a container able to create the item or null if no such container
     *          can be found.
     */
static void rygel_object_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_object_creator_find_any_container_co (_data_);
}


static gboolean rygel_object_creator_find_any_container_co (RygelObjectCreatorFindAnyContainerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->content_dir;
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp1_) : NULL);
	_data_->root_container = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->root_container;
	if (_data_->_tmp3_ == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->root_container);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->didl_object;
	_data_->_tmp5_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->upnp_class = _data_->_tmp7_;
	_data_->_tmp8_ = rygel_relational_expression_new ();
	_data_->expression = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->expression;
	((RygelSearchExpression*) _data_->_tmp9_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
	_data_->_tmp10_ = _data_->expression;
	_data_->_tmp11_ = g_strdup ("upnp:createClass");
	_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand1);
	((RygelSearchExpression*) _data_->_tmp10_)->operand1 = _data_->_tmp11_;
	while (TRUE) {
		_data_->_tmp12_ = _data_->upnp_class;
		if (!(g_strcmp0 (_data_->_tmp12_, "object") != 0)) {
			break;
		}
		_data_->_tmp13_ = _data_->expression;
		_data_->_tmp14_ = _data_->upnp_class;
		_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
		_g_free0 (((RygelSearchExpression*) _data_->_tmp13_)->operand2);
		((RygelSearchExpression*) _data_->_tmp13_)->operand2 = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->root_container;
		_data_->_tmp17_ = _data_->expression;
		_data_->_tmp18_ = _data_->root_container;
		_data_->_tmp19_ = ((RygelMediaContainer*) _data_->_tmp18_)->sort_criteria;
		_data_->_tmp20_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = 0;
		_data_->_state_ = 1;
		rygel_searchable_container_search (_data_->_tmp16_, (RygelSearchExpression*) _data_->_tmp17_, 0, 1, _data_->_tmp19_, _data_->_tmp21_, rygel_object_creator_find_any_container_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = rygel_searchable_container_search_finish (_data_->_tmp16_, _data_->_res_, &_data_->_tmp22_);
		_data_->total_matches = (guint) _data_->_tmp22_;
		_data_->_result_ = _data_->_tmp23_;
		_data_->_tmp24_ = _data_->_result_;
		_data_->_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		if (_data_->_tmp26_ > 0) {
			_data_->_tmp27_ = _data_->self->priv->didl_object;
			_data_->_tmp28_ = _data_->upnp_class;
			gupnp_didl_lite_object_set_upnp_class (_data_->_tmp27_, _data_->_tmp28_);
			_data_->_tmp29_ = _data_->_result_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp29_, 0);
			_data_->result = (RygelMediaObject*) _data_->_tmp30_;
			_g_object_unref0 (_data_->_result_);
			_rygel_search_expression_unref0 (_data_->expression);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->root_container);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			rygel_object_creator_generalize_upnp_class (_data_->self, &_data_->upnp_class);
		}
		_g_object_unref0 (_data_->_result_);
	}
	_data_->_tmp31_ = _data_->upnp_class;
	if (g_strcmp0 (_data_->_tmp31_, "object") == 0) {
		_data_->_tmp32_ = _data_->self->priv->didl_object;
		_data_->_tmp33_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp32_);
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' UPnP class unsupported", _data_->_tmp34_);
		_data_->_inner_error_ = _data_->_tmp35_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->expression);
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->root_container);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->upnp_class);
	_g_object_unref0 (_data_->root_container);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->upnp_class);
	_g_object_unref0 (_data_->root_container);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_object_creator_fetch_container_data_free (gpointer _data) {
	RygelObjectCreatorFetchContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorFetchContainerData, _data_);
}


static void rygel_object_creator_fetch_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorFetchContainerData* _data_;
	RygelObjectCreator* _tmp0_;
	_data_ = g_slice_new0 (RygelObjectCreatorFetchContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_fetch_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_fetch_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_object_creator_fetch_container_co (_data_);
}


static RygelWritableContainer* rygel_object_creator_fetch_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelObjectCreatorFetchContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Get the container to create the item in.
     *
     * This will either try to fetch the container supplied by the caller or
     * search for a container if the caller supplied the "DLNA.ORG_AnyContainer"
     * id.
     *
     * @return an instance of WritableContainer matching the criteria
     * @throws ContentDirectoryError for various problems
     */
static void rygel_object_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorFetchContainerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_object_creator_fetch_container_co (_data_);
}


static gboolean rygel_object_creator_fetch_container_co (RygelObjectCreatorFetchContainerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->media_object = NULL;
	_data_->_tmp0_ = _data_->self->priv->container_id;
	if (g_strcmp0 (_data_->_tmp0_, RYGEL_MEDIA_CONTAINER_ANY) == 0) {
		_data_->_state_ = 1;
		rygel_object_creator_find_any_container (_data_->self, rygel_object_creator_fetch_container_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = rygel_object_creator_find_any_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = _data_->_tmp1_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->media_object);
		_data_->media_object = _data_->_tmp2_;
	} else {
		_data_->_tmp3_ = _data_->self->priv->content_dir;
		_data_->_tmp4_ = _data_->_tmp3_->root_container;
		_data_->_tmp5_ = _data_->self->priv->container_id;
		_data_->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 2;
		rygel_media_object_find_object ((RygelMediaObject*) _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_, rygel_object_creator_fetch_container_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = rygel_media_object_find_object_finish ((RygelMediaObject*) _data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = _data_->_tmp8_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->media_object);
		_data_->media_object = _data_->_tmp9_;
	}
	_data_->_tmp11_ = _data_->media_object;
	if (_data_->_tmp11_ == NULL) {
		_data_->_tmp10_ = TRUE;
	} else {
		_data_->_tmp12_ = _data_->media_object;
		_data_->_tmp10_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_MEDIA_CONTAINER);
	}
	_data_->_tmp13_ = _data_->_tmp10_;
	if (_data_->_tmp13_) {
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _ ("No such object");
		_data_->_tmp15_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp14_);
		_data_->_inner_error_ = _data_->_tmp15_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media_object);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp17_ = _data_->media_object;
		_data_->_tmp18_ = _data_->_tmp17_->ocm_flags;
		if (!((_data_->_tmp18_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD)) {
			_data_->_tmp16_ = TRUE;
		} else {
			_data_->_tmp19_ = _data_->media_object;
			_data_->_tmp16_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp19_, RYGEL_TYPE_WRITABLE_CONTAINER);
		}
		_data_->_tmp20_ = _data_->_tmp16_;
		if (_data_->_tmp20_) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _ ("Object creation in %s not allowed");
			_data_->_tmp22_ = _data_->media_object;
			_data_->_tmp23_ = rygel_media_object_get_id (_data_->_tmp22_);
			_data_->_tmp24_ = _data_->_tmp23_;
			_data_->_tmp25_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp21_, _data_->_tmp24_);
			_data_->_inner_error_ = _data_->_tmp25_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp26_ = _data_->media_object;
	_data_->_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp26_, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) _data_->_tmp26_) : NULL);
	_data_->result = _data_->_tmp27_;
	_g_object_unref0 (_data_->media_object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->media_object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_object_creator_conclude (RygelObjectCreator* self) {
	RygelSerializer* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* didl;
	RygelServiceAction* _tmp2_;
	RygelMediaObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	RygelServiceAction* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->serializer;
	_tmp1_ = rygel_serializer_get_string (_tmp0_);
	didl = _tmp1_;
	_tmp2_ = self->priv->action;
	_tmp3_ = self->priv->object;
	_tmp4_ = rygel_media_object_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	rygel_service_action_set (_tmp2_, "ObjectID", G_TYPE_STRING, _tmp5_, "Result", G_TYPE_STRING, didl);
	_tmp6_ = self->priv->action;
	rygel_service_action_return (_tmp6_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}


static void rygel_object_creator_handle_error (RygelObjectCreator* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		RygelServiceAction* _tmp1_;
		GError* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->action;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->code;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		rygel_service_action_return_error (_tmp1_, _tmp3_, _tmp5_);
	} else {
		RygelServiceAction* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = self->priv->action;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		rygel_service_action_return_error (_tmp6_, 701, _tmp8_);
	}
	_tmp9_ = _ ("Failed to create item under '%s': %s");
	_tmp10_ = self->priv->container_id;
	_tmp11_ = _error_;
	_tmp12_ = _tmp11_->message;
	g_warning (_tmp9_, _tmp10_, _tmp12_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


static gchar* rygel_object_creator_get_generic_mime_type (RygelObjectCreator* self) {
	gchar* result = NULL;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp2_;
	RygelMediaItem* _tmp3_;
	RygelMediaItem* item;
	RygelMediaItem* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->object;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp2_) : NULL);
	item = _tmp3_;
	_tmp4_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_IMAGE_ITEM)) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("image");
		result = _tmp5_;
		_g_object_unref0 (item);
		return result;
	} else {
		RygelMediaItem* _tmp6_;
		_tmp6_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_VIDEO_ITEM)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("video");
			result = _tmp7_;
			_g_object_unref0 (item);
			return result;
		} else {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("audio");
			result = _tmp8_;
			_g_object_unref0 (item);
			return result;
		}
	}
	_g_object_unref0 (item);
}


static void rygel_object_creator_create_object_from_didl_data_free (gpointer _data) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorCreateObjectFromDidlData, _data_);
}


static void rygel_object_creator_create_object_from_didl (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	RygelObjectCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	_data_ = g_slice_new0 (RygelObjectCreatorCreateObjectFromDidlData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_create_object_from_didl);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_create_object_from_didl_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	rygel_object_creator_create_object_from_didl_co (_data_);
}


static void rygel_object_creator_create_object_from_didl_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Transfer information passed by caller to a MediaObject.
     *
     * WritableContainer works on MediaObject so we transfer the supplied data
     * to one. Additionally some checks are performed (e.g. whether the DLNA
     * profile is supported or not) or sanitize the supplied title for use as
     * part of the on-disk filename.
     *
     * This function fills ObjectCreator.object.
     */
static void rygel_object_creator_create_object_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_object_creator_create_object_from_didl_co (_data_);
}


static gboolean rygel_object_creator_create_object_from_didl_co (RygelObjectCreatorCreateObjectFromDidlData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->didl_object;
	_data_->_tmp1_ = gupnp_didl_lite_object_get_id (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->container;
	_data_->_tmp4_ = _data_->self->priv->didl_object;
	_data_->_tmp5_ = gupnp_didl_lite_object_get_title (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->self->priv->didl_object;
	_data_->_tmp8_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = rygel_object_creator_create_object (_data_->self, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp6_, _data_->_tmp9_, &_data_->_inner_error_);
	_data_->_tmp11_ = _data_->_tmp10_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->object);
	_data_->self->priv->object = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->self->priv->object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_MEDIA_ITEM)) {
		rygel_object_creator_extract_item_parameters (_data_->self, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp13_ = _data_->self->priv->object;
	_data_->_tmp14_ = _data_->_tmp13_->uris;
	_data_->_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	if (_data_->_tmp16_ == 0) {
		_data_->_tmp17_ = _data_->container;
		_data_->_tmp18_ = _data_->self->priv->object;
		_data_->_tmp19_ = rygel_media_object_get_title (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_state_ = 1;
		rygel_object_creator_create_uri (_data_->self, _data_->_tmp17_, _data_->_tmp20_, rygel_object_creator_create_object_from_didl_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = rygel_object_creator_create_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->uri = _data_->_tmp21_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp22_ = _data_->self->priv->object;
		_data_->_tmp23_ = _data_->_tmp22_->uris;
		_data_->_tmp24_ = _data_->uri;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp23_, _data_->_tmp24_);
		_data_->_tmp25_ = _data_->self->priv->object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp25_, RYGEL_TYPE_MEDIA_ITEM)) {
			_data_->_tmp26_ = _data_->self->priv->object;
			(G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp26_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp26_) : NULL)->place_holder = TRUE;
		}
		_g_free0 (_data_->uri);
	} else {
		_data_->_tmp27_ = _data_->self->priv->object;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp27_, RYGEL_TYPE_MEDIA_ITEM)) {
			_data_->_tmp28_ = _data_->self->priv->object;
			_data_->_tmp29_ = _data_->_tmp28_->uris;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp29_, 0);
			_data_->_tmp31_ = (gchar*) _data_->_tmp30_;
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = g_file_new_for_uri (_data_->_tmp31_);
			_data_->_tmp33_ = _data_->_tmp32_;
			_g_free0 (_data_->_tmp31_);
			_data_->file = _data_->_tmp33_;
			_data_->_tmp34_ = _data_->self->priv->object;
			_data_->_tmp35_ = _data_->file;
			_data_->_tmp36_ = FALSE;
			_data_->_tmp36_ = g_file_is_native (_data_->_tmp35_);
			(G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp34_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp34_) : NULL)->place_holder = !_data_->_tmp36_;
			_g_object_unref0 (_data_->file);
		}
	}
	_data_->_tmp37_ = _data_->self->priv->object;
	_data_->_tmp38_ = _data_->self->priv->object;
	_data_->_tmp39_ = _data_->_tmp38_->uris;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp39_, 0);
	_data_->_tmp41_ = (gchar*) _data_->_tmp40_;
	rygel_media_object_set_id (_data_->_tmp37_, _data_->_tmp41_);
	_g_free0 (_data_->_tmp41_);
	rygel_object_creator_parse_and_verify_didl_date (_data_->self, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void rygel_object_creator_extract_item_parameters (RygelObjectCreator* self, GError** error) {
	RygelMediaObject* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelMediaItem* item;
	GUPnPDIDLLiteObject* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* resources;
	gboolean _tmp4_ = FALSE;
	GList* _tmp5_;
	gboolean _tmp8_;
	RygelMediaItem* _tmp56_;
	const gchar* _tmp57_;
	RygelMediaItem* _tmp60_;
	glong _tmp61_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp0_) : NULL);
	item = _tmp1_;
	_tmp2_ = self->priv->didl_object;
	_tmp3_ = gupnp_didl_lite_object_get_resources (_tmp2_);
	resources = _tmp3_;
	_tmp5_ = resources;
	if (_tmp5_ != NULL) {
		GList* _tmp6_;
		guint _tmp7_ = 0U;
		_tmp6_ = resources;
		_tmp7_ = g_list_length (_tmp6_);
		_tmp4_ = _tmp7_ > ((guint) 0);
	} else {
		_tmp4_ = FALSE;
	}
	_tmp8_ = _tmp4_;
	if (_tmp8_) {
		GList* _tmp9_;
		GList* _tmp10_ = NULL;
		gconstpointer _tmp11_;
		GUPnPDIDLLiteResource* _tmp12_;
		GUPnPDIDLLiteResource* resource;
		GUPnPDIDLLiteResource* _tmp13_;
		GUPnPProtocolInfo* _tmp14_;
		GUPnPProtocolInfo* _tmp15_;
		GUPnPProtocolInfo* _tmp16_;
		GUPnPProtocolInfo* info;
		GUPnPProtocolInfo* _tmp17_;
		gchar* sanitized_uri;
		GUPnPDIDLLiteResource* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		gboolean _tmp46_ = FALSE;
		GUPnPDIDLLiteResource* _tmp49_;
		glong _tmp50_;
		glong _tmp51_;
		_tmp9_ = resources;
		_tmp10_ = g_list_nth (_tmp9_, (guint) 0);
		_tmp11_ = _tmp10_->data;
		_tmp12_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) _tmp11_);
		resource = _tmp12_;
		_tmp13_ = resource;
		_tmp14_ = gupnp_didl_lite_resource_get_protocol_info (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		info = _tmp16_;
		_tmp17_ = info;
		if (_tmp17_ != NULL) {
			GUPnPProtocolInfo* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			GUPnPProtocolInfo* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp18_ = info;
			_tmp19_ = gupnp_protocol_info_get_dlna_profile (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ != NULL) {
				GUPnPProtocolInfo* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gboolean _tmp24_ = FALSE;
				RygelMediaItem* _tmp29_;
				GUPnPProtocolInfo* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp21_ = info;
				_tmp22_ = gupnp_protocol_info_get_dlna_profile (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = rygel_object_creator_is_profile_valid (self, _tmp23_);
				if (!_tmp24_) {
					GUPnPProtocolInfo* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					GError* _tmp28_;
					_tmp25_ = info;
					_tmp26_ = gupnp_protocol_info_get_dlna_profile (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' DLNA profile unsupported", _tmp27_);
					_inner_error_ = _tmp28_;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (info);
					_g_object_unref0 (resource);
					__g_list_free__g_object_unref0_0 (resources);
					_g_object_unref0 (item);
					return;
				}
				_tmp29_ = item;
				_tmp30_ = info;
				_tmp31_ = gupnp_protocol_info_get_dlna_profile (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strdup (_tmp32_);
				_g_free0 (_tmp29_->dlna_profile);
				_tmp29_->dlna_profile = _tmp33_;
			}
			_tmp34_ = info;
			_tmp35_ = gupnp_protocol_info_get_mime_type (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ != NULL) {
				RygelMediaItem* _tmp37_;
				GUPnPProtocolInfo* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp37_ = item;
				_tmp38_ = info;
				_tmp39_ = gupnp_protocol_info_get_mime_type (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strdup (_tmp40_);
				_g_free0 (_tmp37_->mime_type);
				_tmp37_->mime_type = _tmp41_;
			}
		}
		sanitized_uri = NULL;
		_tmp42_ = resource;
		_tmp43_ = gupnp_didl_lite_resource_get_uri (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp46_ = rygel_object_creator_is_valid_uri (self, _tmp44_, &_tmp45_);
		_g_free0 (sanitized_uri);
		sanitized_uri = _tmp45_;
		if (_tmp46_) {
			RygelMediaItem* _tmp47_;
			const gchar* _tmp48_;
			_tmp47_ = item;
			_tmp48_ = sanitized_uri;
			rygel_media_object_add_uri ((RygelMediaObject*) _tmp47_, _tmp48_);
		}
		_tmp49_ = resource;
		_tmp50_ = gupnp_didl_lite_resource_get_size (_tmp49_);
		_tmp51_ = _tmp50_;
		if (_tmp51_ >= ((glong) 0)) {
			RygelMediaItem* _tmp52_;
			GUPnPDIDLLiteResource* _tmp53_;
			glong _tmp54_;
			glong _tmp55_;
			_tmp52_ = item;
			_tmp53_ = resource;
			_tmp54_ = gupnp_didl_lite_resource_get_size (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp52_->size = _tmp55_;
		}
		_g_free0 (sanitized_uri);
		_g_object_unref0 (info);
		_g_object_unref0 (resource);
	}
	_tmp56_ = item;
	_tmp57_ = _tmp56_->mime_type;
	if (_tmp57_ == NULL) {
		RygelMediaItem* _tmp58_;
		gchar* _tmp59_ = NULL;
		_tmp58_ = item;
		_tmp59_ = rygel_object_creator_get_generic_mime_type (self);
		_g_free0 (_tmp58_->mime_type);
		_tmp58_->mime_type = _tmp59_;
	}
	_tmp60_ = item;
	_tmp61_ = _tmp60_->size;
	if (_tmp61_ < ((glong) 0)) {
		RygelMediaItem* _tmp62_;
		_tmp62_ = item;
		_tmp62_->size = (glong) 0;
	}
	__g_list_free__g_object_unref0_0 (resources);
	_g_object_unref0 (item);
}


static void _vala_SoupDate_free (SoupDate* self) {
	g_boxed_free (soup_date_get_type (), self);
}


static void rygel_object_creator_parse_and_verify_didl_date (RygelObjectCreator* self, GError** error) {
	GUPnPDIDLLiteObject* _tmp0_;
	GUPnPDIDLLiteObject* _tmp1_;
	GUPnPDIDLLiteItem* _tmp2_;
	GUPnPDIDLLiteItem* didl_item;
	GUPnPDIDLLiteItem* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPDIDLLiteItem* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	SoupDate* _tmp9_;
	SoupDate* parsed_date;
	SoupDate* _tmp10_;
	gint year;
	gint month;
	gint day;
	GUPnPDIDLLiteItem* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_ = 0;
	GDate date = {0};
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gboolean _tmp25_ = FALSE;
	RygelMediaObject* _tmp30_;
	GUPnPDIDLLiteItem* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->didl_object;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_item_get_type ())) {
		return;
	}
	_tmp1_ = self->priv->didl_object;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp1_) : NULL);
	didl_item = _tmp2_;
	_tmp3_ = didl_item;
	_tmp4_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (didl_item);
		return;
	}
	_tmp6_ = didl_item;
	_tmp7_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = soup_date_new_from_string (_tmp8_);
	parsed_date = _tmp9_;
	_tmp10_ = parsed_date;
	if (_tmp10_ != NULL) {
		RygelMediaObject* _tmp11_;
		SoupDate* _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp11_ = self->priv->object;
		_tmp12_ = parsed_date;
		_tmp13_ = soup_date_to_string (_tmp12_, SOUP_DATE_ISO8601);
		_g_free0 ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp11_) : NULL)->date);
		(G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp11_) : NULL)->date = _tmp13_;
		__vala_SoupDate_free0 (parsed_date);
		_g_object_unref0 (didl_item);
		return;
	}
	year = 0;
	month = 0;
	day = 0;
	_tmp14_ = didl_item;
	_tmp15_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = sscanf (_tmp16_, "%4d-%02d-%02d", &year, &month, &day);
	if (_tmp17_ != 3) {
		GUPnPDIDLLiteItem* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		GError* _tmp21_;
		_tmp18_ = didl_item;
		_tmp19_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid date format: %s", _tmp20_);
		_inner_error_ = _tmp21_;
		g_propagate_error (error, _inner_error_);
		__vala_SoupDate_free0 (parsed_date);
		_g_object_unref0 (didl_item);
		return;
	}
	memset (&date, 0, sizeof (GDate));
	_tmp22_ = day;
	_tmp23_ = month;
	_tmp24_ = year;
	g_date_set_dmy (&date, (GDateDay) _tmp22_, (gint) ((GDateMonth) _tmp23_), (GDateYear) _tmp24_);
	_tmp25_ = g_date_valid (&date);
	if (!_tmp25_) {
		GUPnPDIDLLiteItem* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		GError* _tmp29_;
		_tmp26_ = didl_item;
		_tmp27_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid date: %s", _tmp28_);
		_inner_error_ = _tmp29_;
		g_propagate_error (error, _inner_error_);
		__vala_SoupDate_free0 (parsed_date);
		_g_object_unref0 (didl_item);
		return;
	}
	_tmp30_ = self->priv->object;
	_tmp31_ = didl_item;
	_tmp32_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, "T00:00:00", NULL);
	_g_free0 ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp30_) : NULL)->date);
	(G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp30_) : NULL)->date = _tmp34_;
	__vala_SoupDate_free0 (parsed_date);
	_g_object_unref0 (didl_item);
}


static RygelMediaObject* rygel_object_creator_create_object (RygelObjectCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaObject* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = upnp_class;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				RygelWritableContainer* _tmp5_;
				const gchar* _tmp6_;
				RygelImageItem* _tmp7_;
				_tmp4_ = id;
				_tmp5_ = parent;
				_tmp6_ = title;
				_tmp7_ = rygel_image_item_new (_tmp4_, (RygelMediaContainer*) _tmp5_, _tmp6_);
				result = (RygelMediaObject*) _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp8_;
				RygelWritableContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelPhotoItem* _tmp11_;
				_tmp8_ = id;
				_tmp9_ = parent;
				_tmp10_ = title;
				_tmp11_ = rygel_photo_item_new (_tmp8_, (RygelMediaContainer*) _tmp9_, _tmp10_);
				result = (RygelMediaObject*) _tmp11_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp12_;
				RygelWritableContainer* _tmp13_;
				const gchar* _tmp14_;
				RygelVideoItem* _tmp15_;
				_tmp12_ = id;
				_tmp13_ = parent;
				_tmp14_ = title;
				_tmp15_ = rygel_video_item_new (_tmp12_, (RygelMediaContainer*) _tmp13_, _tmp14_);
				result = (RygelMediaObject*) _tmp15_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp16_;
				RygelWritableContainer* _tmp17_;
				const gchar* _tmp18_;
				RygelAudioItem* _tmp19_;
				_tmp16_ = id;
				_tmp17_ = parent;
				_tmp18_ = title;
				_tmp19_ = rygel_audio_item_new (_tmp16_, (RygelMediaContainer*) _tmp17_, _tmp18_);
				result = (RygelMediaObject*) _tmp19_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp20_;
				RygelWritableContainer* _tmp21_;
				const gchar* _tmp22_;
				RygelMusicItem* _tmp23_;
				_tmp20_ = id;
				_tmp21_ = parent;
				_tmp22_ = title;
				_tmp23_ = rygel_music_item_new (_tmp20_, (RygelMediaContainer*) _tmp21_, _tmp22_);
				result = (RygelMediaObject*) _tmp23_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PLAYLIST_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				const gchar* _tmp24_;
				RygelWritableContainer* _tmp25_;
				const gchar* _tmp26_;
				RygelPlaylistItem* _tmp27_;
				_tmp24_ = id;
				_tmp25_ = parent;
				_tmp26_ = title;
				_tmp27_ = rygel_playlist_item_new (_tmp24_, (RygelMediaContainer*) _tmp25_, _tmp26_);
				result = (RygelMediaObject*) _tmp27_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER)) {
		switch (0) {
			default:
			{
				const gchar* _tmp28_;
				RygelWritableContainer* _tmp29_;
				const gchar* _tmp30_;
				RygelBaseMediaContainer* _tmp31_;
				_tmp28_ = id;
				_tmp29_ = parent;
				_tmp30_ = title;
				_tmp31_ = rygel_base_media_container_new (_tmp28_, (RygelMediaContainer*) _tmp29_, _tmp30_, 0);
				result = (RygelMediaObject*) _tmp31_;
				return result;
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_PLAYLIST)) {
		switch (0) {
			default:
			{
				const gchar* _tmp32_;
				RygelWritableContainer* _tmp33_;
				const gchar* _tmp34_;
				RygelBaseMediaContainer* _tmp35_;
				RygelBaseMediaContainer* container;
				RygelBaseMediaContainer* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp32_ = id;
				_tmp33_ = parent;
				_tmp34_ = title;
				_tmp35_ = rygel_base_media_container_new (_tmp32_, (RygelMediaContainer*) _tmp33_, _tmp34_, 0);
				container = _tmp35_;
				_tmp36_ = container;
				_tmp37_ = upnp_class;
				_tmp38_ = g_strdup (_tmp37_);
				_g_free0 (((RygelMediaObject*) _tmp36_)->upnp_class);
				((RygelMediaObject*) _tmp36_)->upnp_class = _tmp38_;
				result = (RygelMediaObject*) container;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp39_;
				GError* _tmp40_;
				_tmp39_ = upnp_class;
				_tmp40_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creation of item of class '%s' " "not supported.", _tmp39_);
				_inner_error_ = _tmp40_;
				g_propagate_error (error, _inner_error_);
				return NULL;
			}
		}
	}
}


/**
     * Simple check for the validity of an URI.
     *
     * Check is done by parsing the URI with soup. Additionaly a cleaned-up
     * version of the URI is returned in sanitized_uri.
     *
     * @param uri the input URI
     * @param sanitized_uri containes a sanitized version of the URI on return
     * @returns true if the URI is valid, false otherwise.
     */
static void _vala_SoupURI_free (SoupURI* self) {
	g_boxed_free (soup_uri_get_type (), self);
}


static gboolean rygel_object_creator_is_valid_uri (RygelObjectCreator* self, const gchar* uri, gchar** sanitized_uri) {
	gchar* _vala_sanitized_uri = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	SoupURI* _tmp5_;
	SoupURI* soup_uri;
	gboolean _tmp6_ = FALSE;
	SoupURI* _tmp7_;
	gboolean _tmp10_;
	SoupURI* _tmp11_;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_g_free0 (_vala_sanitized_uri);
	_vala_sanitized_uri = NULL;
	_tmp1_ = uri;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = uri;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = FALSE;
		if (sanitized_uri) {
			*sanitized_uri = _vala_sanitized_uri;
		} else {
			_g_free0 (_vala_sanitized_uri);
		}
		return result;
	}
	_tmp4_ = uri;
	_tmp5_ = soup_uri_new (_tmp4_);
	soup_uri = _tmp5_;
	_tmp7_ = soup_uri;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		SoupURI* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = soup_uri;
		_tmp9_ = _tmp8_->scheme;
		_tmp6_ = _tmp9_ == NULL;
	}
	_tmp10_ = _tmp6_;
	if (_tmp10_) {
		result = FALSE;
		__vala_SoupURI_free0 (soup_uri);
		if (sanitized_uri) {
			*sanitized_uri = _vala_sanitized_uri;
		} else {
			_g_free0 (_vala_sanitized_uri);
		}
		return result;
	}
	_tmp11_ = soup_uri;
	_tmp12_ = soup_uri_to_string (_tmp11_, FALSE);
	_g_free0 (_vala_sanitized_uri);
	_vala_sanitized_uri = _tmp12_;
	result = TRUE;
	__vala_SoupURI_free0 (soup_uri);
	if (sanitized_uri) {
		*sanitized_uri = _vala_sanitized_uri;
	} else {
		_g_free0 (_vala_sanitized_uri);
	}
	return result;
}


/**
     * Transform the title to be usable on legacy file-systems such as FAT32.
     *
     * The function trims down the title to 205 chars (leaving room for an UUID)
     * and replaces all special characters.
     *
     * @param title of the the media item
     * @return the cleaned and shortened title
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	guchar* _tmp1_ = NULL;
	guchar* unparsed;
	gint unparsed_length1;
	gint _unparsed_size_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	guchar* _tmp3_;
	gint _tmp3__length1;
	guchar* _tmp4_;
	gint _tmp4__length1;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar _tmp6_;
	guchar* _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	_tmp0_ = g_new0 (guchar, 16);
	id = _tmp0_;
	id_length1 = 16;
	_id_size_ = id_length1;
	_tmp1_ = g_new0 (guchar, 51);
	unparsed = _tmp1_;
	unparsed_length1 = 51;
	_unparsed_size_ = unparsed_length1;
	_tmp2_ = id;
	_tmp2__length1 = id_length1;
	uuid_generate (_tmp2_);
	_tmp3_ = id;
	_tmp3__length1 = id_length1;
	_tmp4_ = unparsed;
	_tmp4__length1 = unparsed_length1;
	uuid_unparse (_tmp3_, _tmp4_);
	_tmp5_ = unparsed;
	_tmp5__length1 = unparsed_length1;
	_tmp5_[50] = (guchar) '\0';
	_tmp6_ = _tmp5_[50];
	_tmp7_ = unparsed;
	_tmp7__length1 = unparsed_length1;
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	result = _tmp8_;
	unparsed = (g_free (unparsed), NULL);
	id = (g_free (id), NULL);
	return result;
}


static gchar* rygel_object_creator_mangle_title (RygelObjectCreator* self, const gchar* title, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* mangled;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = title;
	_tmp1_ = title;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = MIN (_tmp3_, 205);
	_tmp5_ = string_substring (_tmp0_, (glong) 0, (glong) _tmp4_);
	mangled = _tmp5_;
	_tmp6_ = self->priv->title_regex;
	_tmp7_ = mangled;
	_tmp8_ = g_regex_replace_literal (_tmp6_, _tmp7_, (gssize) (-1), 0, "_", G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (mangled);
		return NULL;
	}
	_g_free0 (mangled);
	mangled = _tmp9_;
	_tmp10_ = uuid_get ();
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "-", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = mangled;
	_tmp15_ = g_strconcat (_tmp13_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = _tmp16_;
	_g_free0 (mangled);
	return result;
}


static void rygel_object_creator_create_uri_data_free (gpointer _data) {
	RygelObjectCreatorCreateUriData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_free0 (_data_->title);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorCreateUriData, _data_);
}


static void rygel_object_creator_create_uri (RygelObjectCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorCreateUriData* _data_;
	RygelObjectCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (RygelObjectCreatorCreateUriData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_create_uri);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_create_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	_tmp3_ = title;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->title);
	_data_->title = _tmp4_;
	rygel_object_creator_create_uri_co (_data_);
}


static gchar* rygel_object_creator_create_uri_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelObjectCreatorCreateUriData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Create an URI from the item's title.
     *
     * Create an unique URI from the supplied title by cleaning it from
     * unwanted characters, shortening it and adding an UUID.
     *
     * @param container to create the item in
     * @param title of the item to base the name on
     * @returns an URI for the newly created item
     */
static void rygel_object_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorCreateUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_object_creator_create_uri_co (_data_);
}


static gboolean rygel_object_creator_create_uri_co (RygelObjectCreatorCreateUriData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->container;
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	rygel_writable_container_get_writable (_data_->_tmp0_, _data_->_tmp2_, rygel_object_creator_create_uri_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rygel_writable_container_get_writable_finish (_data_->_tmp0_, _data_->_res_);
	_data_->dir = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->dir;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _ ("Object creation in %s not allowed");
		_data_->_tmp6_ = _data_->container;
		_data_->_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp5_, _data_->_tmp8_);
		_data_->_inner_error_ = _data_->_tmp9_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->title;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = rygel_object_creator_mangle_title (_data_->self, _data_->_tmp10_, &_data_->_inner_error_);
	_data_->_tmp12_ = _data_->_tmp11_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->dir;
	_data_->_tmp14_ = _data_->_tmp12_;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = g_file_get_child_for_display_name (_data_->_tmp13_, _data_->_tmp14_, &_data_->_inner_error_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_g_free0 (_data_->_tmp14_);
	_data_->file = _data_->_tmp16_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->file;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = g_file_get_uri (_data_->_tmp17_);
	_data_->result = _data_->_tmp18_;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->dir);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->dir);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_object_creator_wait_for_object_data_free (gpointer _data) {
	RygelObjectCreatorWaitForObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelObjectCreatorWaitForObjectData, _data_);
}


static void rygel_object_creator_wait_for_object (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorWaitForObjectData* _data_;
	RygelObjectCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	_data_ = g_slice_new0 (RygelObjectCreatorWaitForObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_wait_for_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_wait_for_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	rygel_object_creator_wait_for_object_co (_data_);
}


static void rygel_object_creator_wait_for_object_finish (RygelObjectCreator* self, GAsyncResult* _res_) {
	RygelObjectCreatorWaitForObjectData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Wait for the new object
     *
     * When creating an object in the back-end via WritableContainer.add_item
     * or WritableContainer.add_container there might be a delay between the
     * creation and the back-end having the newly created item available. This
     * function waits for the item to become available by hooking into the
     * container_updated signal. The maximum time to wait is 5 seconds.
     *
     * @param container to watch
     */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		RygelObjectCreator * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->container);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void rygel_object_creator_wait_for_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorWaitForObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_object_creator_wait_for_object_co (_data_);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		RygelObjectCreator * self;
		self = _data5_->_data4_->self;
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}


static void ____lambda5_ (Block5Data* _data5_, RygelMediaContainer* container) {
	Block4Data* _data4_;
	RygelObjectCreator * self;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_if_fail (container != NULL);
	rygel_object_creator_wait_for_object_co (_data4_->_async_data_);
}


static void _____lambda5__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	____lambda5_ (self, container);
}


static gboolean ____lambda6_ (Block5Data* _data5_) {
	Block4Data* _data4_;
	RygelObjectCreator * self;
	gboolean result = FALSE;
	RygelWritableContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = _data4_->container;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("rygel-object-creator.vala:672: Timeout on waiting for 'updated' signal" \
" on '%s'.", _tmp2_);
	_data5_->timeout = (guint) 0;
	rygel_object_creator_wait_for_object_co (_data4_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda6_ (self);
	return result;
}


static gboolean rygel_object_creator_wait_for_object_co (RygelObjectCreatorWaitForObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->container;
	_g_object_unref0 (_data_->_data4_->container);
	_data_->_data4_->container = _data_->_tmp0_;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->_data4_->container;
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	g_debug ("rygel-object-creator.vala:649: Waiting for new object to appear under " \
"container '%s'..", _data_->_tmp3_);
	_data_->object = NULL;
	while (TRUE) {
		_data_->_tmp4_ = _data_->object;
		if (!(_data_->_tmp4_ == NULL)) {
			break;
		}
		{
			_data_->_tmp5_ = _data_->_data4_->container;
			_data_->_tmp6_ = _data_->self->priv->object;
			_data_->_tmp7_ = rygel_media_object_get_id (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_state_ = 1;
			rygel_media_object_find_object ((RygelMediaObject*) _data_->_tmp5_, _data_->_tmp8_, _data_->_tmp10_, rygel_object_creator_wait_for_object_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = rygel_media_object_find_object_finish ((RygelMediaObject*) _data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp12_ = _data_->_tmp11_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_g_object_unref0 (_data_->object);
			_data_->object = _data_->_tmp12_;
		}
		goto __finally3;
		__catch3_g_error:
		{
			_data_->_error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp13_ = _data_->_data4_->container;
			_data_->_tmp14_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = _data_->self->priv->object;
			_data_->_tmp17_ = rygel_media_object_get_id (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			g_warning ("Error from container '%s' on trying to find newly " "added child object '%s' in it", _data_->_tmp15_, _data_->_tmp18_);
			_g_error_free0 (_data_->_error_);
		}
		__finally3:
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->object);
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp19_ = _data_->object;
		if (_data_->_tmp19_ == NULL) {
			_data_->_data5_ = g_slice_new0 (Block5Data);
			_data_->_data5_->_ref_count_ = 1;
			_data_->_data5_->_data4_ = block4_data_ref (_data_->_data4_);
			_data_->_tmp20_ = _data_->_data4_->container;
			_data_->_tmp21_ = 0UL;
			_data_->_tmp21_ = g_signal_connect_data ((RygelMediaContainer*) _data_->_tmp20_, "container-updated", (GCallback) _____lambda5__rygel_media_container_container_updated, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
			_data_->id = _data_->_tmp21_;
			_data_->_data5_->timeout = (guint) 0;
			_data_->_tmp22_ = 0U;
			_data_->_tmp22_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda6__gsource_func, block5_data_ref (_data_->_data5_), block5_data_unref);
			_data_->_data5_->timeout = _data_->_tmp22_;
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
			_data_->_tmp23_ = _data_->_data4_->container;
			_data_->_tmp24_ = _data_->id;
			g_signal_handler_disconnect ((GObject*) _data_->_tmp23_, _data_->_tmp24_);
			_data_->_tmp25_ = _data_->_data5_->timeout;
			if (_data_->_tmp25_ != ((guint) 0)) {
				_data_->_tmp26_ = _data_->_data5_->timeout;
				g_source_remove (_data_->_tmp26_);
			} else {
				block5_data_unref (_data_->_data5_);
				_data_->_data5_ = NULL;
				break;
			}
			block5_data_unref (_data_->_data5_);
			_data_->_data5_ = NULL;
		}
	}
	_data_->_tmp27_ = _data_->_data4_->container;
	_data_->_tmp28_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp27_);
	_data_->_tmp29_ = _data_->_tmp28_;
	g_debug ("rygel-object-creator.vala:691: Finished waiting for new object to appe" \
"ar under container '%s'", _data_->_tmp29_);
	_g_object_unref0 (_data_->object);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Check if the profile is supported.
     *
     * The check is performed against the MediaEngine's database explicitly excluding
     * the transcoders.
     *
     * @param profile to check
     * @returns true if the profile is supported, false otherwise.
     */
static gint _rygel_dlna_profile_compare_by_name_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = rygel_dlna_profile_compare_by_name (a, b);
	return result;
}


static gboolean rygel_object_creator_is_profile_valid (RygelObjectCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GList* profiles = NULL;
	GList* _result_ = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_;
	GList* _tmp2_ = NULL;
	const gchar* _tmp3_;
	RygelDLNAProfile* _tmp4_;
	RygelDLNAProfile* p;
	GList* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (profile != NULL, FALSE);
	_tmp0_ = rygel_media_engine_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_media_engine_get_dlna_profiles (_tmp1_);
	profiles = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = profile;
	_tmp4_ = rygel_dlna_profile_new (_tmp3_, "");
	p = _tmp4_;
	_tmp5_ = g_list_find_custom (profiles, p, _rygel_dlna_profile_compare_by_name_gcompare_func);
	_result_ = _tmp5_;
	result = _result_ != NULL;
	_rygel_dlna_profile_unref0 (p);
	return result;
}


static GCancellable* rygel_object_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelObjectCreator* self;
	GCancellable* _tmp0_;
	self = (RygelObjectCreator*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_object_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelObjectCreator* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelObjectCreator*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_object_creator_class_init (RygelObjectCreatorClass * klass) {
	GPatternSpec* _tmp0_;
	rygel_object_creator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelObjectCreatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_object_creator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_object_creator_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_object_creator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_OBJECT_CREATOR_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
	rygel_object_creator_comment_pattern = _tmp0_;
}


static void rygel_object_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_object_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_object_creator_real_run;
	iface->run_finish = rygel_object_creator_real_run_finish;
	iface->get_cancellable = rygel_object_creator_real_get_cancellable;
	iface->set_cancellable = rygel_object_creator_real_set_cancellable;
}


static void rygel_object_creator_instance_init (RygelObjectCreator * self) {
	self->priv = RYGEL_OBJECT_CREATOR_GET_PRIVATE (self);
}


static void rygel_object_creator_finalize (GObject* obj) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
	_g_free0 (self->priv->container_id);
	_g_free0 (self->priv->elements);
	_g_object_unref0 (self->priv->didl_object);
	_g_object_unref0 (self->priv->object);
	_g_object_unref0 (self->priv->content_dir);
	_g_object_unref0 (self->priv->action);
	_g_object_unref0 (self->priv->serializer);
	_g_object_unref0 (self->priv->didl_parser);
	_g_regex_unref0 (self->priv->title_regex);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_object_creator_parent_class)->finalize (obj);
}


/**
 * CreateObject action implementation.
 */
GType rygel_object_creator_get_type (void) {
	static volatile gsize rygel_object_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_object_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelObjectCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_object_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelObjectCreator), 0, (GInstanceInitFunc) rygel_object_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_object_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_object_creator_type_id;
		rygel_object_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelObjectCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_object_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_object_creator_type_id__volatile, rygel_object_creator_type_id);
	}
	return rygel_object_creator_type_id__volatile;
}


static void _vala_rygel_object_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
	switch (property_id) {
		case RYGEL_OBJECT_CREATOR_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_object_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
	switch (property_id) {
		case RYGEL_OBJECT_CREATOR_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



