/* rygel-http-request.c generated by valac, the Vala compiler
 * generated from rygel-http-request.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_REQUEST_HANDLER (rygel_http_request_handler_get_type ())
#define RYGEL_HTTP_REQUEST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST_HANDLER, RygelHTTPRequestHandler))
#define RYGEL_HTTP_REQUEST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST_HANDLER, RygelHTTPRequestHandlerClass))
#define RYGEL_IS_HTTP_REQUEST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST_HANDLER))
#define RYGEL_IS_HTTP_REQUEST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST_HANDLER))
#define RYGEL_HTTP_REQUEST_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST_HANDLER, RygelHTTPRequestHandlerClass))

typedef struct _RygelHTTPRequestHandler RygelHTTPRequestHandler;
typedef struct _RygelHTTPRequestHandlerClass RygelHTTPRequestHandlerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHttpRequestRunData RygelHttpRequestRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelHttpRequestFindItemData RygelHttpRequestFindItemData;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _RygelHttpRequestHandleItemRequestData RygelHttpRequestHandleItemRequestData;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelMediaItem* item;
	RygelThumbnail* thumbnail;
	RygelHTTPSeek* seek;
	RygelHTTPRequestHandler* handler;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPRequestPrivate {
	RygelMediaContainer* root_container;
	GHashTable* query;
	GCancellable* _cancellable;
	RygelHTTPResponse* response;
	char* item_id;
	gint thumbnail_index;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	char* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, const char* transcode_target, char** protocol);
	void (*add_resources) (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
	char* (*get_protocol) (RygelTranscodeManager* self);
	char* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelHttpRequestRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	char* header;
	gboolean _tmp0_;
	gboolean _tmp1_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp3_;
	char* _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp7_;
	GError* _tmp8_;
	GError * err;
	GError* _tmp9_;
	RygelHTTPRequestHandler* _tmp10_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};

struct _RygelHttpRequestFindItemData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	GError * err;
	gboolean _tmp2_;
	GError* _tmp3_;
	RygelMediaItem* _tmp4_;
	RygelThumbnail* _tmp5_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHttpRequestHandleItemRequestData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	RygelHTTPTimeSeek* _tmp0_;
	RygelHTTPSeek* _tmp1_;
	RygelHTTPByteSeek* _tmp2_;
	RygelHTTPSeek* _tmp3_;
	char* _tmp5_;
	char* _tmp4_;
	gboolean _tmp6_;
	RygelHTTPResponse* _tmp7_;
	RygelHTTPResponse* _tmp8_;
	GError * _error_;
	GError * _inner_error_;
};


static gpointer rygel_http_request_parent_class = NULL;
static RygelStateMachineIface* rygel_http_request_rygel_state_machine_parent_iface = NULL;

GQuark rygel_http_request_error_quark (void);
GType rygel_state_machine_get_type (void);
GType rygel_http_request_get_type (void);
GType rygel_transcode_manager_get_type (void);
GType rygel_http_server_get_type (void);
GType rygel_media_object_get_type (void);
GType rygel_media_item_get_type (void);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void);
GType rygel_thumbnail_get_type (void);
GType rygel_http_seek_get_type (void);
GType rygel_http_request_handler_get_type (void);
GType rygel_media_container_get_type (void);
GType rygel_http_response_get_type (void);
#define RYGEL_HTTP_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestPrivate))
enum  {
	RYGEL_HTTP_REQUEST_DUMMY_PROPERTY,
	RYGEL_HTTP_REQUEST_CANCELLABLE
};
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
RygelHTTPRequest* rygel_http_request_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg, GHashTable* query);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg, GHashTable* query);
static void rygel_http_request_real_run_data_free (gpointer _data);
static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_request_parse_query (RygelHTTPRequest* self, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_);
static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* data);
static void rygel_http_request_find_item_data_free (gpointer _data);
static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_http_request_handle_item_request (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_request_handle_item_request_finish (RygelHTTPRequest* self, GAsyncResult* _res_);
static gboolean rygel_http_request_find_item_co (RygelHttpRequestFindItemData* data);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
static void rygel_http_request_on_response_completed (RygelHTTPRequest* self, RygelHTTPResponse* response);
static void rygel_http_request_handle_item_request_data_free (gpointer _data);
static void rygel_http_request_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_http_time_seek_needed (RygelHTTPRequest* request);
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPRequest* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPRequest* request, GError** error);
GType rygel_http_time_seek_get_type (void);
gboolean rygel_http_byte_seek_needed (RygelHTTPRequest* request);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPRequest* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPRequest* request, GError** error);
GType rygel_http_byte_seek_get_type (void);
void rygel_http_request_handler_add_response_headers (RygelHTTPRequestHandler* self, RygelHTTPRequest* request, GError** error);
static void _lambda3_ (const char* name, const char* value, RygelHTTPRequest* self);
static void __lambda3__soup_message_headers_foreach_func (const char* name, const char* value, gpointer self);
RygelHTTPResponse* rygel_http_request_handler_render_body (RygelHTTPRequestHandler* self, RygelHTTPRequest* request, GError** error);
static void _rygel_http_request_on_response_completed_rygel_state_machine_completed (RygelHTTPResponse* _sender, gpointer self);
void rygel_http_response_run (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_response_run_finish (RygelHTTPResponse* self, GAsyncResult* _res_);
static gboolean rygel_http_request_handle_item_request_co (RygelHttpRequestHandleItemRequestData* data);
GType rygel_transcoder_get_type (void);
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const char* target, GError** error);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_transcode_handler_get_type (void);
static void rygel_http_request_finalize (GObject* obj);
static void rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


#line 56 "rygel-http-request.vala"
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg, GHashTable* query) {
#line 489 "rygel-http-request.c"
	RygelHTTPRequest * self;
	GCancellable* _tmp0_;
	RygelMediaContainer* _tmp1_;
	SoupServer* _tmp2_;
	SoupMessage* _tmp3_;
	GHashTable* _tmp4_;
#line 56 "rygel-http-request.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 56 "rygel-http-request.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 56 "rygel-http-request.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 56 "rygel-http-request.vala"
	self = (RygelHTTPRequest*) g_object_new (object_type, NULL);
#line 60 "rygel-http-request.vala"
	self->http_server = http_server;
#line 61 "rygel-http-request.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp0_ = g_cancellable_new ());
#line 508 "rygel-http-request.c"
	_g_object_unref0 (_tmp0_);
#line 62 "rygel-http-request.vala"
	self->priv->root_container = (_tmp1_ = _g_object_ref0 (http_server->root_container), _g_object_unref0 (self->priv->root_container), _tmp1_);
#line 63 "rygel-http-request.vala"
	self->server = (_tmp2_ = _g_object_ref0 (server), _g_object_unref0 (self->server), _tmp2_);
#line 64 "rygel-http-request.vala"
	self->msg = (_tmp3_ = _g_object_ref0 (msg), _g_object_unref0 (self->msg), _tmp3_);
#line 65 "rygel-http-request.vala"
	self->priv->query = (_tmp4_ = _g_hash_table_ref0 (query), _g_hash_table_unref0 (self->priv->query), _tmp4_);
#line 66 "rygel-http-request.vala"
	self->priv->thumbnail_index = -1;
#line 520 "rygel-http-request.c"
	return self;
}


#line 56 "rygel-http-request.vala"
RygelHTTPRequest* rygel_http_request_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg, GHashTable* query) {
#line 56 "rygel-http-request.vala"
	return rygel_http_request_construct (RYGEL_TYPE_HTTP_REQUEST, http_server, server, msg, query);
#line 529 "rygel-http-request.c"
}


static void rygel_http_request_real_run_data_free (gpointer _data) {
	RygelHttpRequestRunData* data;
	data = _data;
	g_slice_free (RygelHttpRequestRunData, data);
}


static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPRequest * self;
	RygelHttpRequestRunData* _data_;
	self = (RygelHTTPRequest*) base;
	_data_ = g_slice_new0 (RygelHttpRequestRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_run_data_free);
	_data_->self = self;
	rygel_http_request_real_run_co (_data_);
}


static void rygel_http_request_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpRequestRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_request_real_run_co (data);
}


static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
#line 70 "rygel-http-request.vala"
			soup_server_pause_message (data->self->server, data->self->msg);
#line 574 "rygel-http-request.c"
			data->header = g_strdup (soup_message_headers_get (data->self->msg->request_headers, "getcontentFeatures.dlna.org"));
			data->_tmp2_ = NULL;
#line 76 "rygel-http-request.vala"
			if ((data->_tmp4_ = _vala_strcmp0 (data->_tmp3_ = (g_object_get (data->self->msg, "method", &data->_tmp2_, NULL), data->_tmp2_), "HEAD") != 0, _g_free0 (data->_tmp3_), data->_tmp4_)) {
#line 579 "rygel-http-request.c"
				data->_tmp5_ = NULL;
#line 76 "rygel-http-request.vala"
				data->_tmp1_ = _vala_strcmp0 (data->_tmp6_ = (g_object_get (data->self->msg, "method", &data->_tmp5_, NULL), data->_tmp5_), "GET") != 0;
#line 583 "rygel-http-request.c"
				_g_free0 (data->_tmp6_);
			} else {
#line 76 "rygel-http-request.vala"
				data->_tmp1_ = FALSE;
#line 588 "rygel-http-request.c"
			}
#line 76 "rygel-http-request.vala"
			if (data->_tmp1_) {
#line 76 "rygel-http-request.vala"
				data->_tmp0_ = TRUE;
#line 594 "rygel-http-request.c"
			} else {
#line 77 "rygel-http-request.vala"
				if (data->header != NULL) {
#line 77 "rygel-http-request.vala"
					data->_tmp7_ = _vala_strcmp0 (data->header, "1") != 0;
#line 600 "rygel-http-request.c"
				} else {
#line 77 "rygel-http-request.vala"
					data->_tmp7_ = FALSE;
#line 604 "rygel-http-request.c"
				}
#line 77 "rygel-http-request.vala"
				data->_tmp0_ = data->_tmp7_;
#line 608 "rygel-http-request.c"
			}
#line 76 "rygel-http-request.vala"
			if (data->_tmp0_) {
#line 78 "rygel-http-request.vala"
				rygel_http_request_handle_error (data->self, data->_tmp8_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, "Invalid Request"));
#line 614 "rygel-http-request.c"
				_g_error_free0 (data->_tmp8_);
				_g_free0 (data->header);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			{
#line 84 "rygel-http-request.vala"
				rygel_http_request_parse_query (data->self, &data->_inner_error_);
#line 630 "rygel-http-request.c"
				if (data->_inner_error_ != NULL) {
					goto __catch24_g_error;
					goto __finally24;
				}
			}
			goto __finally24;
			__catch24_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
#line 86 "rygel-http-request.vala"
					g_warning ("rygel-http-request.vala:86: Failed to parse query: %s", data->err->message);
#line 644 "rygel-http-request.c"
					_g_error_free0 (data->err);
				}
			}
			__finally24:
			if (data->_inner_error_ != NULL) {
				_g_free0 (data->header);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
#line 89 "rygel-http-request.vala"
			if (data->self->priv->item_id == NULL) {
#line 90 "rygel-http-request.vala"
				rygel_http_request_handle_error (data->self, data->_tmp9_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Not Found"));
#line 659 "rygel-http-request.c"
				_g_error_free0 (data->_tmp9_);
				_g_free0 (data->header);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 94 "rygel-http-request.vala"
			if (data->self->handler == NULL) {
#line 95 "rygel-http-request.vala"
				data->self->handler = (data->_tmp10_ = (RygelHTTPRequestHandler*) rygel_http_identity_handler_new (rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self)), _g_object_unref0 (data->self->handler), data->_tmp10_);
#line 676 "rygel-http-request.c"
			}
			rygel_http_request_find_item (data->self, rygel_http_request_run_ready, data);
			data->_state_ = 1;
			return FALSE;
			case 1:
#line 98 "rygel-http-request.vala"
			rygel_http_request_find_item_finish (data->self, data->_res_);
#line 684 "rygel-http-request.c"
			_g_free0 (data->header);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_http_request_find_item_data_free (gpointer _data) {
	RygelHttpRequestFindItemData* data;
	data = _data;
	g_slice_free (RygelHttpRequestFindItemData, data);
}


void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* _data_;
	_data_ = g_slice_new0 (RygelHttpRequestFindItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_find_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_find_item_data_free);
	_data_->self = self;
	rygel_http_request_find_item_co (_data_);
}


void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_) {
	RygelHttpRequestFindItemData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_request_find_item_co (data);
}


static gboolean rygel_http_request_find_item_co (RygelHttpRequestFindItemData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			{
				rygel_media_container_find_object (data->self->priv->root_container, data->self->priv->item_id, NULL, rygel_http_request_find_item_ready, data);
				data->_state_ = 2;
				return FALSE;
				case 2:
				data->_tmp0_ = rygel_media_container_find_object_finish (data->self->priv->root_container, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch25_g_error;
					goto __finally25;
				}
#line 105 "rygel-http-request.vala"
				data->media_object = (data->_tmp1_ = data->_tmp0_, _g_object_unref0 (data->media_object), data->_tmp1_);
#line 749 "rygel-http-request.c"
			}
			goto __finally25;
			__catch25_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
#line 108 "rygel-http-request.vala"
					rygel_http_request_handle_error (data->self, data->err);
#line 759 "rygel-http-request.c"
					_g_error_free0 (data->err);
					_g_object_unref0 (data->media_object);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->err);
				}
			}
			__finally25:
			if (data->_inner_error_ != NULL) {
				_g_object_unref0 (data->media_object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
#line 112 "rygel-http-request.vala"
			if (data->media_object == NULL) {
#line 112 "rygel-http-request.vala"
				data->_tmp2_ = TRUE;
#line 785 "rygel-http-request.c"
			} else {
#line 112 "rygel-http-request.vala"
				data->_tmp2_ = !RYGEL_IS_MEDIA_ITEM (data->media_object);
#line 789 "rygel-http-request.c"
			}
#line 112 "rygel-http-request.vala"
			if (data->_tmp2_) {
#line 113 "rygel-http-request.vala"
				rygel_http_request_handle_error (data->self, data->_tmp3_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "requested item '%s' not found", data->self->priv->item_id));
#line 795 "rygel-http-request.c"
				_g_error_free0 (data->_tmp3_);
				_g_object_unref0 (data->media_object);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 119 "rygel-http-request.vala"
			data->self->item = (data->_tmp4_ = _g_object_ref0 (RYGEL_MEDIA_ITEM (data->media_object)), _g_object_unref0 (data->self->item), data->_tmp4_);
#line 121 "rygel-http-request.vala"
			if (data->self->priv->thumbnail_index >= 0) {
#line 122 "rygel-http-request.vala"
				data->self->thumbnail = (data->_tmp5_ = (RygelThumbnail*) gee_abstract_list_get ((GeeAbstractList*) data->self->item->thumbnails, data->self->priv->thumbnail_index), _rygel_icon_info_unref0 (data->self->thumbnail), data->_tmp5_);
#line 814 "rygel-http-request.c"
			}
			rygel_http_request_handle_item_request (data->self, rygel_http_request_find_item_ready, data);
			data->_state_ = 3;
			return FALSE;
			case 3:
#line 125 "rygel-http-request.vala"
			rygel_http_request_handle_item_request_finish (data->self, data->_res_);
#line 822 "rygel-http-request.c"
			_g_object_unref0 (data->media_object);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 128 "rygel-http-request.vala"
static void rygel_http_request_on_response_completed (RygelHTTPRequest* self, RygelHTTPResponse* response) {
#line 128 "rygel-http-request.vala"
	g_return_if_fail (self != NULL);
#line 128 "rygel-http-request.vala"
	g_return_if_fail (response != NULL);
#line 129 "rygel-http-request.vala"
	rygel_http_request_end (self, (guint) SOUP_STATUS_NONE);
#line 846 "rygel-http-request.c"
}


static void rygel_http_request_handle_item_request_data_free (gpointer _data) {
	RygelHttpRequestHandleItemRequestData* data;
	data = _data;
	g_slice_free (RygelHttpRequestHandleItemRequestData, data);
}


static void rygel_http_request_handle_item_request (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpRequestHandleItemRequestData* _data_;
	_data_ = g_slice_new0 (RygelHttpRequestHandleItemRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_handle_item_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_handle_item_request_data_free);
	_data_->self = self;
	rygel_http_request_handle_item_request_co (_data_);
}


static void rygel_http_request_handle_item_request_finish (RygelHTTPRequest* self, GAsyncResult* _res_) {
	RygelHttpRequestHandleItemRequestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_request_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestHandleItemRequestData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_request_handle_item_request_co (data);
}


static void _lambda3_ (const char* name, const char* value, RygelHTTPRequest* self) {
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
#line 144 "rygel-http-request.vala"
	g_debug ("rygel-http-request.vala:144: %s : %s", name, value);
#line 886 "rygel-http-request.c"
}


static void __lambda3__soup_message_headers_foreach_func (const char* name, const char* value, gpointer self) {
	_lambda3_ (name, value, self);
}


#line 128 "rygel-http-request.vala"
static void _rygel_http_request_on_response_completed_rygel_state_machine_completed (RygelHTTPResponse* _sender, gpointer self) {
#line 897 "rygel-http-request.c"
	rygel_http_request_on_response_completed (self, _sender);
}


static gboolean rygel_http_request_handle_item_request_co (RygelHttpRequestHandleItemRequestData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			{
#line 134 "rygel-http-request.vala"
				if (rygel_http_time_seek_needed (data->self)) {
#line 911 "rygel-http-request.c"
					data->_tmp0_ = rygel_http_time_seek_new (data->self, &data->_inner_error_);
					if (data->_inner_error_ != NULL) {
						goto __catch26_g_error;
						goto __finally26;
					}
#line 135 "rygel-http-request.vala"
					data->self->seek = (data->_tmp1_ = (RygelHTTPSeek*) data->_tmp0_, _g_object_unref0 (data->self->seek), data->_tmp1_);
#line 919 "rygel-http-request.c"
				} else {
#line 136 "rygel-http-request.vala"
					if (rygel_http_byte_seek_needed (data->self)) {
#line 923 "rygel-http-request.c"
						data->_tmp2_ = rygel_http_byte_seek_new (data->self, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							goto __catch26_g_error;
							goto __finally26;
						}
#line 137 "rygel-http-request.vala"
						data->self->seek = (data->_tmp3_ = (RygelHTTPSeek*) data->_tmp2_, _g_object_unref0 (data->self->seek), data->_tmp3_);
#line 931 "rygel-http-request.c"
					}
				}
#line 141 "rygel-http-request.vala"
				rygel_http_request_handler_add_response_headers (data->self->handler, data->self, &data->_inner_error_);
#line 936 "rygel-http-request.c"
				if (data->_inner_error_ != NULL) {
					goto __catch26_g_error;
					goto __finally26;
				}
#line 142 "rygel-http-request.vala"
				g_debug ("rygel-http-request.vala:142: Following HTTP headers appended to response:");
#line 143 "rygel-http-request.vala"
				soup_message_headers_foreach (data->self->msg->response_headers, __lambda3__soup_message_headers_foreach_func, data->self);
#line 945 "rygel-http-request.c"
				data->_tmp4_ = NULL;
#line 147 "rygel-http-request.vala"
				if ((data->_tmp6_ = _vala_strcmp0 (data->_tmp5_ = (g_object_get (data->self->msg, "method", &data->_tmp4_, NULL), data->_tmp4_), "HEAD") == 0, _g_free0 (data->_tmp5_), data->_tmp6_)) {
#line 149 "rygel-http-request.vala"
					soup_server_unpause_message (data->self->server, data->self->msg);
#line 150 "rygel-http-request.vala"
					rygel_http_request_end (data->self, (guint) SOUP_STATUS_OK);
#line 953 "rygel-http-request.c"
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
				data->_tmp7_ = rygel_http_request_handler_render_body (data->self->handler, data->self, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch26_g_error;
					goto __finally26;
				}
#line 154 "rygel-http-request.vala"
				data->self->priv->response = (data->_tmp8_ = data->_tmp7_, _g_object_unref0 (data->self->priv->response), data->_tmp8_);
#line 155 "rygel-http-request.vala"
				g_signal_connect_object ((RygelStateMachine*) data->self->priv->response, "completed", (GCallback) _rygel_http_request_on_response_completed_rygel_state_machine_completed, data->self, 0);
#line 973 "rygel-http-request.c"
				rygel_http_response_run (data->self->priv->response, rygel_http_request_handle_item_request_ready, data);
				data->_state_ = 4;
				return FALSE;
				case 4:
#line 156 "rygel-http-request.vala"
				rygel_http_response_run_finish (data->self->priv->response, data->_res_);
#line 980 "rygel-http-request.c"
			}
			goto __finally26;
			__catch26_g_error:
			{
				data->_error_ = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
#line 158 "rygel-http-request.vala"
					rygel_http_request_handle_error (data->self, data->_error_);
#line 990 "rygel-http-request.c"
					_g_error_free0 (data->_error_);
				}
			}
			__finally26:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 162 "rygel-http-request.vala"
static void rygel_http_request_parse_query (RygelHTTPRequest* self, GError** error) {
#line 1016 "rygel-http-request.c"
	GError * _inner_error_;
	char* _tmp0_;
	char* target;
	char* index;
#line 162 "rygel-http-request.vala"
	g_return_if_fail (self != NULL);
#line 1023 "rygel-http-request.c"
	_inner_error_ = NULL;
#line 163 "rygel-http-request.vala"
	if (self->priv->query == NULL) {
#line 164 "rygel-http-request.vala"
		return;
#line 1029 "rygel-http-request.c"
	}
#line 167 "rygel-http-request.vala"
	self->priv->item_id = (_tmp0_ = g_strdup ((const char*) g_hash_table_lookup (self->priv->query, "itemid")), _g_free0 (self->priv->item_id), _tmp0_);
#line 168 "rygel-http-request.vala"
	target = g_strdup ((const char*) g_hash_table_lookup (self->priv->query, "transcode"));
#line 169 "rygel-http-request.vala"
	if (target != NULL) {
#line 1037 "rygel-http-request.c"
		RygelTranscoder* transcoder;
		RygelHTTPRequestHandler* _tmp1_;
#line 170 "rygel-http-request.vala"
		g_debug ("rygel-http-request.vala:170: Transcoding target: %s", target);
#line 172 "rygel-http-request.vala"
		transcoder = rygel_transcode_manager_get_transcoder ((RygelTranscodeManager*) self->http_server, target, &_inner_error_);
#line 1044 "rygel-http-request.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (target);
			return;
		}
#line 173 "rygel-http-request.vala"
		self->handler = (_tmp1_ = (RygelHTTPRequestHandler*) rygel_http_transcode_handler_new (transcoder, rygel_state_machine_get_cancellable ((RygelStateMachine*) self)), _g_object_unref0 (self->handler), _tmp1_);
#line 1052 "rygel-http-request.c"
		_g_object_unref0 (transcoder);
	}
#line 177 "rygel-http-request.vala"
	index = g_strdup ((const char*) g_hash_table_lookup (self->priv->query, "thumbnail"));
#line 178 "rygel-http-request.vala"
	if (index != NULL) {
#line 179 "rygel-http-request.vala"
		self->priv->thumbnail_index = atoi (index);
#line 1061 "rygel-http-request.c"
	}
	_g_free0 (target);
	_g_free0 (index);
}


#line 183 "rygel-http-request.vala"
static void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_) {
#line 1070 "rygel-http-request.c"
	guint status = 0U;
#line 183 "rygel-http-request.vala"
	g_return_if_fail (self != NULL);
#line 184 "rygel-http-request.vala"
	g_warning ("rygel-http-request.vala:184: %s", _error_->message);
#line 187 "rygel-http-request.vala"
	if (_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 188 "rygel-http-request.vala"
		status = (guint) _error_->code;
#line 1080 "rygel-http-request.c"
	} else {
#line 190 "rygel-http-request.vala"
		status = (guint) SOUP_STATUS_NOT_FOUND;
#line 1084 "rygel-http-request.c"
	}
#line 193 "rygel-http-request.vala"
	soup_server_unpause_message (self->server, self->msg);
#line 194 "rygel-http-request.vala"
	rygel_http_request_end (self, status);
#line 1090 "rygel-http-request.c"
}


#line 197 "rygel-http-request.vala"
void rygel_http_request_end (RygelHTTPRequest* self, guint status) {
#line 197 "rygel-http-request.vala"
	g_return_if_fail (self != NULL);
#line 198 "rygel-http-request.vala"
	if (status != SOUP_STATUS_NONE) {
#line 199 "rygel-http-request.vala"
		soup_message_set_status (self->msg, status);
#line 1102 "rygel-http-request.c"
	}
#line 202 "rygel-http-request.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1106 "rygel-http-request.c"
}


static GCancellable* rygel_http_request_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPRequest* self;
	self = (RygelHTTPRequest*) base;
	result = self->priv->_cancellable;
#line 44 "rygel-http-request.vala"
	return result;
#line 1117 "rygel-http-request.c"
}


static void rygel_http_request_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPRequest* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPRequest*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_request_class_init (RygelHTTPRequestClass * klass) {
	rygel_http_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPRequestPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_http_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_request_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_REQUEST_CANCELLABLE, "cancellable");
}


static void rygel_http_request_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_request_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_http_request_real_run;
	iface->run_finish = rygel_http_request_real_run_finish;
	iface->get_cancellable = rygel_http_request_real_get_cancellable;
	iface->set_cancellable = rygel_http_request_real_set_cancellable;
}


static void rygel_http_request_instance_init (RygelHTTPRequest * self) {
	self->priv = RYGEL_HTTP_REQUEST_GET_PRIVATE (self);
}


static void rygel_http_request_finalize (GObject* obj) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (obj);
	_g_object_unref0 (self->priv->root_container);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->msg);
	_g_hash_table_unref0 (self->priv->query);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->response);
	_g_free0 (self->priv->item_id);
	_g_object_unref0 (self->item);
	_rygel_icon_info_unref0 (self->thumbnail);
	_g_object_unref0 (self->seek);
	_g_object_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_request_parent_class)->finalize (obj);
}


GType rygel_http_request_get_type (void) {
	static GType rygel_http_request_type_id = 0;
	if (rygel_http_request_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPRequest), 0, (GInstanceInitFunc) rygel_http_request_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_request_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		rygel_http_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPRequest", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_request_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	}
	return rygel_http_request_type_id;
}


static void rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (object);
	switch (property_id) {
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (object);
	switch (property_id) {
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




