/* rygel-media-db-container.c generated by valac, the Vala compiler
 * generated from rygel-media-db-container.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_DB_CONTAINER (rygel_media_db_container_get_type ())
#define RYGEL_MEDIA_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainer))
#define RYGEL_MEDIA_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainerClass))
#define RYGEL_IS_MEDIA_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER))
#define RYGEL_IS_MEDIA_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB_CONTAINER))
#define RYGEL_MEDIA_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainerClass))

typedef struct _RygelMediaDBContainer RygelMediaDBContainer;
typedef struct _RygelMediaDBContainerClass RygelMediaDBContainerClass;
typedef struct _RygelMediaDBContainerPrivate RygelMediaDBContainerPrivate;

#define RYGEL_TYPE_MEDIA_DB (rygel_media_db_get_type ())
#define RYGEL_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDB))
#define RYGEL_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))
#define RYGEL_IS_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_IS_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_MEDIA_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))

typedef struct _RygelMediaDB RygelMediaDB;
typedef struct _RygelMediaDBClass RygelMediaDBClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaDbContainerGetChildrenData RygelMediaDbContainerGetChildrenData;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint child_count;
	guint32 update_id;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*search) (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaDBContainerPrivate * priv;
	RygelMediaDB* media_db;
};

struct _RygelMediaDBContainerClass {
	RygelMediaContainerClass parent_class;
};

typedef enum  {
	RYGEL_DATABASE_ERROR_SQLITE_ERROR
} RygelDatabaseError;
#define RYGEL_DATABASE_ERROR rygel_database_error_quark ()
struct _RygelMediaDbContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaDBContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	GeeList* result;
	GeeArrayList* children;
	GeeIterator* _child_it;
	RygelMediaObject* child;
	GError * _inner_error_;
};


static gpointer rygel_media_db_container_parent_class = NULL;

GType rygel_media_object_get_type (void);
GType rygel_media_container_get_type (void);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void);
GType rygel_media_db_container_get_type (void);
GType rygel_media_db_get_type (void);
enum  {
	RYGEL_MEDIA_DB_CONTAINER_DUMMY_PROPERTY
};
GQuark rygel_database_error_quark (void);
gint rygel_media_db_get_child_count (RygelMediaDB* self, const char* container_id, GError** error);
RygelMediaContainer* rygel_media_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, guint child_count);
static void rygel_media_db_container_on_db_container_updated (RygelMediaDBContainer* self, RygelMediaContainer* container, RygelMediaContainer* container_updated);
static void _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
RygelMediaDBContainer* rygel_media_db_container_new (RygelMediaDB* media_db, const char* id, const char* title);
RygelMediaDBContainer* rygel_media_db_container_construct (GType object_type, RygelMediaDB* media_db, const char* id, const char* title);
static void rygel_media_db_container_real_get_children_data_free (gpointer _data);
static void rygel_media_db_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_db_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeArrayList* rygel_media_db_get_children (RygelMediaDB* self, const char* container_id, glong offset, glong max_count, GError** error);
static gboolean rygel_media_db_container_real_get_children_co (RygelMediaDbContainerGetChildrenData* data);
static void rygel_media_db_container_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 41 "rygel-media-db-container.vala"
static void _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 189 "rygel-media-db-container.c"
	rygel_media_db_container_on_db_container_updated (self, _sender, container);
}


#line 26 "rygel-media-db-container.vala"
RygelMediaDBContainer* rygel_media_db_container_construct (GType object_type, RygelMediaDB* media_db, const char* id, const char* title) {
#line 196 "rygel-media-db-container.c"
	GError * _inner_error_;
	RygelMediaDBContainer * self;
	gint count = 0;
	RygelMediaDB* _tmp1_;
#line 26 "rygel-media-db-container.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 26 "rygel-media-db-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 26 "rygel-media-db-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 207 "rygel-media-db-container.c"
	_inner_error_ = NULL;
	{
		gint _tmp0_;
#line 29 "rygel-media-db-container.vala"
		_tmp0_ = rygel_media_db_get_child_count (media_db, id, &_inner_error_);
#line 213 "rygel-media-db-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch54_rygel_database_error;
			}
			goto __finally54;
		}
#line 29 "rygel-media-db-container.vala"
		count = _tmp0_;
#line 222 "rygel-media-db-container.c"
	}
	goto __finally54;
	__catch54_rygel_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 31 "rygel-media-db-container.vala"
			g_debug ("rygel-media-db-container.vala:31: Could not get child count from database: %s", e->message);
#line 33 "rygel-media-db-container.vala"
			count = 0;
#line 235 "rygel-media-db-container.c"
			_g_error_free0 (e);
		}
	}
	__finally54:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 35 "rygel-media-db-container.vala"
	self = (RygelMediaDBContainer*) rygel_media_container_construct (object_type, id, NULL, title, (guint) count);
#line 37 "rygel-media-db-container.vala"
	self->media_db = (_tmp1_ = _g_object_ref0 (media_db), _g_object_unref0 (self->media_db), _tmp1_);
#line 38 "rygel-media-db-container.vala"
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated, self, 0);
#line 251 "rygel-media-db-container.c"
	return self;
}


#line 26 "rygel-media-db-container.vala"
RygelMediaDBContainer* rygel_media_db_container_new (RygelMediaDB* media_db, const char* id, const char* title) {
#line 26 "rygel-media-db-container.vala"
	return rygel_media_db_container_construct (RYGEL_TYPE_MEDIA_DB_CONTAINER, media_db, id, title);
#line 260 "rygel-media-db-container.c"
}


#line 41 "rygel-media-db-container.vala"
static void rygel_media_db_container_on_db_container_updated (RygelMediaDBContainer* self, RygelMediaContainer* container, RygelMediaContainer* container_updated) {
#line 266 "rygel-media-db-container.c"
	GError * _inner_error_;
#line 41 "rygel-media-db-container.vala"
	g_return_if_fail (self != NULL);
#line 41 "rygel-media-db-container.vala"
	g_return_if_fail (container != NULL);
#line 41 "rygel-media-db-container.vala"
	g_return_if_fail (container_updated != NULL);
#line 274 "rygel-media-db-container.c"
	_inner_error_ = NULL;
	{
		gint _tmp0_;
#line 44 "rygel-media-db-container.vala"
		_tmp0_ = rygel_media_db_get_child_count (self->media_db, ((RygelMediaObject*) self)->id, &_inner_error_);
#line 280 "rygel-media-db-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			goto __finally55;
		}
#line 44 "rygel-media-db-container.vala"
		((RygelMediaContainer*) self)->child_count = (guint) _tmp0_;
#line 289 "rygel-media-db-container.c"
	}
	goto __finally55;
	__catch55_rygel_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 46 "rygel-media-db-container.vala"
			g_debug ("rygel-media-db-container.vala:46: Could not get child count from database: %s", e->message);
#line 48 "rygel-media-db-container.vala"
			((RygelMediaContainer*) self)->child_count = (guint) 0;
#line 302 "rygel-media-db-container.c"
			_g_error_free0 (e);
		}
	}
	__finally55:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_db_container_real_get_children_data_free (gpointer _data) {
	RygelMediaDbContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelMediaDbContainerGetChildrenData, data);
}


static void rygel_media_db_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaDBContainer * self;
	RygelMediaDbContainerGetChildrenData* _data_;
	self = (RygelMediaDBContainer*) base;
	_data_ = g_slice_new0 (RygelMediaDbContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_db_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_db_container_real_get_children_data_free);
	_data_->self = self;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_db_container_real_get_children_co (_data_);
}


static GeeList* rygel_media_db_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelMediaDbContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_db_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaDbContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_db_container_real_get_children_co (data);
}


static gboolean rygel_media_db_container_real_get_children_co (RygelMediaDbContainerGetChildrenData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->children = rygel_media_db_get_children (data->self->media_db, ((RygelMediaObject*) data->self)->id, (glong) data->offset, (glong) data->max_count, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			{
				data->_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->children);
#line 60 "rygel-media-db-container.vala"
				while (TRUE) {
#line 60 "rygel-media-db-container.vala"
					if (!gee_iterator_next (data->_child_it)) {
#line 60 "rygel-media-db-container.vala"
						break;
#line 388 "rygel-media-db-container.c"
					}
					data->child = (RygelMediaObject*) gee_iterator_get (data->_child_it);
#line 61 "rygel-media-db-container.vala"
					data->child->parent = (RygelMediaContainer*) data->self;
#line 393 "rygel-media-db-container.c"
					_g_object_unref0 (data->child);
				}
				_g_object_unref0 (data->_child_it);
			}
			data->result = (GeeList*) data->children;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->children);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_media_db_container_class_init (RygelMediaDBContainerClass * klass) {
	rygel_media_db_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_media_db_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_media_db_container_real_get_children_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_db_container_finalize;
}


static void rygel_media_db_container_instance_init (RygelMediaDBContainer * self) {
}


static void rygel_media_db_container_finalize (GObject* obj) {
	RygelMediaDBContainer * self;
	self = RYGEL_MEDIA_DB_CONTAINER (obj);
	_g_object_unref0 (self->media_db);
	G_OBJECT_CLASS (rygel_media_db_container_parent_class)->finalize (obj);
}


GType rygel_media_db_container_get_type (void) {
	static GType rygel_media_db_container_type_id = 0;
	if (rygel_media_db_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDBContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_db_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDBContainer), 0, (GInstanceInitFunc) rygel_media_db_container_instance_init, NULL };
		rygel_media_db_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelMediaDBContainer", &g_define_type_info, 0);
	}
	return rygel_media_db_container_type_id;
}




