/* rygel-video-item.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-video-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gint64 size;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	char* author;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _pixel_width;
	gint _pixel_height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	char* uri;
	char* mime_type;
	char* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY,
	RYGEL_VIDEO_ITEM_WIDTH,
	RYGEL_VIDEO_ITEM_HEIGHT,
	RYGEL_VIDEO_ITEM_PIXEL_WIDTH,
	RYGEL_VIDEO_ITEM_PIXEL_HEIGHT,
	RYGEL_VIDEO_ITEM_COLOR_DEPTH,
	RYGEL_VIDEO_ITEM_THUMBNAILS
};
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelVideoItem* rygel_video_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelAudioItem* rygel_audio_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
static gboolean rygel_video_item_real_streamable (RygelMediaItem* base);
static void rygel_video_item_real_add_uri (RygelMediaItem* base, const char* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri);
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const char* uri);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const char* uri, GError** error);
static void rygel_video_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error);
void rygel_subtitle_add_didl_node (RygelSubtitle* self, GUPnPDIDLLiteItem* didl_item);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static GUPnPDIDLLiteResource* rygel_video_item_real_add_resource (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
void rygel_visual_item_add_visual_props (RygelVisualItem* self, GUPnPDIDLLiteResource* res);
static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const char* prop1, const char* prop2);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_video_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const char* uri);
char* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_visual_item_add_thumbnail_proxy_resources (RygelVisualItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
static void rygel_video_item_finalize (GObject* obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
static void rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
static void rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 46 "rygel-video-item.vala"
RygelVideoItem* rygel_video_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 355 "rygel-video-item.c"
	RygelVideoItem * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 46 "rygel-video-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 46 "rygel-video-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 46 "rygel-video-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 46 "rygel-video-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 50 "rygel-video-item.vala"
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type, id, parent, title, upnp_class);
#line 52 "rygel-video-item.vala"
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL));
#line 371 "rygel-video-item.c"
	_g_object_unref0 (_tmp0_);
#line 53 "rygel-video-item.vala"
	self->subtitles = (_tmp1_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL), _g_object_unref0 (self->subtitles), _tmp1_);
#line 375 "rygel-video-item.c"
	return self;
}


#line 46 "rygel-video-item.vala"
RygelVideoItem* rygel_video_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 46 "rygel-video-item.vala"
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM, id, parent, title, upnp_class);
#line 384 "rygel-video-item.c"
}


#line 56 "rygel-video-item.vala"
static gboolean rygel_video_item_real_streamable (RygelMediaItem* base) {
#line 390 "rygel-video-item.c"
	RygelVideoItem * self;
	gboolean result = FALSE;
	self = (RygelVideoItem*) base;
	result = TRUE;
#line 57 "rygel-video-item.vala"
	return result;
#line 397 "rygel-video-item.c"
}


#line 60 "rygel-video-item.vala"
static void rygel_video_item_real_add_uri (RygelMediaItem* base, const char* uri) {
#line 403 "rygel-video-item.c"
	RygelVideoItem * self;
	RygelSubtitleManager* subtitle_manager;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
#line 60 "rygel-video-item.vala"
	g_return_if_fail (uri != NULL);
#line 61 "rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_uri ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), uri);
#line 63 "rygel-video-item.vala"
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, uri);
#line 65 "rygel-video-item.vala"
	subtitle_manager = rygel_subtitle_manager_get_default ();
#line 67 "rygel-video-item.vala"
	if (subtitle_manager != NULL) {
#line 418 "rygel-video-item.c"
		{
			RygelSubtitle* subtitle;
#line 69 "rygel-video-item.vala"
			subtitle = rygel_subtitle_manager_get_subtitle (subtitle_manager, uri, &_inner_error_);
#line 423 "rygel-video-item.c"
			if (_inner_error_ != NULL) {
				goto __catch43_g_error;
			}
#line 70 "rygel-video-item.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) self->subtitles, subtitle);
#line 429 "rygel-video-item.c"
			_rygel_subtitle_unref0 (subtitle);
		}
		goto __finally43;
		__catch43_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (err);
			}
		}
		__finally43:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (subtitle_manager);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (subtitle_manager);
}


#line 75 "rygel-video-item.vala"
static void rygel_video_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 456 "rygel-video-item.c"
	RygelVideoItem * self;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
#line 75 "rygel-video-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 462 "rygel-video-item.c"
	{
		GeeIterator* _subtitle_it;
#line 78 "rygel-video-item.vala"
		_subtitle_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->subtitles);
#line 78 "rygel-video-item.vala"
		while (TRUE) {
#line 469 "rygel-video-item.c"
			RygelSubtitle* subtitle;
			char* protocol;
			gboolean _tmp0_ = FALSE;
#line 78 "rygel-video-item.vala"
			if (!gee_iterator_next (_subtitle_it)) {
#line 78 "rygel-video-item.vala"
				break;
#line 477 "rygel-video-item.c"
			}
#line 78 "rygel-video-item.vala"
			subtitle = (RygelSubtitle*) gee_iterator_get (_subtitle_it);
#line 79 "rygel-video-item.vala"
			protocol = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, subtitle->uri, &_inner_error_);
#line 483 "rygel-video-item.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_subtitle_unref0 (subtitle);
				_g_object_unref0 (_subtitle_it);
				return;
			}
#line 81 "rygel-video-item.vala"
			if (allow_internal) {
#line 81 "rygel-video-item.vala"
				_tmp0_ = TRUE;
#line 494 "rygel-video-item.c"
			} else {
#line 81 "rygel-video-item.vala"
				_tmp0_ = _vala_strcmp0 (protocol, "internal") != 0;
#line 498 "rygel-video-item.c"
			}
#line 81 "rygel-video-item.vala"
			if (_tmp0_) {
#line 82 "rygel-video-item.vala"
				rygel_subtitle_add_didl_node (subtitle, didl_item);
#line 504 "rygel-video-item.c"
			}
			_g_free0 (protocol);
			_rygel_subtitle_unref0 (subtitle);
		}
		_g_object_unref0 (_subtitle_it);
	}
#line 86 "rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), didl_item, allow_internal, &_inner_error_);
#line 513 "rygel-video-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 88 "rygel-video-item.vala"
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, didl_item, allow_internal, &_inner_error_);
#line 520 "rygel-video-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 91 "rygel-video-item.vala"
static GUPnPDIDLLiteResource* rygel_video_item_real_add_resource (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error) {
#line 530 "rygel-video-item.c"
	RygelVideoItem * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
#line 91 "rygel-video-item.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 91 "rygel-video-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 97 "rygel-video-item.vala"
	res = RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_resource ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), didl_item, uri, protocol, import_uri, &_inner_error_);
#line 542 "rygel-video-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 99 "rygel-video-item.vala"
	rygel_visual_item_add_visual_props ((RygelVisualItem*) self, res);
#line 549 "rygel-video-item.c"
	result = res;
#line 101 "rygel-video-item.vala"
	return result;
#line 553 "rygel-video-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 104 "rygel-video-item.vala"
static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property) {
#line 564 "rygel-video-item.c"
	RygelVideoItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelVideoItem* item;
	const char* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	self = (RygelVideoItem*) base;
#line 104 "rygel-video-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 104 "rygel-video-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 106 "rygel-video-item.vala"
	if (!RYGEL_IS_VIDEO_ITEM (media_object)) {
#line 579 "rygel-video-item.c"
		result = 1;
#line 107 "rygel-video-item.vala"
		return result;
#line 583 "rygel-video-item.c"
	}
#line 110 "rygel-video-item.vala"
	item = _g_object_ref0 ((_tmp0_ = media_object, RYGEL_IS_VIDEO_ITEM (_tmp0_) ? ((RygelVideoItem*) _tmp0_) : NULL));
#line 587 "rygel-video-item.c"
	_tmp1_ = property;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("dc:author"))))
	switch (0) {
		default:
		{
			result = rygel_media_object_compare_string_props ((RygelMediaObject*) self, self->author, item->author);
			_g_object_unref0 (item);
#line 114 "rygel-video-item.vala"
			return result;
#line 598 "rygel-video-item.c"
		}
	} else
	switch (0) {
		default:
		{
			result = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->compare_by_property ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), (RygelMediaObject*) item, property);
			_g_object_unref0 (item);
#line 116 "rygel-video-item.vala"
			return result;
#line 608 "rygel-video-item.c"
		}
	}
	_g_object_unref0 (item);
}


#line 120 "rygel-video-item.vala"
static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
#line 617 "rygel-video-item.c"
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* didl_item;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
#line 120 "rygel-video-item.vala"
	g_return_val_if_fail (writer != NULL, NULL);
#line 120 "rygel-video-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 123 "rygel-video-item.vala"
	didl_item = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->serialize ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), writer, http_server, &_inner_error_);
#line 630 "rygel-video-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 125 "rygel-video-item.vala"
	if (self->author != NULL) {
#line 125 "rygel-video-item.vala"
		_tmp0_ = _vala_strcmp0 (self->author, "") != 0;
#line 639 "rygel-video-item.c"
	} else {
#line 125 "rygel-video-item.vala"
		_tmp0_ = FALSE;
#line 643 "rygel-video-item.c"
	}
#line 125 "rygel-video-item.vala"
	if (_tmp0_) {
#line 647 "rygel-video-item.c"
		GUPnPDIDLLiteContributor* contributor;
#line 126 "rygel-video-item.vala"
		contributor = gupnp_didl_lite_object_add_author (didl_item);
#line 127 "rygel-video-item.vala"
		gupnp_didl_lite_contributor_set_name (contributor, self->author);
#line 653 "rygel-video-item.c"
		_g_object_unref0 (contributor);
	}
	result = didl_item;
#line 130 "rygel-video-item.vala"
	return result;
#line 659 "rygel-video-item.c"
}


#line 133 "rygel-video-item.vala"
static void rygel_video_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
#line 665 "rygel-video-item.c"
	RygelVideoItem * self;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
#line 133 "rygel-video-item.vala"
	g_return_if_fail (server != NULL);
#line 133 "rygel-video-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 673 "rygel-video-item.c"
	{
		GeeIterator* _subtitle_it;
#line 137 "rygel-video-item.vala"
		_subtitle_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->subtitles);
#line 137 "rygel-video-item.vala"
		while (TRUE) {
#line 680 "rygel-video-item.c"
			RygelSubtitle* subtitle;
#line 137 "rygel-video-item.vala"
			if (!gee_iterator_next (_subtitle_it)) {
#line 137 "rygel-video-item.vala"
				break;
#line 686 "rygel-video-item.c"
			}
#line 137 "rygel-video-item.vala"
			subtitle = (RygelSubtitle*) gee_iterator_get (_subtitle_it);
#line 138 "rygel-video-item.vala"
			if (rygel_http_server_need_proxy (server, subtitle->uri)) {
#line 692 "rygel-video-item.c"
				char* uri;
				gint index;
				char* _tmp0_;
				char* _tmp1_;
#line 139 "rygel-video-item.vala"
				uri = g_strdup (subtitle->uri);
#line 140 "rygel-video-item.vala"
				index = gee_abstract_list_index_of ((GeeAbstractList*) self->subtitles, subtitle);
#line 142 "rygel-video-item.vala"
				subtitle->uri = (_tmp0_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) server, (RygelMediaItem*) self, -1, index, NULL), _g_free0 (subtitle->uri), _tmp0_);
#line 146 "rygel-video-item.vala"
				rygel_subtitle_add_didl_node (subtitle, didl_item);
#line 149 "rygel-video-item.vala"
				subtitle->uri = (_tmp1_ = g_strdup (uri), _g_free0 (subtitle->uri), _tmp1_);
#line 707 "rygel-video-item.c"
				_g_free0 (uri);
			}
			_rygel_subtitle_unref0 (subtitle);
		}
		_g_object_unref0 (_subtitle_it);
	}
#line 153 "rygel-video-item.vala"
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_proxy_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), server, didl_item, &_inner_error_);
#line 716 "rygel-video-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 156 "rygel-video-item.vala"
	rygel_visual_item_add_thumbnail_proxy_resources ((RygelVisualItem*) self, server, didl_item, &_inner_error_);
#line 723 "rygel-video-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_width;
#line 37 "rygel-video-item.vala"
	return result;
#line 738 "rygel-video-item.c"
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_width = value;
	g_object_notify ((GObject *) self, "width");
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_height;
#line 38 "rygel-video-item.vala"
	return result;
#line 757 "rygel-video-item.c"
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_height = value;
	g_object_notify ((GObject *) self, "height");
}


static gint rygel_video_item_real_get_pixel_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_pixel_width;
#line 39 "rygel-video-item.vala"
	return result;
#line 776 "rygel-video-item.c"
}


static void rygel_video_item_real_set_pixel_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_pixel_width = value;
	g_object_notify ((GObject *) self, "pixel-width");
}


static gint rygel_video_item_real_get_pixel_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_pixel_height;
#line 40 "rygel-video-item.vala"
	return result;
#line 795 "rygel-video-item.c"
}


static void rygel_video_item_real_set_pixel_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_pixel_height = value;
	g_object_notify ((GObject *) self, "pixel-height");
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_color_depth;
#line 41 "rygel-video-item.vala"
	return result;
#line 814 "rygel-video-item.c"
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_color_depth = value;
	g_object_notify ((GObject *) self, "color-depth");
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_thumbnails;
#line 43 "rygel-video-item.vala"
	return result;
#line 833 "rygel-video-item.c"
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	self = (RygelVideoItem*) base;
	self->priv->_thumbnails = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_thumbnails), _tmp0_);
	g_object_notify ((GObject *) self, "thumbnails");
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_video_item_real_streamable;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_video_item_real_add_uri;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_video_item_real_add_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_video_item_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_video_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_video_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_video_item_real_add_proxy_resources;
	G_OBJECT_CLASS (klass)->get_property = rygel_video_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_video_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_WIDTH, "width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_HEIGHT, "height");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_PIXEL_WIDTH, "pixel-width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_PIXEL_HEIGHT, "pixel-height");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_COLOR_DEPTH, "color-depth");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_THUMBNAILS, "thumbnails");
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_video_item_real_get_width;
	iface->set_width = rygel_video_item_real_set_width;
	iface->get_height = rygel_video_item_real_get_height;
	iface->set_height = rygel_video_item_real_set_height;
	iface->get_pixel_width = rygel_video_item_real_get_pixel_width;
	iface->set_pixel_width = rygel_video_item_real_set_pixel_width;
	iface->get_pixel_height = rygel_video_item_real_get_pixel_height;
	iface->set_pixel_height = rygel_video_item_real_set_pixel_height;
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_pixel_width = -1;
	self->priv->_pixel_height = -1;
	self->priv->_color_depth = -1;
}


static void rygel_video_item_finalize (GObject* obj) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (obj);
	_g_free0 (self->author);
	_g_object_unref0 (self->priv->_thumbnails);
	_g_object_unref0 (self->subtitles);
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
}


/**
 * Represents a video item.
 */
GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


static void rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (object);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_WIDTH:
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT:
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_WIDTH:
		g_value_set_int (value, rygel_visual_item_get_pixel_width ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_HEIGHT:
		g_value_set_int (value, rygel_visual_item_get_pixel_height ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (object);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_WIDTH:
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT:
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_WIDTH:
		rygel_visual_item_set_pixel_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_HEIGHT:
		rygel_visual_item_set_pixel_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




