
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                     Tool Library                      //
//                    pj_georeference                    //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                   TLB_Interface.cpp                   //
//                                                       //
//                Copyright (C) 2003-13 by               //
//              SAGA User Group Association              //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
// 1. Include the appropriate SAGA-API header...

#include <saga_api/saga_api.h>


//---------------------------------------------------------
// 2. Place general tool library informations here...

CSG_String Get_Info(int i)
{
	switch( i )
	{
	case TLB_INFO_Name:	default:
		return( _TL("Georeferencing") );

	case TLB_INFO_Category:
		return( _TL("Projection") );

	case TLB_INFO_Author:
		return( SG_T("SAGA User Group Association (c) 2003-13") );

	case TLB_INFO_Description:
		return( _TL("Tools for the georeferencing of spatial data.") );

	case TLB_INFO_Version:
		return( SG_T("1.0") );

	case TLB_INFO_Menu_Path:
		return( _TL("Projection|Georeferencing") );
	}
}


//---------------------------------------------------------
// 3. Include the headers of your tools here...

#include "Collect_Points.h"
#include "Georef_Grid.h"
#include "Georef_Shapes.h"
#include "georef_grid_move.h"
#include "direct_georeferencing.h"
#include "set_grid_georeference.h"
#include "georef_with_coordinate_grids.h"


//---------------------------------------------------------
// 4. Allow your tools to be created here...

CSG_Tool *		Create_Tool(int i)
{
	switch( i )
	{
	case  0:	return( new CCollect_Points );
	case  1:	return( new CGeoref_Grid );
	case  2:	return( new CGeoref_Shapes );
	case  3:	return( new CGeoref_Grid_Move );
	case  4:	return( new CDirect_Georeferencing );
	case  6:	return( new CDirect_Georeferencing_WorldFile );
	case  5:	return( new CSet_Grid_Georeference );
	case  7:	return( new CGeoRef_with_Coordinate_Grids );

	case 10:	return( NULL );
	default:	return( TLB_INTERFACE_SKIP_TOOL );
	}
}


///////////////////////////////////////////////////////////
//														 //
//														 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
//{{AFX_SAGA

	TLB_INTERFACE

//}}AFX_SAGA
