##   -*- autoconf -*-

dnl    This file is part of the KDE libraries/packages
dnl    Copyright (C) 1997 Janos Farkas (chexum@shadow.banki.hu)
dnl              (C) 1997,98,99 Stephan Kulow (coolo@kde.org)

dnl    This file is free software; you can redistribute it and/or
dnl    modify it under the terms of the GNU Library General Public
dnl    License as published by the Free Software Foundation; either
dnl    version 2 of the License, or (at your option) any later version.

dnl    This library is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl    Library General Public License for more details.

dnl    You should have received a copy of the GNU Library General Public License
dnl    along with this library; see the file COPYING.LIB.  If not, write to
dnl    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
dnl    Boston, MA 02110-1301, USA.

dnl IMPORTANT NOTE:
dnl Please do not modify this file unless you expect your modifications to be
dnl carried into every other module in the repository. 
dnl
dnl Single-module modifications are best placed in configure.in for kdelibs
dnl and kdebase or configure.in.in if present.

dnl ------------------------------------------------------------------------
dnl Find a file (or one of more files in a list of dirs)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN([AC_FIND_FILE],
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    echo "configure: __oline__: $i/$j" >&AC_FD_CC
    if test -r "$i/$j"; then
      echo "taking that" >&AC_FD_CC
      $3=$i
      break 2
    fi
  done
done
])


dnl KDE_FIND_PATH(program-name, variable-name, list-of-dirs,
dnl	if-not-found, test-parameter, prepend-path)
dnl
dnl Look for program-name in list-of-dirs+$PATH.
dnl If prepend-path is set, look in $PATH+list-of-dirs instead.
dnl If found, $variable-name is set. If not, if-not-found is evaluated.
dnl test-parameter: if set, the program is executed with this arg,
dnl                 and only a successful exit code is required.
AC_DEFUN([KDE_FIND_PATH],
[
   AC_MSG_CHECKING([for $1])
   if test -n "$$2"; then
        kde_cv_path="$$2";
   else
        kde_cache=`echo $1 | sed 'y%./+-%__p_%'`

        AC_CACHE_VAL(kde_cv_path_$kde_cache,
        [
        kde_cv_path="NONE"
	kde_save_IFS=$IFS
	IFS=':'
	dirs=""
	for dir in $PATH; do
	  dirs="$dirs $dir"
	done
	if test -z "$6"; then  dnl Append dirs in PATH (default)
	  dirs="$3 $dirs"
        else  dnl Prepend dirs in PATH (if 6th arg is set)
	  dirs="$dirs $3"
	fi
	IFS=$kde_save_IFS

        for dir in $dirs; do
	  if test -x "$dir/$1"; then
	    if test -n "$5"
	    then
              evalstr="$dir/$1 $5 2>&1 "
	      if eval $evalstr; then
                kde_cv_path="$dir/$1"
                break
	      fi
            else
		kde_cv_path="$dir/$1"
                break
	    fi
          fi
        done

        eval "kde_cv_path_$kde_cache=$kde_cv_path"

        ])

      eval "kde_cv_path=\"`echo '$kde_cv_path_'$kde_cache`\""

   fi

   if test -z "$kde_cv_path" || test "$kde_cv_path" = NONE; then
      AC_MSG_RESULT(not found)
      $4
   else
      AC_MSG_RESULT($kde_cv_path)
      $2=$kde_cv_path

   fi
])

# qt.m4 - Qt detection functions. -*-Autoconf-*-
dnl
dnl Copyright (C) 2005 Jeremy Lainé <jeremy.laine@m4x.org>
dnl See AUTHORS file for a full list of contributors.
dnl 
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
dnl


dnl ------------------------------------------------------------------------
dnl Determine the directory to which documentation is installed
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_CHECK_DOCDIR,
[
    AC_ARG_WITH(docdir,
        [AC_HELP_STRING([--with-docdir=DIR],
	    [where documentation is installed @<:@default=PREFIX/share/doc/$1@:>@])],
        [ac_cv_with_docdir="$withval"])
	
    AC_MSG_CHECKING([for documentation directory])
    if test x"$ac_cv_with_docdir" = x; then
        pkgdocdir="${prefix}/share/doc/$1"
    else
        pkgdocdir="$ac_cv_with_docdir"
    fi
    AC_MSG_RESULT($pkgdocdir)
    AC_SUBST(pkgdocdir)
])


dnl ------------------------------------------------------------------------
dnl Error messages
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_MOC_ERROR_MESSAGE,
[
    AC_MSG_ERROR([No Qt meta object compiler (moc) found!
Please check whether you installed Qt correctly.
You need to have a running moc binary.
configure tried to run $ac_cv_path_moc and the test didn't
succeed. If configure shouldn't have tried this one, set
the environment variable MOC to the right one before running
configure.
])
])


AC_DEFUN(JWB_UIC_ERROR_MESSAGE,
[
    AC_MSG_WARN([No Qt ui compiler (uic) found!
Please check whether you installed Qt correctly.
You need to have a running uic binary.
configure tried to run $ac_cv_path_uic and the test didn't
succeed. If configure shouldn't have tried this one, set
the environment variable UIC to the right one before running
configure.
])
])


AC_DEFUN(JWB_LRELEASE_ERROR_MESSAGE,
[
    AC_MSG_ERROR([No Qt translation tool (lrelease) found!
Please check whether you installed Qt correctly.
You need to have a running lrelease binary.
configure tried to run $ac_cv_path_lrelease and the test didn't
succeed. If configure shouldn't have tried this one, set
the environment variable LRELEASE to the right one before running
configure.
])
])


AC_DEFUN(JWB_LUPDATE_ERROR_MESSAGE,
[
    AC_MSG_ERROR([No Qt translation tool (lupdate) found!
Please check whether you installed Qt correctly.
You need to have a running lupdate binary.
configure tried to run $ac_cv_path_lupdate and the test didn't
succeed. If configure shouldn't have tried this one, set
the environment variable LUPDATE to the right one before running
configure.
])
])


dnl ------------------------------------------------------------------------
dnl Qt variables initialisation
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_QT_INIT,
[
    AC_REQUIRE([JWB_PATH_MISC])

    dnl Platform-specific initialisations
    case "$host" in 
      *-mingw32* )
        dnl Convert backslashes to forward slashes
        QTDIR=`echo $QTDIR | sed -e 's/\\\\/\\//g'`
        
	dnl Set Qt library suffix
	jwb_qt_suffix_version="4"
	jwb_qt_suffix_debug="d"
	ac_qt_debug_default=no
        ;;
      * )
	dnl Set Qt library suffix
        jwb_qt_suffix_version=""
	jwb_qt_suffix_debug="_debug"
	ac_qt_debug_default=no
        ;;
    esac

    dnl Define configure options
    AC_ARG_ENABLE(qt-debug,
        AC_HELP_STRING([--enable-qt-debug],[link to debug version of Qt ]),
        ac_qt_debug=$enableval,
	ac_qt_debug=$ac_qt_debug_default
        )

    AC_ARG_WITH(qt-dir,
        AC_HELP_STRING([--with-qt-dir=DIR],[where the root of Qt is installed ]),
        [  ac_qt_includes="$withval"/include
           ac_qt_libraries="$withval"/lib
           ac_qt_bindir="$withval"/bin
        ])

    AC_ARG_WITH(qt-includes,
        AC_HELP_STRING([--with-qt-includes=DIR],[where the Qt includes are. ]),
        [  ac_qt_includes="$withval"
        ])

    AC_ARG_WITH(qt-libraries,
        AC_HELP_STRING([--with-qt-libraries=DIR],[where the Qt library is installed.]),
        [  ac_qt_libraries="$withval"
        ])


    dnl Set Qt search directories
    jwb_qt_dirs="$QTDIR /usr/lib/qt4 /usr/lib/qt /usr/share/qt4"

    dnl Set the Qt libary suffix
    AC_MSG_CHECKING([Qt library extension])
    if test "$ac_qt_debug" = "yes"; then
        jwb_qt_suffix=$jwb_qt_suffix_debug
    else
        jwb_qt_suffix=""
    fi
    jwb_qt_suffix=$jwb_qt_suffix${jwb_qt_suffix_version}
    AC_MSG_RESULT($jwb_qt_suffix)
    
])


dnl ------------------------------------------------------------------------
dnl Find the Qt tools
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_PATH_QT_BIN,
[
    AC_REQUIRE([JWB_QT_INIT])
    qt_bindirs=""
    for dir in $jwb_qt_dirs; do
        qt_bindirs="$qt_bindirs $dir/bin"
    done
    qt_bindirs="$qt_bindirs /usr/bin /usr/X11R6/bin /usr/local/qt/bin"
    if test ! "$ac_qt_bindir" = "NO"; then
        qt_bindirs="$ac_qt_bindir $qt_bindirs"
    fi

    KDE_FIND_PATH(moc, MOC, [$qt_bindirs], [JWB_MOC_ERROR_MESSAGE])
    AC_SUBST(MOC)
    KDE_FIND_PATH(uic, UIC, [$qt_bindirs], [JWB_UIC_ERROR_MESSAGE])
    AC_SUBST(UIC)
    KDE_FIND_PATH(lrelease, LRELEASE, [$qt_bindirs], [JWB_LRELEASE_ERROR_MESSAGE])
    AC_SUBST(LRELEASE)
    KDE_FIND_PATH(lupdate, LUPDATE, [$qt_bindirs], [JWB_LUPDATE_ERROR_MESSAGE])
    AC_SUBST(LUPDATE)
])


dnl ------------------------------------------------------------------------
dnl Find the Qt includes directory
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_PATH_QT_INCLUDES,
[
    AC_MSG_CHECKING([for Qt4 headers])
    qt_incdirs=""
    for dir in $jwb_qt_dirs; do
          qt_incdirs="$qt_incdirs $dir/include $dir"
    done
    qt_incdirs="$QTINC $qt_incdirs /usr/local/qt/include /usr/include/qt /usr/include /usr/X11R6/include/X11/qt /usr/X11R6/include/qt"
    if test ! "$ac_qt_includes" = "NO"; then
         qt_incdirs="$ac_qt_includes $qt_incdirs"
    fi

    AC_FIND_FILE(QtCore/QCoreApplication, $qt_incdirs, qt_incdir)
    if test "$qt_incdir" = "NO"; then
      qt_incdir=""
      AC_MSG_RESULT([not found])
    else
      ac_qt_includes="$qt_incdir"
      AC_MSG_RESULT([$qt_incdir])
    fi

    if test -z "$qt_incdir"; then
        AC_MSG_ERROR([could not find Qt4 headers])
    fi
])


dnl ------------------------------------------------------------------------
dnl Find the Qt libraries directory
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_PATH_QT_LIBRARIES,
[
    AC_MSG_CHECKING([for Qt4 libraries])
   
    qt_libdirs=""
    for dir in $jwb_qt_dirs; do
        qt_libdirs="$qt_libdirs $dir/lib $dir"
    done
    qt_libdirs="$QTLIB $qt_libdirs /usr/X11R6/lib /usr/lib /usr/local/qt/lib"
    
    if test -n "$ac_qt_libraries"; then
        qt_libdir=$ac_qt_libraries
    else
        qt_testlib="libQtCore"$jwb_qt_suffix
        for qt_extension in la a so; do
	    qt_testfile=$qt_testlib.$qt_extension
            echo "configure: __oline__: looking for $qt_testfile" >&AC_FD_CC
            AC_FIND_FILE($qt_testfile, $qt_libdirs, qt_libdir)
            if test "$qt_libdir" = "NO"; then
	        qt_libdir=""
	    else
	    	echo "configure: __oline__: found in $qt_libdir" >&AC_FD_CC
                ac_qt_libraries="$qt_libdir"
                break 2;
	    fi
        done
    fi
    
    AC_MSG_RESULT([$qt_libdir])
    if test -z "$qt_libdir"; then
        AC_MSG_ERROR([could not find Qt4 libraries])
    fi

])


dnl ------------------------------------------------------------------------
dnl Find a Qt module
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_PATH_QT_MODULE,
[
  AC_LANG_SAVE
  AC_LANG_CPLUSPLUS
  
  ac_cppflags_safe="$CPPFLAGS"
  ac_cxxflags_safe="$CXXFLAGS"
  ac_ldflags_safe="$LDFLAGS"
  ac_libs_safe="$LIBS"

  CPPFLAGS="$CPPFLAGS -I$qt_incdir"
  LDFLAGS="$LDFLAGS -L$qt_libdir"
  
  have_module=no
  AC_CHECK_HEADERS([$1/$1], [qt_have_module=yes], [qt_have_module=no])
 
  CPPFLAGS="$ac_cppflags_safe"
  CXXFLAGS="$ac_cxxflags_safe"
  LDFLAGS="$ac_ldflags_safe"
  LIBS="$ac_libs_safe"

  ac_have_qt_$1=$qt_have_module
  if test "$qt_have_module" = "yes"; then
      QT_INCLUDES="$QT_INCLUDES -I$qt_incdir/$1"
      $2="-l$1"$jwb_qt_suffix
      $3
  else
      $2=""
      $4
  fi
])


dnl ------------------------------------------------------------------------
dnl Check whether the QtOpenGL module of Qt is available
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_HAVE_QTOPENGL,
[
  ac_have_qtopengl=no

  dnl Check OpenGL support
  AC_REQUIRE([JWB_HAVE_GL])
  if test "$ac_cv_have_gl" = "yes"; then
    JWB_PATH_QT_MODULE(QtOpenGL, LIB_QTOPENGL, [ac_have_qtopengl=yes])
  fi

  AC_MSG_CHECKING([for QtOpenGL])
  if test "$ac_have_qtopengl" = "yes"; then
    AC_MSG_RESULT([yes])
    AC_DEFINE(HAVE_QTOPENGL, 1, [Defines if you have QtOpenGL])
    $1
  else
    AC_MSG_RESULT([no])
    $2
  fi
  
  AC_SUBST(LIB_QTOPENGL)
])


dnl ------------------------------------------------------------------------
dnl Check whether the QtOpenGL module of Qt is available
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_HAVE_QTXML,
[
  JWB_PATH_QT_MODULE(QtXml,LIB_QTXML,[ac_have_qtxml=yes],[ac_have_qtxml=no])

  AC_MSG_CHECKING([for QtXml])
  if test "$ac_have_qtxml" = "yes"; then
    AC_MSG_RESULT([yes])
    AC_DEFINE(HAVE_QTXML, 1, [Defines if you have QtXml])
    $1
  else
    AC_MSG_RESULT([no])
    $2
  fi
  AC_SUBST(LIB_QTXML)
])



dnl ------------------------------------------------------------------------
dnl Find the Qt binaries, includes and libraries
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_CHECK_QT,
[
    AC_REQUIRE([JWB_QT_INIT])
    AC_REQUIRE([JWB_PATH_QT_BIN])
    
    JWB_PATH_QT_INCLUDES
    QT_INCLUDES="-I$qt_incdir -I$qt_incdir/Qt"
    
    JWB_PATH_QT_LIBRARIES
    QT_LDFLAGS="-L$qt_libdir"
  
    dnl compulsory modules
    JWB_PATH_QT_MODULE(QtCore, LIB_QTCORE, [qt_have_core=yes], [qt_have_core=no])
    JWB_PATH_QT_MODULE(QtGui, LIB_QTGUI, [qt_have_gui=yes], [qt_have_gui=no])
   
    AC_MSG_CHECKING([for Qt])
    if test "$qt_have_core" = "yes" && test "$qt_have_gui" = "yes"; then
      AC_MSG_RESULT([yes])
      AC_DEFINE(HAVE_QT, 1, [Defines if you have Qt])
      LIB_QT="$LIB_QT $LIB_QTCORE $LIB_QTGUI"
      $1
    else
      AC_MSG_RESULT([no])
      LIB_QT=""
      $2
    fi
   
    AC_SUBST(QT_INCLUDES)
    AC_SUBST(QT_LDFLAGS)
    AC_SUBST(LIB_QT)
])


dnl ------------------------------------------------------------------------
dnl Check for various libraries
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(JWB_PATH_MISC,
[
    dnl Check various libraries
    case "$host" in
      *-mingw32* )
        x_includes=""
	x_libraries=""
        ;;
      *)
        AC_PATH_X
        AC_PATH_XTRA
        ;;
    esac

    if test -z "$x_includes"; then
        X_INCLUDES=""
    else
        X_INCLUDES="-I$x_includes"
    fi
    if test -z "$x_libraries"; then
        LIB_X11=""
        X_LDFLAGS=""
    else
        LIB_X11="-lX11"
        X_LDFLAGS="-L$x_libraries"
    fi

    AC_SUBST(LIB_X11) 
    AC_SUBST(X_INCLUDES) 
    AC_SUBST(X_LDFLAGS) 
])


dnl ------------------------------------------------------------------------
dnl Check whether OpenGL is available (taken from KDE)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN([JWB_HAVE_GL],
[
    AC_REQUIRE([JWB_PATH_MISC])
    
    case "$host" in 
      *-mingw32* )
        jwb_gl_libs="-lopengl32 -lglu32"
        	
        ;;
      * )
        jwb_gl_libs="-lGL -lGLU"
        ;;
    esac

    test -z "$GL_LDFLAGS" && GL_LDFLAGS=
    test -z "$GL_INCLUDE" && GL_INCLUDE=

    AC_ARG_WITH(gl,AC_HELP_STRING([--without-gl],[disable 3D GL modes]),
                gl_test=$withval, gl_test="yes")
    if test "x$kde_use_qt_emb" = "xyes"; then
        # GL and Qt Embedded is a no-go for now.
        ac_cv_have_gl=no
    elif test "x$gl_test" = xno; then
        ac_cv_have_gl=no
    else
        AC_MSG_CHECKING(for GL)
        AC_CACHE_VAL(ac_cv_have_gl,
        [
            AC_LANG_SAVE
            AC_LANG_CPLUSPLUS
            ac_save_ldflags=$LDFLAGS
            ac_save_cxxflags=$CXXFLAGS
            ac_save_libs=$LIBS
            LDFLAGS="$LDFLAGS $GL_LDFLAGS $X_LDFLAGS $all_libraries"
            LIBS="$LIBS $jwb_gl_libs"
            test -n "$LIB_X11" && LIBS="$LIBS $LIB_X11"
            LIBS="$LIBS $LIB_XEXT -lm $LIBSOCKET"
            CXXFLAGS="$CFLAGS $X_INCLUDES"
            test -n "$GL_INCLUDE" && CFLAGS="-I$GL_INCLUDE $CFLAGS"
            AC_TRY_LINK([#include <GL/gl.h>
#include <GL/glu.h>
], [], ac_cv_have_gl="yes", ac_cv_have_gl="no")
            AC_LANG_RESTORE
            LDFLAGS=$ac_save_ldflags
            CXXFLAGS=$ac_save_cxxflags
            LIBS=$ac_save_libs
         ])dnl

        if test "$ac_cv_have_gl" = "no"; then
            AC_MSG_RESULT(no)
            GL_LDFLAGS=""
            GLINC=""
            $2
        else
            AC_DEFINE(HAVE_GL, 1, [Defines if you have GL (Mesa, OpenGL, ...)])
            if test "$GL_LDFLAGS" = ""; then
                GLLIB="$jwb_gl_libs "'$(LIB_X11)'
            else
                GLLIB="$GL_LDFLAGS $jwb_gl_libs "'$(LIB_X11)'
            fi
            if test "$GL_INCLUDE" = ""; then
                GLINC=""
            else
                GLINC="-I$GL_INCLUDE"
            fi
            AC_MSG_RESULT($ac_cv_have_gl)
            $1
        fi
    fi
    AC_SUBST(GLINC)
    AC_SUBST(GLLIB)
])


