/*
 * Copyright (C) 1993-2005 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 *
 * $Id: sailworker.h,v 1.5 2005/10/09 20:41:37 sailcuter Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SAILWORKER_H
#define SAILWORKER_H

#include "sail.h"
#include "saildef.h"

#include "geocpp/vect_geom.h"
#include "sailcalc.h"

// forward declarations
class CSail;
class CSeam;


/** The CSailWorker class does all the sail-related calculations. It is used to create
 * the sail from its definition.
 *
 * @see CSailDef, CSail
 */
class CSailWorker : public CSailDef
{
public:
    CSailWorker(const CSailDef &s);
    ~CSailWorker()
    {}
    ;

    real Area();
    real Diagonal();
    real IRCwidth( const real &h );
    real SailW( const real &h );
    real LeechLength( const real &h );
    real LuffLength( const real &h );
    real SailLP( );

    CSail makeSail();
    CSail makeSail( CSail &flatsail, CSail &dispsail );

    // corners of the sail
    CPoint3d tack, head, peak, clew;

protected:
    // layout of sail's panels
    CSail Layout0( CSail &flatsail, CSail &dispsail ); // CROSS
    CSail LayoutTwist( CSail &flatsail, CSail &dispsail ); // TWIST
    CSail LayoutVertical( CSail &flatsail, CSail &dispsail ); // VERTICAL
    CSail LayoutRadial( CSail &flatsail, CSail &dispsail ); // RADIAL
    CSail LayoutMitre( CSail &flatsail, CSail &dispsail ); // MITRE
    CSail LayoutTriRadial( CSail &flatsail, CSail &dispsail ); // TRIRADIAL
    CSail LayoutWing( CSail &flatsail, CSail &dispsail ); // WING

    // intersections with edges
    CPoint3d FwdIntersect( const CPoint3d &p1 );
    CPoint3d AftIntersect( const CPoint3d &p1 );
    CPoint3d FootIntersect( const CPoint3d &pt1, const CVector3d &v1 );
    CPoint3d GaffIntersect( const CPoint3d &pt1, const CVector3d &v1 );
    CPoint3d LeechIntersect( const CPoint3d &pt1, const CVector3d &v1 );
    CPoint3d LuffIntersect( const CPoint3d &pt1, const CVector3d &v1 );
    CPoint3d MitreIntersect( const CPoint3d &pt1, const CVector3d &v1 );
    // depth at any point
    CPoint3d Zpoint( const CPoint3d &p1 );
    // mitre intersection with luff
    CPoint3d mitrePt;
    // define useful edges vectors
    CVector3d footV, gaffV, leechV, luffV, mitreV;
    // and their unitary perpendicular vectors
    CVector3d footVP, gaffVP, leechVP, luffVP;
    // define useful (3d) straight lines
    CSubSpace foot, gaff, leech, luff, mitre;
};

#endif
