//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
// File   : DlgRef.cxx
// Author : Vadim SANDLER, Open CASCADE S.A.S. (vadim.sandler@opencascade.com)
//
#include "DlgRef.h"

//////////////////////////////////////////
// DlgRef_1List1Spin1Btn
//////////////////////////////////////////

DlgRef_1List1Spin1Btn::DlgRef_1List1Spin1Btn( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1List1Spin1Btn::~DlgRef_1List1Spin1Btn()
{
}

//////////////////////////////////////////
// DlgRef_1Sel1Check1List
//////////////////////////////////////////

DlgRef_1Sel1Check1List::DlgRef_1Sel1Check1List( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel1Check1List::~DlgRef_1Sel1Check1List()
{
}

//////////////////////////////////////////
// DlgRef_1Sel1Check1Sel
//////////////////////////////////////////

DlgRef_1Sel1Check1Sel::DlgRef_1Sel1Check1Sel( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel1Check1Sel::~DlgRef_1Sel1Check1Sel()
{
}

//////////////////////////////////////////
// DlgRef_1Sel1Check
//////////////////////////////////////////

DlgRef_1Sel1Check::DlgRef_1Sel1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel1Check::~DlgRef_1Sel1Check()
{
}

//////////////////////////////////////////
// DlgRef_1Sel1List1Check3Btn
//////////////////////////////////////////

DlgRef_1Sel1List1Check3Btn::DlgRef_1Sel1List1Check3Btn( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel1List1Check3Btn::~DlgRef_1Sel1List1Check3Btn()
{
}

//////////////////////////////////////////
// DlgRef_1Sel1Spin1Check
//////////////////////////////////////////

DlgRef_1Sel1Spin1Check::DlgRef_1Sel1Spin1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel1Spin1Check::~DlgRef_1Sel1Spin1Check()
{
}

//////////////////////////////////////////
// DlgRef_1Sel1Spin
//////////////////////////////////////////

DlgRef_1Sel1Spin::DlgRef_1Sel1Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel1Spin::~DlgRef_1Sel1Spin()
{
}

//////////////////////////////////////////
// DlgRef_1Sel2Spin1View1Check
//////////////////////////////////////////

DlgRef_1Sel2Spin1View1Check::DlgRef_1Sel2Spin1View1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel2Spin1View1Check::~DlgRef_1Sel2Spin1View1Check()
{
}

//////////////////////////////////////////
// DlgRef_1Sel2Spin
//////////////////////////////////////////

DlgRef_1Sel2Spin::DlgRef_1Sel2Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel2Spin::~DlgRef_1Sel2Spin()
{
}

//////////////////////////////////////////
// DlgRef_1Sel3Check
//////////////////////////////////////////

DlgRef_1Sel3Check::DlgRef_1Sel3Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel3Check::~DlgRef_1Sel3Check()
{
}

//////////////////////////////////////////
// DlgRef_1Sel3Spin
//////////////////////////////////////////

DlgRef_1Sel3Spin::DlgRef_1Sel3Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel3Spin::~DlgRef_1Sel3Spin()
{
}

//////////////////////////////////////////
// DlgRef_1Sel3Spin1Check
//////////////////////////////////////////

DlgRef_1Sel3Spin1Check::DlgRef_1Sel3Spin1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel3Spin1Check::~DlgRef_1Sel3Spin1Check()
{
}

//////////////////////////////////////////
// DlgRef_1Sel4Spin
//////////////////////////////////////////

DlgRef_1Sel4Spin::DlgRef_1Sel4Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel4Spin::~DlgRef_1Sel4Spin()
{
}

//////////////////////////////////////////
// DlgRef_1Sel5Spin1Check
//////////////////////////////////////////

DlgRef_1Sel5Spin1Check::DlgRef_1Sel5Spin1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel5Spin1Check::~DlgRef_1Sel5Spin1Check()
{
}

//////////////////////////////////////////
// DlgRef_1Sel5Spin
//////////////////////////////////////////

DlgRef_1Sel5Spin::DlgRef_1Sel5Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel5Spin::~DlgRef_1Sel5Spin()
{
}

//////////////////////////////////////////
// DlgRef_1Spin
//////////////////////////////////////////

DlgRef_1Spin::DlgRef_1Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Spin::~DlgRef_1Spin()
{
}

//////////////////////////////////////////
// DlgRef_1Sel
//////////////////////////////////////////

DlgRef_1Sel::DlgRef_1Sel( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1Sel::~DlgRef_1Sel()
{
}

//////////////////////////////////////////
// DlgRef_1SelExt
//////////////////////////////////////////

DlgRef_1SelExt::DlgRef_1SelExt( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_1SelExt::~DlgRef_1SelExt()
{
}

//////////////////////////////////////////
// DlgRef_2Sel1List1Check
//////////////////////////////////////////

DlgRef_2Sel1List1Check::DlgRef_2Sel1List1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel1List1Check::~DlgRef_2Sel1List1Check()
{
}

//////////////////////////////////////////
// DlgRef_2Sel1List
//////////////////////////////////////////

DlgRef_2Sel1List::DlgRef_2Sel1List( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel1List::~DlgRef_2Sel1List()
{
}

//////////////////////////////////////////
// DlgRef_2Sel1Spin2Check
//////////////////////////////////////////

DlgRef_2Sel1Spin2Check::DlgRef_2Sel1Spin2Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel1Spin2Check::~DlgRef_2Sel1Spin2Check()
{
}

//////////////////////////////////////////
// DlgRef_2Sel1Spin
//////////////////////////////////////////

DlgRef_2Sel1Spin::DlgRef_2Sel1Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel1Spin::~DlgRef_2Sel1Spin()
{
}

//////////////////////////////////////////
// DlgRef_2Sel1SpinInt
//////////////////////////////////////////

DlgRef_2Sel1SpinInt::DlgRef_2Sel1SpinInt( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel1SpinInt::~DlgRef_2Sel1SpinInt()
{
}

//////////////////////////////////////////
// DlgRef_2Sel2List
//////////////////////////////////////////

DlgRef_2Sel2List::DlgRef_2Sel2List( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel2List::~DlgRef_2Sel2List()
{
}

//////////////////////////////////////////
// DlgRef_2Sel2Spin1Check
//////////////////////////////////////////

DlgRef_2Sel2Spin1Check::DlgRef_2Sel2Spin1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel2Spin1Check::~DlgRef_2Sel2Spin1Check()
{
}

//////////////////////////////////////////
// DlgRef_2Sel2Spin
//////////////////////////////////////////

DlgRef_2Sel2Spin::DlgRef_2Sel2Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel2Spin::~DlgRef_2Sel2Spin()
{
}

//////////////////////////////////////////
// DlgRef_2Sel3Spin2Rb
//////////////////////////////////////////

DlgRef_2Sel3Spin2Rb::DlgRef_2Sel3Spin2Rb( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel3Spin2Rb::~DlgRef_2Sel3Spin2Rb()
{
}

//////////////////////////////////////////
// DlgRef_2Sel3Spin
//////////////////////////////////////////

DlgRef_2Sel3Spin::DlgRef_2Sel3Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel3Spin::~DlgRef_2Sel3Spin()
{
}

//////////////////////////////////////////
// DlgRef_2Sel4Spin1Check
//////////////////////////////////////////

DlgRef_2Sel4Spin1Check::DlgRef_2Sel4Spin1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel4Spin1Check::~DlgRef_2Sel4Spin1Check()
{
}

//////////////////////////////////////////
// DlgRef_2Sel
//////////////////////////////////////////

DlgRef_2Sel::DlgRef_2Sel( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Sel::~DlgRef_2Sel()
{
}

//////////////////////////////////////////
// DlgRef_2SelExt
//////////////////////////////////////////

DlgRef_2SelExt::DlgRef_2SelExt( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2SelExt::~DlgRef_2SelExt()
{
}

//////////////////////////////////////////
// DlgRef_2Spin
//////////////////////////////////////////

DlgRef_2Spin::DlgRef_2Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_2Spin::~DlgRef_2Spin()
{
}

//////////////////////////////////////////
// DlgRef_3Check
//////////////////////////////////////////

DlgRef_3Check::DlgRef_3Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Check::~DlgRef_3Check()
{
}

//////////////////////////////////////////
// DlgRef_3Radio
//////////////////////////////////////////

DlgRef_3Radio::DlgRef_3Radio( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Radio::~DlgRef_3Radio()
{
}

//////////////////////////////////////////
// DlgRef_3Radio1Sel1Spin
//////////////////////////////////////////

DlgRef_3Radio1Sel1Spin::DlgRef_3Radio1Sel1Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Radio1Sel1Spin::~DlgRef_3Radio1Sel1Spin()
{
}

//////////////////////////////////////////
// DlgRef_3Sel1Check
//////////////////////////////////////////

DlgRef_3Sel1Check::DlgRef_3Sel1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Sel1Check::~DlgRef_3Sel1Check()
{
}

//////////////////////////////////////////
// DlgRef_3Sel1Spin
//////////////////////////////////////////

DlgRef_3Sel1Spin::DlgRef_3Sel1Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Sel1Spin::~DlgRef_3Sel1Spin()
{
}

//////////////////////////////////////////
// DlgRef_3Sel2Spin
//////////////////////////////////////////

DlgRef_3Sel2Spin::DlgRef_3Sel2Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Sel2Spin::~DlgRef_3Sel2Spin()
{
}

//////////////////////////////////////////
// DlgRef_3Sel3Spin1Check
//////////////////////////////////////////

DlgRef_3Sel3Spin1Check::DlgRef_3Sel3Spin1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Sel3Spin1Check::~DlgRef_3Sel3Spin1Check()
{
}

void DlgRef_3Sel3Spin1Check::ShowRows( int fromRow, int toRow, bool toShow )
{
  const int maxRows = 7;
  
  if ( toRow >= fromRow && fromRow >= 0 && toRow <= maxRows ) {
    int c = gridLayout1->count();
    for ( int i = 0; i < c; i++ ) {
      QWidget* w = gridLayout1->itemAt( i )->widget();
      int row, col, rowspan, colspan;
      gridLayout1->getItemPosition( i, &row, &col, &rowspan, &colspan );
      if ( w && row >= fromRow && row <= toRow )
	w->setVisible( toShow );
    }
  }
}

//////////////////////////////////////////
// DlgRef_3Sel3Spin2Check
//////////////////////////////////////////

DlgRef_3Sel3Spin2Check::DlgRef_3Sel3Spin2Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Sel3Spin2Check::~DlgRef_3Sel3Spin2Check()
{
}

void DlgRef_3Sel3Spin2Check::ShowRows( int fromRow, int toRow, bool toShow )
{
  const int maxRows = 8;
  
  if ( toRow >= fromRow && fromRow >= 0 && toRow <= maxRows ) {
    int c = gridLayout1->count();
    for ( int i = 0; i < c; i++ ) {
      QWidget* w = gridLayout1->itemAt( i )->widget();
      int row, col, rowspan, colspan;
      gridLayout1->getItemPosition( i, &row, &col, &rowspan, &colspan );
      if ( w && row >= fromRow && row <= toRow )
	w->setVisible( toShow );
    }
  }
}

//////////////////////////////////////////
// DlgRef_3Sel4Spin2Check
//////////////////////////////////////////

DlgRef_3Sel4Spin2Check::DlgRef_3Sel4Spin2Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Sel4Spin2Check::~DlgRef_3Sel4Spin2Check()
{
}

//////////////////////////////////////////
// DlgRef_3Sel
//////////////////////////////////////////

DlgRef_3Sel::DlgRef_3Sel( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Sel::~DlgRef_3Sel()
{
}

//////////////////////////////////////////
// DlgRef_3Spin1Check
//////////////////////////////////////////

DlgRef_3Spin1Check::DlgRef_3Spin1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Spin1Check::~DlgRef_3Spin1Check()
{
}

//////////////////////////////////////////
// DlgRef_3Spin
//////////////////////////////////////////

DlgRef_3Spin::DlgRef_3Spin( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_3Spin::~DlgRef_3Spin()
{
}

//////////////////////////////////////////
// DlgRef_4Sel1List1Check
//////////////////////////////////////////

DlgRef_4Sel1List1Check::DlgRef_4Sel1List1Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_4Sel1List1Check::~DlgRef_4Sel1List1Check()
{
}

//////////////////////////////////////////
// DlgRef_4Sel1List
//////////////////////////////////////////

DlgRef_4Sel1List::DlgRef_4Sel1List( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_4Sel1List::~DlgRef_4Sel1List()
{
}

//////////////////////////////////////////
// DlgRef_4Sel1Spin2Check
//////////////////////////////////////////

DlgRef_4Sel1Spin2Check::DlgRef_4Sel1Spin2Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_4Sel1Spin2Check::~DlgRef_4Sel1Spin2Check()
{
}

void DlgRef_4Sel1Spin2Check::ShowRows( int fromRow, int toRow, bool toShow )
{
  const int maxRows = 6;
  
  if ( toRow >= fromRow && fromRow >= 0 && toRow <= maxRows ) {
    int c = gridLayout1->count();
    for ( int i = 0; i < c; i++ ) {
      QWidget* w = gridLayout1->itemAt( i )->widget();
      int row, col, rowspan, colspan;
      gridLayout1->getItemPosition( i, &row, &col, &rowspan, &colspan );
      if ( w && row >= fromRow && row <= toRow )
	w->setVisible( toShow );
    }
  }
}

//////////////////////////////////////////
// DlgRef_4Sel1Spin3Check
//////////////////////////////////////////

DlgRef_4Sel1Spin3Check::DlgRef_4Sel1Spin3Check( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_4Sel1Spin3Check::~DlgRef_4Sel1Spin3Check()
{
}

//////////////////////////////////////////
// DlgRef_6Sel
//////////////////////////////////////////

DlgRef_6Sel::DlgRef_6Sel( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_6Sel::~DlgRef_6Sel()
{
}

//////////////////////////////////////////
// DlgRef_Skeleton
//////////////////////////////////////////

DlgRef_Skeleton::DlgRef_Skeleton( QWidget* parent, Qt::WindowFlags f )
: QWidget( parent, f )
{
  setupUi( this );
}

DlgRef_Skeleton::~DlgRef_Skeleton()
{
}

//////////////////////////////////////////
// Utility functions
//////////////////////////////////////////

QString DlgRef::PrintDoubleValue( double theValue, int thePrecision )
{
  const double prec = 1e-12;
  
  if ( qAbs(theValue) < prec )
    return "0";

  QString aRes;
  aRes.setNum( theValue, 'g', thePrecision );

  if ( prec > 0 ) {
    int p = 0;
    while ( p < thePrecision ) {
      aRes.setNum( theValue, 'g', p++ );
      double v = aRes.toDouble();
      double err = qAbs( theValue - v );
      if ( err > 0 && err <= prec )
	break;
    }
  }

  // remove trailing zeroes
  QString delim( "." );

  int idx = aRes.lastIndexOf( delim );
  if ( idx == -1 )
    return aRes;

  QString iPart = aRes.left( idx );
  QString fPart = aRes.mid( idx + 1 );

  while ( !fPart.isEmpty() && fPart.at( fPart.length() - 1 ) == '0' )
    fPart.remove( fPart.length() - 1, 1 );

  aRes = iPart;
  if ( !fPart.isEmpty() )
    aRes += delim + fPart;

  return aRes;
}
