//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  SALOME VTKViewer : build VTK viewer into Salome desktop
//  File   : VISU_WidgetCtrl.hxx
//  Author : Peter KURNEV
//  Module : SALOME
//  $Header$
//
#ifndef __VISU_WidgetCtrl_hxx
#define __VISU_WidgetCtrl_hxx

#include "VISUPipeline.hxx"
#include <vtkImplicitFunction.h>

#include "VTKViewer.h"

class vtkImplicitFunction;
class vtkObject;
class vtkRenderWindowInteractor;
class vtkCommand;
class vtkCallbackCommand;

class VISU_PlanesWidget;
class VISU_SphereWidget;
class VISU_ImplicitFunctionWidget;

class VISU_PIPELINE_EXPORT VISU_WidgetCtrl : public vtkImplicitFunction
{
public:
  static VISU_WidgetCtrl *New();
  vtkTypeRevisionMacro(VISU_WidgetCtrl,vtkObject);

  vtkImplicitFunction* ImplicitFunction();

  virtual
  vtkFloatingPointType 	
  EvaluateFunction(vtkFloatingPointType theX[3]);

  virtual
  void 	
  EvaluateGradient(vtkFloatingPointType theX[3], 
		   vtkFloatingPointType theG[3]);

  virtual
  unsigned long
  GetMTime();

  void PlaceWidget(vtkFloatingPointType theBounds[6]);
  void SetEnabled(int theFlag);
  int  GetEnabled();
  void On() {SetEnabled(1);}
  void Off(){SetEnabled(0);}
  
  void SetInteractor(vtkRenderWindowInteractor* theRWI);
  vtkRenderWindowInteractor* GetInteractor();
  //
  void  
  SetPlaceFactor(vtkFloatingPointType theFactor);

  vtkFloatingPointType
  GetPlaceFactor();
  //
  void SetActiveIndex(const int theFlag);
  int  GetActiveIndex()const;
  bool HasActiveIndex()const;
  bool IsPlanesActive()const;
  bool IsSphereActive()const;

  
  VISU_ImplicitFunctionWidget* GetActiveWidget();
  VISU_ImplicitFunctionWidget* GetWidget(const int);

  int GetNbWidgets()const;
  int GetDisableAll()const;
  
  //
  VISU_PlanesWidget * GetPlanesWidget();
  VISU_SphereWidget * GetSphereWidget();
  //
  static void ProcessEvents(vtkObject* theObject, 
			    unsigned long theEvent,
			    void* theClientData, 
			    void* theCalldata);
  //
protected:
  VISU_WidgetCtrl();
  ~VISU_WidgetCtrl();

protected:
  int myNbWidgets;
  int myActiveIndex;
  int myCounter;
  int myDisableAll;
  vtkFloatingPointType myPriority;
  VISU_ImplicitFunctionWidget *myWidgets[2];
  VISU_ImplicitFunctionWidget *myDummyWidget;
  VISU_PlanesWidget *myPlanesWidget;
  VISU_SphereWidget *mySphereWidget;
  vtkCallbackCommand *myEventCallbackCommand;

private:
  VISU_WidgetCtrl(const VISU_WidgetCtrl&);  //Not implemented
  void operator=(const VISU_WidgetCtrl&);   //Not implemented
};

#endif
