//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  SALOME VTKViewer : build VTK viewer into Salome desktop
//  File   : 
//  Author : 
//  Module : SALOME
//  $Header$
//
#ifndef VVTK_Renderer_h
#define VVTK_Renderer_h

#include "VVTK.h"

#include "SVTK_Renderer.h"

class VISU_WidgetCtrl;
class VISU_InsideCursorSettings;
class VISU_OutsideCursorSettings;
class VISU_PickingSettings;
class VISU_FPSActor;

class vtkPointPicker;
class vtkImplicitFunction;

//----------------------------------------------------------------------------
//! To customize SVTK_Renderer according to VVTK functionality
class VVTK_EXPORT VVTK_Renderer : public SVTK_Renderer
{
 public:
  vtkTypeMacro(VVTK_Renderer,SVTK_Renderer);
  static VVTK_Renderer* New();

  //! Reimplement SVTK_Renderer::AddActor
  /*!
    Perform an additional action - apply picking settings on the published VISU_GaussPtsAct actors
  */
  virtual
  void 
  AddActor(VTKViewer_Actor* theActor);

  //! Reimplement SVTK_Renderer::RemoveActor (remove additional settings)
  virtual
  void 
  RemoveActor(VTKViewer_Actor* theActor);

  //! To set VISU_PickingSettings to share them among all VISU_GaussPtsAct actors published into the view 
  void
  SetInsideCursorSettings(VISU_InsideCursorSettings* theInsideCursorSettings);

  void
  SetPickingSettings(VISU_PickingSettings* thePickingSettings);

 protected:
  VVTK_Renderer();
  ~VVTK_Renderer();

  VISU_PickingSettings* myPickingSettings; //! Keeps reference of the VISU_PickingSettings
  VISU_InsideCursorSettings* myInsideCursorSettings; //! Keeps reference of the VISU_InsideCursorSettings
  vtkSmartPointer<VISU_FPSActor> myFPSActor; //!< To show FPS of the rendering at run-time

  vtkSmartPointer<vtkPointPicker> myGaussPointPicker;
  vtkSmartPointer<vtkProperty>    myGaussPreHighlightProperty;
  vtkSmartPointer<vtkProperty>    myGaussHighlightProperty;
};


//----------------------------------------------------------------------------
//! To extend VVTK_Renderer to implement base view functionality
class VVTK_EXPORT VVTK_Renderer1 : public VVTK_Renderer
{
 public:
  vtkTypeMacro(VVTK_Renderer1,VVTK_Renderer);
  static VVTK_Renderer1* New();

  //! Reimplement SVTK_Renderer::Initialize
  virtual
  void 
  Initialize(vtkRenderWindowInteractor* theInteractor,
	     SVTK_Selector* theSelector);

  //! Reimplement VVTK_Renderer::AddActor to apply to the actor additional settings
  virtual
  void 
  AddActor(VTKViewer_Actor* theActor);

  //! Reimplement VVTK_Renderer::RemoveActor
  virtual
  void 
  RemoveActor(VTKViewer_Actor* theActor);

  //! To set VISU_PickingSettings to share them among all VISU_GaussPtsAct1 actors published into the view 
  void
  SetOutsideCursorSettings(VISU_OutsideCursorSettings* theOutsideCursorSettings);

  VISU_WidgetCtrl*  GetWidgetCtrl();

 protected:
  VVTK_Renderer1();
  ~VVTK_Renderer1();

  //! Reimplement VVTK_Renderer::OnAdjustActors
  virtual
  bool
  OnAdjustActors();

  void AdjustWidgetCtrl();

  VISU_WidgetCtrl* myWidgetCtrl;
  //vtkSmartPointer<VISU_WidgetCtrl> myWidgetCtrl;
  VISU_OutsideCursorSettings* myOutsideCursorSettings;
  vtkSmartPointer<VISU_FPSActor> myTextActor;
};


//----------------------------------------------------------------------------
class VVTK_EXPORT VVTK_Renderer2 : public VVTK_Renderer
{
 public:
  vtkTypeMacro(VVTK_Renderer2,VVTK_Renderer);
  static VVTK_Renderer2* New();

  //! Reimplement VVTK_Renderer::AddActor to apply to the actor additional settings
  virtual
  void 
  AddActor(VTKViewer_Actor* theActor);

  //! Reimplement VVTK_Renderer::RemoveActor
  virtual
  void 
  RemoveActor(VTKViewer_Actor* theActor);

  void SetWidgetCtrl(VISU_WidgetCtrl* theWidgetCtrl);

  //! To handle vtkCommand::EndInteractionEvent to redraw the view
  void
  OnEndInteractionEvent();

 protected:
  VVTK_Renderer2();
  ~VVTK_Renderer2();

  //! Main process VTK event method
  static
  void
  ProcessEvents(vtkObject* theObject, 
		unsigned long theEvent,
		void* theClientData, 
		void* theCallData);

  //! Used to process VTK events
  vtkSmartPointer<vtkCallbackCommand> myEventCallbackCommand;

  //! Priority at which events are processed
  float myPriority;

  VISU_WidgetCtrl* myWidgetCtrl;
};


#endif
