//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#ifndef VVTK_VIEWMODEL_H
#define VVTK_VIEWMODEL_H

#include <QColor>

#include "VVTK.h"
#include "SVTK_ViewModel.h"

class VVTK_ViewWindow;

//! VVTK View Model
class VVTK_EXPORT VVTK_Viewer : public SVTK_Viewer
{
  Q_OBJECT;

public:
  typedef VVTK_ViewWindow TViewWindow;

  static
  QString
  Type() 
  { 
    return "VVTK"; 
  }

  VVTK_Viewer();

  virtual
  ~VVTK_Viewer();

  //! See #SUIT_ViewModel::createView
  virtual
  SUIT_ViewWindow* 
  createView(SUIT_Desktop*);

  //! See SUIT_ViewModel::getType
  virtual
  QString 
  getType() const 
  { 
    return Type(); 
  }

  //! See #SALOME_View::Display( const SALOME_Prs* )
  virtual
  void
  Display(const SALOME_VTKPrs* thePrs); 

  //! See #SALOME_View::isVisible( const Handle(SALOME_InteractiveObject)& )
  virtual
  bool
  isVisible(const Handle(SALOME_InteractiveObject)& theIO);
};

#endif
