//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
#ifndef VVTK_VIEWWINDOW_H
#define VVTK_VIEWWINDOW_H

#ifdef WIN32
#pragma warning( disable:4251 )
#endif

#include "VVTK.h"
#include "SVTK_ViewWindow.h"

#include <QImage>

#include <string>

class VVTK_MainWindow1;
class VVTK_MainWindow2;
class SVTK_View;

//----------------------------------------------------------------------------
//! Customize the SVTK_ViewWindow in order to manage two SVTK_View (base and segmented one)
class VVTK_EXPORT VVTK_ViewWindow : public SVTK_ViewWindow
{
  Q_OBJECT;

public:
  //! To construct the class
  VVTK_ViewWindow(SUIT_Desktop* theDesktop);

  //! Destroy
  virtual
  ~VVTK_ViewWindow();

  //! To initialize
  virtual
  void
  Initialize(SVTK_ViewModelBase* theModel);

  //----------------------------------------------------------------------------
  //! Get access to base SVTK_MainWindow
  VVTK_MainWindow1* 
  getMainWindow1();

  //! Get access to segmented SVTK_MainWindow
  VVTK_MainWindow2* 
  getMainWindow2();

  //----------------------------------------------------------------------------
  //! Redefine SVTK_ViewWindow::AddActor method
  /*!
    This is an entry point for publication the presentation into the viewer.
    Pointed actor published into the basic MainWindow. If the actor is
    a Gauss Points one second actor is created from initial actor and 
    is put into segemented MainWindow.
  */
  virtual
  void
  AddActor(VTKViewer_Actor* theActor,
	   bool theIsUpdate = false);

  //! Redefine SVTK_ViewWindow::RemoveActor method
  virtual
  void
  RemoveActor(VTKViewer_Actor* theActor,
	      bool theIsUpdate = false);

  //! Redefine SVTK_ViewWindow::Repaint method
  virtual
  void
  Repaint(bool theUpdateTrihedron = true);

  //----------------------------------------------------------------------------
  /*  interactive object management */
  //! Redefine SVTK_ViewWindow::highlight method
  virtual
  void
  highlight(const Handle(SALOME_InteractiveObject)& theIO, 
	    bool theIsHighlight = true, 
	    bool theIsUpdate = true);

  //! Redefine SVTK_ViewWindow::unHighlightAll method
  virtual
  void
  unHighlightAll();

  //! Redefine SVTK_ViewWindow::setBackgroundColor method
  virtual
  void
  setBackgroundColor( const QColor& );

  //----------------------------------------------------------------------------

  //! Refresh dump images of the viewers
  virtual
  void RefreshDumpImage();
  
public slots:
  //! Redefine SVTK_ViewWindow::onSelectionChanged method
  virtual
  void
  onSelectionChanged();

  //! Redefine SVTK_ViewWindow::onResetView method
  virtual
  void
  onResetView();     

  //! Redefine SVTK_ViewWindow::onFitAll method
  virtual
  void 
  onFitAll();

  //----------------------------------------------------------------------------
protected:
  virtual 
  bool
  action( const int );

  virtual QImage dumpView();

  VVTK_MainWindow1* myMainWindow1; //!< The manage base view
  SVTK_View* myView1; //!< The manage base view

  VVTK_MainWindow2* myMainWindow2; //!< The manage segmented view
  SVTK_View* myView2; //!< The manage segmented view

private:
  QImage myDumpImage;
};

#ifdef WIN32
#pragma warning( default:4251 )
#endif

#endif
