# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XAttributeWithComments(XAttribute):
    __init__xattributes__ = XAttribute.__init__xattributes__ + [
        XAttribute("en_comment", xtype=XString(), default_value=""),
        XAttribute("fr_comment", xtype=XString(), default_value=""),
        XAttribute("de_comment", xtype=XString(), default_value=""),
        ]
    pass

class Point(XNamedObject):
    __init__xattributes__ = [
        XAttributeWithComments("x", xtype=XFloat(), en_comment="x coordinate"),
        XAttributeWithComments("y", xtype=XFloat(), en_comment="y coordinate"),
        XAttributeWithComments("z", xtype=XFloat(), en_comment="z coordinate"),
        ]
    pass

class PointTestCase(unittest.TestCase):
    def test(self):
        #
        x = Point(0, 0, 0)
        #
        xattrs = x.__class__.__init__xattributes__
        xattr1 = xattrs[0]
        self.failUnlessEqual(xattr1.en_comment, "x coordinate")
        self.failUnlessEqual(xattr1.fr_comment, "")
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
