# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class A(XObject):
    # 'x', 'y', 'z' can be given implicitely
    __init__xattributes__ = [
        XAttribute("x", xtype=XInt(min=0)),
        XAttribute("y", xtype=XInt(min=0)),
        XAttribute("z", xtype=XInt(min=0)),
        ]
    pass

class ATestCase(unittest.TestCase):
    def test(self):
        a = A(1, 2, 3)
        a = A(1, 2, z=3)
        a = A(z=3, y=2, x=1)
        return
    pass

class B(XObject):
    __init__argslen__ = 0 # Everything must be given explicitely
    __init__xattributes__ = [
        XAttribute("x", xtype=XInt(min=0)),
        XAttribute("y", xtype=XInt(min=0)),
        XAttribute("z", xtype=XInt(min=0)),
        ]
    pass

class BTestCase(unittest.TestCase):
    def test(self):
        b = B(x=1, y=2, z=3)
        b = B(z=3, y=2, x=1)
        self.failUnlessRaises(XAttributeError, B, 1, 2, 3)
        self.failUnlessRaises(XAttributeError, B, 1, y=2, z=3)
        return
    pass

class C(XObject):
    __init__argslen__ = 1 # Only 'x' can be given implicitely
    __init__xattributes__ = [
        XAttribute("x", xtype=XInt(min=0)),
        XAttribute("y", xtype=XInt(min=0)),
        XAttribute("z", xtype=XInt(min=0)),
        ]
    pass

class CTestCase(unittest.TestCase):
    def test(self):
        c = C(1, z=3, y=2)
        c = C(z=3, y=2, x=1)
        self.failUnlessRaises(XAttributeError, C, 1, 2, 3)
        self.failUnlessRaises(XAttributeError, C, 1, 2, z=3)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
