# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XDictTestCase(unittest.TestCase):
    def test(self):
        x = XDict()
        self.failUnlessRaises(XValueError, x, 0)
        self.failUnlessEqual(x({}), {})
        return
    def test_keys(self):
        self.failUnlessRaises(XValueError, XDict, keys="toto")
        x = XDict(keys=XString())
        self.failUnlessRaises(XValueError, x, {1: None})
        self.failUnlessEqual(x({"a":None, "b":None}), {"a":None, "b":None})
        x = XDict(keys=XInt())
        self.failUnlessRaises(XValueError, x, {"toto": None})
        self.failUnlessEqual(x({1: None, 2:None}), {1:None, 2:None})
        self.failUnlessEqual(x({"1": None, "2":None}), {1:None, 2:None})
        return
    def test_keys_values(self):
        self.failUnlessRaises(XValueError, XDict, values="toto")
        x = XDict(keys=XString(), values=XInt())
        self.failUnlessRaises(XValueError, x, {"a":None, "b":None})
        self.failUnlessEqual(x({"a": 1, "b": 2}), {"a": 1, "b": 2})
        self.failUnlessEqual(x({"a": "1", "b": "2"}), {"a": 1, "b": 2})
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
