# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XIntTestCase(unittest.TestCase):
    def test(self):
        x = XInt()
        self.failUnlessEqual(x(123), 123)
        self.failUnlessEqual(x("123"), 123)
        self.failUnlessEqual(x(2*3), 6)
        self.failUnlessEqual(x("2*3"), 6)
        self.failUnlessRaises(XValueError, x, "toto")
        self.failUnlessRaises(XValueError, x, "3.2")
        self.failUnlessRaises(XValueError, x, 3.2)
        return
    def test_into_min_max(self):
        # into
        x = XInt(into=[1, "2", 3, "10", 20])
        self.failUnlessRaises(XValueError, x, 15)
        self.failUnlessEqual(x("10"), 10)
        self.failUnlessRaises(XValueError, XInt, into="toto")
        self.failUnlessRaises(XValueError, XInt, into=["toto", "titi"])
        # min, max
        self.failUnlessRaises(XValueError, XInt, min=2, max=4.5)
        x = XInt(into=[1, 2, 3, 5, 10, 20], min=5, max=15)
        self.failUnlessRaises(XValueError, x, 1)
        self.failUnlessEqual(x(5), 5)
        self.failUnlessEqual(x("10"), 10)
        self.failUnlessEqual(x(10), 10)
        return
    def test_not_into(self):
        x = XInt(not_into=[0, 1, 5])
        self.failUnlessRaises(XValueError, x, 0)
        self.failUnlessRaises(XValueError, x, 1)
        self.failUnlessRaises(XValueError, x, 5)
        self.failUnlessEqual(x(2), 2)
        self.failUnlessEqual(x("2"), 2)
        return
    def test_boolean(self):
        x = XInt()
        self.failUnless(x(True) is 1)
        self.failUnless(x(False) is 0)
        self.failUnless(x("True") is 1)
        self.failUnless(x("False") is 0)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
