# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XStringTestCase(unittest.TestCase):
    def test(self):
        x = XString()
        self.failUnlessRaises(XValueError, x, 3.2)
        self.failUnlessEqual(x("test"), "test")
        return
    def test_into(self):
        self.failUnlessRaises(XValueError, XString, into=[1.1])
        x = XString(into=["toto", "titi"])
        self.failUnlessRaises(XValueError, x, "test")
        self.failUnlessEqual(x("toto"), "toto")
        return
    def test_len(self):
        self.failUnlessRaises(XValueError, XString, len="toto")
        self.failUnlessRaises(XValueError, XString, len=-1)
        x = XString(len=3)
        self.failUnlessRaises(XValueError, x, "a")
        self.failUnlessRaises(XValueError, x, "aaaaa")
        self.failUnlessEqual(x("aaa"), "aaa")
        return
    def test_len_min_max(self):
        x = XString(len_min=2, len_max=3)
        self.failUnlessRaises(XValueError, x, "a")
        self.failUnlessRaises(XValueError, x, "aaaa")
        self.failUnlessEqual(x("aa"), "aa")
        self.failUnlessEqual(x("aaa"), "aaa")
        return
    def test_into_nocase(self):
        x = XString(into=["toto", "titi"])
        self.failUnlessRaises(XValueError, x, "test")
        self.failUnlessEqual(x("ToTo"), "toto")
        self.failUnlessEqual(x("TITI"), "titi")
        x = XString(into=["Castem", "PorFlow"])
        self.failUnlessRaises(XValueError, x, "test")
        self.failUnlessEqual(x("castem"), "Castem")
        self.failUnlessEqual(x("porflow"), "PorFlow")
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
