# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XTupleTestCase(unittest.TestCase):
    def test(self):
        x = XTuple()
        self.failUnlessEqual(x(3.2), (3.2, ))
        self.failUnlessEqual(x(("a", 1)), ("a", 1))
        self.failUnlessEqual(x(("a",)), ("a",))
        return
    def test_sequence(self):
        self.failUnlessRaises(XValueError, XTuple, sequence="toto")
        self.failUnlessRaises(XValueError, XTuple, sequence=[])
        #
        x = XTuple(sequence=XInt(min=0))
        self.failUnlessRaises(XValueError, x, ("toto", ) )
        self.failUnlessRaises(XValueError, x, (-1,) )
        self.failUnlessEqual(x( (1, ) ), (1, ))
        self.failUnlessEqual(x( ("1", ) ), (1, ))
        #
        x = XTuple(sequence=[XString(), XInt()])
        self.failUnlessRaises(XValueError, x, ("toto", ) )
        self.failUnlessRaises(XValueError, x, ("toto", "toto") )
        self.failUnlessRaises(XValueError, x, (1, 2, 3) )
        self.failUnlessEqual(x( ("a", 1) ), ("a", 1))
        self.failUnlessEqual(x( ("a", "1") ), ("a", 1))
        return
    def test_sequence_totuple(self):
        x = XTuple(sequence=XInt())
        self.failUnlessEqual(x(1), (1, ))
        return
    def test_list_to_tuple(self):
        x = XTuple()
        self.failUnlessEqual(x([1, 2, 3,]), (1, 2, 3,))
        return
    def test_xtuple_str(self):
        x = XTuple(sequence=(XString(), XFloat(), ))
        val = x("('He', 0.4)")
        self.failUnlessEqual(val, ('He', 0.4))
        val = x("He, 0.4")
        self.failUnlessEqual(val, ('He', 0.4))
        val = x("[He, 0.4]")
        self.failUnlessEqual(val, ('He', 0.4))
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
