# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import getXSalomeSession
salome = getXSalomeSession(modules=["STUDYTEST"])

compo = salome.lcc.FindOrLoadComponent("FactoryServerPy", "STUDYTEST")
from STUDYTEST_CORBA import STUDYTEST_Component
compo = compo._narrow(STUDYTEST_Component)

from batchmode_salome import myStudy
from batchmode_salome import myStudyManager

class StudyTree(object):
    
    def __init__(self, sobj):
        self.sobj = sobj
        return
    
    def getChildren(self):
        sobjs = []
        itr = myStudy.NewChildIterator(self.sobj)
        itr.InitEx(1)
        while itr.More():
            sobjs.append(itr.Value())
            itr.Next()
            pass
        return [ StudyTree(sobj) for sobj in sobjs ]
    
    children = property(getChildren)
    
    pass

class TestCase(unittest.TestCase):
    
    def setUp(self):
        myBuilder = myStudy.NewBuilder()
        scompo = myStudy.FindComponent("STUDYTEST")
        if scompo:
            itr = myStudy.NewChildIterator(scompo)
            itr.InitEx(1)
            while itr.More():
                sobj = itr.Value()
                myBuilder.RemoveObjectWithChildren(sobj)
                itr.Next()
                pass
            pass
        return
    
    def testEmpty(self):
        #
        from time import time
        #
        nb = 100
        #
        t0 = time()
        objs = []
        for i in range(nb):
            objs.append(compo.newEmpty_no_superv())
            pass
        t1 = time()
        print 10000*(t1-t0)/nb, t1-t0
        #
        t0 = time()
        for obj in objs:
            compo.PublishInStudy(myStudy, None, obj, "obj")
            pass
        t1 = time()
        print 10000*(t1-t0)/nb, t1-t0
##        compo.PublishInStudy(myStudy, None, obj, "objbis")
##        #
##        scompo = myStudy.FindComponent("STUDYTEST")
##        tree = StudyTree(scompo)
##        children = tree.getChildren()
##        self.failUnlessEqual(len(children), 1)
##        child = children[0]
##        self.failUnlessEqual(len(child.children), 0)
##        sobj = child.sobj
##        attr = sobj.FindAttribute("AttributeName")[1]
##        self.failUnlessEqual(attr.Value(), "objbis")
##        #
        return
    
    def testListOfEmpty(self):
        #
        from time import time
        #
        nb = 100
        #
        t0 = time()
        objs = []
        for i in range(nb):
            objs.append(compo.newEmpty_no_superv())
            pass
        t1 = time()
        print 10000*(t1-t0)/nb, t1-t0
        #
        obj = compo.newListOfEmpty_no_superv(objs)
        #
        t0 = time()
        compo.PublishInStudy(myStudy, None, obj, "obj")
        t1 = time()
        print 10000*(t1-t0)/nb, t1-t0
        return
    
    def testListOfEmptyNoContent(self):
        nb = 10
        objs = []
        for i in range(nb):
            objs.append(compo.newEmpty_no_superv())
            pass
        obj = compo.newListOfEmpty_no_superv(objs)
        compo.PublishInStudyWithoutContent(myStudy, None, obj, "obj")
        myStudyManager.SaveAs('./test.hdf', myStudy, 1)
        return
    
    def testListOfEmptyOrNone(self):
        #
        from time import time
        #
        nb = 100
        #
        t0 = time()
        objs = []
        for i in range(nb):
            objs.append(compo.newEmpty_no_superv())
            pass
        t1 = time()
        print 10000*(t1-t0)/nb, t1-t0
        #
        objs = compo.newXListXObjectValues(objs)
        obj = compo.newListOfEmptyOrNone_no_superv(objs)
        #
        t0 = time()
        compo.PublishInStudy(myStudy, None, obj, "obj")
        t1 = time()
        print 10000*(t1-t0)/nb, t1-t0
        return
    
    def testDictOfLongKeys(self):
        #
        from time import time
        #
        nb = 100
        #
        t0 = time()
        objs = []
        for i in range(nb):
            objs.append(compo.newEmpty_no_superv())
            pass
        t1 = time()
        print 10000*(t1-t0)/nb, t1-t0
        #
        obj = compo.newXDictLongKeys(range(nb), objs)
        obj = compo.newDictOfLongKeys(obj)
        #
        t0 = time()
        compo.PublishInStudy(myStudy, None, obj, "obj")
        t1 = time()
        print 10000*(t1-t0)/nb, t1-t0
        return
    
    def tearDown(self):
        return
    
    pass

if __name__ == '__main__':
    unittest.main()
    pass
