# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession
salome = XSalomeSession(modules=["DATATEST1"])

epsilon = 1.e-5

class TestCase(unittest.TestCase):
    def test(self):
        #
        component = salome.lcc.FindOrLoadComponent("FactoryServerPy", "DATATEST1")
        self.failUnless(component)
        from DATATEST1_CORBA import DATATEST1_Component
        component = component._narrow(DATATEST1_Component)
        self.failUnless(component)
        #
        # Test if the SALOME_Component corba services are callable
        # and return a correct value ...
        #
        self.failUnlessEqual(component._get_instanceName(), "DATATEST1_inst_1")
        self.failUnlessEqual(component._get_interfaceName(), "DATATEST1")
        #
        x = component.newXObject()
        self.failUnless(x)
        c = x.getCorbaComponent()
        self.failUnlessEqual(c._get_instanceName(), "DATATEST1_inst_1")
        self.failUnlessEqual(c._get_interfaceName(), "DATATEST1")
        #
        i, f, s = 111, 2.3, "toto"
        ii = component.newXInt(i)
        ff = component.newXFloat(f)
        ss = component.newXString(s)
        #
        x = component.newTestXIntXFloatXString(i, f, s, ii, ff, ss)
        self.failUnlessEqual(x.getI(), i)
        self.failUnless(abs(x.getF() - f) < epsilon)
        self.failUnlessEqual(x.getS(), s)
        self.failUnlessEqual(x.getIi().value(), i)
        self.failUnless(abs(x.getFf().value() - f) < epsilon)
        self.failUnlessEqual(x.getSs().value(), s)
        #
        x = component.newTestXIntXFloatXString(i, f, s, None, None, None)
        self.failUnlessEqual(x.getI(), i)
        self.failUnless(abs(x.getF() - f) < epsilon)
        self.failUnlessEqual(x.getS(), s)
        self.failUnlessEqual(x.getIi(), None)
        self.failUnlessEqual(x.getFf(), None)
        self.failUnlessEqual(x.getSs(), None)
        #
        x.setI(2*i)
        x.setF(2*f)
        x.setS(2*s)
        x.setIi(ii)
        x.setFf(ff)
        x.setSs(ss)
        self.failUnlessEqual(x.getI(), 2*i)
        self.failUnless(abs(x.getF() - 2*f) < epsilon)
        self.failUnlessEqual(x.getS(), 2*s)
        self.failUnlessEqual(x.getIi().value(), i)
        self.failUnless(abs(x.getFf().value() - f) < epsilon)
        self.failUnlessEqual(x.getSs().value(), s)
        #
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
