# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession

salome = XSalomeSession(modules=["DATATEST1"])

def compare_lists(l1, l2):
    epsilon = 1.e-5
    for i in range(len(l1)):
        v1, v2 = l1[i], l2[i]
        if abs(v1 - v2) > epsilon:
            print v1, v2
            raise "KO"
        pass
    return

class TestCase(unittest.TestCase):
    def test(self):
        #
        component = salome.lcc.FindOrLoadComponent("FactoryServerPy", "DATATEST1")
        self.failUnless(component)
        from DATATEST1_CORBA import DATATEST1_Component
        component = component._narrow(DATATEST1_Component)
        self.failUnless(component)
        #
        xobj = component.newXObject()
        x = component.newTestCorbaSequences([1, 2, 3],
                                            [1.1, 2.2, 3.3],
                                            ['a', 'b', 'c'],
                                            [xobj],
                                            )
        self.failUnlessEqual(x.getLi(), [1, 2, 3])
        self.failUnlessEqual(x.getLi2(), range(5))
        # self.failUnlessEqual(x.getLf(), [1.1, 2.2, 3.3])
        compare_lists(x.getLf(), [1.1, 2.2, 3.3])
        self.failUnlessEqual(x.getLs(), ['a', 'b', 'c'])
        self.failUnlessEqual(len(x.getLX()), 1)
        x.appendToLists(123)
        self.failUnlessEqual(x.getLi(), [1, 2, 3, 123])
        self.failUnlessEqual(x.getLi2(), range(5)+ [123])
        # self.failUnlessEqual(x.getLf(), [1.1, 2.2, 3.3, 1.0])
        compare_lists(x.getLf(), [1.1, 2.2, 3.3, 1.0])
        self.failUnlessEqual(x.getLs(), ['a', 'b', 'c', 'd'])
        self.failUnlessEqual(len(x.getLX()), 2)
        #
        x = component.newTestXList(None,
                                   None,
                                   None,
                                   None,
                                   )
        self.failUnlessEqual(x.getLi(), None)
        self.failUnlessEqual(x.getLf(), None)
        self.failUnlessEqual(x.getLs(), None)
        self.failUnlessEqual(x.getLX(), None)
        self.failUnlessEqual(x.getLi2().value(), range(5))
        #
        xobj = component.newXObject()
        li = component.newXListLongValues([1, 2, 3])
        lf = component.newXListDoubleValues([1.1, 2.2, 3.3])
        ls = component.newXListStringValues(['a', 'b', 'c'])
        lX = component.newXListXObjectValues([xobj])
        x = component.newTestXList(li,
                                   lf,
                                   ls,
                                   lX,
                                   )
        self.failUnlessEqual(x.getLi().value(), [1, 2, 3])
        # self.failUnlessEqual(x.getLf().value(), [1.1, 2.2, 3.3])
        compare_lists(x.getLf().value(), [1.1, 2.2, 3.3])
        self.failUnlessEqual(x.getLs().value(), ['a', 'b', 'c'])
        self.failUnlessEqual(len(x.getLX().value()), 1)
        self.failUnlessEqual(x.getLi2().value(), range(5))
        #
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
