# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession

def compare_lists(l1, l2):
    epsilon = 1.e-5
    for i in range(len(l1)):
        v1, v2 = l1[i], l2[i]
        if abs(v1 - v2) > epsilon:
            print v1, v2
            raise "KO"
        pass
    return

class TestCase(unittest.TestCase):
    def test(self):
        #
        salome = XSalomeSession(modules=["DATATEST1"])
        #
        from xlistusecases import FFFFF
        xobj = FFFFF()
        from xlistusecases import TestCorbaSequences
        x = TestCorbaSequences([1, 2, 3],
                               [1.1, 2.2, 3.3],
                               ['a', 'b', 'c'],
                               [xobj],
                               )
        self.failUnlessEqual(x.getLi(), [1, 2, 3])
        self.failUnlessEqual(x.getLi2(), range(5))
        compare_lists(x.getLf(), [1.1, 2.2, 3.3])
        self.failUnlessEqual(x.getLs(), ['a', 'b', 'c'])
        self.failUnlessEqual(x.getLX(), [xobj])
        x.appendToLists(123)
        self.failUnlessEqual(x.getLi(), [1, 2, 3, 123])
        self.failUnlessEqual(x.getLi2(), range(5)+ [123])
        compare_lists(x.getLf(), [1.1, 2.2, 3.3, 1.0])
        self.failUnlessEqual(x.getLs(), ['a', 'b', 'c', 'd'])
        self.failUnlessEqual(len(x.getLX()), 2)
        #
        from xlistusecases import TestXList
        x = TestXList(None,
                      None,
                      None,
                      None,
                      )
        self.failUnlessEqual(x.getLi(), None)
        self.failUnlessEqual(x.getLf(), None)
        self.failUnlessEqual(x.getLs(), None)
        self.failUnlessEqual(x.getLX(), None)
        self.failUnlessEqual(x.getLi2(), range(5))
        #
        from xlistusecases import FFFFF
        xobj = FFFFF()
        x = TestXList([1, 2, 3],
                      [1.1, 2.2, 3.3],
                      ['a', 'b', 'c'],
                      [xobj],
                      )
        self.failUnlessEqual(x.getLi(), [1, 2, 3])
        compare_lists(x.getLf(), [1.1, 2.2, 3.3])
        self.failUnlessEqual(x.getLs(), ['a', 'b', 'c'])
        self.failUnlessEqual(len(x.getLX()), 1)
        self.failUnlessEqual(x.getLi2(), range(5))
        # --
        # Test with tuples
        from xlistusecases import FFFFF
        xobj = FFFFF()
        x = TestXList((1, 2, 3, ),
                      (1.1, 2.2, 3.3, ),
                      ('a', 'b', 'c', ),
                      (xobj, ),
                      )
        self.failUnlessEqual(x.getLi(), [1, 2, 3])
        compare_lists(x.getLf(), [1.1, 2.2, 3.3])
        self.failUnlessEqual(x.getLs(), ['a', 'b', 'c'])
        self.failUnlessEqual(len(x.getLX()), 1)
        self.failUnlessEqual(x.getLi2(), range(5))
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
