# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xqt import *
from xutilities import message

class XDataItemRecursion:
    def findItemByXTree(self, xtree):
        for it in self.items:
            if it.xtree is xtree: return it
            # recursion
            res = it.findItemByXTree(xtree)
            if res: return res
            pass
        return
    def findReferenceItemsByXTree(self, xtree):
        l = []
        for it in self.items:
            if it.xtree.node is xtree: l.append(it)
            l += it.findReferenceItemsByXTree(xtree)
            pass
        return l
    def selectedItems(self):
        l = []
        for it in self.items:
            if it.isSelected(): l.append(it)
            l += it.selectedItems()
            pass
        return l
    pass

class XDataQListView(QListView, XDataItemRecursion):
    def __init__(self, parent):
        QListView.__init__(self, parent)
        self.setWFlags(Qt.WDestructiveClose)
        self.setSelectionMode(QListView.Extended)
        self.setResizeMode(QListView.AllColumns)
        self.setSorting(-1)
        self.setVScrollBarMode(QScrollView.AlwaysOn)
        self.header().setTracking(1)
        self.header().setMovingEnabled(0)
        if pyqt_module_name == "qt":
            self.connect(self, SIGNAL("selectionChanged()"), self.theSelectionChanged)
            self.connect(self, SIGNAL("contextMenuRequested(QListViewItem *,const QPoint &,int)"), self.contextMenuRequested)
        else:
            self.connect(self, SIGNAL("itemSelectionChanged()"), self.theSelectionChanged)
            self.setContextMenuPolicy(Qt.CustomContextMenu)
            self.connect(self, SIGNAL("customContextMenuRequested(const QPoint &)"), self.contextMenuRequested_qt4)
            pass
        self.items = []
        return
    def theSelectionChanged(self):
        message("Not implemented here !")
        return
    def contextMenuRequested(self, item, position, col):
        message("Not implemented here !")
        return
    def contextMenuRequested_qt4(self, position):
        self.contextMenuRequested(None, position, 0)
        return
    pass

class XDataQListViewItem(QListViewItem, XDataItemRecursion):
    def __init__(self, parent, after):
        QListViewItem.__init__(self, parent, after)
        self.parent = parent # 'cause self.parent() seems to be buggy
        self.base_color_index = 1
        self.base_color_list = [Qt.white, QColor(238, 247, 254)]
        # begin{G.F}
        self.color=None
        # end{G.F}
        self.status = "Unknown"
        self.items = []
        return
    def updateBaseColor(self):
        if self.itemAbove():
            self.base_color_index = not self.itemAbove().base_color_index
        else:
            self.base_color_index = 1
            pass
        return
    def getBaseColor(self):
        self.updateBaseColor()
        return self.base_color_list[self.base_color_index]
    def paintCell(self, p, cg, column, width, align):
        #
        p.save()
        #
        cg = QColorGroup(cg)
        cg.setColor(QColorGroup.Base, self.getBaseColor())
        if column == 0:
            text_color = Qt.black
            highlighted_text_color = Qt.white
            # begin{G.F}
            if self.status == "NoValid" or self.color=="Red":
                # end{G.F}
                text_color = Qt.red
                highlighted_text_color = Qt.red
            elif self.status == "Reference":
                text_color = Qt.blue
                highlighted_text_color = Qt.blue
                pass
            cg.setColor(QColorGroup.Text, text_color)
            cg.setColor(QColorGroup.HighlightedText, highlighted_text_color)
            pass
        QListViewItem.paintCell(self, p, cg, column, width, align)
        #
        p.restore()
        #
        if column == 0:
            p.drawLine(0, 0, 0, self.height()-1)
            pass
        p.drawLine(0, self.height()-1, width-1, self.height()-1)
        p.drawLine(width-1, 0, width-1, self.height()-1)
        #
        return
    pass
