# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xutilities import message
from xqt import *
from xmainwindow import getMainWindow

_workspace = None

def setWorkSpace(pyws):
    message("Hello", verbose_level_min=5)
    message(pyws, verbose_level_min=5)
    message("Good bye", verbose_level_min=5)
    return

_selection = None

def setWorkSpaceFromSetSettings(pyws):
    message("Hello", verbose_level_min=5)
    message(pyws, verbose_level_min=5)
    #
    global _workspace
    _workspace = pyws
    #
    from SalomePyQt import SalomePyQt
    sgPyQt = SalomePyQt()
    desktop = sgPyQt.getDesktop()
    message("desktop =", desktop, verbose_level_min=5)
    menu_bar = sgPyQt.getMainMenuBar()
    message("menu_bar =", menu_bar, verbose_level_min=5)
    if hasattr(sgPyQt, "getPopupMenu"):
        import SalomePyQt
        file_popup_menu = sgPyQt.getPopupMenu(SalomePyQt.File)
        view_popup_menu = sgPyQt.getPopupMenu(SalomePyQt.View)
        edit_popup_menu = sgPyQt.getPopupMenu(SalomePyQt.Edit)
        pref_popup_menu = sgPyQt.getPopupMenu(SalomePyQt.Preferences)
        tool_popup_menu = sgPyQt.getPopupMenu(SalomePyQt.Tools)
        wind_popup_menu = sgPyQt.getPopupMenu(SalomePyQt.Window)
        help_popup_menu = sgPyQt.getPopupMenu(SalomePyQt.Help)
    else:
        file_popup_menu = None
        view_popup_menu = None
        edit_popup_menu = None
        pref_popup_menu = None
        tool_popup_menu = None
        wind_popup_menu = None
        help_popup_menu = None
        pass
    message("file_popup_menu =", file_popup_menu, verbose_level_min=5)
    message("pref_popup_menu =", pref_popup_menu, verbose_level_min=5)
    message("help_popup_menu =", help_popup_menu, verbose_level_min=5)
    #
    global _selection
    if _selection:
        try:
            # VSR: trying disconnect previous selection object
            QObject.disconnect(_selection, SIGNAL("currentSelectionChanged()"), selectionChanged)
        except RuntimeError:
            pass
        pass
    selection = sgPyQt.getSelection()
    selection.ClearIObjects()
    _selection = selection
    #
    from xmainwindow import setMainWindow
    setMainWindow(desktop)
    from xmainmenubar import setMenuBar
    setMenuBar(menu_bar)
    from xmainmenubar import setMenuBarPopupMenus
    setMenuBarPopupMenus(File = file_popup_menu,
                         View = view_popup_menu,
                         Edit = edit_popup_menu,
                         Preferences = pref_popup_menu,
                         Tools = tool_popup_menu,
                         Window = wind_popup_menu,
                         Help = help_popup_menu,
                         )
    #
    QObject.connect(selection, SIGNAL("currentSelectionChanged()"), selectionChanged)
    #
    message("Good bye", verbose_level_min=5)
    return

_current_item_id_2_xdata_name = {}

def setSettingsForModule(component_name, item_id_2_xdata_name):
    message(component_name, item_id_2_xdata_name, verbose_level_min=5)
    global _workspace
    pyws = _workspace
    setWorkSpaceFromSetSettings(pyws)
    from xmainmenubar import getMenuBar
    menu_bar = getMenuBar()
    if menu_bar:
        # --
        # E.A. 06/10/2008 :
        # Salome 5 : Register the correspondance between
        # the item_id's and the actions
        # --
        if pyqt_module_name == "PyQt4":
            from SalomePyQt import SalomePyQt
            sgPyQt = SalomePyQt()
            for item_id, name in item_id_2_xdata_name.items():
                fields = name.split('/')
                depth = len(fields)-1
                if depth == 0:
                    receiver = menu_bar
                elif depth ==1:
                    key = fields[0]
                    from xmainmenubar import getMenuBarPopupMenus
                    receiver = getMenuBarPopupMenus()[key]
                    message(key, receiver)
                else:
                    msg = "Strange : depth > 1 in %s %s"%(item_id, name)
                    raise Exception(msg)
                try:
                    d = receiver.__item_id__to__action__
                except AttributeError:
                    receiver.__item_id__to__action__ = {}
                    d = receiver.__item_id__to__action__
                    pass
                try:
                    action = d[item_id]
                except KeyError:
                    action = sgPyQt.action(item_id)
                    pass
                message(item_id, item_id_2_xdata_name[item_id], action)
                d[item_id] = action
                pass
            pass
        menu_bar.setSettings(component_name, item_id_2_xdata_name)
        pass
    #
    from xsalome import setComponentFromGUI
    setComponentFromGUI(component_name)
    #
    global _current_item_id_2_xdata_name
    _current_item_id_2_xdata_name = item_id_2_xdata_name
    #
    return

def activeStudyChanged(ID):
    message(ID)
    return

def OnGUIEvent(ID):
    message(ID, type(ID))
    if ID == 1000:
        if hasattr(getMainWindow(), "__current__import__"):
            msg  = "A script is currently imported ....\n"
            msg += "You should wait that current import finished !\n"
            msg += "\n"
            QMessageBox.warning(getMainWindow(), "Warning", msg)
            return
        from SalomePyQt import SalomePyQt
        sgPyQt = SalomePyQt()
        l = QStringList()
        l.append("*.py")
        fn = sgPyQt.getFileName(getMainWindow(), QString.null, l, "Import", 1)
        if fn.isEmpty(): return
        fileName = str(fn)
        message(fileName)
        from xdatagui import importPy
        importPy(fileName, "salome")
    elif ID == 1001:
        self = getMainWindow()
        from xtree import getMainXTree
        axtree = getMainXTree()
        fn = QFileDialog.getSaveFileName(QString.null,
                                         "(*.py)",
                                         self,
                                         "save file dialog"
                                         "Choose a filename to save under" );
        if fn.isEmpty(): return
        fileName = str(fn)
        message(fileName)
        QApplication.setOverrideCursor(Qt.waitCursor)
        axtree.saveAs(fileName)
        QApplication.restoreOverrideCursor()
        pass
    return

def definePopup(theContext, theObject, theParent):
    message(theContext, theObject, theParent)
    return

def customPopup(popup, theContext, theObject, theParent, theIsClearPopup = 1):
    message(popup, theContext, theObject, theParent)
    # Patch for bad mdk 10.1 occ binaries
    try:
        from xqt import QHBox
        if isinstance(popup, QHBox):
            from xqt import QPopupMenu
            popup.__class__ = QPopupMenu
            pass
        pass
    except:
        pass
    # Patch for bad mdk 10.1 occ binaries
    if theIsClearPopup:
        try:
            popup.clear()
        except SystemError, e:
            n = popup.count()
            ids = [ popup.idAt(i) for i in range(n) ]
            for id in ids: popup.removeItem(id)
            pass
        pass
    selection = selectedItems()
    from xdatagui import customPopup
    customPopup(popup, selection)
    return

def deactivate():
    message("HELLO !!")
    global _current_item_id_2_xdata_name
    message(_current_item_id_2_xdata_name)
    if pyqt_module_name == "qt":
        pass
    else:
        items  = _current_item_id_2_xdata_name.items()
        for key, value in items:
            if value.find('/') > -1:
                menu_name = value.split('/')[0]
                from xmainmenubar import getMenuBarPopupMenus
                receiver = getMenuBarPopupMenus()[menu_name]
            else:
                from xmainmenubar import getMenuBar
                receiver = getMenuBar()
                pass
            receiver.removeItem(key)
            pass
        pass
    _current_item_id_2_xdata_name = {}
    global _selection
    if _selection:
        try:
            # VSR: disconnect previous selection object
            QObject.disconnect(_selection, SIGNAL("currentSelectionChanged()"), selectionChanged)
        except RuntimeError:
            pass
        pass
    return

# ------------------------------
# ------------------------------

def selectionChanged():
    message("qqqq")
    selection = selectedItems()
    self = getMainWindow()
    self.browserSelectionChanged(selection)
    return

def selectedItems():
    from salome import sg
    selection = sg.getAllSelected()
    selection = [ SalomeStudyItem(ID) for ID in selection ]
    return selection

class SalomeStudyXTree(object):
    def __init__(self, entry):
        message(entry)
        self.entry = entry
        self.depth = len(entry.split(':'))-3
        #
        from salome import sg
        myStudyId = sg.getActiveStudyId()
        from salome import myStudyManager
        myStudy = myStudyManager.GetStudyByID(myStudyId)
        sobj = myStudy.FindObjectID(entry)
        #
        import SALOMEDS
        name = sobj.FindAttribute("AttributeName")[1]
        name = name._narrow(SALOMEDS.AttributeName).Value()
        self.name = name
        message(name)
        #
        ior = sobj.FindAttribute("AttributeIOR")[1]
        if ior:
            ior = ior._narrow(SALOMEDS.AttributeIOR).Value()
            from xsalome import getORB
            node = getORB().string_to_object(ior)
            from xsalome import corba2python
            node = corba2python(node)
            # --
            # Fix bugs after save / restore
            from xdata import XObject
            if isinstance(node, XObject):
                # __instance__name__ attribute
                if self.depth == 1:
                    if not hasattr(node, "__instance__name__"):
                        setattr(node, "__instance__name__", name)
                        pass
                    pass
                # __init__ok__ attribute
                if not hasattr(node, "__init__ok__"):
                    setattr(node, "__init__ok__", 1)
                    pass
                pass
            #
            pass
        else:
            message('Not a corba object')
            parent_branch = [self]
            while 1:
                test = parent_branch[0]
                xattr = test.getXAttribute()
                parent = test.getParent()
                if parent is None:
                    # E.A. : Situation where the sobject has been
                    # publish in study outside the scope of xdata ...
                    # Trying to find the value attribute
                    for s in ['Comment', 'Real', 'Integer']:
                        attr = sobj.FindAttribute("Attribute%s"%(s))[1]
                        if attr:
                            interface = getattr(SALOMEDS, "Attribute%s"%(s))
                            attr = attr._narrow(interface)
                            value = attr.Value()
                            self.node = value
                            return
                        pass
                    self.node = entry
                    return
                parent_branch.insert(0, parent)
                if xattr: break
                pass
            #
            node = parent_branch[0].node
            for p in parent_branch[1:]:
                name = p.name
                if name[0] == '[':
                    exec "node = node%s"%(name)
                else:
                    exec "node = node.%s"%(name)
                    pass
                pass
            pass
        #
        self.node = node
        #
        return
    
    def getXAttribute(self):
        if self.depth <= 1 :
            return None
        parent = self.parent
        node = parent.node
        from xdata import XObject
        if not isinstance(node, XObject):
            return None
        cls = node.__class__
        for x in cls.getXAttributesMRO():
            if x.name == self.name:
                return x
            pass
        return None
    
    def getParent(self):
        entry = self.entry
        parent_entry = ':'.join(entry.split(':')[:-1])
        message(parent_entry)
        try:
            parent = SalomeStudyXTree(parent_entry)
        except AttributeError:
            parent = None
            pass
        return parent
    
    xattribute = property(getXAttribute)
    parent = property(getParent)
    
    pass

class SalomeStudyItem(object):
    def __init__(self, study_id):
        self.xtree = SalomeStudyXTree(study_id)
        self.name = self.xtree.name
        return
    pass
