# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

class TestCase(unittest.TestCase):
    def test(self):
        from os import getenv
        medfile  = getenv("MED_ROOT_DIR")
        medfile += "/share/salome/resources/med/pointe.med"
        #
        from libMEDClient import MED, MED_DRIVER
        #
        med = MED(MED_DRIVER, medfile)
        mesh = med.getMesh(med.getMeshName(0))
        mesh.read()
        #
        import medfieldcreator
        mfc = medfieldcreator.MedFieldCreator(mesh)
        mfc.run()
        field = mfc.getField()
        print field
        print dir(field)
        support = field.getSupport()
        print support
        print dir(support)
        mesh = support.getMesh()
        print mesh
        print dir(mesh)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
