#  Check availability of HXX2SALOME_GENERIC_CLASS_NAME binary distribution
#
#  Author : Marc Tajchman (CEA, 2002)
#------------------------------------------------------------

AC_DEFUN([CHECK_HXX2SALOME_GENERIC_CLASS_NAME],[

AC_CHECKING(for HXX2SALOME_GENERIC_CLASS_NAME)

HXX2SALOME_GENERIC_CLASS_NAME_ok=no

AC_ARG_WITH(calc,
	    --with-HXX2SALOME_GENERIC_CLASS_NAME=DIR  root directory path of HXX2SALOME_GENERIC_CLASS_NAME build or installation,
	    HXX2SALOME_GENERIC_CLASS_NAME_DIR="$withval",HXX2SALOME_GENERIC_CLASS_NAME_DIR="")

if test "x$HXX2SALOME_GENERIC_CLASS_NAME_DIR" = "x" ; then

# no --with-gui-dir option used

  if test "x$HXX2SALOME_GENERIC_CLASS_NAME_ROOT_DIR" != "x" ; then

    # SALOME_ROOT_DIR environment variable defined
    HXX2SALOME_GENERIC_CLASS_NAME_DIR=$HXX2SALOME_GENERIC_CLASS_NAME_ROOT_DIR

  else

    # search Salome binaries in PATH variable
    AC_PATH_PROG(TEMP, libHXX2SALOME_GENERIC_CLASS_NAMEEngine.so)
    if test "x$TEMP" != "x" ; then
      HXX2SALOME_GENERIC_CLASS_NAME_DIR=`dirname $TEMP`
    fi

  fi

fi

if test -f ${HXX2SALOME_GENERIC_CLASS_NAME_DIR}/lib/salome/libHXX2SALOME_GENERIC_CLASS_NAMEEngine.so  ; then
  HXX2SALOME_GENERIC_CLASS_NAME_ok=yes
  AC_MSG_RESULT(Using HXX2SALOME_GENERIC_CLASS_NAME module distribution in ${HXX2SALOME_GENERIC_CLASS_NAME_DIR})

  if test "x$HXX2SALOME_GENERIC_CLASS_NAME_ROOT_DIR" == "x" ; then
    HXX2SALOME_GENERIC_CLASS_NAME_ROOT_DIR=${HXX2SALOME_GENERIC_CLASS_NAME_DIR}
  fi
  AC_SUBST(HXX2SALOME_GENERIC_CLASS_NAME_ROOT_DIR)
else
  AC_MSG_WARN("Cannot find compiled HXX2SALOME_GENERIC_CLASS_NAME module distribution")
fi
  
AC_MSG_RESULT(for HXX2SALOME_GENERIC_CLASS_NAME: $HXX2SALOME_GENERIC_CLASS_NAME_ok)
 
])dnl
 
