#!/usr/bin/env python

# Unix SMB/CIFS implementation.
# Copyright (C) Jelmer Vernooij <jelmer@samba.org> 2009
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from samba.netcmd import Command
import samba.tests

class CommandTests(samba.tests.TestCase):

    def test_name(self):
        class cmd_foo(Command):
            pass
        self.assertEquals("foo", cmd_foo().name)

    def test_description(self):
        class cmd_foo(Command):
            """Mydescription"""
        self.assertEquals("Mydescription", cmd_foo().description)
